/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.browsers.BrowserLauncherAppless;
import com.intellij.ide.browsers.DefaultBrowserPolicy;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u0004\u0018\u00010\u0001\u00a8\u0006\u0002"}, d2={"findUsingBrowser", "Lcom/intellij/ide/browsers/WebBrowser;", "intellij.xml.impl"})
public final class OpenFileInDefaultBrowserActionKt {
    @Nullable
    public static final WebBrowser findUsingBrowser() {
        WebBrowserManager browserManager;
        WebBrowserManager webBrowserManager = browserManager = WebBrowserManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)webBrowserManager), (String)"browserManager");
        DefaultBrowserPolicy defaultBrowserPolicy = webBrowserManager.getDefaultBrowserPolicy();
        if (defaultBrowserPolicy == DefaultBrowserPolicy.FIRST || defaultBrowserPolicy == DefaultBrowserPolicy.SYSTEM && !BrowserLauncherAppless.Companion.canUseSystemDefaultBrowserPolicy()) {
            return browserManager.getFirstActiveBrowser();
        }
        if (defaultBrowserPolicy == DefaultBrowserPolicy.ALTERNATIVE) {
            GeneralSettings generalSettings = GeneralSettings.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)generalSettings, (String)"GeneralSettings.getInstance()");
            String path = generalSettings.getBrowserPath();
            CharSequence charSequence = path;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                WebBrowser browser2 = browserManager.findBrowserById(path);
                if (browser2 == null) {
                    Iterator<WebBrowser> iterator = browserManager.getActiveBrowsers().iterator();
                    while (iterator.hasNext()) {
                        WebBrowser item;
                        WebBrowser webBrowser = item = iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)webBrowser, (String)"item");
                        if (!Intrinsics.areEqual((Object)path, (Object)webBrowser.getPath())) continue;
                        return item;
                    }
                } else {
                    return browser2;
                }
            }
        }
        return null;
    }
}

