/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.ui.persistence;

import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.FUSUsageContext;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@State(name="ToolbarClicksCollector", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED), @Storage(value="statistics.toolbar.clicks.xml", roamingType=RoamingType.DISABLED, deprecated=true)})
public class ToolbarClicksCollector
implements PersistentStateComponent<ClicksState> {
    private ClicksState myState = new ClicksState();

    public ClicksState getState() {
        return this.myState;
    }

    public void loadState(@NotNull ClicksState state) {
        if (state == null) {
            ToolbarClicksCollector.$$$reportNull$$$0(0);
        }
        this.myState = state;
    }

    public static void record(@NotNull AnAction action, String place) {
        if (action == null) {
            ToolbarClicksCollector.$$$reportNull$$$0(1);
        }
        ToolbarClicksCollector.record(ToolbarClicksCollector.toRecordedId(action), place);
    }

    @NotNull
    private static String toRecordedId(@NotNull AnAction action) {
        PluginType type;
        if (action == null) {
            ToolbarClicksCollector.$$$reportNull$$$0(2);
        }
        if (!(type = StatisticsUtilKt.getPluginType(action.getClass())).isDevelopedByJetBrains()) {
            String string = type.name();
            if (string == null) {
                ToolbarClicksCollector.$$$reportNull$$$0(3);
            }
            return string;
        }
        String id = ActionManager.getInstance().getId(action);
        if (id == null) {
            id = action instanceof ActionWithDelegate ? ((ActionWithDelegate)action).getPresentableName() : action.getClass().getName();
        }
        String string = id;
        if (string == null) {
            ToolbarClicksCollector.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static void record(String actionId, String place) {
        ToolbarClicksCollector collector = ToolbarClicksCollector.getInstance();
        if (collector != null) {
            String key = ConvertUsagesUtil.escapeDescriptorName(actionId + "@" + place);
            FeatureUsageLogger.INSTANCE.log("statistics.ui.toolbar.clicks", key, FUSUsageContext.OS_CONTEXT.getData());
            ClicksState state = collector.getState();
            if (state != null) {
                Integer count = state.myValues.get(key);
                int value = count == null ? 1 : count + 1;
                state.myValues.put(key, value);
            }
        }
    }

    public static ToolbarClicksCollector getInstance() {
        return (ToolbarClicksCollector)ServiceManager.getService(ToolbarClicksCollector.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/ui/persistence/ToolbarClicksCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/ui/persistence/ToolbarClicksCollector";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toRecordedId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "record";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toRecordedId";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ClicksState {
        @Tag(value="counts")
        @MapAnnotation(surroundWithTag=false, keyAttributeName="action", valueAttributeName="count")
        public Map<String, Integer> myValues = new HashMap<String, Integer>();
    }
}

