/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.eventLog.FeatureUsageUiEvents;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J$\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u001c\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u001c\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u001c\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J$\u0010\u001a\u001a\u00020\u00052\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0002R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00060\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00060\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00060\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00060\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/internal/statistic/eventLog/FeatureUsageUiEventsImpl;", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageUiEvents;", "()V", "APPLY_CONFIGURABLE_DATA", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "CLOSE_CANCEL_DIALOG_DATA", "kotlin.jvm.PlatformType", "CLOSE_CUSTOM_DIALOG_DATA", "CLOSE_OK_DIALOG_DATA", "RESET_CONFIGURABLE_DATA", "SELECT_CONFIGURABLE_DATA", "SHOW_DIALOG_DATA", "logApplyConfigurable", "", "name", "context", "Ljava/lang/Class;", "logCloseDialog", "exitCode", "", "logResetConfigurable", "logSelectConfigurable", "logShowDialog", "toReport", "defaultValue", "intellij.platform.ide.impl"})
public final class FeatureUsageUiEventsImpl
implements FeatureUsageUiEvents {
    private final HashMap<String, Object> SELECT_CONFIGURABLE_DATA = new HashMap();
    private final HashMap<String, Object> APPLY_CONFIGURABLE_DATA = new HashMap();
    private final HashMap<String, Object> RESET_CONFIGURABLE_DATA = new HashMap();
    private final HashMap<String, Object> SHOW_DIALOG_DATA = ContainerUtil.newHashMap();
    private final HashMap<String, Object> CLOSE_OK_DIALOG_DATA = ContainerUtil.newHashMap();
    private final HashMap<String, Object> CLOSE_CANCEL_DIALOG_DATA = ContainerUtil.newHashMap();
    private final HashMap<String, Object> CLOSE_CUSTOM_DIALOG_DATA = ContainerUtil.newHashMap();

    public void logSelectConfigurable(@NotNull String name, @NotNull Class<?> context) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
    }

    public void logApplyConfigurable(@NotNull String name, @NotNull Class<?> context) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
    }

    public void logResetConfigurable(@NotNull String name, @NotNull Class<?> context) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
    }

    public void logShowDialog(@NotNull String name, @NotNull Class<?> context) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        if (FeatureUsageLogger.INSTANCE.isEnabled()) {
            String report = this.toReport(context, name, "dialog.third.party.plugin");
            HashMap<String, Object> hashMap = this.SHOW_DIALOG_DATA;
            Intrinsics.checkExpressionValueIsNotNull(hashMap, (String)"SHOW_DIALOG_DATA");
            FeatureUsageLogger.INSTANCE.log("ui.dialogs", report, (Map)hashMap);
        }
    }

    public void logCloseDialog(@NotNull String name, int exitCode, @NotNull Class<?> context) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        if (FeatureUsageLogger.INSTANCE.isEnabled()) {
            String report = this.toReport(context, name, "dialog.third.party.plugin");
            if (exitCode == 0) {
                HashMap<String, Object> hashMap = this.CLOSE_OK_DIALOG_DATA;
                Intrinsics.checkExpressionValueIsNotNull(hashMap, (String)"CLOSE_OK_DIALOG_DATA");
                FeatureUsageLogger.INSTANCE.log("ui.dialogs", report, (Map)hashMap);
            } else if (exitCode == 1) {
                HashMap<String, Object> hashMap = this.CLOSE_CANCEL_DIALOG_DATA;
                Intrinsics.checkExpressionValueIsNotNull(hashMap, (String)"CLOSE_CANCEL_DIALOG_DATA");
                FeatureUsageLogger.INSTANCE.log("ui.dialogs", report, (Map)hashMap);
            } else {
                HashMap<String, Object> hashMap = this.CLOSE_CUSTOM_DIALOG_DATA;
                Intrinsics.checkExpressionValueIsNotNull(hashMap, (String)"CLOSE_CUSTOM_DIALOG_DATA");
                FeatureUsageLogger.INSTANCE.log("ui.dialogs", report, (Map)hashMap);
            }
        }
    }

    private final String toReport(Class<?> context, String name, String defaultValue) {
        PluginId pluginId = PluginManagerCore.getPluginByClassName(context.getName());
        return StatisticsUtilKt.isDevelopedByJetBrains(pluginId) ? name : defaultValue;
    }

    public FeatureUsageUiEventsImpl() {
        Map map = this.SELECT_CONFIGURABLE_DATA;
        String string = "type";
        Object object = "select";
        map.put(string, object);
        map = this.APPLY_CONFIGURABLE_DATA;
        string = "type";
        object = "apply";
        map.put(string, object);
        map = this.RESET_CONFIGURABLE_DATA;
        string = "type";
        object = "reset";
        map.put(string, object);
        HashMap<String, Object> hashMap = this.SHOW_DIALOG_DATA;
        Intrinsics.checkExpressionValueIsNotNull(hashMap, (String)"SHOW_DIALOG_DATA");
        map = hashMap;
        string = "type";
        object = "show";
        map.put(string, object);
        HashMap<String, Object> hashMap2 = this.CLOSE_OK_DIALOG_DATA;
        Intrinsics.checkExpressionValueIsNotNull(hashMap2, (String)"CLOSE_OK_DIALOG_DATA");
        map = hashMap2;
        string = "type";
        object = "close";
        map.put(string, object);
        HashMap<String, Object> hashMap3 = this.CLOSE_OK_DIALOG_DATA;
        Intrinsics.checkExpressionValueIsNotNull(hashMap3, (String)"CLOSE_OK_DIALOG_DATA");
        map = hashMap3;
        string = "code";
        object = 0;
        map.put(string, object);
        HashMap<String, Object> hashMap4 = this.CLOSE_CANCEL_DIALOG_DATA;
        Intrinsics.checkExpressionValueIsNotNull(hashMap4, (String)"CLOSE_CANCEL_DIALOG_DATA");
        map = hashMap4;
        string = "type";
        object = "close";
        map.put(string, object);
        HashMap<String, Object> hashMap5 = this.CLOSE_CANCEL_DIALOG_DATA;
        Intrinsics.checkExpressionValueIsNotNull(hashMap5, (String)"CLOSE_CANCEL_DIALOG_DATA");
        map = hashMap5;
        string = "code";
        object = 1;
        map.put(string, object);
        HashMap<String, Object> hashMap6 = this.CLOSE_CUSTOM_DIALOG_DATA;
        Intrinsics.checkExpressionValueIsNotNull(hashMap6, (String)"CLOSE_CUSTOM_DIALOG_DATA");
        map = hashMap6;
        string = "type";
        object = "close";
        map.put(string, object);
        HashMap<String, Object> hashMap7 = this.CLOSE_CUSTOM_DIALOG_DATA;
        Intrinsics.checkExpressionValueIsNotNull(hashMap7, (String)"CLOSE_CUSTOM_DIALOG_DATA");
        map = hashMap7;
        string = "code";
        object = 2;
        map.put(string, object);
    }
}

