/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.FUSUsageContext;
import com.intellij.internal.statistic.service.fus.collectors.FUSession;
import com.intellij.internal.statistic.service.fus.collectors.FeatureUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsagesCollectorConsumer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractUsageTrigger<T extends FeatureUsagesCollector>
implements UsagesCollectorConsumer {
    private static final Logger LOG = Logger.getInstance((String)("#" + AbstractUsageTrigger.class.getPackage().getName()));
    private State myState = new State();

    public void trigger(@NotNull Class<? extends T> fusClass, @NotNull @NonNls String feature) {
        if (fusClass == null) {
            AbstractUsageTrigger.$$$reportNull$$$0(0);
        }
        if (feature == null) {
            AbstractUsageTrigger.$$$reportNull$$$0(1);
        }
        this.trigger(fusClass, feature, null);
    }

    public void trigger(@NotNull Class<? extends T> fusClass, @NotNull @NonNls String feature, @Nullable FUSUsageContext context) {
        FeatureUsagesCollector collector;
        if (fusClass == null) {
            AbstractUsageTrigger.$$$reportNull$$$0(2);
        }
        if (feature == null) {
            AbstractUsageTrigger.$$$reportNull$$$0(3);
        }
        if ((collector = this.findCollector(fusClass)) != null) {
            this.doTrigger(collector.getGroupId(), feature, context);
        } else {
            LOG.warn("Cannot find collector `" + fusClass + "`. Make sure it's registered");
        }
    }

    protected abstract FeatureUsagesCollector findCollector(@NotNull Class<? extends T> var1);

    protected abstract Map<String, Object> createEventLogData(@Nullable FUSUsageContext var1);

    protected void doTrigger(@NotNull String usageCollectorId, @NotNull String feature, @Nullable FUSUsageContext context) {
        if (usageCollectorId == null) {
            AbstractUsageTrigger.$$$reportNull$$$0(4);
        }
        if (feature == null) {
            AbstractUsageTrigger.$$$reportNull$$$0(5);
        }
        FeatureUsageLogger.INSTANCE.log(usageCollectorId, feature, this.createEventLogData(context));
        SessionInfo sessionInfo = this.getOrCreateSessionInfo();
        UsagesCollectorInfo collectorInfo = sessionInfo.getUsageCollectorInfo(usageCollectorId);
        AbstractUsageTrigger.migrateLegacyData(collectorInfo);
        FUsageInfo usage = AbstractUsageTrigger.findUsageInfo(collectorInfo.usages, feature, context);
        if (usage == null) {
            collectorInfo.usages.add(FUsageInfo.create(feature, 1, context));
        } else {
            FUsageInfo fUsageInfo = usage;
            fUsageInfo.count = fUsageInfo.count + 1;
        }
    }

    private static void migrateLegacyData(@NotNull UsagesCollectorInfo info) {
        if (info == null) {
            AbstractUsageTrigger.$$$reportNull$$$0(6);
        }
        if (info.counts.size() > 0) {
            for (Map.Entry<String, Integer> entry : info.counts.entrySet()) {
                info.usages.add(FUsageInfo.create(entry.getKey(), entry.getValue(), null));
            }
            info.counts.clear();
        }
    }

    @Nullable
    private static FUsageInfo findUsageInfo(@NotNull Set<FUsageInfo> usages, @NotNull String feature, @Nullable FUSUsageContext context) {
        if (usages == null) {
            AbstractUsageTrigger.$$$reportNull$$$0(7);
        }
        if (feature == null) {
            AbstractUsageTrigger.$$$reportNull$$$0(8);
        }
        for (FUsageInfo usage : usages) {
            if (!usage.id.equals(feature) || !AbstractUsageTrigger.equalContexts(context, usage.context)) continue;
            return usage;
        }
        return null;
    }

    private static boolean equalContexts(@Nullable FUSUsageContext context, @Nullable Map<String, String> contextData) {
        if (context == null && (contextData == null || contextData.isEmpty())) {
            return true;
        }
        return context != null && Objects.equals(contextData, context.getData());
    }

    @NotNull
    public Set<UsageDescriptor> getData(@NotNull String usageCollectorId) {
        SessionInfo info;
        if (usageCollectorId == null) {
            AbstractUsageTrigger.$$$reportNull$$$0(9);
        }
        if ((info = this.geExistingSessionInfo()) != null) {
            Set<UsageDescriptor> set = info.getUsageCollectorInfo((String)usageCollectorId).usages.stream().map(usage -> new UsageDescriptor(usage.id, (int)usage.count, usage.context != null && usage.context.size() > 0 ? FUSUsageContext.create(usage.contextValues()) : null)).collect(Collectors.toSet());
            if (set == null) {
                AbstractUsageTrigger.$$$reportNull$$$0(10);
            }
            return set;
        }
        Set<UsageDescriptor> set = Collections.emptySet();
        if (set == null) {
            AbstractUsageTrigger.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    private SessionInfo getOrCreateSessionInfo() {
        SessionInfo info = this.geExistingSessionInfo();
        if (info != null) {
            SessionInfo sessionInfo = info;
            if (sessionInfo == null) {
                AbstractUsageTrigger.$$$reportNull$$$0(12);
            }
            return sessionInfo;
        }
        SessionInfo sessionInfo = SessionInfo.create(this.getFUSession().getId());
        this.myState.sessions.add(sessionInfo);
        SessionInfo sessionInfo2 = sessionInfo;
        if (sessionInfo2 == null) {
            AbstractUsageTrigger.$$$reportNull$$$0(13);
        }
        return sessionInfo2;
    }

    protected abstract FUSession getFUSession();

    @Nullable
    private SessionInfo geExistingSessionInfo() {
        FUSession session2 = this.getFUSession();
        for (SessionInfo info : this.myState.sessions) {
            if (info.id != session2.getId()) continue;
            return info;
        }
        return null;
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            AbstractUsageTrigger.$$$reportNull$$$0(14);
        }
        this.myState = state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fusClass";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageCollectorId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/collectors/AbstractUsageTrigger";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/collectors/AbstractUsageTrigger";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateSessionInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "trigger";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doTrigger";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "migrateLegacyData";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findUsageInfo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="usage")
    public static class FUsageInfo {
        @Attribute(value="id")
        public String id;
        @Attribute(value="value")
        public Integer count;
        @Tag(value="context")
        @MapAnnotation(surroundWithTag=false)
        public Map<String, String> context = ContainerUtil.newLinkedHashMap();

        private static FUsageInfo create(@NotNull String feature, int value, @Nullable FUSUsageContext context) {
            if (feature == null) {
                FUsageInfo.$$$reportNull$$$0(0);
            }
            FUsageInfo usage = new FUsageInfo();
            usage.id = feature;
            usage.count = value;
            usage.context = context != null ? context.getData() : ContainerUtil.newLinkedHashMap();
            return usage;
        }

        public String[] contextValues() {
            return ArrayUtil.toStringArray(this.context.values());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "feature", "com/intellij/internal/statistic/service/fus/collectors/AbstractUsageTrigger$FUsageInfo", "create"));
        }
    }

    @Tag(value="usages-collector")
    public static class UsagesCollectorInfo {
        @Attribute(value="id")
        public String id;
        @Tag(value="counts")
        @MapAnnotation(surroundWithTag=false)
        public Map<String, Integer> counts = new HashMap<String, Integer>();
        @Property(surroundWithTag=false)
        @XCollection
        Set<FUsageInfo> usages = ContainerUtil.newLinkedHashSet();
    }

    @Tag(value="session")
    public static class SessionInfo {
        @Attribute(value="id")
        public int id;
        @Property(surroundWithTag=false)
        @XCollection
        List<UsagesCollectorInfo> collectors = ContainerUtil.newSmartList();

        @NotNull
        public UsagesCollectorInfo getUsageCollectorInfo(String id) {
            UsagesCollectorInfo collector = this.findUsageCollectorInfo(id);
            if (collector != null) {
                UsagesCollectorInfo usagesCollectorInfo = collector;
                if (usagesCollectorInfo == null) {
                    SessionInfo.$$$reportNull$$$0(0);
                }
                return usagesCollectorInfo;
            }
            UsagesCollectorInfo info = new UsagesCollectorInfo();
            info.id = id;
            this.collectors.add(info);
            UsagesCollectorInfo usagesCollectorInfo = info;
            if (usagesCollectorInfo == null) {
                SessionInfo.$$$reportNull$$$0(1);
            }
            return usagesCollectorInfo;
        }

        @Nullable
        public UsagesCollectorInfo findUsageCollectorInfo(String id) {
            for (UsagesCollectorInfo collector : this.collectors) {
                if (!id.equals(collector.id)) continue;
                return collector;
            }
            return null;
        }

        public static SessionInfo create(int id) {
            SessionInfo info = new SessionInfo();
            info.id = id;
            return info;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/service/fus/collectors/AbstractUsageTrigger$SessionInfo", "getUsageCollectorInfo"));
        }
    }

    static final class State {
        @Property(surroundWithTag=false)
        @XCollection
        List<SessionInfo> sessions = ContainerUtil.newSmartList();

        State() {
        }
    }
}

