/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.impl.external.ContentExternalizer;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.diff.impl.external.ExternalToolContentExternalizer;
import com.intellij.openapi.diff.impl.external.LocalFileExternalizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import com.intellij.util.config.StringProperty;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseExternalTool
implements DiffTool {
    private final BooleanProperty myEnableProperty;
    private final StringProperty myToolProperty;

    protected BaseExternalTool(BooleanProperty enableProperty, StringProperty toolProperty) {
        this.myEnableProperty = enableProperty;
        this.myToolProperty = toolProperty;
    }

    public final boolean canShow(@NotNull DiffRequest request) {
        if (request == null) {
            BaseExternalTool.$$$reportNull$$$0(0);
        }
        if (!this.isEnabled() || StringUtil.isEmpty((String)this.getToolPath())) {
            return false;
        }
        return this.isAvailable(request);
    }

    public DiffViewer createComponent(String title, DiffRequest request, Window window, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            BaseExternalTool.$$$reportNull$$$0(1);
        }
        return null;
    }

    public abstract boolean isAvailable(@NotNull DiffRequest var1);

    @Nullable
    protected ContentExternalizer externalize(@NotNull DiffRequest request, int index) {
        VirtualFile file2;
        if (request == null) {
            BaseExternalTool.$$$reportNull$$$0(2);
        }
        if (LocalFileExternalizer.canExternalizeAsFile(file2 = BaseExternalTool.getLocalFile(request.getContents()[index].getFile()))) {
            return LocalFileExternalizer.tryCreate(file2);
        }
        return new ExternalToolContentExternalizer(request, index);
    }

    public static AbstractProperty.AbstractPropertyContainer getProperties() {
        return DiffManagerImpl.getInstanceEx().getProperties();
    }

    protected String getToolPath() {
        return (String)this.myToolProperty.get(BaseExternalTool.getProperties());
    }

    protected boolean isEnabled() {
        return this.myEnableProperty.value(BaseExternalTool.getProperties());
    }

    @NotNull
    protected List<String> getParameters(@NotNull DiffRequest request) throws Exception {
        if (request == null) {
            BaseExternalTool.$$$reportNull$$$0(3);
        }
        String p1 = this.convertToPath(request, 0);
        String p2 = this.convertToPath(request, 1);
        ArrayList<String> params = new ArrayList<String>();
        if (p1 != null) {
            params.add(p1);
        }
        if (p2 != null) {
            params.add(p2);
        }
        ArrayList<String> arrayList = params;
        if (arrayList == null) {
            BaseExternalTool.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public void show(DiffRequest request) {
        this.saveContents(request);
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(this.getToolPath());
        try {
            commandLine.addParameters(this.getParameters(request));
            commandLine.createProcess();
        }
        catch (Exception e) {
            ExecutionErrorDialog.show((ExecutionException)new ExecutionException(e.getMessage()), (String)DiffBundle.message((String)"cant.launch.diff.tool.error.message", (Object[])new Object[0]), (Project)request.getProject());
        }
    }

    protected void saveContents(DiffRequest request) {
        for (DiffContent diffContent : request.getContents()) {
            Document document = diffContent.getDocument();
            if (document == null) continue;
            FileDocumentManager.getInstance().saveDocument(document);
        }
    }

    @Nullable
    protected String convertToPath(DiffRequest request, int index) throws Exception {
        ContentExternalizer externalize = this.externalize(request, index);
        return externalize == null ? null : externalize.getContentFile().getAbsolutePath();
    }

    @Nullable
    protected static VirtualFile getLocalFile(VirtualFile file2) {
        if (file2 != null && file2.isInLocalFileSystem()) {
            return file2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/external/BaseExternalTool";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/external/BaseExternalTool";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canShow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createComponent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "externalize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

