/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.options.SchemeState;
import com.intellij.util.ArrayUtilRt;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\u001a\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015\u001a$\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002\u001a#\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u001d2\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0019H\u0002\u00a2\u0006\u0002\u0010\u001f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"ACTION", "", "FIRST_KEYSTROKE_ATTRIBUTE", "ID_ATTRIBUTE", "KEYBOARD_GESTURE_KEY", "KEYBOARD_GESTURE_MODIFIER", "KEYBOARD_GESTURE_SHORTCUT", "KEYBOARD_SHORTCUT", "KEYSTROKE_ATTRIBUTE", "KEY_MAP", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MOUSE_SHORTCUT", "NAME_ATTRIBUTE", "PARENT_ATTRIBUTE", "SECOND_KEYSTROKE_ATTRIBUTE", "VERSION_ATTRIBUTE", "KeymapImpl", "Lcom/intellij/openapi/keymap/impl/KeymapImpl;", "name", "dataHolder", "Lcom/intellij/configurationStore/SchemeDataHolder;", "areShortcutsEqual", "", "shortcuts1", "", "Lcom/intellij/openapi/actionSystem/Shortcut;", "shortcuts2", "sortInRegistrationOrder", "", "ids", "(Ljava/util/List;)[Ljava/lang/String;", "intellij.platform.ide.impl"})
public final class KeymapImplKt {
    private static final String KEY_MAP = "keymap";
    private static final String KEYBOARD_SHORTCUT = "keyboard-shortcut";
    private static final String KEYBOARD_GESTURE_SHORTCUT = "keyboard-gesture-shortcut";
    private static final String KEYBOARD_GESTURE_KEY = "keystroke";
    private static final String KEYBOARD_GESTURE_MODIFIER = "modifier";
    private static final String KEYSTROKE_ATTRIBUTE = "keystroke";
    private static final String FIRST_KEYSTROKE_ATTRIBUTE = "first-keystroke";
    private static final String SECOND_KEYSTROKE_ATTRIBUTE = "second-keystroke";
    private static final String ACTION = "action";
    private static final String VERSION_ATTRIBUTE = "version";
    private static final String PARENT_ATTRIBUTE = "parent";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String ID_ATTRIBUTE = "id";
    private static final String MOUSE_SHORTCUT = "mouse-shortcut";
    private static final Logger LOG;

    @NotNull
    public static final KeymapImpl KeymapImpl(@NotNull String name, @NotNull SchemeDataHolder<? super KeymapImpl> dataHolder) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)NAME_ATTRIBUTE);
        Intrinsics.checkParameterIsNotNull(dataHolder, (String)"dataHolder");
        KeymapImpl result2 = new KeymapImpl(dataHolder);
        result2.setName(name);
        result2.schemeState = SchemeState.UNCHANGED;
        return result2;
    }

    private static final String[] sortInRegistrationOrder(List<String> ids) {
        Object[] array = ArrayUtilRt.toStringArray((Collection)ids);
        Intrinsics.checkExpressionValueIsNotNull((Object)array, (String)"array");
        ActionManagerEx actionManagerEx = ActionManagerEx.getInstanceEx();
        Intrinsics.checkExpressionValueIsNotNull((Object)actionManagerEx, (String)"ActionManagerEx.getInstanceEx()");
        Comparator comparator2 = actionManagerEx.getRegistrationOrderComparator();
        Intrinsics.checkExpressionValueIsNotNull((Object)comparator2, (String)"ActionManagerEx.getInsta\u2026gistrationOrderComparator");
        ArraysKt.sortWith((Object[])array, (Comparator)comparator2);
        return array;
    }

    private static final boolean areShortcutsEqual(List<? extends Shortcut> shortcuts1, List<? extends Shortcut> shortcuts2) {
        if (shortcuts1.size() != shortcuts2.size()) {
            return false;
        }
        for (Shortcut shortcut : shortcuts1) {
            if (shortcuts2.contains(shortcut)) continue;
            return false;
        }
        return true;
    }

    static {
        KEY_MAP = KEY_MAP;
        KEYBOARD_SHORTCUT = KEYBOARD_SHORTCUT;
        KEYBOARD_GESTURE_SHORTCUT = KEYBOARD_GESTURE_SHORTCUT;
        KEYBOARD_GESTURE_KEY = "keystroke";
        KEYBOARD_GESTURE_MODIFIER = KEYBOARD_GESTURE_MODIFIER;
        KEYSTROKE_ATTRIBUTE = "keystroke";
        FIRST_KEYSTROKE_ATTRIBUTE = FIRST_KEYSTROKE_ATTRIBUTE;
        SECOND_KEYSTROKE_ATTRIBUTE = SECOND_KEYSTROKE_ATTRIBUTE;
        ACTION = ACTION;
        VERSION_ATTRIBUTE = VERSION_ATTRIBUTE;
        PARENT_ATTRIBUTE = PARENT_ATTRIBUTE;
        NAME_ATTRIBUTE = NAME_ATTRIBUTE;
        ID_ATTRIBUTE = ID_ATTRIBUTE;
        MOUSE_SHORTCUT = MOUSE_SHORTCUT;
        Logger logger = Logger.getInstance(KeymapImpl.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ boolean access$areShortcutsEqual(@NotNull List shortcuts1, @NotNull List shortcuts2) {
        return KeymapImplKt.areShortcutsEqual(shortcuts1, shortcuts2);
    }

    @NotNull
    public static final /* synthetic */ String[] access$sortInRegistrationOrder(@Nullable List ids) {
        return KeymapImplKt.sortInRegistrationOrder(ids);
    }

    @NotNull
    public static final /* synthetic */ String access$getKEY_MAP$p() {
        return KEY_MAP;
    }

    @NotNull
    public static final /* synthetic */ String access$getVERSION_ATTRIBUTE$p() {
        return VERSION_ATTRIBUTE;
    }

    @NotNull
    public static final /* synthetic */ String access$getNAME_ATTRIBUTE$p() {
        return NAME_ATTRIBUTE;
    }

    @NotNull
    public static final /* synthetic */ String access$getPARENT_ATTRIBUTE$p() {
        return PARENT_ATTRIBUTE;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    @NotNull
    public static final /* synthetic */ String access$getACTION$p() {
        return ACTION;
    }

    @NotNull
    public static final /* synthetic */ String access$getID_ATTRIBUTE$p() {
        return ID_ATTRIBUTE;
    }

    @NotNull
    public static final /* synthetic */ String access$getKEYBOARD_SHORTCUT$p() {
        return KEYBOARD_SHORTCUT;
    }

    @NotNull
    public static final /* synthetic */ String access$getFIRST_KEYSTROKE_ATTRIBUTE$p() {
        return FIRST_KEYSTROKE_ATTRIBUTE;
    }

    @NotNull
    public static final /* synthetic */ String access$getSECOND_KEYSTROKE_ATTRIBUTE$p() {
        return SECOND_KEYSTROKE_ATTRIBUTE;
    }

    @NotNull
    public static final /* synthetic */ String access$getKEYBOARD_GESTURE_SHORTCUT$p() {
        return KEYBOARD_GESTURE_SHORTCUT;
    }

    @NotNull
    public static final /* synthetic */ String access$getKEYBOARD_GESTURE_KEY$p() {
        return KEYBOARD_GESTURE_KEY;
    }

    @NotNull
    public static final /* synthetic */ String access$getKEYBOARD_GESTURE_MODIFIER$p() {
        return KEYBOARD_GESTURE_MODIFIER;
    }

    @NotNull
    public static final /* synthetic */ String access$getMOUSE_SHORTCUT$p() {
        return MOUSE_SHORTCUT;
    }

    @NotNull
    public static final /* synthetic */ String access$getKEYSTROKE_ATTRIBUTE$p() {
        return KEYSTROKE_ATTRIBUTE;
    }
}

