/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.ChangeListRemoveConfirmation$WhenMappings;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJG\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2'\u0010\u000f\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\b0\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\n0\u0010H\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/ChangeListRemoveConfirmation;", "", "()V", "checkCanDeleteChangelist", "Lcom/intellij/util/ThreeState;", "project", "Lcom/intellij/openapi/project/Project;", "list", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "explicitly", "", "deleteEmptyInactiveLists", "", "lists", "", "confirm", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "toAsk", "intellij.platform.vcs.impl"})
public final class ChangeListRemoveConfirmation {
    public static final ChangeListRemoveConfirmation INSTANCE;

    @NotNull
    public final ThreeState checkCanDeleteChangelist(@NotNull Project project, @NotNull LocalChangeList list2, boolean explicitly) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)list2, (String)"list");
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectLevelVcsManager, (String)"ProjectLevelVcsManager.getInstance(project)");
        AbstractVcs[] activeVcss = projectLevelVcsManager.getAllActiveVcss();
        boolean confirmationAsked = false;
        boolean removeVetoed = false;
        for (AbstractVcs vcs : activeVcss) {
            ThreeState permission = vcs.mayRemoveChangeList(list2, explicitly);
            if (permission != ThreeState.UNSURE) {
                confirmationAsked = true;
            }
            if (permission != ThreeState.NO) continue;
            removeVetoed = true;
            break;
        }
        if (!confirmationAsked) {
            return ThreeState.UNSURE;
        }
        if (removeVetoed) {
            return ThreeState.NO;
        }
        return ThreeState.YES;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void deleteEmptyInactiveLists(@NotNull Project project, @NotNull Collection<? extends LocalChangeList> lists, @NotNull Function1<? super List<? extends LocalChangeList>, Boolean> confirm) {
        Collection list2;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(lists, (String)"lists");
        Intrinsics.checkParameterIsNotNull(confirm, (String)"confirm");
        ChangeListManager manager = ChangeListManager.getInstance((Project)project);
        List toRemove2 = new ArrayList();
        List toAsk = new ArrayList();
        Iterable iterable = $receiver$iv = (Iterable)lists;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            LocalChangeList localChangeList;
            Object element$iv$iv = element$iv$iv$iv;
            LocalChangeList it = (LocalChangeList)element$iv$iv;
            if (manager.getChangeList(it.getId()) == null) continue;
            LocalChangeList it$iv$iv = localChangeList;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterator<Object> iterator = ((List)destination$iv$iv).iterator();
        while (iterator.hasNext()) {
            Collection collection = list2 = (LocalChangeList)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"list");
            if (collection.isDefault()) continue;
            switch (ChangeListRemoveConfirmation$WhenMappings.$EnumSwitchMapping$0[INSTANCE.checkCanDeleteChangelist(project, (LocalChangeList)list2, false).ordinal()]) {
                case 1: {
                    toAsk.add(list2);
                    break;
                }
                case 2: {
                    toRemove2.add(list2);
                }
            }
        }
        list2 = toAsk;
        if (!list2.isEmpty() && ((Boolean)confirm.invoke((Object)toAsk)).booleanValue()) {
            toRemove2.addAll(toAsk);
        }
        Iterable $receiver$iv2 = toRemove2;
        for (Object element$iv : $receiver$iv2) {
            LocalChangeList it = (LocalChangeList)element$iv;
            manager.removeChangeList(it.getName());
        }
    }

    private ChangeListRemoveConfirmation() {
    }

    static {
        ChangeListRemoveConfirmation changeListRemoveConfirmation;
        INSTANCE = changeListRemoveConfirmation = new ChangeListRemoveConfirmation();
    }
}

