/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00120\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/impl/ModuleVcsDetector;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "myVcsManager", "Lcom/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl;", "startupManager", "Lcom/intellij/openapi/startup/StartupManager;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl;Lcom/intellij/openapi/startup/StartupManager;)V", "autoDetectModuleVcsMapping", "", "module", "Lcom/intellij/openapi/module/Module;", "autoDetectVcsMappings", "tryMapPieces", "", "getMappings", "", "Lkotlin/Pair;", "", "Lcom/intellij/openapi/vcs/VcsDirectoryMapping;", "MyModulesListener", "intellij.platform.vcs.impl"})
public final class ModuleVcsDetector {
    private final Project myProject;
    private final ProjectLevelVcsManagerImpl myVcsManager;

    /*
     * WARNING - void declaration
     */
    private final void autoDetectVcsMappings(boolean tryMapPieces) {
        Iterable it;
        void $receiver$iv$iv;
        Iterable list$iv$iv;
        void $receiver$iv$iv2;
        Module[] $receiver$iv;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(myProject)");
        Module[] moduleArray = moduleManager.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"ModuleManager.getInstance(myProject).modules");
        Module[] moduleArray2 = $receiver$iv = moduleArray;
        Iterable destination$iv$iv = new ArrayList();
        void var6_5 = $receiver$iv$iv2;
        int n = ((void)var6_5).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it2;
            void v2 = it2 = (element$iv$iv = var6_5[i]);
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            Object[] objectArray = ProjectUtil.getRootManager((Module)v2).getContentRoots();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"it.rootManager.contentRoots");
            list$iv$iv = ArraysKt.asIterable((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List roots = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        Iterable $receiver$iv2 = roots;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            Pair pair;
            Pair pair2;
            Object element$iv$iv = element$iv$iv$iv;
            VirtualFile root = (VirtualFile)element$iv$iv;
            if (this.myVcsManager.findVersioningVcs(root) != null) {
                it = list$iv$iv;
                pair2 = TuplesKt.to((Object)root, (Object)it);
            } else {
                pair2 = null;
            }
            if (pair2 == null) continue;
            Pair it$iv$iv = pair = pair2;
            destination$iv$iv2.add(it$iv$iv);
        }
        List rootVcses = (List)destination$iv$iv2;
        if (rootVcses.size() == 1) {
            void root;
            destination$iv$iv2 = (Pair)CollectionsKt.first((List)rootVcses);
            $receiver$iv2 = (VirtualFile)destination$iv$iv2.component1();
            AbstractVcs vcs = (AbstractVcs)destination$iv$iv2.component2();
            VirtualFile projectBaseDir = this.myProject.getBaseDir();
            if (projectBaseDir != null && Intrinsics.areEqual((Object)projectBaseDir, (Object)root)) {
                Iterator $receiver$iv$iv3;
                Object item$iv$iv2;
                void $receiver$iv$iv4;
                Object element$iv$iv$iv;
                Iterable $receiver$iv3 = roots;
                element$iv$iv$iv = $receiver$iv3;
                Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
                for (Object item$iv$iv2 : $receiver$iv$iv4) {
                    it = (VirtualFile)item$iv$iv2;
                    Collection collection = destination$iv$iv3;
                    Iterable iterable = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"it");
                    String string = iterable.getPath();
                    collection.add(string);
                }
                Set rootPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
                List<VcsDirectoryMapping> list2 = this.myVcsManager.getDirectoryMappings();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"myVcsManager.directoryMappings");
                Iterable $receiver$iv4 = list2;
                destination$iv$iv3 = $receiver$iv4;
                Collection destination$iv$iv4 = new ArrayList();
                item$iv$iv2 = $receiver$iv$iv3.iterator();
                while (item$iv$iv2.hasNext()) {
                    VcsDirectoryMapping it3;
                    Object element$iv$iv = item$iv$iv2.next();
                    VcsDirectoryMapping vcsDirectoryMapping = it3 = (VcsDirectoryMapping)element$iv$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)vcsDirectoryMapping, (String)"it");
                    if (!rootPaths.contains(vcsDirectoryMapping.getDirectory())) continue;
                    destination$iv$iv4.add(element$iv$iv);
                }
                List redundantMappings = (List)destination$iv$iv4;
                AbstractVcs abstractVcs = vcs;
                Intrinsics.checkExpressionValueIsNotNull((Object)abstractVcs, (String)"vcs");
                this.myVcsManager.setAutoDirectoryMapping("", abstractVcs.getName());
                $receiver$iv4 = redundantMappings;
                for (Object element$iv : $receiver$iv4) {
                    VcsDirectoryMapping it4 = (VcsDirectoryMapping)element$iv;
                    this.myVcsManager.removeDirectoryMapping(it4);
                }
                this.myVcsManager.cleanupMappings();
            }
        } else if (tryMapPieces) {
            $receiver$iv2 = rootVcses;
            for (Object element$iv : $receiver$iv2) {
                Pair $root_vcs = (Pair)element$iv;
                VirtualFile root = (VirtualFile)$root_vcs.component1();
                AbstractVcs vcs = (AbstractVcs)$root_vcs.component2();
                VirtualFile virtualFile = root;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"root");
                String string = virtualFile.getPath();
                AbstractVcs abstractVcs = vcs;
                Intrinsics.checkExpressionValueIsNotNull((Object)abstractVcs, (String)"vcs");
                this.myVcsManager.setAutoDirectoryMapping(string, abstractVcs.getName());
            }
            this.myVcsManager.cleanupMappings();
        }
    }

    private final void autoDetectModuleVcsMapping(Module module) {
        boolean mappingsUpdated = false;
        for (VirtualFile file2 : ProjectUtil.getRootManager((Module)module).getContentRoots()) {
            AbstractVcs vcs = this.myVcsManager.findVersioningVcs(file2);
            if (vcs == null || vcs == this.myVcsManager.getVcsFor(file2, module)) continue;
            VirtualFile virtualFile = file2;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
            this.myVcsManager.setAutoDirectoryMapping(virtualFile.getPath(), vcs.getName());
            mappingsUpdated = true;
        }
        if (mappingsUpdated) {
            this.myVcsManager.cleanupMappings();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, VcsDirectoryMapping>> getMappings(Module module) {
        Object $receiver$iv$iv;
        void $receiver$iv$iv$iv;
        String moduleName = module.getName();
        VirtualFile[] virtualFileArray = ProjectUtil.getRootManager((Module)module).getContentRoots();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"module.rootManager.contentRoots");
        Object $receiver$iv = virtualFileArray;
        VirtualFile[] virtualFileArray2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void var7_7 = $receiver$iv$iv$iv = $receiver$iv$iv;
        int n = ((void)var7_7).length;
        for (int i = 0; i < n; ++i) {
            VcsDirectoryMapping vcsDirectoryMapping;
            Object v4;
            block3: {
                void element$iv$iv$iv;
                void element$iv$iv;
                void root = element$iv$iv = (element$iv$iv$iv = var7_7[i]);
                List<VcsDirectoryMapping> list2 = this.myVcsManager.getDirectoryMappings();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"myVcsManager.directoryMappings");
                Iterable $receiver$iv2 = list2;
                for (Object element$iv : $receiver$iv2) {
                    VcsDirectoryMapping it = (VcsDirectoryMapping)element$iv;
                    String string = it.systemIndependentPath();
                    void v3 = root;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"root");
                    if (!Intrinsics.areEqual((Object)string, (Object)v3.getPath())) continue;
                    v4 = element$iv;
                    break block3;
                }
                v4 = null;
            }
            if ((VcsDirectoryMapping)v4 == null) continue;
            VcsDirectoryMapping it$iv$iv = vcsDirectoryMapping;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            VcsDirectoryMapping vcsDirectoryMapping = (VcsDirectoryMapping)item$iv$iv;
            Collection collection = destination$iv$iv;
            Pair pair = TuplesKt.to((Object)moduleName, (Object)it);
            collection.add(pair);
        }
        return (List)destination$iv$iv;
    }

    public ModuleVcsDetector(@NotNull Project myProject, @NotNull ProjectLevelVcsManagerImpl myVcsManager, @NotNull StartupManager startupManager) {
        Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
        Intrinsics.checkParameterIsNotNull((Object)((Object)myVcsManager), (String)"myVcsManager");
        Intrinsics.checkParameterIsNotNull((Object)startupManager, (String)"startupManager");
        this.myProject = myProject;
        this.myVcsManager = myVcsManager;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode()) {
            StartupManager $receiver = startupManager;
            $receiver.registerStartupActivity(new Runnable(this){
                final /* synthetic */ ModuleVcsDetector this$0;
                {
                    this.this$0 = moduleVcsDetector;
                }

                public final void run() {
                    if (ModuleVcsDetector.access$getMyVcsManager$p(this.this$0).needAutodetectMappings()) {
                        ModuleVcsDetector.access$autoDetectVcsMappings(this.this$0, true);
                    }
                }
            });
            $receiver.registerPostStartupActivity(new Runnable(this){
                final /* synthetic */ ModuleVcsDetector this$0;
                {
                    this.this$0 = moduleVcsDetector;
                }

                public final void run() {
                    MessageBusConnection messageBusConnection;
                    MyModulesListener listener2 = this.this$0.new MyModulesListener();
                    MessageBusConnection $receiver = messageBusConnection = ModuleVcsDetector.access$getMyProject$p(this.this$0).getMessageBus().connect();
                    $receiver.subscribe(ProjectTopics.MODULES, (Object)listener2);
                    $receiver.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)listener2);
                }
            });
        }
    }

    @NotNull
    public static final /* synthetic */ Project access$getMyProject$p(ModuleVcsDetector $this) {
        return $this.myProject;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/impl/ModuleVcsDetector$MyModulesListener;", "Lcom/intellij/openapi/roots/ModuleRootListener;", "Lcom/intellij/openapi/project/ModuleListener;", "(Lcom/intellij/openapi/vcs/impl/ModuleVcsDetector;)V", "myMappingsForRemovedModules", "", "Lkotlin/Pair;", "", "Lcom/intellij/openapi/vcs/VcsDirectoryMapping;", "beforeModuleRemoved", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "beforeRootsChange", "event", "Lcom/intellij/openapi/roots/ModuleRootEvent;", "moduleAdded", "rootsChanged", "intellij.platform.vcs.impl"})
    private final class MyModulesListener
    implements ModuleRootListener,
    ModuleListener {
        private final List<Pair<String, VcsDirectoryMapping>> myMappingsForRemovedModules;

        public void beforeRootsChange(@NotNull ModuleRootEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            this.myMappingsForRemovedModules.clear();
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            Iterable $receiver$iv = this.myMappingsForRemovedModules;
            for (Object element$iv : $receiver$iv) {
                Pair $$_$_mapping = (Pair)element$iv;
                VcsDirectoryMapping mapping = (VcsDirectoryMapping)$$_$_mapping.component2();
                ModuleVcsDetector.this.myVcsManager.removeDirectoryMapping(mapping);
            }
            if (ModuleVcsDetector.this.myVcsManager.needAutodetectMappings()) {
                ModuleVcsDetector.this.autoDetectVcsMappings(false);
            }
        }

        public void moduleAdded(@NotNull Project project, @NotNull Module module) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            this.myMappingsForRemovedModules.removeAll(ModuleVcsDetector.this.getMappings(module));
            ModuleVcsDetector.this.autoDetectModuleVcsMapping(module);
        }

        public void beforeModuleRemoved(@NotNull Project project, @NotNull Module module) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            this.myMappingsForRemovedModules.addAll(ModuleVcsDetector.this.getMappings(module));
        }

        public MyModulesListener() {
            List list2;
            MyModulesListener myModulesListener = this;
            myModulesListener.myMappingsForRemovedModules = list2 = (List)new ArrayList();
        }
    }
}

