/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.impl.RepositoryBrowserPanel;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007\"\u001f\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"REPOSITORY_BROWSER_DATA_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/openapi/vcs/impl/RepositoryBrowserPanel;", "kotlin.jvm.PlatformType", "getREPOSITORY_BROWSER_DATA_KEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "TOOLWINDOW_ID", "", "registerRepositoriesToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "project", "Lcom/intellij/openapi/project/Project;", "showRepositoryBrowser", "", "root", "Lcom/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile;", "localRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "title", "intellij.platform.vcs.impl"})
public final class RepositoryBrowserKt {
    @NotNull
    public static final String TOOLWINDOW_ID = "Repositories";
    @NotNull
    private static final DataKey<RepositoryBrowserPanel> REPOSITORY_BROWSER_DATA_KEY = DataKey.create((String)"com.intellij.openapi.vcs.impl.RepositoryBrowserPanel");

    public static final void showRepositoryBrowser(@NotNull Project project, @NotNull AbstractVcsVirtualFile root, @NotNull VirtualFile localRoot, @NotNull String title) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)root), (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)localRoot, (String)"localRoot");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(TOOLWINDOW_ID);
        if (toolWindow == null) {
            ToolWindowManager toolWindowManager2 = toolWindowManager;
            Intrinsics.checkExpressionValueIsNotNull((Object)toolWindowManager2, (String)"toolWindowManager");
            toolWindow = RepositoryBrowserKt.registerRepositoriesToolWindow(toolWindowManager2, project);
        }
        ToolWindow repoToolWindow = toolWindow;
        ContentManager contentManager = repoToolWindow.getContentManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)contentManager, (String)"repoToolWindow.contentManager");
        Content[] contentArray = contentManager.getContents();
        int n = contentArray.length;
        for (int i = 0; i < n; ++i) {
            RepositoryBrowserPanel component;
            Content content;
            Content content2 = content = contentArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)content2, (String)"content");
            JComponent jComponent = content2.getComponent();
            if (!(jComponent instanceof RepositoryBrowserPanel)) {
                jComponent = null;
            }
            if ((RepositoryBrowserPanel)jComponent == null) {
                continue;
            }
            if (!Intrinsics.areEqual((Object)((Object)component.getRoot()), (Object)((Object)root))) continue;
            repoToolWindow.getContentManager().setSelectedContent(content);
            return;
        }
        RepositoryBrowserPanel contentPanel = new RepositoryBrowserPanel(project, root, localRoot);
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)contentPanel, title, true);
        repoToolWindow.getContentManager().addContent(content);
        repoToolWindow.getContentManager().setSelectedContent(content, true);
        repoToolWindow.activate(null);
    }

    private static final ToolWindow registerRepositoriesToolWindow(ToolWindowManager toolWindowManager, Project project) {
        ToolWindow toolWindow;
        ToolWindow toolWindow2 = toolWindow = toolWindowManager.registerToolWindow(TOOLWINDOW_ID, true, ToolWindowAnchor.LEFT, (Disposable)project, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)toolWindow2, (String)"toolWindow");
        new ContentManagerWatcher(toolWindow, toolWindow2.getContentManager());
        return toolWindow;
    }

    @NotNull
    public static final DataKey<RepositoryBrowserPanel> getREPOSITORY_BROWSER_DATA_KEY() {
        return REPOSITORY_BROWSER_DATA_KEY;
    }
}

