/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ModuleAttachProcessorKt;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/ModuleAttachProcessor;", "Lcom/intellij/projectImport/ProjectAttachProcessor;", "()V", "attachToProject", "", "project", "Lcom/intellij/openapi/project/Project;", "projectDir", "Ljava/nio/file/Path;", "callback", "Lcom/intellij/projectImport/ProjectOpenedCallback;", "Companion", "intellij.platform.lang.impl"})
public final class ModuleAttachProcessor
extends ProjectAttachProcessor {
    public static final Companion Companion = new Companion(null);

    public boolean attachToProject(@NotNull Project project, @NotNull Path projectDir, @Nullable ProjectOpenedCallback callback2) {
        boolean isAttached;
        Path dotIdeaDir;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)projectDir, (String)"projectDir");
        Path path = dotIdeaDir = projectDir.resolve(".idea");
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"dotIdeaDir");
        if (!PathKt.exists((Path)path)) {
            Project project2 = ProjectManagerEx.getInstanceEx().newProject(((Object)projectDir.getFileName()).toString(), ((Object)projectDir).toString(), true, false);
            if (project2 == null) {
                return false;
            }
            Project newProject = project2;
            VirtualFile baseDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(PathKt.getSystemIndependentPath((Path)projectDir));
            PlatformProjectOpenProcessor.runDirectoryProjectConfigurators(baseDir, newProject);
            newProject.save();
            ApplicationManager.getApplication().runWriteAction(new Computable<T>(newProject){
                final /* synthetic */ Project $newProject$inlined;
                {
                    this.$newProject$inlined = project;
                }

                public final T compute() {
                    Disposer.dispose((Disposable)((Disposable)this.$newProject$inlined));
                    return (T)Unit.INSTANCE;
                }
            });
        }
        if (!(isAttached = ModuleAttachProcessorKt.access$findMainModule(project, dotIdeaDir, callback2))) {
            isAttached = ModuleAttachProcessorKt.access$findMainModule(project, projectDir, callback2);
        }
        if (isAttached) {
            return true;
        }
        return Messages.showYesNoDialog((Project)project, (String)("The project at " + projectDir + " uses a non-standard layout and cannot be attached to this project. Would you like to open it in a new window?"), (String)"Open Project", (Icon)Messages.getQuestionIcon()) != 0;
    }

    @JvmStatic
    @Nullable
    public static final Module findModuleInBaseDir(@NotNull Project project) {
        return Companion.findModuleInBaseDir(project);
    }

    @JvmStatic
    @Nullable
    public static final Module getPrimaryModule(@NotNull Project project) {
        return Companion.getPrimaryModule(project);
    }

    @JvmStatic
    @NotNull
    public static final List<Module> getSortedModules(@NotNull Project project) {
        return Companion.getSortedModules(project);
    }

    @JvmStatic
    @Nullable
    public static final String getMultiProjectDisplayName(@NotNull Project project) {
        return Companion.getMultiProjectDisplayName(project);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/ModuleAttachProcessor$Companion;", "", "()V", "findModuleInBaseDir", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "getMultiProjectDisplayName", "", "getPrimaryModule", "getSortedModules", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final Module findModuleInBaseDir(@NotNull Project project) {
            Module module;
            block3: {
                Module[] $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                VirtualFile baseDir = project.getBaseDir();
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                Module[] moduleArray = moduleManager.getModules();
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
                Module[] moduleArray2 = $receiver$iv = moduleArray;
                int n = moduleArray2.length;
                for (int i = 0; i < n; ++i) {
                    boolean bl;
                    Module element$iv;
                    block2: {
                        VirtualFile[] $receiver$iv2;
                        Module it;
                        Module module2 = it = (element$iv = moduleArray2[i]);
                        Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"it");
                        Intrinsics.checkExpressionValueIsNotNull((Object)ProjectUtil.getRootManager((Module)module2).getContentRoots(), (String)"it.rootManager.contentRoots");
                        for (VirtualFile element$iv2 : $receiver$iv2) {
                            VirtualFile it2 = element$iv2;
                            if (!Intrinsics.areEqual((Object)it2, (Object)baseDir)) continue;
                            bl = true;
                            break block2;
                        }
                        bl = false;
                    }
                    if (!bl) continue;
                    module = element$iv;
                    break block3;
                }
                module = null;
            }
            return module;
        }

        @JvmStatic
        @Nullable
        public final Module getPrimaryModule(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return ProjectAttachProcessor.canAttachToProject() ? this.findModuleInBaseDir(project) : null;
        }

        @JvmStatic
        @NotNull
        public final List<Module> getSortedModules(@NotNull Project project) {
            ArrayList<Module> result2;
            block2: {
                Module module;
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Module primaryModule = this.getPrimaryModule(project);
                result2 = new ArrayList<Module>();
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                Module[] moduleArray = moduleManager.getModules();
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
                Object $receiver$iv = moduleArray;
                for (Module element$iv : $receiver$iv) {
                    Module it = element$iv;
                    if (!(it != primaryModule)) continue;
                    ((Collection)result2).add(element$iv);
                }
                $receiver$iv = result2;
                if ($receiver$iv.size() > 1) {
                    Object object = $receiver$iv;
                    Comparator comparator2 = new Comparator<T>(){

                        public final int compare(T a, T b) {
                            Module p1 = (Module)a;
                            Comparable comparable = (Comparable)((Object)p1.getName());
                            p1 = (Module)b;
                            Comparable comparable2 = comparable;
                            String string = p1.getName();
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                        }
                    };
                    CollectionsKt.sortWith((List)object, (Comparator)comparator2);
                }
                Module module2 = primaryModule;
                if (module2 == null) break block2;
                Module module3 = module = module2;
                result2.add(0, module3);
            }
            return result2;
        }

        @JvmStatic
        @Nullable
        public final String getMultiProjectDisplayName(@NotNull Project project) {
            Module primaryModule;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            if (!ProjectAttachProcessor.canAttachToProject()) {
                return null;
            }
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
            Object[] modules = moduleManager.getModules();
            if (modules.length <= 1) {
                return null;
            }
            Module module = this.getPrimaryModule(project);
            if (module == null) {
                Intrinsics.checkExpressionValueIsNotNull((Object)modules, (String)"modules");
                module = (Module)ArraysKt.first((Object[])modules);
            }
            Module module2 = primaryModule = module;
            Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"primaryModule");
            StringBuilder result2 = new StringBuilder(module2.getName());
            result2.append(", ");
            int n = modules.length;
            for (int i = 0; i < n; ++i) {
                Object module3 = modules[i];
                if (module3 == primaryModule) continue;
                Object object = module3;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"module");
                result2.append(object.getName());
                break;
            }
            if (modules.length > 2) {
                result2.append("...");
            }
            return result2.toString();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

