/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.google.common.base.MoreObjects;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.SmartPointerAnchorProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.WeakInterner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Identikit {
    private static final Logger LOG = Logger.getInstance(Identikit.class);
    private static final WeakInterner<ByType> ourPlainInterner = new WeakInterner();
    private static final WeakInterner<ByAnchor> ourAnchorInterner = new WeakInterner();

    @Nullable
    public abstract PsiElement findPsiElement(@NotNull PsiFile var1, int var2, int var3);

    @NotNull
    public abstract Language getFileLanguage();

    public abstract boolean isForPsiFile();

    public static ByType fromPsi(@NotNull PsiElement element, @NotNull Language fileLanguage) {
        if (element == null) {
            Identikit.$$$reportNull$$$0(0);
        }
        if (fileLanguage == null) {
            Identikit.$$$reportNull$$$0(1);
        }
        return Identikit.fromTypes(element.getClass(), PsiUtilCore.getElementType((PsiElement)element), fileLanguage);
    }

    @Nullable
    static Pair<ByAnchor, PsiElement> withAnchor(@NotNull PsiElement element, @NotNull Language fileLanguage) {
        if (element == null) {
            Identikit.$$$reportNull$$$0(2);
        }
        if (fileLanguage == null) {
            Identikit.$$$reportNull$$$0(3);
        }
        PsiUtilCore.ensureValid((PsiElement)element);
        if (element.isPhysical()) {
            for (SmartPointerAnchorProvider provider : (SmartPointerAnchorProvider[])SmartPointerAnchorProvider.EP_NAME.getExtensions()) {
                PsiElement anchor2 = provider.getAnchor(element);
                if (anchor2 == null || !anchor2.isPhysical() || provider.restoreElement(anchor2) != element) continue;
                ByAnchor anchorKit = new ByAnchor(Identikit.fromPsi(element, fileLanguage), Identikit.fromPsi(anchor2, fileLanguage), provider);
                return Pair.create((Object)ourAnchorInterner.intern((Object)anchorKit), (Object)anchor2);
            }
        }
        return null;
    }

    @NotNull
    static ByType fromTypes(@NotNull Class elementClass, @Nullable IElementType elementType, @NotNull Language fileLanguage) {
        if (elementClass == null) {
            Identikit.$$$reportNull$$$0(4);
        }
        if (fileLanguage == null) {
            Identikit.$$$reportNull$$$0(5);
        }
        ByType byType = (ByType)ourPlainInterner.intern((Object)new ByType(elementClass, elementType, fileLanguage));
        if (byType == null) {
            Identikit.$$$reportNull$$$0(6);
        }
        return byType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileLanguage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/smartPointers/Identikit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/smartPointers/Identikit";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fromTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromPsi";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withAnchor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromTypes";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ByAnchor
    extends Identikit {
        private final ByType myElementInfo;
        private final ByType myAnchorInfo;
        private final SmartPointerAnchorProvider myAnchorProvider;

        ByAnchor(@NotNull ByType elementInfo, @NotNull ByType anchorInfo, @NotNull SmartPointerAnchorProvider anchorProvider) {
            if (elementInfo == null) {
                ByAnchor.$$$reportNull$$$0(0);
            }
            if (anchorInfo == null) {
                ByAnchor.$$$reportNull$$$0(1);
            }
            if (anchorProvider == null) {
                ByAnchor.$$$reportNull$$$0(2);
            }
            this.myElementInfo = elementInfo;
            this.myAnchorInfo = anchorInfo;
            this.myAnchorProvider = anchorProvider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ByAnchor)) {
                return false;
            }
            ByAnchor anchor2 = (ByAnchor)o;
            if (!this.myElementInfo.equals(anchor2.myElementInfo)) {
                return false;
            }
            if (!this.myAnchorInfo.equals(anchor2.myAnchorInfo)) {
                return false;
            }
            return this.myAnchorProvider.equals(anchor2.myAnchorProvider);
        }

        public int hashCode() {
            return this.myElementInfo.hashCode();
        }

        @Override
        @Nullable
        public PsiElement findPsiElement(@NotNull PsiFile file2, int startOffset, int endOffset) {
            PsiElement anchor2;
            if (file2 == null) {
                ByAnchor.$$$reportNull$$$0(3);
            }
            PsiElement element = (anchor2 = this.myAnchorInfo.findPsiElement(file2, startOffset, endOffset)) == null ? null : this.myAnchorProvider.restoreElement(anchor2);
            return element != null && this.myElementInfo.isAcceptable(element) ? element : null;
        }

        @Override
        @NotNull
        public Language getFileLanguage() {
            Language language = this.myAnchorInfo.getFileLanguage();
            if (language == null) {
                ByAnchor.$$$reportNull$$$0(4);
            }
            return language;
        }

        @Override
        public boolean isForPsiFile() {
            return this.myAnchorInfo.isForPsiFile();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchorInfo";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchorProvider";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/smartPointers/Identikit$ByAnchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/smartPointers/Identikit$ByAnchor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileLanguage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findPsiElement";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ByType
    extends Identikit {
        private final Class myElementClass;
        private final IElementType myElementType;
        private final Language myFileLanguage;

        private ByType(@NotNull Class elementClass, @Nullable IElementType elementType, @NotNull Language fileLanguage) {
            if (elementClass == null) {
                ByType.$$$reportNull$$$0(0);
            }
            if (fileLanguage == null) {
                ByType.$$$reportNull$$$0(1);
            }
            this.myElementClass = elementClass;
            this.myElementType = elementType;
            this.myFileLanguage = fileLanguage;
        }

        @Override
        @Nullable
        public PsiElement findPsiElement(@NotNull PsiFile file2, int startOffset, int endOffset) {
            if (file2 == null) {
                ByType.$$$reportNull$$$0(2);
            }
            Language actualLanguage = this.myFileLanguage != Language.ANY ? this.myFileLanguage : file2.getViewProvider().getBaseLanguage();
            PsiFile actualLanguagePsi = file2.getViewProvider().getPsi(actualLanguage);
            if (actualLanguagePsi == null) {
                LOG.error("getPsi(" + actualLanguage + ")=null; file=" + file2 + "; myLanguage=" + this.myFileLanguage + "; baseLanguage=" + file2.getViewProvider().getBaseLanguage());
                return null;
            }
            return this.findInside((PsiElement)actualLanguagePsi, startOffset, endOffset);
        }

        public PsiElement findInside(@NotNull PsiElement element, int startOffset, int endOffset) {
            PsiElement anchor2;
            if (element == null) {
                ByType.$$$reportNull$$$0(3);
            }
            if ((anchor2 = AbstractFileViewProvider.findElementAt(element, startOffset)) == null && startOffset == element.getTextLength()) {
                anchor2 = PsiTreeUtil.getDeepestLast((PsiElement)element);
            }
            if (anchor2 == null) {
                return null;
            }
            PsiElement result2 = this.findParent(startOffset, endOffset, anchor2);
            if (endOffset == startOffset) {
                while ((result2 == null || result2.getTextRange().getStartOffset() != startOffset) && anchor2.getTextRange().getStartOffset() == endOffset && (anchor2 = PsiTreeUtil.prevLeaf((PsiElement)anchor2, (boolean)false)) != null) {
                    result2 = this.findParent(startOffset, endOffset, anchor2);
                }
            }
            return result2;
        }

        @Nullable
        private PsiElement findParent(int startOffset, int endOffset, PsiElement anchor2) {
            TextRange range2 = anchor2.getTextRange();
            if (range2.getStartOffset() != startOffset) {
                return null;
            }
            while (range2.getEndOffset() < endOffset) {
                if ((anchor2 = anchor2.getParent()) == null || anchor2 instanceof PsiDirectory) {
                    return null;
                }
                range2 = anchor2.getTextRange();
            }
            while (range2.getEndOffset() == endOffset) {
                if (this.isAcceptable(anchor2)) {
                    return anchor2;
                }
                if ((anchor2 = anchor2.getParent()) == null || anchor2 instanceof PsiDirectory) break;
                range2 = anchor2.getTextRange();
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ByType)) {
                return false;
            }
            ByType info = (ByType)o;
            return this.myElementType == info.myElementType && this.myElementClass == info.myElementClass && this.myFileLanguage == info.myFileLanguage;
        }

        public int hashCode() {
            return (this.myElementType == null ? 0 : this.myElementType.hashCode() * 31 * 31) + 31 * this.myElementClass.getName().hashCode() + this.myFileLanguage.hashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("class", (Object)this.myElementClass).add("elementType", (Object)this.myElementType).add("fileLanguage", (Object)this.myFileLanguage).toString();
        }

        @Override
        @NotNull
        public Language getFileLanguage() {
            Language language = this.myFileLanguage;
            if (language == null) {
                ByType.$$$reportNull$$$0(4);
            }
            return language;
        }

        @Override
        public boolean isForPsiFile() {
            return this.myElementType instanceof IFileElementType;
        }

        private boolean isAcceptable(@NotNull PsiElement element) {
            if (element == null) {
                ByType.$$$reportNull$$$0(5);
            }
            return this.myElementClass == element.getClass() && this.myElementType == PsiUtilCore.getElementType((PsiElement)element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileLanguage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/smartPointers/Identikit$ByType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/smartPointers/Identikit$ByType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileLanguage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findPsiElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findInside";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isAcceptable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

