/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.google.common.hash.HashCode;
import com.intellij.index.PrebuiltIndexProviderBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.stubs.PrebuiltStubsProvider;
import com.intellij.psi.stubs.SerializationManagerImpl;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubTreeExternalizer;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.io.PersistentHashMap;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/intellij/psi/stubs/PrebuiltStubsProviderBase;", "Lcom/intellij/index/PrebuiltIndexProviderBase;", "Lcom/intellij/psi/stubs/SerializedStubTree;", "Lcom/intellij/psi/stubs/PrebuiltStubsProvider;", "()V", "indexExternalizer", "Lcom/intellij/psi/stubs/StubTreeExternalizer;", "getIndexExternalizer", "()Lcom/intellij/psi/stubs/StubTreeExternalizer;", "indexName", "", "getIndexName", "()Ljava/lang/String;", "mySerializationManager", "Lcom/intellij/psi/stubs/SerializationManagerImpl;", "stubVersion", "", "getStubVersion", "()I", "findStub", "Lcom/intellij/psi/stubs/Stub;", "fileContent", "Lcom/intellij/util/indexing/FileContent;", "openIndexStorage", "Lcom/intellij/util/io/PersistentHashMap;", "Lcom/google/common/hash/HashCode;", "indexesRoot", "Ljava/io/File;", "Companion", "intellij.platform.lang.impl"})
public abstract class PrebuiltStubsProviderBase
extends PrebuiltIndexProviderBase<SerializedStubTree>
implements PrebuiltStubsProvider {
    private SerializationManagerImpl mySerializationManager;
    @NotNull
    public static final String PREBUILT_INDICES_PATH_PROPERTY = "prebuilt_indices_path";
    @NotNull
    public static final String SDK_STUBS_STORAGE_NAME = "sdk-stubs";
    private static final Logger LOG;
    public static final Companion Companion;

    protected abstract int getStubVersion();

    @Override
    @NotNull
    protected String getIndexName() {
        return SDK_STUBS_STORAGE_NAME;
    }

    @NotNull
    protected StubTreeExternalizer getIndexExternalizer() {
        return new StubTreeExternalizer();
    }

    @Override
    @Nullable
    public PersistentHashMap<HashCode, SerializedStubTree> openIndexStorage(@NotNull File indexesRoot) {
        PersistentHashMap persistentHashMap;
        Intrinsics.checkParameterIsNotNull((Object)indexesRoot, (String)"indexesRoot");
        String versionInFile = FileUtil.loadFile((File)new File(indexesRoot, this.getIndexName() + ".version"));
        if (Integer.parseInt(versionInFile) == this.getStubVersion()) {
            this.mySerializationManager = new SerializationManagerImpl(new File(indexesRoot, this.getIndexName() + ".names"));
            Disposable disposable = (Disposable)ApplicationManager.getApplication();
            SerializationManagerImpl serializationManagerImpl = this.mySerializationManager;
            if (serializationManagerImpl == null) {
                Intrinsics.throwNpe();
            }
            Disposer.register((Disposable)disposable, (Disposable)serializationManagerImpl);
            persistentHashMap = super.openIndexStorage(indexesRoot);
        } else {
            LOG.error("Prebuilt stubs version mismatch: " + versionInFile + ", current version is " + this.getStubVersion());
            persistentHashMap = null;
        }
        return persistentHashMap;
    }

    @Override
    @Nullable
    public Stub findStub(@NotNull FileContent fileContent) {
        Intrinsics.checkParameterIsNotNull((Object)fileContent, (String)"fileContent");
        Stub stub = null;
        try {
            SerializedStubTree stubTree = (SerializedStubTree)this.get(fileContent);
            if (stubTree != null) {
                SerializationManagerImpl serializationManagerImpl = this.mySerializationManager;
                if (serializationManagerImpl == null) {
                    Intrinsics.throwNpe();
                }
                stub = stubTree.getStub(false, serializationManagerImpl);
            }
        }
        catch (SerializerNotFoundException e) {
            LOG.error("Can't deserialize stub tree", (Throwable)e);
        }
        if (stub != null) {
            return stub;
        }
        return null;
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.PrebuiltStubsProviderBase");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/psi/stubs/PrebuiltStubsProviderBase$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "PREBUILT_INDICES_PATH_PROPERTY", "", "SDK_STUBS_STORAGE_NAME", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

