/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.agent.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.agent.annotation.AsyncCall;
import com.intellij.remoteServer.agent.annotation.ChildCall;
import com.intellij.remoteServer.agent.annotation.FinalCall;
import com.intellij.remoteServer.agent.annotation.ImmediateCall;
import com.intellij.remoteServer.agent.impl.ChildWrapperCreator;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jetbrains.annotations.Nullable;

public class ThreadInvocationHandler
implements InvocationHandler {
    private static final Logger LOG = Logger.getInstance(ThreadInvocationHandler.class);
    private final ExecutorService myTaskExecutor;
    private final ClassLoader myCallerClassLoader;
    private final Object myTarget;
    private final ChildWrapperCreator myPreWrapperFactory;

    public ThreadInvocationHandler(ExecutorService taskExecutor, ClassLoader callerClassLoader, Object target2, @Nullable ChildWrapperCreator preWrapperCreator) {
        this.myTaskExecutor = taskExecutor;
        this.myCallerClassLoader = callerClassLoader;
        this.myTarget = target2;
        this.myPreWrapperFactory = preWrapperCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean finalCall;
        Callable<Object> taskCallable;
        block18: {
            boolean finalCall2;
            boolean asyncCall;
            block17: {
                boolean finalCall3;
                boolean immediateCall;
                block15: {
                    boolean finalCall4;
                    Object object;
                    Object child2;
                    block16: {
                        boolean finalCall5;
                        boolean childCall;
                        taskCallable = () -> {
                            try {
                                return method.invoke(this.myTarget, args);
                            }
                            catch (IllegalAccessException | InvocationTargetException e) {
                                LOG.error((Throwable)e);
                                return null;
                            }
                        };
                        immediateCall = method.getAnnotation(ImmediateCall.class) != null;
                        boolean bl = childCall = method.getAnnotation(ChildCall.class) != null;
                        if (!childCall) break block15;
                        Object object2 = child2 = immediateCall ? taskCallable.call() : this.executeAndWait(taskCallable);
                        if (child2 != null) break block16;
                        Object var8_10 = null;
                        boolean bl2 = finalCall5 = method.getAnnotation(FinalCall.class) != null;
                        if (finalCall5) {
                            this.myTaskExecutor.shutdownNow();
                        }
                        return var8_10;
                    }
                    try {
                        Object result2;
                        Class<?> childClass = child2.getClass();
                        if (childClass.isArray()) {
                            Class<?> componentType = childClass.getComponentType();
                            int length = Array.getLength(child2);
                            result2 = Array.newInstance(componentType, length);
                            for (int i = 0; i < length; ++i) {
                                Array.set(result2, i, this.createChildProxy(Array.get(child2, i)));
                            }
                        } else {
                            result2 = this.createChildProxy(child2);
                        }
                        object = result2;
                        boolean bl = finalCall4 = method.getAnnotation(FinalCall.class) != null;
                    }
                    catch (Throwable throwable) {
                        boolean finalCall6;
                        boolean bl = finalCall6 = method.getAnnotation(FinalCall.class) != null;
                        if (finalCall6) {
                            this.myTaskExecutor.shutdownNow();
                        }
                        throw throwable;
                    }
                    if (finalCall4) {
                        this.myTaskExecutor.shutdownNow();
                    }
                    return object;
                }
                if (!immediateCall && !StringUtil.equals((CharSequence)method.getName(), (CharSequence)"toString")) break block17;
                Object child2 = taskCallable.call();
                boolean bl = finalCall3 = method.getAnnotation(FinalCall.class) != null;
                if (finalCall3) {
                    this.myTaskExecutor.shutdownNow();
                }
                return child2;
            }
            boolean bl = asyncCall = method.getAnnotation(AsyncCall.class) != null;
            if (!asyncCall) break block18;
            this.myTaskExecutor.submit(() -> {
                try {
                    taskCallable.call();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            });
            Object var8_13 = null;
            boolean bl3 = finalCall2 = method.getAnnotation(FinalCall.class) != null;
            if (finalCall2) {
                this.myTaskExecutor.shutdownNow();
            }
            return var8_13;
        }
        Object object = this.executeAndWait(taskCallable);
        boolean bl = finalCall = method.getAnnotation(FinalCall.class) != null;
        if (finalCall) {
            this.myTaskExecutor.shutdownNow();
        }
        return object;
    }

    private Object executeAndWait(Callable<Object> taskCallable) throws Throwable {
        Object child2;
        Future<Object> future2 = this.myTaskExecutor.submit(taskCallable);
        try {
            child2 = future2.get();
        }
        catch (InterruptedException e) {
            throw new CancellationException("Operation cancelled");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw cause == null ? e : cause;
        }
        return child2;
    }

    private Object createChildProxy(Object child2) {
        Class<?> callerChildInterface;
        Class<?> childClass = child2.getClass();
        Class<?>[] childInterfaces = childClass.getInterfaces();
        LOG.assertTrue(childInterfaces.length == 1, (Object)"Child class is expected to implement single child interface");
        Class<?> childInterface = childInterfaces[0];
        try {
            callerChildInterface = this.myCallerClassLoader.loadClass(childInterface.getName());
        }
        catch (ClassNotFoundException e) {
            LOG.error((Throwable)e);
            return null;
        }
        Object preWrappedChild = this.myPreWrapperFactory == null ? child2 : Proxy.newProxyInstance(this.myCallerClassLoader, new Class[]{callerChildInterface}, this.myPreWrapperFactory.createWrapperInvocationHandler(child2));
        return Proxy.newProxyInstance(this.myCallerClassLoader, new Class[]{callerChildInterface}, (InvocationHandler)new ThreadInvocationHandler(this.myTaskExecutor, this.myCallerClassLoader, preWrappedChild, this.myPreWrapperFactory));
    }
}

