/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.PowerKt;
import com.intellij.util.io.PowerService;
import com.intellij.util.io.PowerStatus;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.win32.StdCallLibrary;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0002\b\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/util/io/WinPowerService;", "Lcom/intellij/util/io/PowerService;", "()V", "kernel32", "Lcom/intellij/util/io/WinPowerService$Kernel32;", "kotlin.jvm.PlatformType", "status", "Lcom/intellij/util/io/PowerStatus;", "Kernel32", "SYSTEM_POWER_STATUS", "intellij.platform.ide.impl"})
final class WinPowerService
implements PowerService {
    private final Kernel32 kernel32 = (Kernel32)Native.loadLibrary((String)"kernel32", Kernel32.class);

    @Override
    @NotNull
    public PowerStatus status() {
        PowerStatus powerStatus;
        SYSTEM_POWER_STATUS status = new SYSTEM_POWER_STATUS();
        if (!this.kernel32.GetSystemPowerStatus(status)) {
            throw (Throwable)new IOException("GetSystemPowerStatus(): " + this.kernel32.GetLastError());
        }
        Logger logger = PowerKt.access$getLOG$p();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
        if (logger.isDebugEnabled()) {
            PowerKt.access$getLOG$p().debug("ACLineStatus=" + status.ACLineStatus);
        }
        switch (status.ACLineStatus) {
            case 0: {
                powerStatus = PowerStatus.BATTERY;
                break;
            }
            case 1: {
                powerStatus = PowerStatus.AC;
                break;
            }
            default: {
                powerStatus = PowerStatus.UNKNOWN;
            }
        }
        return powerStatus;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/util/io/WinPowerService$SYSTEM_POWER_STATUS;", "Lcom/sun/jna/Structure;", "()V", "ACLineStatus", "", "BatteryFlag", "BatteryFullLifeTime", "", "BatteryLifePercent", "BatteryLifeTime", "SystemStatusFlag", "getFieldOrder", "", "", "intellij.platform.ide.impl"})
    public static final class SYSTEM_POWER_STATUS
    extends Structure {
        @JvmField
        public byte ACLineStatus;
        @JvmField
        public byte BatteryFlag;
        @JvmField
        public byte BatteryLifePercent;
        @JvmField
        public byte SystemStatusFlag;
        @JvmField
        public int BatteryLifeTime;
        @JvmField
        public int BatteryFullLifeTime;

        @NotNull
        protected List<String> getFieldOrder() {
            return CollectionsKt.listOf((Object[])new String[]{"ACLineStatus", "BatteryFlag", "BatteryLifePercent", "SystemStatusFlag", "BatteryLifeTime", "BatteryFullLifeTime"});
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/intellij/util/io/WinPowerService$Kernel32;", "Lcom/sun/jna/win32/StdCallLibrary;", "GetLastError", "", "GetSystemPowerStatus", "", "result", "Lcom/intellij/util/io/WinPowerService$SYSTEM_POWER_STATUS;", "intellij.platform.ide.impl"})
    private static interface Kernel32
    extends StdCallLibrary {
        public boolean GetSystemPowerStatus(@NotNull SYSTEM_POWER_STATUS var1);

        public int GetLastError();
    }
}

