/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.VcsUserKeyDescriptor;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.impl.VcsUserImpl;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tJ\u0014\u0010\u0014\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0016J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0012H\u0016J\u0006\u0010\u001c\u001a\u00020\u0012J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u0012H\u0002R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lcom/intellij/vcs/log/data/VcsUserRegistryImpl;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/vcs/log/VcsUserRegistry;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "_persistentEnumerator", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/util/io/PersistentEnumeratorBase;", "Lcom/intellij/vcs/log/VcsUser;", "interner", "Lcom/intellij/util/containers/Interner;", "mapFile", "Ljava/io/File;", "persistentEnumerator", "getPersistentEnumerator", "()Lcom/intellij/util/io/PersistentEnumeratorBase;", "addUser", "", "user", "addUsers", "users", "", "createUser", "name", "", "email", "dispose", "flush", "getUsers", "", "initEnumerator", "", "rebuild", "Companion", "intellij.platform.vcs.log.impl"})
public final class VcsUserRegistryImpl
implements Disposable,
VcsUserRegistry {
    private final AtomicReference<PersistentEnumeratorBase<VcsUser>> _persistentEnumerator;
    private final Interner<VcsUser> interner;
    private final File mapFile;
    private static final Logger LOG;
    private static final File USER_CACHE_APP_DIR;
    private static final int STORAGE_VERSION = 2;
    public static final Companion Companion;

    private final PersistentEnumeratorBase<VcsUser> getPersistentEnumerator() {
        return this._persistentEnumerator.get();
    }

    private final boolean initEnumerator() {
        try {
            PersistentBTreeEnumerator enumerator2 = (PersistentBTreeEnumerator)IOUtil.openCleanOrResetBroken((ThrowableComputable)new ThrowableComputable<T, IOException>(this){
                final /* synthetic */ VcsUserRegistryImpl this$0;

                @NotNull
                public final PersistentBTreeEnumerator<VcsUser> compute() {
                    return new PersistentBTreeEnumerator(VcsUserRegistryImpl.access$getMapFile$p(this.this$0), (KeyDescriptor)new VcsUserKeyDescriptor(this.this$0), Page.PAGE_SIZE, null, 2);
                }
                {
                    this.this$0 = vcsUserRegistryImpl;
                }
            }, (File)this.mapFile);
            boolean wasSet = this._persistentEnumerator.compareAndSet(null, (PersistentEnumeratorBase<VcsUser>)enumerator2);
            if (!wasSet) {
                LOG.error("Could not assign newly opened enumerator");
                PersistentBTreeEnumerator persistentBTreeEnumerator = enumerator2;
                if (persistentBTreeEnumerator != null) {
                    persistentBTreeEnumerator.close();
                }
            }
            return wasSet;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public VcsUser createUser(@NotNull String name, @NotNull String email) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        Interner<VcsUser> interner = this.interner;
        synchronized (interner) {
            Object object = this.interner.intern((Object)new VcsUserImpl(name, email));
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"interner.intern(VcsUserImpl(name, email))");
            VcsUser vcsUser = (VcsUser)object;
            return vcsUser;
        }
    }

    public final void addUser(@NotNull VcsUser user) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        try {
            PersistentEnumeratorBase<VcsUser> persistentEnumeratorBase = this.getPersistentEnumerator();
            if (persistentEnumeratorBase != null) {
                persistentEnumeratorBase.enumerate((Object)user);
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            this.rebuild();
        }
    }

    public final void addUsers(@NotNull Collection<? extends VcsUser> users) {
        Intrinsics.checkParameterIsNotNull(users, (String)"users");
        for (VcsUser vcsUser : users) {
            this.addUser(vcsUser);
        }
    }

    @NotNull
    public Set<VcsUser> getUsers() {
        Object object;
        try {
            PersistentEnumeratorBase<VcsUser> it;
            Object object2 = this.getPersistentEnumerator();
            object = object2 != null && (object2 = ContainerUtil.newHashSet((Iterable)(it = (object = object2)).getAllDataObjects((PersistentEnumeratorBase.DataFilter)getUsers.1.1.INSTANCE))) != null ? (Set)object2 : SetsKt.emptySet();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            this.rebuild();
            object = SetsKt.emptySet();
        }
        return object;
    }

    private final void rebuild() {
        block2: {
            PersistentEnumeratorBase<VcsUser> persistentEnumeratorBase = this.getPersistentEnumerator();
            if (persistentEnumeratorBase == null) break block2;
            if (persistentEnumeratorBase.isCorrupted()) {
                PersistentEnumeratorBase persistentEnumeratorBase2 = this._persistentEnumerator.getAndSet(null);
                if (persistentEnumeratorBase2 != null) {
                    PersistentEnumeratorBase persistentEnumeratorBase3;
                    PersistentEnumeratorBase oldEnumerator = persistentEnumeratorBase3 = persistentEnumeratorBase2;
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(oldEnumerator, this){
                        final /* synthetic */ PersistentEnumeratorBase $oldEnumerator;
                        final /* synthetic */ VcsUserRegistryImpl this$0;
                        {
                            this.$oldEnumerator = persistentEnumeratorBase;
                            this.this$0 = vcsUserRegistryImpl;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void run() {
                            try {
                                this.$oldEnumerator.close();
                            }
                            catch (IOException iOException) {
                            }
                            finally {
                                VcsUserRegistryImpl.access$initEnumerator(this.this$0);
                            }
                        }
                    });
                }
            }
        }
    }

    public final void flush() {
        block0: {
            PersistentEnumeratorBase<VcsUser> persistentEnumeratorBase = this.getPersistentEnumerator();
            if (persistentEnumeratorBase == null) break block0;
            persistentEnumeratorBase.force();
        }
    }

    public void dispose() {
        try {
            PersistentEnumeratorBase<VcsUser> persistentEnumeratorBase = this.getPersistentEnumerator();
            if (persistentEnumeratorBase != null) {
                persistentEnumeratorBase.close();
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public VcsUserRegistryImpl(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this._persistentEnumerator = new AtomicReference();
        this.mapFile = new File(USER_CACHE_APP_DIR, project.getLocationHash() + "." + 2);
        this.initEnumerator();
        this.interner = new Interner();
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(VcsUserRegistryImpl.class);
        USER_CACHE_APP_DIR = new File(PathManager.getSystemPath(), "vcs-users");
    }

    @NotNull
    public static final /* synthetic */ File access$getMapFile$p(VcsUserRegistryImpl $this) {
        return $this.mapFile;
    }

    public static final /* synthetic */ boolean access$initEnumerator(VcsUserRegistryImpl $this) {
        return $this.initEnumerator();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/vcs/log/data/VcsUserRegistryImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "STORAGE_VERSION", "", "USER_CACHE_APP_DIR", "Ljava/io/File;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

