/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.collapsing;

import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.collapsing.CollapsedGraph;
import com.intellij.vcs.log.graph.collapsing.DottedFilterEdgesGeneratorImpl;
import com.intellij.vcs.log.graph.collapsing.InplaceFilterEdgesGenerator;
import com.intellij.vcs.log.graph.collapsing.ShiftNumber;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\b&\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH$J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H$J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0015\u001a\u00020\u000bH\u0002J\b\u0010\u0016\u001a\u00020\u000bH\u0002J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH$J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0005H$J\b\u0010\u0019\u001a\u00020\u000bH\u0002J\r\u0010\u001a\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u001bR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/vcs/log/graph/collapsing/DottedFilterEdgesGenerator;", "", "graph", "Lcom/intellij/vcs/log/graph/api/LiteLinearGraph;", "upIndex", "", "downIndex", "(Lcom/intellij/vcs/log/graph/api/LiteLinearGraph;II)V", "numbers", "Lcom/intellij/vcs/log/graph/collapsing/ShiftNumber;", "addDottedArrow", "", "nodeIndex", "isUp", "", "addDottedEdge", "nodeIndex1", "nodeIndex2", "addEdgeOrArrow", "currentNodeIndex", "anotherNodeIndex", "cleanup", "downWalk", "hasDottedEdges", "nodeIsVisible", "upWalk", "update", "update$intellij_platform_vcs_log_graph_impl", "Companion", "intellij.platform.vcs.log.graph.impl"})
public abstract class DottedFilterEdgesGenerator {
    private final ShiftNumber numbers;
    private final LiteLinearGraph graph;
    private final int upIndex;
    private final int downIndex;
    public static final Companion Companion = new Companion(null);

    protected abstract boolean nodeIsVisible(int var1);

    protected abstract void addDottedEdge(int var1, int var2);

    protected abstract void addDottedArrow(int var1, boolean var2);

    protected abstract boolean hasDottedEdges(int var1, boolean var2);

    public final void update$intellij_platform_vcs_log_graph_impl() {
        this.downWalk();
        this.cleanup();
        this.upWalk();
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanup() {
        int n = this.upIndex;
        int n2 = this.downIndex;
        if (n <= n2) {
            while (true) {
                void currentNodeIndex;
                this.numbers.setNumber((int)currentNodeIndex, Integer.MAX_VALUE);
                if (currentNodeIndex == n2) break;
                ++currentNodeIndex;
            }
        }
    }

    private final void addEdgeOrArrow(int currentNodeIndex, int anotherNodeIndex, boolean isUp) {
        if (this.hasDottedEdges(currentNodeIndex, isUp)) {
            if (this.nodeIsVisible(anotherNodeIndex)) {
                this.addDottedEdge(currentNodeIndex, anotherNodeIndex);
            } else {
                this.addDottedArrow(currentNodeIndex, isUp);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void downWalk() {
        int n = this.upIndex;
        int n2 = this.downIndex;
        if (n <= n2) {
            while (true) {
                int nearlyUp;
                void currentNodeIndex;
                if (this.nodeIsVisible((int)currentNodeIndex)) {
                    nearlyUp = Integer.MIN_VALUE;
                    int maxAdjNumber = Integer.MIN_VALUE;
                    for (Integer upNode : this.graph.getNodes((int)currentNodeIndex, LiteLinearGraph.NodeFilter.UP)) {
                        if (Intrinsics.compare((int)upNode, (int)this.upIndex) < 0) {
                            Integer n3 = upNode;
                            Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"upNode");
                            this.addEdgeOrArrow((int)currentNodeIndex, n3, true);
                            continue;
                        }
                        Integer n4 = upNode;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n4, (String)"upNode");
                        if (this.nodeIsVisible(n4)) {
                            maxAdjNumber = Math.max(maxAdjNumber, this.numbers.getNumber(upNode));
                            continue;
                        }
                        nearlyUp = Math.max(nearlyUp, this.numbers.getNumber(upNode));
                    }
                    if (nearlyUp == maxAdjNumber || nearlyUp == Integer.MIN_VALUE) {
                        this.numbers.setNumber((int)currentNodeIndex, maxAdjNumber);
                    } else {
                        this.addDottedEdge((int)currentNodeIndex, nearlyUp);
                        this.numbers.setNumber((int)currentNodeIndex, nearlyUp);
                    }
                } else {
                    nearlyUp = Integer.MIN_VALUE;
                    Iterator<Integer> iterator = this.graph.getNodes((int)currentNodeIndex, LiteLinearGraph.NodeFilter.UP).iterator();
                    while (iterator.hasNext()) {
                        Integer upNode;
                        Integer n5 = upNode = iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)n5, (String)"upNode");
                        if (this.nodeIsVisible(n5)) {
                            nearlyUp = Math.max(nearlyUp, upNode);
                            continue;
                        }
                        if (Intrinsics.compare((int)upNode, (int)this.upIndex) < 0) continue;
                        nearlyUp = Math.max(nearlyUp, this.numbers.getNumber(upNode));
                    }
                    this.numbers.setNumber((int)currentNodeIndex, nearlyUp);
                }
                if (currentNodeIndex == n2) break;
                ++currentNodeIndex;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void upWalk() {
        int n = this.downIndex;
        int n2 = this.upIndex;
        if (n >= n2) {
            while (true) {
                int nearlyDown;
                void currentNodeIndex;
                if (this.nodeIsVisible((int)currentNodeIndex)) {
                    nearlyDown = Integer.MAX_VALUE;
                    int minAdjNumber = Integer.MAX_VALUE;
                    for (Integer downNode : this.graph.getNodes((int)currentNodeIndex, LiteLinearGraph.NodeFilter.DOWN)) {
                        if (Intrinsics.compare((int)downNode, (int)this.downIndex) > 0) {
                            Integer n3 = downNode;
                            Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"downNode");
                            this.addEdgeOrArrow((int)currentNodeIndex, n3, false);
                            continue;
                        }
                        Integer n4 = downNode;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n4, (String)"downNode");
                        if (this.nodeIsVisible(n4)) {
                            minAdjNumber = Math.min(minAdjNumber, this.numbers.getNumber(downNode));
                            continue;
                        }
                        nearlyDown = Math.min(nearlyDown, this.numbers.getNumber(downNode));
                    }
                    if (nearlyDown == minAdjNumber || nearlyDown == Integer.MAX_VALUE) {
                        this.numbers.setNumber((int)currentNodeIndex, minAdjNumber);
                    } else {
                        this.addDottedEdge((int)currentNodeIndex, nearlyDown);
                        this.numbers.setNumber((int)currentNodeIndex, nearlyDown);
                    }
                } else {
                    nearlyDown = Integer.MAX_VALUE;
                    Iterator<Integer> iterator = this.graph.getNodes((int)currentNodeIndex, LiteLinearGraph.NodeFilter.DOWN).iterator();
                    while (iterator.hasNext()) {
                        Integer downNode;
                        Integer n5 = downNode = iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)n5, (String)"downNode");
                        if (this.nodeIsVisible(n5)) {
                            nearlyDown = Math.min(nearlyDown, downNode);
                            continue;
                        }
                        if (Intrinsics.compare((int)downNode, (int)this.downIndex) > 0) continue;
                        nearlyDown = Math.min(nearlyDown, this.numbers.getNumber(downNode));
                    }
                    this.numbers.setNumber((int)currentNodeIndex, nearlyDown);
                }
                if (currentNodeIndex == n2) break;
                --currentNodeIndex;
            }
        }
    }

    public DottedFilterEdgesGenerator(@NotNull LiteLinearGraph graph2, int upIndex, int downIndex) {
        Intrinsics.checkParameterIsNotNull((Object)graph2, (String)"graph");
        this.graph = graph2;
        this.upIndex = upIndex;
        this.downIndex = downIndex;
        this.numbers = new ShiftNumber(this.upIndex, this.downIndex);
    }

    @JvmStatic
    public static final void update(@NotNull CollapsedGraph collapsedGraph, int upDelegateNodeIndex, int downDelegateNodeIndex) {
        Companion.update(collapsedGraph, upDelegateNodeIndex, downDelegateNodeIndex);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ \u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/vcs/log/graph/collapsing/DottedFilterEdgesGenerator$Companion;", "", "()V", "hideInplace", "", "collapsedGraph", "Lcom/intellij/vcs/log/graph/collapsing/CollapsedGraph;", "toHide", "", "", "update", "upDelegateNodeIndex", "downDelegateNodeIndex", "intellij.platform.vcs.log.graph.impl"})
    public static final class Companion {
        @JvmStatic
        public final void update(@NotNull CollapsedGraph collapsedGraph, int upDelegateNodeIndex, int downDelegateNodeIndex) {
            CollapsedGraph.Modification modification;
            Intrinsics.checkParameterIsNotNull((Object)collapsedGraph, (String)"collapsedGraph");
            CollapsedGraph.Modification modification2 = modification = collapsedGraph.startModification();
            Intrinsics.checkExpressionValueIsNotNull((Object)modification2, (String)"modification");
            new DottedFilterEdgesGeneratorImpl(collapsedGraph, modification2, upDelegateNodeIndex, downDelegateNodeIndex).update$intellij_platform_vcs_log_graph_impl();
            modification.apply();
        }

        public final void hideInplace(@NotNull CollapsedGraph collapsedGraph, @NotNull Set<Integer> toHide) {
            CollapsedGraph.Modification modification;
            Intrinsics.checkParameterIsNotNull((Object)collapsedGraph, (String)"collapsedGraph");
            Intrinsics.checkParameterIsNotNull(toHide, (String)"toHide");
            CollapsedGraph.Modification modification2 = modification = collapsedGraph.startModification();
            Intrinsics.checkExpressionValueIsNotNull((Object)modification2, (String)"modification");
            new InplaceFilterEdgesGenerator(collapsedGraph, modification2, toHide).update$intellij_platform_vcs_log_graph_impl();
            Iterable $receiver$iv = toHide;
            for (Object element$iv : $receiver$iv) {
                int it = ((Number)element$iv).intValue();
                modification.hideNode(collapsedGraph.convertToDelegateNodeIndex(it));
            }
            modification.apply();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

