/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.collapsing.CollapsedGraph;
import com.intellij.vcs.log.graph.impl.facade.GraphModificationUtilKt;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.history.FileHistoryBuilder;
import com.intellij.vcs.log.history.FileHistoryKt;
import com.intellij.vcs.log.history.FileHistoryRefiner;
import com.intellij.vcs.log.history.FileNamesData;
import com.intellij.vcs.log.history.MaybeDeletedFilePath;
import com.intellij.vcs.log.history.ReachableNodesUtilKt;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001f2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001:\u0001\u001fB\u001f\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J2\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J9\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\u001b2\u0006\u0010\u0013\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u001cJ\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00022\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/vcs/log/history/FileHistoryBuilder;", "Ljava/util/function/BiConsumer;", "Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController;", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;", "", "startCommit", "startPath", "Lcom/intellij/openapi/vcs/FilePath;", "fileNamesData", "Lcom/intellij/vcs/log/history/FileNamesData;", "(Ljava/lang/Integer;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/vcs/log/history/FileNamesData;)V", "pathsMap", "", "Lcom/intellij/vcs/log/history/MaybeDeletedFilePath;", "getPathsMap", "()Ljava/util/Map;", "Ljava/lang/Integer;", "accept", "", "controller", "permanentGraphInfo", "findAncestorRowAffectingFile", "Lkotlin/Pair;", "commitId", "visibleLinearGraph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "refine", "", "(Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController;Ljava/lang/Integer;Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;)Ljava/util/Map;", "removeTrivialMerges", "", "Companion", "intellij.platform.vcs.log.impl"})
public final class FileHistoryBuilder
implements BiConsumer<LinearGraphController, PermanentGraphInfo<Integer>> {
    @NotNull
    private final Map<Integer, MaybeDeletedFilePath> pathsMap;
    private final Integer startCommit;
    private final FilePath startPath;
    private final FileNamesData fileNamesData;
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public final Map<Integer, MaybeDeletedFilePath> getPathsMap() {
        return this.pathsMap;
    }

    @Override
    public void accept(@NotNull LinearGraphController controller, @NotNull PermanentGraphInfo<Integer> permanentGraphInfo) {
        Intrinsics.checkParameterIsNotNull((Object)controller, (String)"controller");
        Intrinsics.checkParameterIsNotNull(permanentGraphInfo, (String)"permanentGraphInfo");
        boolean needToRepeat = this.removeTrivialMerges(controller, permanentGraphInfo);
        this.pathsMap.putAll(this.refine(controller, this.startCommit, permanentGraphInfo));
        if (needToRepeat) {
            LOG.info("Some merge commits were not excluded from file history for " + this.startPath.getPath());
            this.removeTrivialMerges(controller, permanentGraphInfo);
        }
    }

    private final boolean removeTrivialMerges(LinearGraphController controller, PermanentGraphInfo<Integer> permanentGraphInfo) {
        TIntHashSet trivialCandidates = new TIntHashSet();
        TIntHashSet nonTrivialMerges = new TIntHashSet();
        this.fileNamesData.forEach((Function3<? super FilePath, ? super Integer, ? super TIntObjectHashMap<VcsLogPathsIndex.ChangeKind>, Unit>)((Function3)new Function3<FilePath, Integer, TIntObjectHashMap<VcsLogPathsIndex.ChangeKind>, Unit>(trivialCandidates, nonTrivialMerges){
            final /* synthetic */ TIntHashSet $trivialCandidates;
            final /* synthetic */ TIntHashSet $nonTrivialMerges;

            public final void invoke(@NotNull FilePath $noName_0, int commit, @NotNull TIntObjectHashMap<VcsLogPathsIndex.ChangeKind> changes2) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkParameterIsNotNull(changes2, (String)"changes");
                if (changes2.size() > 1) {
                    if (changes2.containsValue((Object)((Object)VcsLogPathsIndex.ChangeKind.NOT_CHANGED))) {
                        this.$trivialCandidates.add(commit);
                    } else {
                        this.$nonTrivialMerges.add(commit);
                    }
                }
            }
            {
                this.$trivialCandidates = tIntHashSet;
                this.$nonTrivialMerges = tIntHashSet2;
                super(3);
            }
        }));
        boolean needToRepeat = FileHistoryKt.removeAll(trivialCandidates, nonTrivialMerges);
        GraphModificationUtilKt.modifyGraph(controller, (Function1<? super CollapsedGraph, Unit>)((Function1)new Function1<CollapsedGraph, Unit>(this, trivialCandidates, permanentGraphInfo){
            final /* synthetic */ FileHistoryBuilder this$0;
            final /* synthetic */ TIntHashSet $trivialCandidates;
            final /* synthetic */ PermanentGraphInfo $permanentGraphInfo;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CollapsedGraph collapsedGraph) {
                Collection<Integer> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)collapsedGraph, (String)"collapsedGraph");
                Set<Integer> trivialMerges2 = FileHistoryKt.hideTrivialMerges(collapsedGraph, (Function1<? super Integer, Boolean>)((Function1)new Function1<Integer, Boolean>(this){
                    final /* synthetic */ removeTrivialMerges.2 this$0;

                    public final boolean invoke(int nodeId) {
                        TIntHashSet tIntHashSet = this.this$0.$trivialCandidates;
                        CommitId CommitId2 = this.this$0.$permanentGraphInfo.getPermanentCommitsInfo().getCommitId(nodeId);
                        Intrinsics.checkExpressionValueIsNotNull(CommitId2, (String)"permanentGraphInfo.perma\u2026sInfo.getCommitId(nodeId)");
                        return tIntHashSet.contains(((Number)CommitId2).intValue());
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
                Iterable iterable = trivialMerges2;
                FileNamesData fileNamesData = FileHistoryBuilder.access$getFileNamesData$p(this.this$0);
                void var4_5 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    int n = ((Number)item$iv$iv).intValue();
                    collection = destination$iv$iv;
                    Integer n2 = (Integer)this.$permanentGraphInfo.getPermanentCommitsInfo().getCommitId((int)it);
                    collection.add(n2);
                }
                collection = (List)destination$iv$iv;
                fileNamesData.removeAll((List<Integer>)collection);
            }
            {
                this.this$0 = fileHistoryBuilder;
                this.$trivialCandidates = tIntHashSet;
                this.$permanentGraphInfo = permanentGraphInfo;
                super(1);
            }
        }));
        return needToRepeat;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, MaybeDeletedFilePath> refine(LinearGraphController controller, Integer startCommit, PermanentGraphInfo<Integer> permanentGraphInfo) {
        block5: {
            void row2;
            Object object;
            Pair<Integer, MaybeDeletedFilePath> pair;
            LinearGraph visibleLinearGraph;
            block7: {
                block6: {
                    if (!this.fileNamesData.getHasRenames()) break block5;
                    visibleLinearGraph = controller.getCompiledGraph();
                    pair = startCommit;
                    if (pair == null) break block6;
                    object = pair;
                    int it = ((Number)object).intValue();
                    int n = startCommit.intValue();
                    LinearGraph linearGraph = visibleLinearGraph;
                    Intrinsics.checkExpressionValueIsNotNull((Object)linearGraph, (String)"visibleLinearGraph");
                    pair = this.findAncestorRowAffectingFile(n, linearGraph, permanentGraphInfo);
                    if (pair != null) break block7;
                }
                pair = new Pair((Object)0, (Object)new MaybeDeletedFilePath(this.startPath));
            }
            Pair<Integer, MaybeDeletedFilePath> pair2 = pair;
            int n = ((Number)pair2.component1()).intValue();
            MaybeDeletedFilePath path = (MaybeDeletedFilePath)pair2.component2();
            if (row2 >= 0) {
                void paths;
                boolean hidden;
                LinearGraph linearGraph = visibleLinearGraph;
                Intrinsics.checkExpressionValueIsNotNull((Object)linearGraph, (String)"visibleLinearGraph");
                FileHistoryRefiner refiner = new FileHistoryRefiner(linearGraph, permanentGraphInfo, this.fileNamesData);
                Pair<HashMap<Integer, MaybeDeletedFilePath>, HashSet<Integer>> $i$a$1$let = refiner.refine((int)row2, path);
                object = (HashMap)$i$a$1$let.component1();
                HashSet excluded = (HashSet)$i$a$1$let.component2();
                if (!excluded.isEmpty() && !(hidden = GraphModificationUtilKt.hideCommits(controller, permanentGraphInfo, excluded))) {
                    LOG.error("Could not hide excluded commits from history for " + this.startPath.getPath());
                }
                return (Map)paths;
            }
        }
        return this.fileNamesData.buildPathsMap();
    }

    private final Pair<Integer, MaybeDeletedFilePath> findAncestorRowAffectingFile(int commitId, LinearGraph visibleLinearGraph, PermanentGraphInfo<Integer> permanentGraphInfo) {
        MaybeDeletedFilePath existing = new MaybeDeletedFilePath(this.startPath);
        MaybeDeletedFilePath deleted = new MaybeDeletedFilePath(this.startPath, true);
        Ref ref = Ref.create((Object)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)ref, (String)"Ref.create(false)");
        Ref isDeleted = ref;
        Integer n = ReachableNodesUtilKt.findVisibleAncestorRow(commitId, visibleLinearGraph, permanentGraphInfo, (Function1<? super Integer, Boolean>)((Function1)new Function1<Integer, Boolean>(this, permanentGraphInfo, existing, deleted, isDeleted){
            final /* synthetic */ FileHistoryBuilder this$0;
            final /* synthetic */ PermanentGraphInfo $permanentGraphInfo;
            final /* synthetic */ MaybeDeletedFilePath $existing;
            final /* synthetic */ MaybeDeletedFilePath $deleted;
            final /* synthetic */ Ref $isDeleted;

            public final boolean invoke(int nodeId) {
                boolean bl;
                Integer id = (Integer)this.$permanentGraphInfo.getPermanentCommitsInfo().getCommitId(nodeId);
                FileNamesData fileNamesData = FileHistoryBuilder.access$getFileNamesData$p(this.this$0);
                Integer n = id;
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"id");
                if (fileNamesData.affects(n, this.$existing)) {
                    bl = true;
                } else if (FileHistoryBuilder.access$getFileNamesData$p(this.this$0).affects(id, this.$deleted)) {
                    this.$isDeleted.set((Object)true);
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
            {
                this.this$0 = fileHistoryBuilder;
                this.$permanentGraphInfo = permanentGraphInfo;
                this.$existing = maybeDeletedFilePath;
                this.$deleted = maybeDeletedFilePath2;
                this.$isDeleted = ref;
                super(1);
            }
        }));
        int row2 = n != null ? n : -1;
        Integer n2 = row2;
        Object object = isDeleted.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"isDeleted.get()");
        return new Pair((Object)n2, (Object)((Boolean)object != false ? deleted : existing));
    }

    public FileHistoryBuilder(@Nullable Integer startCommit, @NotNull FilePath startPath, @NotNull FileNamesData fileNamesData) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)startPath, (String)"startPath");
        Intrinsics.checkParameterIsNotNull((Object)fileNamesData, (String)"fileNamesData");
        this.startCommit = startCommit;
        this.startPath = startPath;
        this.fileNamesData = fileNamesData;
        FileHistoryBuilder fileHistoryBuilder = this;
        fileHistoryBuilder.pathsMap = map = (Map)new LinkedHashMap();
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(FileHistoryBuilder.class);
    }

    @NotNull
    public static final /* synthetic */ FileNamesData access$getFileNamesData$p(FileHistoryBuilder $this) {
        return $this.fileNamesData;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryBuilder$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

