/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.history.VcsCachingHistory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogBranchFilterImpl;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogModifiableIndex;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.RowInfo;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.history.FileHistoryBuilder;
import com.intellij.vcs.log.history.FileHistoryVisiblePack;
import com.intellij.vcs.log.history.FileNamesData;
import com.intellij.vcs.log.history.MaybeDeletedFilePath;
import com.intellij.vcs.log.history.VcsLogFileHistoryFilter;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.impl.VcsLogRevisionFilterImpl;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.CommitCountStage;
import com.intellij.vcs.log.visible.VcsLogFilterer;
import com.intellij.vcs.log.visible.VcsLogFiltererImpl;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 (2\u00020\u0001:\u0002()B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J4\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u001cH\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RL\u0010\t\u001a@\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r \f*\u001e\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r0\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryFilterer;", "Lcom/intellij/vcs/log/visible/VcsLogFilterer;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "(Lcom/intellij/vcs/log/data/VcsLogData;)V", "index", "Lcom/intellij/vcs/log/data/index/VcsLogIndex;", "indexDataGetter", "Lcom/intellij/vcs/log/data/index/IndexDataGetter;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "Lcom/intellij/vcs/log/VcsLogProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "vcsLogFilterer", "Lcom/intellij/vcs/log/visible/VcsLogFiltererImpl;", "canFilterEmptyPack", "", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "filter", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/vcs/log/visible/VisiblePack;", "Lcom/intellij/vcs/log/visible/CommitCountStage;", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "sortType", "Lcom/intellij/vcs/log/graph/PermanentGraph$SortType;", "commitCount", "getFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "getHash", "Lcom/intellij/vcs/log/Hash;", "getStructureFilter", "Lcom/intellij/vcs/log/VcsLogStructureFilter;", "Companion", "MyWorker", "intellij.platform.vcs.log.impl"})
public final class FileHistoryFilterer
implements VcsLogFilterer {
    private final Project project;
    private final Map<VirtualFile, VcsLogProvider> logProviders;
    private final VcsLogStorage storage;
    private final VcsLogIndex index;
    private final IndexDataGetter indexDataGetter;
    private final VcsLogFiltererImpl vcsLogFilterer;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    @NotNull
    public com.intellij.openapi.util.Pair<VisiblePack, CommitCountStage> filter(@NotNull DataPack dataPack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount) {
        VirtualFile root;
        Intrinsics.checkParameterIsNotNull((Object)dataPack, (String)"dataPack");
        Intrinsics.checkParameterIsNotNull((Object)sortType, (String)"sortType");
        Intrinsics.checkParameterIsNotNull((Object)filters, (String)"filters");
        Intrinsics.checkParameterIsNotNull((Object)((Object)commitCount), (String)"commitCount");
        FilePath filePath = this.getFilePath(filters);
        if (filePath == null || filePath.isDirectory() && this.logProviders.keySet().contains(filePath.getVirtualFile())) {
            com.intellij.openapi.util.Pair<VisiblePack, CommitCountStage> pair = this.vcsLogFilterer.filter(dataPack, sortType, filters, commitCount);
            Intrinsics.checkExpressionValueIsNotNull(pair, (String)"vcsLogFilterer.filter(da\u2026pe, filters, commitCount)");
            return pair;
        }
        VirtualFile virtualFile = VcsLogUtil.getActualRoot(this.project, filePath);
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        VirtualFile virtualFile2 = root = virtualFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"root");
        return new MyWorker(virtualFile2, filePath, this.getHash(filters)).filter(dataPack, sortType, filters, commitCount);
    }

    @Override
    public boolean canFilterEmptyPack(@NotNull VcsLogFilterCollection filters) {
        FilePath filePath;
        FilePath $receiver;
        Intrinsics.checkParameterIsNotNull((Object)filters, (String)"filters");
        FilePath filePath2 = this.getFilePath(filters);
        return filePath2 != null ? !($receiver = (filePath = filePath2)).isDirectory() : false;
    }

    private final VcsLogStructureFilter getStructureFilter(VcsLogFilterCollection filters) {
        List list2 = filters.getDetailsFilters();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"filters.detailsFilters");
        Object object = CollectionsKt.singleOrNull((List)list2);
        if (!(object instanceof VcsLogStructureFilter)) {
            object = null;
        }
        return (VcsLogStructureFilter)object;
    }

    private final FilePath getFilePath(VcsLogFilterCollection filters) {
        VcsLogStructureFilter vcsLogStructureFilter = this.getStructureFilter(filters);
        if (vcsLogStructureFilter == null) {
            return null;
        }
        VcsLogStructureFilter filter = vcsLogStructureFilter;
        Collection collection = filter.getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"filter.files");
        return (FilePath)CollectionsKt.singleOrNull((Iterable)collection);
    }

    private final Hash getHash(VcsLogFilterCollection filters) {
        VcsLogFileHistoryFilter fileHistoryFilter;
        VcsLogStructureFilter vcsLogStructureFilter = this.getStructureFilter(filters);
        if (!(vcsLogStructureFilter instanceof VcsLogFileHistoryFilter)) {
            vcsLogStructureFilter = null;
        }
        if ((fileHistoryFilter = (VcsLogFileHistoryFilter)vcsLogStructureFilter) != null) {
            return fileHistoryFilter.getHash();
        }
        VcsLogRevisionFilter revisionFilter = (VcsLogRevisionFilter)filters.get(VcsLogFilterCollection.REVISION_FILTER);
        Object object = revisionFilter;
        return object != null && (object = object.getHeads()) != null && (object = (CommitId)CollectionsKt.singleOrNull((Iterable)((Iterable)object))) != null ? object.getHash() : null;
    }

    public FileHistoryFilterer(@NotNull VcsLogData logData) {
        Intrinsics.checkParameterIsNotNull((Object)logData, (String)"logData");
        this.project = logData.getProject();
        this.logProviders = logData.getLogProviders();
        this.storage = logData.getStorage();
        VcsLogIndex vcsLogIndex = this.index = logData.getIndex();
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsLogIndex, (String)"index");
        IndexDataGetter indexDataGetter = vcsLogIndex.getDataGetter();
        if (indexDataGetter == null) {
            Intrinsics.throwNpe();
        }
        this.indexDataGetter = indexDataGetter;
        this.vcsLogFilterer = new VcsLogFiltererImpl(this.logProviders, this.storage, logData.getTopCommitsCache(), logData.getCommitDetailsGetter(), this.index);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(FileHistoryFilterer.class);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogFilterCollection createFilters(@NotNull FilePath path, @Nullable Hash revision, @NotNull VirtualFile root, boolean showAllBranches) {
        return Companion.createFilters(path, revision, root, showAllBranches);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J2\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013J \u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J,\u0010\u001a\u001a\u00020\u000e2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00072\u0006\u0010!\u001a\u00020\fH\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0016\u0010&\u001a\u00020\n2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020#0(H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryFilterer$MyWorker;", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "hash", "Lcom/intellij/vcs/log/Hash;", "(Lcom/intellij/vcs/log/history/FileHistoryFilterer;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/vcs/log/Hash;)V", "checkNotEmpty", "", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "visiblePack", "Lcom/intellij/vcs/log/visible/VisiblePack;", "withIndex", "", "filter", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/vcs/log/visible/CommitCountStage;", "sortType", "Lcom/intellij/vcs/log/graph/PermanentGraph$SortType;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "commitCount", "filterWithIndex", "filterWithProvider", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "getFilteredRefs", "", "Lcom/intellij/vcs/log/data/CompressedRefs;", "getHead", "pack", "getIndex", "", "revision", "Lcom/intellij/openapi/vcs/history/VcsFileRevision;", "reindexFirstCommitsIfNeeded", "graph", "Lcom/intellij/vcs/log/graph/VisibleGraph;", "intellij.platform.vcs.log.impl"})
    private final class MyWorker {
        private final VirtualFile root;
        private final FilePath filePath;
        private final Hash hash;

        @NotNull
        public final com.intellij.openapi.util.Pair<VisiblePack, CommitCountStage> filter(@NotNull DataPack dataPack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount) {
            Intrinsics.checkParameterIsNotNull((Object)dataPack, (String)"dataPack");
            Intrinsics.checkParameterIsNotNull((Object)sortType, (String)"sortType");
            Intrinsics.checkParameterIsNotNull((Object)filters, (String)"filters");
            Intrinsics.checkParameterIsNotNull((Object)((Object)commitCount), (String)"commitCount");
            long start2 = System.currentTimeMillis();
            if (FileHistoryFilterer.this.index.isIndexed(this.root) && (dataPack.isFull() || this.filePath.isDirectory())) {
                VisiblePack visiblePack = this.filterWithIndex(dataPack, sortType, filters);
                LOG.debug(StopWatch.formatTime(System.currentTimeMillis() - start2) + " for computing history for " + this.filePath + " with index");
                this.checkNotEmpty(dataPack, visiblePack, true);
                com.intellij.openapi.util.Pair pair = com.intellij.openapi.util.Pair.create((Object)visiblePack, (Object)((Object)commitCount));
                Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"Pair.create(visiblePack, commitCount)");
                return pair;
            }
            if (this.filePath.isDirectory()) {
                com.intellij.openapi.util.Pair<VisiblePack, CommitCountStage> pair = FileHistoryFilterer.this.vcsLogFilterer.filter(dataPack, sortType, filters, commitCount);
                Intrinsics.checkExpressionValueIsNotNull(pair, (String)"vcsLogFilterer.filter(da\u2026pe, filters, commitCount)");
                return pair;
            }
            AbstractVcs abstractVcs = ProjectLevelVcsManager.getInstance((Project)FileHistoryFilterer.this.project).getVcsFor(this.root);
            if (abstractVcs != null) {
                AbstractVcs abstractVcs2;
                AbstractVcs vcs;
                AbstractVcs abstractVcs3 = vcs = (abstractVcs2 = abstractVcs);
                Intrinsics.checkExpressionValueIsNotNull((Object)abstractVcs3, (String)"vcs");
                if (abstractVcs3.getVcsHistoryProvider() != null) {
                    com.intellij.openapi.util.Pair pair;
                    try {
                        VisiblePack visiblePack = this.filterWithProvider(vcs, dataPack, sortType, filters);
                        LOG.debug(StopWatch.formatTime(System.currentTimeMillis() - start2) + " for computing history for " + this.filePath + " with history provider");
                        this.checkNotEmpty(dataPack, visiblePack, false);
                        com.intellij.openapi.util.Pair pair2 = com.intellij.openapi.util.Pair.create((Object)visiblePack, (Object)((Object)commitCount));
                        Intrinsics.checkExpressionValueIsNotNull((Object)pair2, (String)"Pair.create(visiblePack, commitCount)");
                        pair = pair2;
                    }
                    catch (VcsException e) {
                        LOG.error((Throwable)e);
                        com.intellij.openapi.util.Pair pair3 = FileHistoryFilterer.this.vcsLogFilterer.filter(dataPack, sortType, filters, commitCount);
                        Intrinsics.checkExpressionValueIsNotNull(pair3, (String)"vcsLogFilterer.filter(da\u2026pe, filters, commitCount)");
                        pair = pair3;
                    }
                    return pair;
                }
            }
            LOG.warn("Could not find vcs or history provider for file " + this.filePath);
            com.intellij.openapi.util.Pair<VisiblePack, CommitCountStage> pair = FileHistoryFilterer.this.vcsLogFilterer.filter(dataPack, sortType, filters, commitCount);
            Intrinsics.checkExpressionValueIsNotNull(pair, (String)"vcsLogFilterer.filter(da\u2026pe, filters, commitCount)");
            return pair;
        }

        private final void checkNotEmpty(DataPack dataPack, VisiblePack visiblePack, boolean withIndex) {
            if (!dataPack.isFull()) {
                Logger logger = LOG;
                StringBuilder stringBuilder = new StringBuilder().append("Data pack is not full while computing file history for ").append(this.filePath).append('\n').append("Found ");
                VisibleGraph<Integer> visibleGraph = visiblePack.getVisibleGraph();
                Intrinsics.checkExpressionValueIsNotNull(visibleGraph, (String)"visiblePack.visibleGraph");
                logger.debug(stringBuilder.append(visibleGraph.getVisibleCommitCount()).append(" commits").toString());
            } else {
                VisibleGraph<Integer> visibleGraph = visiblePack.getVisibleGraph();
                Intrinsics.checkExpressionValueIsNotNull(visibleGraph, (String)"visiblePack.visibleGraph");
                if (visibleGraph.getVisibleCommitCount() == 0) {
                    LOG.warn("Empty file history from " + (withIndex ? "index" : "provider") + " for " + this.filePath);
                }
            }
        }

        private final VisiblePack filterWithProvider(AbstractVcs<?> vcs, DataPack dataPack, PermanentGraph.SortType sortType, VcsLogFilterCollection filters) throws VcsException {
            TextRevisionNumber revisionNumber = this.hash != null ? VcsLogUtil.convertToRevisionNumber(this.hash) : null;
            List<VcsFileRevision> revisions = VcsCachingHistory.collect(vcs, this.filePath, (VcsRevisionNumber)revisionNumber);
            if (revisions.isEmpty()) {
                VisiblePack visiblePack = VisiblePack.EMPTY;
                Intrinsics.checkExpressionValueIsNotNull((Object)visiblePack, (String)"VisiblePack.EMPTY");
                return visiblePack;
            }
            if (dataPack.isFull()) {
                HashMap pathsMap = ContainerUtil.newHashMap();
                Iterator<VcsFileRevision> iterator = revisions.iterator();
                while (iterator.hasNext()) {
                    VcsFileRevision revision;
                    VcsFileRevision vcsFileRevision = revision = iterator.next();
                    if (vcsFileRevision == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vcs.history.VcsFileRevisionEx");
                    }
                    VcsFileRevisionEx revisionEx = (VcsFileRevisionEx)vcsFileRevision;
                    HashMap hashMap = pathsMap;
                    Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"pathsMap");
                    Map map = hashMap;
                    Integer n = this.getIndex(revision);
                    FilePath filePath = revisionEx.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)filePath, (String)"revisionEx.path");
                    MaybeDeletedFilePath maybeDeletedFilePath = new MaybeDeletedFilePath(filePath, revisionEx.isDeleted());
                    map.put(n, maybeDeletedFilePath);
                }
                VisibleGraph<Integer> visibleGraph = FileHistoryFilterer.this.vcsLogFilterer.createVisibleGraph(dataPack, sortType, null, pathsMap.keySet());
                DataPackBase dataPackBase = dataPack;
                VisibleGraph<Integer> visibleGraph2 = visibleGraph;
                Intrinsics.checkExpressionValueIsNotNull(visibleGraph2, (String)"visibleGraph");
                HashMap hashMap = pathsMap;
                Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"pathsMap");
                return new FileHistoryVisiblePack(dataPackBase, visibleGraph2, false, filters, hashMap);
            }
            ArrayList commits = ContainerUtil.newArrayListWithCapacity((int)revisions.size());
            HashMap pathsMap = ContainerUtil.newHashMap();
            Iterator<VcsFileRevision> revisionEx = revisions.iterator();
            while (revisionEx.hasNext()) {
                VcsFileRevision revision;
                VcsFileRevision vcsFileRevision = revision = revisionEx.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)vcsFileRevision, (String)"revision");
                int index = this.getIndex(vcsFileRevision);
                VcsFileRevisionEx revisionEx2 = (VcsFileRevisionEx)revision;
                HashMap hashMap = pathsMap;
                Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"pathsMap");
                Map map = hashMap;
                Integer n = index;
                FilePath filePath = revisionEx2.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)filePath, (String)"revisionEx.path");
                MaybeDeletedFilePath maybeDeletedFilePath = new MaybeDeletedFilePath(filePath, revisionEx2.isDeleted());
                map.put(n, maybeDeletedFilePath);
                Integer n2 = index;
                List list2 = CollectionsKt.emptyList();
                Date date = revision.getRevisionDate();
                Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"revision.getRevisionDate()");
                commits.add(GraphCommitImpl.createCommit(n2, list2, date.getTime()));
            }
            Map<VirtualFile, CompressedRefs> refs = this.getFilteredRefs(dataPack);
            Map providers = ContainerUtil.newHashMap((com.intellij.openapi.util.Pair)com.intellij.openapi.util.Pair.create((Object)this.root, FileHistoryFilterer.this.logProviders.get(this.root)), (com.intellij.openapi.util.Pair[])new com.intellij.openapi.util.Pair[0]);
            DataPack fakeDataPack = DataPack.build(commits, refs, providers, FileHistoryFilterer.this.storage, false);
            VisibleGraph<Integer> visibleGraph = FileHistoryFilterer.this.vcsLogFilterer.createVisibleGraph(fakeDataPack, sortType, null, null);
            DataPack dataPack2 = fakeDataPack;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataPack2, (String)"fakeDataPack");
            DataPackBase dataPackBase = dataPack2;
            VisibleGraph<Integer> visibleGraph3 = visibleGraph;
            Intrinsics.checkExpressionValueIsNotNull(visibleGraph3, (String)"visibleGraph");
            HashMap hashMap = pathsMap;
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"pathsMap");
            return new FileHistoryVisiblePack(dataPackBase, visibleGraph3, false, filters, hashMap);
        }

        private final Map<VirtualFile, CompressedRefs> getFilteredRefs(DataPack dataPack) {
            RefsModel refsModel = dataPack.getRefsModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)refsModel, (String)"dataPack.refsModel");
            CompressedRefs compressedRefs = refsModel.getAllRefsByRoot().get(this.root);
            if (compressedRefs == null) {
                compressedRefs = new CompressedRefs(SetsKt.emptySet(), FileHistoryFilterer.this.storage);
            }
            CompressedRefs compressedRefs2 = compressedRefs;
            return MapsKt.mapOf((Pair)new Pair((Object)this.root, (Object)compressedRefs2));
        }

        private final int getIndex(VcsFileRevision revision) {
            return FileHistoryFilterer.this.storage.getCommitIndex(HashImpl.build(revision.getRevisionNumber().asString()), this.root);
        }

        private final VisiblePack filterWithIndex(DataPack dataPack, PermanentGraph.SortType sortType, VcsLogFilterCollection filters) {
            Integer n;
            Set<Integer> matchingHeads = FileHistoryFilterer.this.vcsLogFilterer.getMatchingHeads(dataPack.getRefsModel(), SetsKt.setOf((Object)this.root), filters);
            FileNamesData data = FileHistoryFilterer.this.indexDataGetter.createFileNamesData(this.filePath);
            PermanentGraph<Integer> permanentGraph = dataPack.getPermanentGraph();
            if (!(permanentGraph instanceof PermanentGraphImpl)) {
                VisibleGraph<Integer> visibleGraph = FileHistoryFilterer.this.vcsLogFilterer.createVisibleGraph(dataPack, sortType, matchingHeads, data.getCommits());
                DataPackBase dataPackBase = dataPack;
                VisibleGraph<Integer> visibleGraph2 = visibleGraph;
                Intrinsics.checkExpressionValueIsNotNull(visibleGraph2, (String)"visibleGraph");
                return new FileHistoryVisiblePack(dataPackBase, visibleGraph2, false, filters, data.buildPathsMap());
            }
            if (VcsLogFiltererImpl.matchesNothing((Collection)matchingHeads) || data.isEmpty()) {
                VisiblePack visiblePack = VisiblePack.EMPTY;
                Intrinsics.checkExpressionValueIsNotNull((Object)visiblePack, (String)"VisiblePack.EMPTY");
                return visiblePack;
            }
            Hash hash = this.hash;
            if (hash == null) {
                hash = this.getHead(dataPack);
            }
            if (hash != null) {
                Hash hash2;
                Hash it = hash2 = hash;
                n = FileHistoryFilterer.this.storage.getCommitIndex(it, this.root);
            } else {
                n = null;
            }
            Integer commit = n;
            FileNamesData fileNamesData = data;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileNamesData, (String)"data");
            FileHistoryBuilder historyBuilder = new FileHistoryBuilder(commit, this.filePath, fileNamesData);
            VisibleGraph<Integer> visibleGraph = ((PermanentGraphImpl)permanentGraph).createVisibleGraph(sortType, matchingHeads, data.getCommits(), historyBuilder);
            if (!this.filePath.isDirectory()) {
                VisibleGraph<Integer> visibleGraph3 = visibleGraph;
                Intrinsics.checkExpressionValueIsNotNull(visibleGraph3, (String)"visibleGraph");
                this.reindexFirstCommitsIfNeeded(visibleGraph3);
            }
            DataPackBase dataPackBase = dataPack;
            VisibleGraph<Integer> visibleGraph4 = visibleGraph;
            Intrinsics.checkExpressionValueIsNotNull(visibleGraph4, (String)"visibleGraph");
            return new FileHistoryVisiblePack(dataPackBase, visibleGraph4, false, filters, historyBuilder.getPathsMap());
        }

        /*
         * WARNING - void declaration
         */
        private final void reindexFirstCommitsIfNeeded(VisibleGraph<Integer> graph2) {
            if (graph2 instanceof VisibleGraphImpl) {
                LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph(((VisibleGraphImpl)graph2).getLinearGraph());
                int n = 0;
                int n2 = liteLinearGraph.nodesCount();
                while (n < n2) {
                    void row2;
                    if (liteLinearGraph.getNodes((int)row2, LiteLinearGraph.NodeFilter.DOWN).isEmpty() && FileHistoryFilterer.this.index instanceof VcsLogModifiableIndex) {
                        VcsLogModifiableIndex vcsLogModifiableIndex = (VcsLogModifiableIndex)FileHistoryFilterer.this.index;
                        RowInfo rowInfo = graph2.getRowInfo((int)row2);
                        Intrinsics.checkExpressionValueIsNotNull((Object)rowInfo, (String)"graph.getRowInfo(row)");
                        Object object = rowInfo.getCommit();
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"graph.getRowInfo(row).commit");
                        vcsLogModifiableIndex.reindexWithRenames(((Number)object).intValue(), this.root);
                    }
                    ++row2;
                }
            }
        }

        private final Hash getHead(DataPack pack) {
            VcsRef vcsRef = VcsLogUtil.findBranch(pack.getRefsModel(), this.root, "HEAD");
            return vcsRef != null ? vcsRef.getCommitHash() : null;
        }

        public MyWorker(@NotNull VirtualFile root, @Nullable FilePath filePath, Hash hash) {
            Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            this.root = root;
            this.filePath = filePath;
            this.hash = hash;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryFilterer$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createFilters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "revision", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "showAllBranches", "", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final VcsLogFilterCollection createFilters(@NotNull FilePath path, @Nullable Hash revision, @NotNull VirtualFile root, boolean showAllBranches) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
            VcsLogFileHistoryFilter fileFilter = new VcsLogFileHistoryFilter(path, revision);
            VcsLogFilter revisionFilter = showAllBranches ? null : (revision != null ? (VcsLogFilter)VcsLogRevisionFilterImpl.fromCommit(new CommitId(revision, root)) : (VcsLogFilter)VcsLogBranchFilterImpl.fromBranch("HEAD"));
            VcsLogFilterCollection vcsLogFilterCollection = new VcsLogFilterCollectionImpl.VcsLogFilterCollectionBuilder((VcsLogFilter)fileFilter, revisionFilter).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)vcsLogFilterCollection, (String)"VcsLogFilterCollectionIm\u2026, revisionFilter).build()");
            return vcsLogFilterCollection;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

