/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.utils.BfsUtil;
import com.intellij.vcs.log.graph.utils.DfsUtil;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import com.intellij.vcs.log.history.FileNamesData;
import com.intellij.vcs.log.history.MaybeDeletedFilePath;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J&\u0010 \u001a\u0004\u0018\u00010\u000f2\u0006\u0010!\u001a\u00020\u00062\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0#H\u0002J4\u0010$\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0%2\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u000fR\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00060\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u001e\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000f0\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/vcs/log/history/FileHistoryRefiner;", "Lcom/intellij/vcs/log/graph/utils/DfsUtil$NodeVisitor;", "visibleLinearGraph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "permanentGraphInfo", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;", "", "namesData", "Lcom/intellij/vcs/log/history/FileNamesData;", "(Lcom/intellij/vcs/log/graph/api/LinearGraph;Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;Lcom/intellij/vcs/log/history/FileNamesData;)V", "excluded", "Ljava/util/HashSet;", "kotlin.jvm.PlatformType", "paths", "Lcom/intellij/util/containers/Stack;", "Lcom/intellij/vcs/log/history/MaybeDeletedFilePath;", "pathsForCommits", "Ljava/util/HashMap;", "permanentCommitsInfo", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentCommitsInfo;", "permanentLinearGraph", "Lcom/intellij/vcs/log/graph/api/LiteLinearGraph;", "visibilityBuffer", "Lcom/intellij/vcs/log/graph/utils/impl/BitSetFlags;", "enterNode", "", "currentNode", "previousNode", "down", "", "exitNode", "node", "findPathWithoutConflict", "nodeId", "pathGetter", "Lkotlin/Function1;", "refine", "Lkotlin/Pair;", "row", "startPath", "intellij.platform.vcs.log.impl"})
public final class FileHistoryRefiner
implements DfsUtil.NodeVisitor {
    private final PermanentCommitsInfo<Integer> permanentCommitsInfo;
    private final LiteLinearGraph permanentLinearGraph;
    private final Stack<MaybeDeletedFilePath> paths;
    private final BitSetFlags visibilityBuffer;
    private final HashMap<Integer, MaybeDeletedFilePath> pathsForCommits;
    private final HashSet<Integer> excluded;
    private final LinearGraph visibleLinearGraph;
    private final FileNamesData namesData;

    @NotNull
    public final Pair<HashMap<Integer, MaybeDeletedFilePath>, HashSet<Integer>> refine(int row2, @NotNull MaybeDeletedFilePath startPath) {
        Intrinsics.checkParameterIsNotNull((Object)startPath, (String)"startPath");
        this.paths.push((Object)startPath);
        DfsUtil.walk(LinearGraphUtils.asLiteLinearGraph(this.visibleLinearGraph), row2, this);
        this.pathsForCommits.forEach(new BiConsumer<Integer, MaybeDeletedFilePath>(this){
            final /* synthetic */ FileHistoryRefiner this$0;

            public final void accept(Integer commit, MaybeDeletedFilePath path) {
                if (path != null) {
                    FileNamesData fileNamesData = FileHistoryRefiner.access$getNamesData$p(this.this$0);
                    Integer n = commit;
                    Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"commit");
                    if (!fileNamesData.affects(n, path)) {
                        FileHistoryRefiner.access$getExcluded$p(this.this$0).add(commit);
                    }
                }
            }
            {
                this.this$0 = fileHistoryRefiner;
            }
        });
        HashSet<Integer> hashSet = this.excluded;
        Intrinsics.checkExpressionValueIsNotNull(hashSet, (String)"excluded");
        Iterable $receiver$iv = hashSet;
        for (Object element$iv : $receiver$iv) {
            Integer it = (Integer)element$iv;
            this.pathsForCommits.remove(it);
        }
        return new Pair(this.pathsForCommits, this.excluded);
    }

    @Override
    public void enterNode(int currentNode, int previousNode, boolean down) {
        MaybeDeletedFilePath previousPath;
        int currentNodeId = this.visibleLinearGraph.getNodeId(currentNode);
        Integer currentCommit = this.permanentCommitsInfo.getCommitId(currentNodeId);
        MaybeDeletedFilePath maybeDeletedFilePath = previousPath = (MaybeDeletedFilePath)CollectionsKt.last((List)((List)this.paths));
        Intrinsics.checkExpressionValueIsNotNull((Object)maybeDeletedFilePath, (String)"previousPath");
        MaybeDeletedFilePath currentPath = maybeDeletedFilePath;
        if (previousNode != -1) {
            MaybeDeletedFilePath maybeDeletedFilePath2;
            MaybeDeletedFilePath path;
            Function1 pathGetter2;
            int previousNodeId = this.visibleLinearGraph.getNodeId(previousNode);
            Integer previousCommit = this.permanentCommitsInfo.getCommitId(previousNodeId);
            if (down) {
                pathGetter2 = (Function1)new Function1<Integer, MaybeDeletedFilePath>(this, previousCommit, previousPath){
                    final /* synthetic */ FileHistoryRefiner this$0;
                    final /* synthetic */ Integer $previousCommit;
                    final /* synthetic */ MaybeDeletedFilePath $previousPath;

                    @NotNull
                    public final MaybeDeletedFilePath invoke(int parentIndex) {
                        FileNamesData fileNamesData = FileHistoryRefiner.access$getNamesData$p(this.this$0);
                        Integer n = this.$previousCommit;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"previousCommit");
                        int n2 = n;
                        CommitId CommitId2 = FileHistoryRefiner.access$getPermanentCommitsInfo$p(this.this$0).getCommitId(parentIndex);
                        Intrinsics.checkExpressionValueIsNotNull(CommitId2, (String)"permanentCommitsInfo.getCommitId(parentIndex)");
                        return fileNamesData.getPathInParentRevision(n2, ((Number)CommitId2).intValue(), this.$previousPath.getFilePath());
                    }
                    {
                        this.this$0 = fileHistoryRefiner;
                        this.$previousCommit = n;
                        this.$previousPath = maybeDeletedFilePath;
                        super(1);
                    }
                };
                path = this.findPathWithoutConflict(previousNodeId, (Function1<? super Integer, MaybeDeletedFilePath>)pathGetter2);
                maybeDeletedFilePath2 = path;
                if (maybeDeletedFilePath2 == null) {
                    maybeDeletedFilePath2 = (MaybeDeletedFilePath)pathGetter2.invoke((Object)BfsUtil.getCorrespondingParent(this.permanentLinearGraph, previousNodeId, currentNodeId, this.visibilityBuffer));
                }
            } else {
                pathGetter2 = (Function1)new Function1<Integer, MaybeDeletedFilePath>(this, currentCommit, previousPath){
                    final /* synthetic */ FileHistoryRefiner this$0;
                    final /* synthetic */ Integer $currentCommit;
                    final /* synthetic */ MaybeDeletedFilePath $previousPath;

                    @NotNull
                    public final MaybeDeletedFilePath invoke(int parentIndex) {
                        FileNamesData fileNamesData = FileHistoryRefiner.access$getNamesData$p(this.this$0);
                        Integer n = this.$currentCommit;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"currentCommit");
                        int n2 = n;
                        CommitId CommitId2 = FileHistoryRefiner.access$getPermanentCommitsInfo$p(this.this$0).getCommitId(parentIndex);
                        Intrinsics.checkExpressionValueIsNotNull(CommitId2, (String)"permanentCommitsInfo.getCommitId(parentIndex)");
                        return fileNamesData.getPathInChildRevision(n2, ((Number)CommitId2).intValue(), this.$previousPath.getFilePath());
                    }
                    {
                        this.this$0 = fileHistoryRefiner;
                        this.$currentCommit = n;
                        this.$previousPath = maybeDeletedFilePath;
                        super(1);
                    }
                };
                path = this.findPathWithoutConflict(currentNodeId, (Function1<? super Integer, MaybeDeletedFilePath>)pathGetter2);
                maybeDeletedFilePath2 = path;
                if (maybeDeletedFilePath2 == null) {
                    maybeDeletedFilePath2 = (MaybeDeletedFilePath)pathGetter2.invoke((Object)BfsUtil.getCorrespondingParent(this.permanentLinearGraph, currentNodeId, previousNodeId, this.visibilityBuffer));
                }
            }
            currentPath = maybeDeletedFilePath2;
        }
        HashMap<Integer, MaybeDeletedFilePath> hashMap = this.pathsForCommits;
        Intrinsics.checkExpressionValueIsNotNull(hashMap, (String)"pathsForCommits");
        Map map = hashMap;
        MaybeDeletedFilePath maybeDeletedFilePath3 = currentPath;
        map.put(currentCommit, maybeDeletedFilePath3);
        this.paths.push((Object)currentPath);
    }

    private final MaybeDeletedFilePath findPathWithoutConflict(int nodeId, Function1<? super Integer, MaybeDeletedFilePath> pathGetter2) {
        Object v3;
        MaybeDeletedFilePath path;
        block3: {
            Iterable iterable;
            List<Integer> parents;
            List<Integer> list2 = parents = this.permanentLinearGraph.getNodes(nodeId, LiteLinearGraph.NodeFilter.DOWN);
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"parents");
            Object object = CollectionsKt.first(list2);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parents.first()");
            path = (MaybeDeletedFilePath)pathGetter2.invoke(object);
            if (parents.size() == 1) {
                return path;
            }
            Iterable iterable2 = iterable = (Iterable)parents.subList(1, parents.size());
            for (Object t : iterable2) {
                Integer it;
                Integer n = it = (Integer)t;
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"it");
                if (!(Intrinsics.areEqual((Object)((MaybeDeletedFilePath)pathGetter2.invoke((Object)n)), (Object)path) ^ true)) continue;
                v3 = t;
                break block3;
            }
            v3 = null;
        }
        if (v3 != null) {
            return null;
        }
        return path;
    }

    @Override
    public void exitNode(int node) {
        this.paths.pop();
    }

    public FileHistoryRefiner(@NotNull LinearGraph visibleLinearGraph, @NotNull PermanentGraphInfo<Integer> permanentGraphInfo, @NotNull FileNamesData namesData) {
        Intrinsics.checkParameterIsNotNull((Object)visibleLinearGraph, (String)"visibleLinearGraph");
        Intrinsics.checkParameterIsNotNull(permanentGraphInfo, (String)"permanentGraphInfo");
        Intrinsics.checkParameterIsNotNull((Object)namesData, (String)"namesData");
        this.visibleLinearGraph = visibleLinearGraph;
        this.namesData = namesData;
        PermanentCommitsInfo<Integer> permanentCommitsInfo = permanentGraphInfo.getPermanentCommitsInfo();
        Intrinsics.checkExpressionValueIsNotNull(permanentCommitsInfo, (String)"permanentGraphInfo.permanentCommitsInfo");
        this.permanentCommitsInfo = permanentCommitsInfo;
        LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph(permanentGraphInfo.getLinearGraph());
        Intrinsics.checkExpressionValueIsNotNull((Object)liteLinearGraph, (String)"LinearGraphUtils.asLiteL\u2026entGraphInfo.linearGraph)");
        this.permanentLinearGraph = liteLinearGraph;
        this.paths = new Stack();
        this.visibilityBuffer = new BitSetFlags(this.permanentLinearGraph.nodesCount());
        this.pathsForCommits = ContainerUtil.newHashMap();
        this.excluded = ContainerUtil.newHashSet();
    }

    @NotNull
    public static final /* synthetic */ FileNamesData access$getNamesData$p(FileHistoryRefiner $this) {
        return $this.namesData;
    }

    @NotNull
    public static final /* synthetic */ HashSet access$getExcluded$p(FileHistoryRefiner $this) {
        return $this.excluded;
    }

    @NotNull
    public static final /* synthetic */ PermanentCommitsInfo access$getPermanentCommitsInfo$p(FileHistoryRefiner $this) {
        return $this.permanentCommitsInfo;
    }
}

