/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractParsing {
    protected static final TokenSet LA_INCLUDE_CONTENT = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{RncTokenTypes.KEYWORD_DIV, RncTokenTypes.KEYWORD_START}), RncTokenTypes.IDENTIFIERS});
    protected static final TokenSet LA_GRAMMAR_CONTENT = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{RncTokenTypes.KEYWORD_INCLUDE}), LA_INCLUDE_CONTENT});
    protected static final TokenSet ATTR_OR_ELEMENT = TokenSet.create((IElementType[])new IElementType[]{RncTokenTypes.KEYWORD_ATTRIBUTE, RncTokenTypes.KEYWORD_ElEMENT});
    protected static final TokenSet CONTENT = TokenSet.create((IElementType[])new IElementType[]{RncTokenTypes.KEYWORD_LIST, RncTokenTypes.KEYWORD_MIXED});
    protected static final TokenSet LA_DATATYPE = TokenSet.create((IElementType[])new IElementType[]{RncTokenTypes.KEYWORD_STRING, RncTokenTypes.KEYWORD_TOKEN});
    protected static final TokenSet LA_DECL = TokenSet.create((IElementType[])new IElementType[]{RncTokenTypes.KEYWORD_DATATYPES, RncTokenTypes.KEYWORD_NAMESPACE, RncTokenTypes.KEYWORD_DEFAULT});
    protected static final TokenSet NS_URI_LITERAL = TokenSet.create((IElementType[])new IElementType[]{RncTokenTypes.KEYWORD_INHERIT, RncTokenTypes.LITERAL});
    protected static final TokenSet ASSIGN_METHOD = TokenSet.create((IElementType[])new IElementType[]{RncTokenTypes.EQ, RncTokenTypes.CHOICE_EQ, RncTokenTypes.INTERLEAVE_EQ});
    protected final PsiBuilder myBuilder;

    public AbstractParsing(PsiBuilder builder2) {
        this.myBuilder = builder2;
    }

    protected final PsiBuilder.Marker begin() {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.advance();
        return marker;
    }

    protected final boolean matches(TokenSet set) {
        if (set.contains(this.currentToken())) {
            this.advance();
            return true;
        }
        return false;
    }

    protected final boolean matches(IElementType t) {
        if (t == this.currentToken()) {
            this.advance();
            return true;
        }
        return false;
    }

    protected final void match(IElementType token, @NotNull String msg) {
        if (msg == null) {
            AbstractParsing.$$$reportNull$$$0(0);
        }
        if (!this.matches(token)) {
            this.error(msg);
            this.advance();
        }
    }

    protected final void match(TokenSet set, @NotNull String msg) {
        if (msg == null) {
            AbstractParsing.$$$reportNull$$$0(1);
        }
        if (!this.matches(set)) {
            this.error(msg);
            this.advance();
        }
    }

    protected final void error(@NotNull String s) {
        if (s == null) {
            AbstractParsing.$$$reportNull$$$0(2);
        }
        this.myBuilder.error(s);
    }

    protected final void advance() {
        this.myBuilder.advanceLexer();
    }

    protected final IElementType currentToken() {
        IElementType token = this.myBuilder.getTokenType();
        if (AbstractParsing.isName(token)) {
            PsiBuilder.Marker marker = this.myBuilder.mark();
            this.makeName();
            if (this.myBuilder.getTokenType() == RncTokenTypes.LBRACKET) {
                this.skipAnnotation(marker, RncElementTypes.ANNOTATION_ELEMENT);
                return this.currentToken();
            }
            marker.rollbackTo();
        } else {
            if (token == RncTokenTypes.LBRACKET) {
                PsiBuilder.Marker marker = this.myBuilder.mark();
                this.skipAnnotation(marker, RncElementTypes.ANNOTATION);
                return this.currentToken();
            }
            if (token == RncTokenTypes.GTGT) {
                PsiBuilder.Marker marker = this.myBuilder.mark();
                this.advance();
                if (AbstractParsing.isName(this.myBuilder.getTokenType())) {
                    this.makeName();
                    if (this.myBuilder.getTokenType() == RncTokenTypes.LBRACKET) {
                        this.skipAnnotation(marker, RncElementTypes.FORWARD_ANNOTATION);
                        return this.currentToken();
                    }
                }
                marker.done(RncElementTypes.FORWARD_ANNOTATION);
                return this.currentToken();
            }
        }
        return token;
    }

    protected static boolean isName(IElementType token) {
        return RncTokenTypes.IDENTIFIER_OR_KEYWORD.contains(token) || token == RncTokenTypes.PREFIXED_NAME;
    }

    private void skipAnnotation(PsiBuilder.Marker marker, IElementType annotationType) {
        boolean b = this.myBuilder.getTokenType() == RncTokenTypes.LBRACKET;
        this.advance();
        assert (b);
        while (!this.myBuilder.eof() && this.currentToken() != RncTokenTypes.RBRACKET) {
            this.advance();
        }
        if (this.myBuilder.getTokenType() == RncTokenTypes.RBRACKET) {
            this.advance();
        }
        marker.done(annotationType);
    }

    protected final void makeName() {
        PsiBuilder.Marker name = this.myBuilder.mark();
        this.advance();
        name.done(RncElementTypes.NAME);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/relaxNG/compact/parser/AbstractParsing";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "match";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

