/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.connection;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.RemoteVmConnectionKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aF\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u001c\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u0002H\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n0\b\u001a\u001c\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0007\u001a&\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0001*\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"chooseDebuggee", "Lorg/jetbrains/concurrency/Promise;", "T", "targets", "", "selectedIndex", "", "renderer", "Lkotlin/Function2;", "Lcom/intellij/ui/ColoredListCellRenderer;", "", "initRemoteVmConnectionSync", "Lorg/jetbrains/debugger/Vm;", "connection", "Lorg/jetbrains/debugger/connection/RemoteVmConnection;", "debugPort", "open", "address", "Ljava/net/InetSocketAddress;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "intellij.platform.scriptDebugger.ui"})
public final class RemoteVmConnectionKt {
    @NotNull
    public static final Promise<? extends Vm> open(@NotNull RemoteVmConnection<?> $receiver, @NotNull InetSocketAddress address, @NotNull ProcessHandler processHandler2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        Intrinsics.checkParameterIsNotNull((Object)processHandler2, (String)"processHandler");
        return $receiver.open(address, (Condition<Void>)((Condition)new Condition<Void>(processHandler2){
            final /* synthetic */ ProcessHandler $processHandler;

            public final boolean value(Void it) {
                return this.$processHandler.isProcessTerminating() || this.$processHandler.isProcessTerminated();
            }
            {
                this.$processHandler = processHandler2;
            }
        }));
    }

    @NotNull
    public static final <T> Promise<T> chooseDebuggee(@NotNull Collection<? extends T> targets, int selectedIndex, @NotNull Function2<? super T, ? super ColoredListCellRenderer<?>, Unit> renderer) {
        Intrinsics.checkParameterIsNotNull(targets, (String)"targets");
        Intrinsics.checkParameterIsNotNull(renderer, (String)"renderer");
        if (targets.size() == 1) {
            return Promises.resolvedPromise((Object)CollectionsKt.first((Iterable)targets));
        }
        if (targets.isEmpty()) {
            return Promises.rejectedPromise((String)"No tabs to inspect");
        }
        AsyncPromise result2 = new AsyncPromise();
        ApplicationManager.getApplication().invokeLater(new Runnable(targets, renderer, result2, selectedIndex){
            final /* synthetic */ Collection $targets;
            final /* synthetic */ Function2 $renderer;
            final /* synthetic */ AsyncPromise $result;
            final /* synthetic */ int $selectedIndex;

            public final void run() {
                ArrayList model = ContainerUtil.newArrayList((Iterable)this.$targets);
                IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder((List)model).setRenderer((ListCellRenderer)new ColoredListCellRenderer<T>(this){
                    final /* synthetic */ chooseDebuggee.1 this$0;

                    protected void customizeCellRenderer(@NotNull JList<? extends T> list2, T value, int index, boolean selected, boolean hasFocus) {
                        Intrinsics.checkParameterIsNotNull(list2, (String)"list");
                        this.this$0.$renderer.invoke(value, (Object)((Object)this));
                    }
                    {
                        this.this$0 = $outer;
                    }
                }).setTitle("Choose Page to Debug").setCancelOnWindowDeactivation(false).setItemChosenCallback((Consumer)new Consumer<T>(this){
                    final /* synthetic */ chooseDebuggee.1 this$0;

                    public final void consume(T value) {
                        this.this$0.$result.setResult(value);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                if (this.$selectedIndex != -1) {
                    builder2.setSelectedValue(model.get(this.$selectedIndex), false);
                }
                builder2.createPopup().showInFocusCenter();
            }
            {
                this.$targets = collection;
                this.$renderer = function2;
                this.$result = asyncPromise;
                this.$selectedIndex = n;
            }
        });
        return (Promise)result2;
    }

    @Deprecated(message="Use NodeCommandLineUtil.initRemoteVmConnectionSync instead")
    @NotNull
    public static final Vm initRemoteVmConnectionSync(@NotNull RemoteVmConnection<?> connection, int debugPort) throws ExecutionException {
        Vm vm;
        Intrinsics.checkParameterIsNotNull(connection, (String)"connection");
        InetSocketAddress address = new InetSocketAddress(InetAddress.getLoopbackAddress(), debugPort);
        Promise vmPromise = RemoteVmConnection.open$default(connection, address, null, 2, null);
        try {
            Object object = vmPromise.blockingGet(30, TimeUnit.SECONDS);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            vm = (Vm)object;
        }
        catch (Exception e) {
            throw (Throwable)new ExecutionException("Cannot connect to VM (" + address + ')', (Throwable)e);
        }
        return vm;
    }
}

