/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.actions.CreateResourceDirectoryDialog;
import org.jetbrains.android.actions.ElementCreatingValidator;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverrideResourceAction
extends AbstractIntentionAction {
    @Nullable
    public static String ourTargetFolderName;

    private static String getActionName(@Nullable String folder) {
        return "Override Resource in " + (folder != null ? folder : "Other Configuration...");
    }

    @NotNull
    public String getText() {
        String string = OverrideResourceAction.getActionName(null);
        if (string == null) {
            OverrideResourceAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            OverrideResourceAction.$$$reportNull$$$0(1);
        }
        if (file instanceof XmlFile && file.isValid() && AndroidFacet.getInstance((PsiElement)file) != null) {
            ResourceFolderType folderType = ResourceHelper.getFolderType(file);
            if (folderType == null) {
                return false;
            }
            if (folderType != ResourceFolderType.VALUES) {
                return true;
            }
            return this.isAvailable(OverrideResourceAction.getValueTag(editor, file), file);
        }
        return false;
    }

    public boolean isAvailable(@Nullable XmlTag tag, PsiFile file) {
        if (file instanceof XmlFile && file.isValid() && AndroidFacet.getInstance((PsiElement)file) != null) {
            ResourceFolderType folderType = ResourceHelper.getFolderType(file);
            if (folderType == null) {
                return false;
            }
            if (folderType != ResourceFolderType.VALUES) {
                return true;
            }
            if (tag != null && tag.getAttributeValue("name") != null) {
                return AndroidResourceUtil.getResourceForResourceTag(tag) != null;
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        ResourceFolderType folderType;
        if (project == null) {
            OverrideResourceAction.$$$reportNull$$$0(2);
        }
        if ((folderType = ResourceHelper.getFolderType(file)) == null) {
            return;
        }
        if (folderType != ResourceFolderType.VALUES) {
            OverrideResourceAction.forkResourceFile((XmlFile)file, null, true);
        } else if (editor != null) {
            OverrideResourceAction.forkResourceValue(project, editor, file, null, true);
        }
    }

    private static void forkResourceValue(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiDirectory dir, boolean open) {
        if (project == null) {
            OverrideResourceAction.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            OverrideResourceAction.$$$reportNull$$$0(4);
        }
        if (file == null) {
            OverrideResourceAction.$$$reportNull$$$0(5);
        }
        TransactionGuard.submitTransaction((Disposable)project, () -> {
            XmlTag tag;
            if (editor == null) {
                OverrideResourceAction.$$$reportNull$$$0(23);
            }
            if (file == null) {
                OverrideResourceAction.$$$reportNull$$$0(24);
            }
            if (project == null) {
                OverrideResourceAction.$$$reportNull$$$0(25);
            }
            if ((tag = OverrideResourceAction.getValueTag(editor, file)) == null) {
                return;
            }
            OverrideResourceAction.forkResourceValue(project, tag, file, dir, open);
        });
    }

    @Nullable
    private static PsiDirectory findRes(@NotNull PsiFile file) {
        PsiDirectory resourceFolder;
        if (file == null) {
            OverrideResourceAction.$$$reportNull$$$0(6);
        }
        return (resourceFolder = file.getParent()) == null ? null : resourceFolder.getParent();
    }

    public static void forkResourceValue(@NotNull Project project, @NotNull XmlTag tag, @NotNull PsiFile file, @Nullable PsiDirectory dir, boolean open) {
        PsiDirectory resFolder;
        if (project == null) {
            OverrideResourceAction.$$$reportNull$$$0(7);
        }
        if (tag == null) {
            OverrideResourceAction.$$$reportNull$$$0(8);
        }
        if (file == null) {
            OverrideResourceAction.$$$reportNull$$$0(9);
        }
        if ((resFolder = OverrideResourceAction.findRes(file)) == null) {
            return;
        }
        String name = tag.getAttributeValue("name");
        ResourceType type = AndroidResourceUtil.getResourceForResourceTag(tag);
        if (name == null || type == null) {
            return;
        }
        if (dir == null) {
            dir = OverrideResourceAction.selectFolderDir(project, resFolder.getVirtualFile(), ResourceFolderType.VALUES);
        }
        if (dir != null) {
            String value = ResourceHelper.getTextContent(tag).trim();
            OverrideResourceAction.createValueResource(project, resFolder, file, dir, name, value, type, tag.getText(), open);
        }
    }

    @Nullable
    private static XmlTag getEditorTag(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement != null) {
            return (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class, (boolean)false);
        }
        return null;
    }

    @Nullable
    private static XmlTag getValueTag(Editor editor, PsiFile file) {
        return OverrideResourceAction.getValueTag(OverrideResourceAction.getEditorTag(editor, file));
    }

    @Nullable
    public static XmlTag getValueTag(@Nullable XmlTag tag) {
        XmlTag current = null;
        if (tag != null) {
            XmlTag parentParent;
            current = tag;
            XmlTag parent = current.getParentTag();
            while (parent != null && (parentParent = parent.getParentTag()) != null) {
                current = parent;
                parent = parentParent;
            }
        }
        return current;
    }

    private static void createValueResource(final @NotNull Project project, final @NotNull PsiDirectory resDir, @NotNull PsiFile file, @NotNull PsiDirectory resourceSubdir, final @NotNull String resName, final @NotNull String value, final @NotNull ResourceType type, final @NotNull String oldTagText, boolean open) {
        if (project == null) {
            OverrideResourceAction.$$$reportNull$$$0(10);
        }
        if (resDir == null) {
            OverrideResourceAction.$$$reportNull$$$0(11);
        }
        if (file == null) {
            OverrideResourceAction.$$$reportNull$$$0(12);
        }
        if (resourceSubdir == null) {
            OverrideResourceAction.$$$reportNull$$$0(13);
        }
        if (resName == null) {
            OverrideResourceAction.$$$reportNull$$$0(14);
        }
        if (value == null) {
            OverrideResourceAction.$$$reportNull$$$0(15);
        }
        if (type == null) {
            OverrideResourceAction.$$$reportNull$$$0(16);
        }
        if (oldTagText == null) {
            OverrideResourceAction.$$$reportNull$$$0(17);
        }
        final String filename = file.getName();
        final List<String> dirNames = Collections.singletonList(resourceSubdir.getName());
        final AtomicReference openAfter = new AtomicReference();
        WriteCommandAction<Void> action = new WriteCommandAction<Void>(project, "Override Resource " + resName, new PsiFile[]{file}){

            protected void run(@NotNull Result<Void> result) {
                XmlTag tag;
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                ArrayList elements = Lists.newArrayListWithExpectedSize((int)1);
                AndroidResourceUtil.createValueResource(project, resDir.getVirtualFile(), resName, type, filename, dirNames, value, elements);
                if (elements.size() == 1 && (tag = ((ResourceElement)elements.get(0)).getXmlTag()) != null && tag.isValid()) {
                    try {
                        XmlTag tagFromText = XmlElementFactory.getInstance((Project)tag.getProject()).createTagFromText((CharSequence)oldTagText);
                        PsiElement replaced = tag.replace((PsiElement)tagFromText);
                        openAfter.set(replaced);
                    }
                    catch (IncorrectOperationException e) {
                        openAfter.set(tag);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/actions/OverrideResourceAction$1", "run"));
            }
        };
        action.execute();
        PsiElement tag = (PsiElement)openAfter.get();
        if (open && tag != null) {
            NavigationUtil.openFileWithPsiElement((PsiElement)tag, (boolean)true, (boolean)true);
        }
    }

    public static void forkResourceFile(@NotNull EditorDesignSurface surface, @Nullable String newFolder, boolean open) {
        Configuration configuration;
        if (surface == null) {
            OverrideResourceAction.$$$reportNull$$$0(18);
        }
        if ((configuration = surface.getConfiguration()) == null) {
            assert (false);
            return;
        }
        VirtualFile file = configuration.getFile();
        if (file == null) {
            assert (false);
            return;
        }
        Module module = configuration.getModule();
        if (module == null) {
            assert (false);
            return;
        }
        XmlFile xmlFile = (XmlFile)configuration.getPsiFile();
        ResourceFolderType folderType = ResourceHelper.getFolderType((PsiFile)xmlFile);
        if (folderType == null) {
            folderType = ResourceFolderType.LAYOUT;
        }
        OverrideResourceAction.forkResourceFile(module.getProject(), folderType, file, xmlFile, newFolder, configuration, open);
    }

    public static void forkResourceFile(@NotNull XmlFile xmlFile, @Nullable String myNewFolder, boolean open) {
        VirtualFile file;
        if (xmlFile == null) {
            OverrideResourceAction.$$$reportNull$$$0(19);
        }
        if ((file = xmlFile.getVirtualFile()) == null) {
            return;
        }
        Module module = AndroidPsiUtils.getModuleSafely((PsiElement)xmlFile);
        if (module == null) {
            return;
        }
        ResourceFolderType folderType = ResourceHelper.getFolderType((PsiFile)xmlFile);
        if (folderType == null || folderType == ResourceFolderType.VALUES) {
            return;
        }
        Configuration configuration = null;
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            configuration = ConfigurationManager.getOrCreateInstance(module).getConfiguration(file);
        }
        OverrideResourceAction.forkResourceFile(module.getProject(), folderType, file, xmlFile, myNewFolder, configuration, open);
    }

    private static void forkResourceFile(@NotNull Project project, final @NotNull ResourceFolderType folderType, final @NotNull VirtualFile file, final @Nullable XmlFile xmlFile, @Nullable String myNewFolder, @Nullable Configuration configuration, boolean open) {
        FolderConfiguration folderConfig;
        if (project == null) {
            OverrideResourceAction.$$$reportNull$$$0(20);
        }
        if (folderType == null) {
            OverrideResourceAction.$$$reportNull$$$0(21);
        }
        if (file == null) {
            OverrideResourceAction.$$$reportNull$$$0(22);
        }
        if (myNewFolder == null) {
            VirtualFile parentFolder = file.getParent();
            assert (parentFolder != null);
            VirtualFile res = parentFolder.getParent();
            folderConfig = OverrideResourceAction.selectFolderConfig(project, res, folderType);
        } else {
            folderConfig = FolderConfiguration.getConfigForFolder((String)myNewFolder);
        }
        if (folderConfig == null) {
            return;
        }
        Computable<Pair<String, VirtualFile>> computable = new Computable<Pair<String, VirtualFile>>(){

            public Pair<String, VirtualFile> compute() {
                String folderName = folderConfig.getFolderName(folderType);
                try {
                    VirtualFile existing;
                    VirtualFile parentFolder = file.getParent();
                    assert (parentFolder != null);
                    VirtualFile res = parentFolder.getParent();
                    VirtualFile newParentFolder = res.findChild(folderName);
                    if (newParentFolder == null) {
                        try {
                            newParentFolder = res.createChildDirectory((Object)this, folderName);
                        }
                        catch (IncorrectOperationException e) {
                            String message = String.format("Could not create folder %1$s in %2$s, Reason:\n%3$s", folderName, res.getPath(), e.getMessage());
                            return Pair.of((Object)message, null);
                        }
                    }
                    if ((existing = newParentFolder.findChild(file.getName())) != null && existing.exists()) {
                        String message = String.format("File 'res/%1$s/%2$s' already exists!", folderName, file.getName());
                        return Pair.of((Object)message, null);
                    }
                    String text = xmlFile != null && xmlFile.isValid() ? xmlFile.getText() : StreamUtil.readText((InputStream)file.getInputStream(), (String)"UTF-8");
                    VirtualFile newFile = newParentFolder.createChildData((Object)this, file.getName());
                    VfsUtil.saveText((VirtualFile)newFile, (String)text);
                    return Pair.of(null, (Object)newFile);
                }
                catch (IOException e2) {
                    String message = String.format("Failed to create File 'res/%1$s/%2$s' : %3$s", folderName, file.getName(), e2.getMessage());
                    return Pair.of((Object)message, null);
                }
            }
        };
        WriteCommandAction<Pair<String, VirtualFile>> action = new WriteCommandAction<Pair<String, VirtualFile>>(project, "Add Resource", new PsiFile[0], (Computable)computable){
            final /* synthetic */ Computable val$computable;
            {
                this.val$computable = computable;
                super(arg0, arg1, arg2);
            }

            protected void run(@NotNull Result<Pair<String, VirtualFile>> result) throws Throwable {
                if (result == null) {
                    3.$$$reportNull$$$0(0);
                }
                result.setResult(this.val$computable.compute());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/actions/OverrideResourceAction$3", "run"));
            }
        };
        Pair result = (Pair)action.execute().getResultObject();
        String error = (String)result.getFirst();
        VirtualFile newFile = (VirtualFile)result.getSecond();
        if (error != null) {
            Messages.showErrorDialog((Project)project, (String)error, (String)"Create Resource");
        } else {
            if (configuration != null) {
                ConfigurationManager configurationManager = configuration.getConfigurationManager();
                configurationManager.createSimilar(newFile, file);
            }
            if (open) {
                OpenFileDescriptor descriptor = new OpenFileDescriptor(project, newFile, -1);
                FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
            }
        }
    }

    @Nullable
    public static PsiDirectory selectFolderDir(Project project, VirtualFile res, ResourceFolderType folderType) {
        PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(res);
        if (directory == null) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && ourTargetFolderName != null) {
            PsiDirectory subDirectory = directory.findSubdirectory(ourTargetFolderName);
            if (subDirectory != null) {
                return subDirectory;
            }
            Computable createDirComputable = () -> directory.createSubdirectory(ourTargetFolderName);
            return (PsiDirectory)ApplicationManager.getApplication().runWriteAction(createDirComputable);
        }
        CreateResourceDirectoryDialog dialog = new CreateResourceDirectoryDialog(project, null, folderType, directory, null, resDirectory -> new ResourceDirectorySelector(project, resDirectory));
        dialog.setTitle("Select Resource Directory");
        if (!dialog.showAndGet()) {
            return null;
        }
        PsiElement[] createdElements = dialog.getCreatedElements();
        if (createdElements.length > 0) {
            return (PsiDirectory)createdElements[0];
        }
        return null;
    }

    @Nullable
    public static FolderConfiguration selectFolderConfig(Project project, VirtualFile res, ResourceFolderType folderType) {
        PsiDirectory dir = OverrideResourceAction.selectFolderDir(project, res, folderType);
        if (dir != null) {
            return FolderConfiguration.getConfigForFolder((String)dir.getName());
        }
        return null;
    }

    public static AndroidLintQuickFix createFix(@Nullable String folder) {
        return new OverrideElementFix(folder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/actions/OverrideResourceAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resDir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceSubdir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldTagText";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/actions/OverrideResourceAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "forkResourceValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findRes";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createValueResource";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "forkResourceFile";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$forkResourceValue$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OverrideElementFix
    implements AndroidLintQuickFix {
        private final String myFolder;

        private OverrideElementFix(@Nullable String folder) {
            this.myFolder = folder;
        }

        @Override
        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            ResourceFolderType folderType;
            PsiFile file;
            if (startElement == null) {
                OverrideElementFix.$$$reportNull$$$0(0);
            }
            if (endElement == null) {
                OverrideElementFix.$$$reportNull$$$0(1);
            }
            if (context == null) {
                OverrideElementFix.$$$reportNull$$$0(2);
            }
            if ((file = startElement.getContainingFile()) instanceof XmlFile && (folderType = ResourceHelper.getFolderType(file)) != null) {
                if (folderType != ResourceFolderType.VALUES) {
                    OverrideResourceAction.forkResourceFile((XmlFile)file, this.myFolder, true);
                } else {
                    XmlTag tag = OverrideResourceAction.getValueTag((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false));
                    if (tag != null) {
                        PsiDirectory resFolder;
                        PsiDirectory dir = null;
                        if (this.myFolder != null && (resFolder = OverrideResourceAction.findRes(file)) != null && (dir = resFolder.findSubdirectory(this.myFolder)) == null) {
                            dir = resFolder.createSubdirectory(this.myFolder);
                        }
                        OverrideResourceAction.forkResourceValue(startElement.getProject(), tag, file, dir, true);
                    }
                }
            }
        }

        @Override
        public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
            if (startElement == null) {
                OverrideElementFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                OverrideElementFix.$$$reportNull$$$0(4);
            }
            if (contextType == null) {
                OverrideElementFix.$$$reportNull$$$0(5);
            }
            return true;
        }

        @Override
        @NotNull
        public String getName() {
            String string = OverrideResourceAction.getActionName(this.myFolder);
            if (string == null) {
                OverrideElementFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contextType";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/actions/OverrideResourceAction$OverrideElementFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/actions/OverrideResourceAction$OverrideElementFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ResourceDirectorySelector
    extends ElementCreator
    implements ElementCreatingValidator {
        private final PsiDirectory myDirectory;
        private PsiElement[] myCreatedElements = PsiElement.EMPTY_ARRAY;

        ResourceDirectorySelector(Project project, PsiDirectory directory) {
            super(project, "Select Resource Directory");
            this.myDirectory = directory;
        }

        public boolean checkInput(String inputString) {
            return ResourceFolderType.getFolderType((String)inputString) != null && FolderConfiguration.getConfigForFolder((String)inputString) != null;
        }

        public PsiElement[] create(String newName) throws Exception {
            PsiDirectory subdirectory = this.myDirectory.findSubdirectory(newName);
            if (subdirectory == null) {
                subdirectory = this.myDirectory.createSubdirectory(newName);
            }
            return new PsiElement[]{subdirectory};
        }

        public String getActionName(String newName) {
            return "Select Resource Directory";
        }

        public boolean canClose(String inputString) {
            PsiDirectory subdirectory = this.myDirectory.findSubdirectory(inputString);
            if (subdirectory != null) {
                this.myCreatedElements = new PsiDirectory[]{subdirectory};
                return true;
            }
            this.myCreatedElements = this.tryCreate(inputString);
            return this.myCreatedElements.length > 0;
        }

        @Override
        @NotNull
        public final PsiElement[] getCreatedElements() {
            if (this.myCreatedElements == null) {
                ResourceDirectorySelector.$$$reportNull$$$0(0);
            }
            return this.myCreatedElements;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/OverrideResourceAction$ResourceDirectorySelector", "getCreatedElements"));
        }
    }
}

