/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassNavigation
implements NavigationItem {
    @NotNull
    private PsiFile myPsiFile;
    private int myOffset;
    private int myLine;

    private PsiClassNavigation(@NotNull PsiFile file, int offset, int line) {
        if (file == null) {
            PsiClassNavigation.$$$reportNull$$$0(0);
        }
        this.myPsiFile = file;
        this.myOffset = offset;
        this.myLine = line;
    }

    @Nullable
    public static PsiClassNavigation[] getNavigationForClass(@NotNull Project project, @Nullable String className) {
        if (project == null) {
            PsiClassNavigation.$$$reportNull$$$0(1);
        }
        if (className == null || className.isEmpty()) {
            return null;
        }
        PsiClass[] resolvedClasses = PsiClassNavigation.resolveClasses(project, className);
        PsiClassNavigation[] navigatables = new PsiClassNavigation[resolvedClasses.length];
        for (int i = 0; i < resolvedClasses.length; ++i) {
            PsiClass c = resolvedClasses[i];
            navigatables[i] = new PsiClassNavigation(c.getContainingFile(), c.getTextOffset(), -1);
        }
        return navigatables;
    }

    @Nullable
    public static PsiClassNavigation[] getNavigationForClass(@NotNull Project project, @Nullable String className, int line) {
        if (project == null) {
            PsiClassNavigation.$$$reportNull$$$0(2);
        }
        if (className == null || className.isEmpty()) {
            return null;
        }
        PsiClass[] psiClasses = PsiClassNavigation.getPsiClassesForOuterClass(project, className);
        PsiClassNavigation[] navigatables = new PsiClassNavigation[psiClasses.length];
        for (int i = 0; i < psiClasses.length; ++i) {
            PsiClass c = psiClasses[i];
            navigatables[i] = new PsiClassNavigation(c.getContainingFile(), -1, line);
        }
        return navigatables;
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(PsiClassNavigation.class);
        if (logger == null) {
            PsiClassNavigation.$$$reportNull$$$0(3);
        }
        return logger;
    }

    @NotNull
    private static PsiClass[] resolveClasses(@NotNull Project project, @NotNull String className) {
        PsiClass[] psiClasses;
        if (project == null) {
            PsiClassNavigation.$$$reportNull$$$0(4);
        }
        if (className == null) {
            PsiClassNavigation.$$$reportNull$$$0(5);
        }
        if ((psiClasses = PsiClassNavigation.getPsiClassesForOuterClass(project, className)).length == 0) {
            if (psiClasses == null) {
                PsiClassNavigation.$$$reportNull$$$0(6);
            }
            return psiClasses;
        }
        String[] classNameComponents = className.split("\\$");
        if (classNameComponents.length == 1) {
            if (psiClasses == null) {
                PsiClassNavigation.$$$reportNull$$$0(7);
            }
            return psiClasses;
        }
        block0: for (int psiClassIndex = 0; psiClassIndex < psiClasses.length; ++psiClassIndex) {
            for (int i = 1; i < classNameComponents.length; ++i) {
                String innerClassName = classNameComponents[i];
                if (PsiClassNavigation.startsWithInteger(innerClassName)) {
                    int innerClassIndex = PsiClassNavigation.convertToClassIndex(innerClassName);
                    if (innerClassIndex < 0) {
                        PsiClassNavigation.getLog().info("Attempted to resolve mismatched class name in hprof file: " + className);
                        continue block0;
                    }
                    CountDownAnonymousClassVisitor visitor = new CountDownAnonymousClassVisitor(innerClassIndex);
                    psiClasses[psiClassIndex].accept((PsiElementVisitor)visitor);
                    PsiAnonymousClass anonymousClass = visitor.getAnonymousClass();
                    if (anonymousClass == null) continue block0;
                    psiClasses[psiClassIndex] = anonymousClass;
                    continue;
                }
                PsiClass innerClass = psiClasses[psiClassIndex].findInnerClassByName(innerClassName, false);
                if (innerClass == null) continue block0;
                psiClasses[psiClassIndex] = innerClass;
            }
        }
        if (psiClasses == null) {
            PsiClassNavigation.$$$reportNull$$$0(8);
        }
        return psiClasses;
    }

    @NotNull
    private static PsiClass[] getPsiClassesForOuterClass(@NotNull Project project, @NotNull String className) {
        String outerClassName;
        if (project == null) {
            PsiClassNavigation.$$$reportNull$$$0(9);
        }
        if (className == null) {
            PsiClassNavigation.$$$reportNull$$$0(10);
        }
        if ((outerClassName = PsiClassNavigation.getOuterClassName(className)) == null) {
            if (PsiClass.EMPTY_ARRAY == null) {
                PsiClassNavigation.$$$reportNull$$$0(11);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass[] psiClasses = javaPsiFacade.findClasses(outerClassName, GlobalSearchScope.projectScope((Project)project));
        if (psiClasses.length == 0) {
            psiClasses = javaPsiFacade.findClasses(outerClassName, GlobalSearchScope.allScope((Project)project));
        }
        block0: for (int i = 0; i < psiClasses.length; ++i) {
            PsiClass[] sourcePsiClasses;
            PsiElement fileElement;
            PsiClass psiClass = psiClasses[i];
            if (psiClass.getQualifiedName() == null || !(psiClass instanceof PsiCompiledElement) || (fileElement = psiClass.getContainingFile().getNavigationElement()) instanceof PsiCompiledElement || !(fileElement instanceof PsiJavaFile)) continue;
            for (PsiClass sourcePsiClass : sourcePsiClasses = ((PsiJavaFile)fileElement).getClasses()) {
                if (!psiClass.getQualifiedName().equals(sourcePsiClass.getQualifiedName())) continue;
                psiClasses[i] = sourcePsiClass;
                continue block0;
            }
        }
        if (psiClasses == null) {
            PsiClassNavigation.$$$reportNull$$$0(12);
        }
        return psiClasses;
    }

    @Nullable
    private static String getOuterClassName(@NotNull String className) {
        int innerClassSymbolIndex;
        if (className == null) {
            PsiClassNavigation.$$$reportNull$$$0(13);
        }
        if ((innerClassSymbolIndex = className.indexOf(36)) > 0) {
            return className.substring(0, innerClassSymbolIndex);
        }
        if (innerClassSymbolIndex == 0) {
            PsiClassNavigation.getLog().warn("Invalid class name: starts with '$'");
            return null;
        }
        return className;
    }

    private static int convertToClassIndex(@NotNull String innerClassNameString) {
        if (innerClassNameString == null) {
            PsiClassNavigation.$$$reportNull$$$0(14);
        }
        try {
            return Integer.parseInt(innerClassNameString) - 1;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static boolean startsWithInteger(@NotNull String target) {
        if (target == null) {
            PsiClassNavigation.$$$reportNull$$$0(15);
        }
        return !target.isEmpty() && Character.isDigit(target.charAt(0));
    }

    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            PsiClassNavigation.$$$reportNull$$$0(16);
        }
        return psiFile;
    }

    @Nullable
    public String getName() {
        return this.myPsiFile.getName();
    }

    @Nullable
    public ItemPresentation getPresentation() {
        return this.myPsiFile.getPresentation();
    }

    public void navigate(boolean requestFocus) {
        OpenFileDescriptor fileDescriptor = this.myOffset >= 0 ? new OpenFileDescriptor(this.myPsiFile.getProject(), this.myPsiFile.getVirtualFile(), this.myOffset) : new OpenFileDescriptor(this.myPsiFile.getProject(), this.myPsiFile.getVirtualFile(), this.myLine, 0);
        fileDescriptor.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myPsiFile.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myPsiFile.canNavigateToSource();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/actions/PsiClassNavigation";
                break;
            }
            case 5: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClassNameString";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/actions/PsiClassNavigation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveClasses";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiClassesForOuterClass";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationForClass";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 16: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveClasses";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPsiClassesForOuterClass";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getOuterClassName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "convertToClassIndex";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "startsWithInteger";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CountDownAnonymousClassVisitor
    extends JavaRecursiveElementVisitor {
        @Nullable
        private PsiAnonymousClass myAnonymousClass;
        private int myAnonymousClassIndex;

        CountDownAnonymousClassVisitor(int anonymousClassIndex) {
            this.myAnonymousClassIndex = anonymousClassIndex;
        }

        public void visitAnonymousClass(PsiAnonymousClass aClass) {
            super.visitAnonymousClass(aClass);
            if (this.myAnonymousClassIndex == 0) {
                this.myAnonymousClass = aClass;
            }
            --this.myAnonymousClassIndex;
        }

        @Nullable
        public PsiAnonymousClass getAnonymousClass() {
            return this.myAnonymousClass;
        }
    }
}

