/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb;

import com.android.ddmlib.Log;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbLogOutput {

    public static class ToStringLogger
    implements Log.ILogOutput {
        private final StringBuilder sb = new StringBuilder(100);

        public void printLog(@Nullable Log.LogLevel logLevel, @Nullable String tag, @Nullable String message) {
            this.append(message);
        }

        public void printAndPromptLog(@Nullable Log.LogLevel logLevel, @Nullable String tag, @Nullable String message) {
            this.append(message);
        }

        private void append(String message) {
            if (!StringUtil.isEmpty((String)message)) {
                this.sb.append(message);
                this.sb.append('\n');
            }
        }

        @NotNull
        public String getOutput() {
            String string = this.sb.toString();
            if (string == null) {
                ToStringLogger.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/adb/AdbLogOutput$ToStringLogger", "getOutput"));
        }
    }

    public static class SystemLogRedirecter
    implements Log.ILogOutput {
        private static final NotificationGroup EVENT_LOG = NotificationGroup.logOnlyGroup((String)"ADB Logs");
        private static final Logger LOG = Logger.getInstance((String)"#com.android.ddmlib");

        public void printLog(@Nullable Log.LogLevel logLevel, @Nullable String tag, @Nullable String message) {
            SystemLogRedirecter.reportAdbLog(logLevel, tag, message);
        }

        public void printAndPromptLog(@Nullable Log.LogLevel logLevel, @Nullable String tag, @Nullable String message) {
            SystemLogRedirecter.reportAdbLog(logLevel, tag, message);
        }

        public static Logger getLogger() {
            return LOG;
        }

        private static void reportAdbLog(@Nullable Log.LogLevel logLevel, @Nullable String tag, @Nullable String message) {
            if (StringUtil.isEmpty((String)message)) {
                return;
            }
            if (logLevel == null) {
                logLevel = Log.LogLevel.DEBUG;
            }
            switch (logLevel) {
                case VERBOSE: 
                case DEBUG: {
                    LOG.debug(message);
                    break;
                }
                case INFO: {
                    LOG.info(message);
                    break;
                }
                case WARN: {
                    LOG.warn(message);
                    break;
                }
                case ERROR: 
                case ASSERT: {
                    LOG.warn(message);
                    EVENT_LOG.createNotification(message, MessageType.WARNING).notify(null);
                }
            }
        }
    }
}

