/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.apk.analyzer.ApkSizeCalculator;
import com.android.tools.apk.analyzer.Archive;
import com.android.tools.apk.analyzer.Archives;
import com.android.tools.apk.analyzer.BinaryXmlParser;
import com.android.tools.apk.analyzer.internal.ArchiveTreeNode;
import com.android.tools.idea.apk.viewer.ApkFileEditorComponent;
import com.android.tools.idea.apk.viewer.ApkFileSystem;
import com.android.tools.idea.apk.viewer.ApkParser;
import com.android.tools.idea.apk.viewer.ApkViewPanel;
import com.android.tools.idea.apk.viewer.ApkVirtualFile;
import com.android.tools.idea.apk.viewer.EmptyPanel;
import com.android.tools.idea.apk.viewer.arsc.ArscViewer;
import com.android.tools.idea.apk.viewer.dex.DexFileViewer;
import com.android.tools.idea.apk.viewer.diff.ApkDiffPanel;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.messages.MessageBusConnection;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkEditor
extends UserDataHolderBase
implements FileEditor,
ApkViewPanel.Listener {
    private final Project myProject;
    private final VirtualFile myBaseFile;
    private final VirtualFile myRoot;
    private ApkViewPanel myApkViewPanel;
    private Archive myArchive;
    private JBSplitter mySplitter;
    private ApkFileEditorComponent myCurrentEditor;

    public ApkEditor(@NotNull Project project, final @NotNull VirtualFile baseFile, @NotNull VirtualFile root) {
        if (project == null) {
            ApkEditor.$$$reportNull$$$0(0);
        }
        if (baseFile == null) {
            ApkEditor.$$$reportNull$$$0(1);
        }
        if (root == null) {
            ApkEditor.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myBaseFile = baseFile;
        this.myRoot = root;
        this.mySplitter = new JBSplitter(true, "android.apk.viewer", 0.62f);
        this.mySplitter.setName("apkViwerContainer");
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    if (!ApkEditor.this.myBaseFile.equals(vFileEvent.getFile()) || !ApkEditor.this.myBaseFile.isValid()) continue;
                    ApkEditor.this.refreshApk(baseFile);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/android/tools/idea/apk/viewer/ApkEditor$1", "after"));
            }
        });
        this.refreshApk(this.myBaseFile);
        this.mySplitter.setSecondComponent((JComponent)new JPanel());
    }

    private void refreshApk(@NotNull VirtualFile apkVirtualFile) {
        if (apkVirtualFile == null) {
            ApkEditor.$$$reportNull$$$0(3);
        }
        this.disposeArchive();
        try {
            Path copyOfApk = Files.createTempFile(apkVirtualFile.getNameWithoutExtension(), "." + apkVirtualFile.getExtension(), new FileAttribute[0]);
            Files.copy(VfsUtilCore.virtualToIoFile((VirtualFile)apkVirtualFile).toPath(), copyOfApk, StandardCopyOption.REPLACE_EXISTING);
            this.myArchive = Archives.open((Path)copyOfApk);
            this.myApkViewPanel = new ApkViewPanel(this.myProject, new ApkParser(this.myArchive, ApkSizeCalculator.getDefault()));
            this.myApkViewPanel.setListener(this);
            this.mySplitter.setFirstComponent(this.myApkViewPanel.getContainer());
            this.selectionChanged(null);
        }
        catch (IOException e) {
            Logger.getInstance(ApkEditor.class).error((Throwable)e);
            this.disposeArchive();
            this.mySplitter.setFirstComponent((JComponent)new JBLabel(e.toString()));
        }
    }

    @Override
    public void selectionChanged(@Nullable ArchiveTreeNode[] entries) {
        if (this.myCurrentEditor != null) {
            Disposer.dispose((Disposable)this.myCurrentEditor);
            this.myCurrentEditor = null;
        }
        this.myCurrentEditor = this.getEditor(entries);
        this.mySplitter.setSecondComponent(this.myCurrentEditor.getComponent());
    }

    @Override
    public void selectApkAndCompare() {
        FileChooserDescriptor desc = new FileChooserDescriptor(true, false, false, false, false, false);
        desc.withFileFilter(file -> ApkFileSystem.EXTENSIONS.contains(file.getExtension()));
        VirtualFile file2 = FileChooser.chooseFile((FileChooserDescriptor)desc, (Project)this.myProject, null);
        if (file2 == null) {
            return;
        }
        VirtualFile oldApk = ApkFileSystem.getInstance().getRootByLocal(file2);
        assert (oldApk != null);
        DialogBuilder builder = new DialogBuilder(this.myProject);
        builder.setTitle(oldApk.getName() + " (old) vs " + this.myRoot.getName() + " (new)");
        ApkDiffPanel panel = new ApkDiffPanel(oldApk, this.myRoot);
        builder.setCenterPanel(panel.getContainer());
        builder.setPreferredFocusComponent(panel.getPreferredFocusedComponent());
        builder.show();
    }

    @NotNull
    public JComponent getComponent() {
        JBSplitter jBSplitter = this.mySplitter;
        if (jBSplitter == null) {
            ApkEditor.$$$reportNull$$$0(4);
        }
        return jBSplitter;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myApkViewPanel.getPreferredFocusedComponent();
    }

    @NotNull
    public String getName() {
        String string = this.myBaseFile.getName();
        if (string == null) {
            ApkEditor.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            ApkEditor.$$$reportNull$$$0(6);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return this.myBaseFile.isValid();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            ApkEditor.$$$reportNull$$$0(7);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            ApkEditor.$$$reportNull$$$0(8);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        if (this.myCurrentEditor != null) {
            Disposer.dispose((Disposable)this.myCurrentEditor);
            this.myCurrentEditor = null;
        }
        Logger.getInstance(ApkEditor.class).info("Disposing ApkEditor with ApkViewPanel: " + this.myApkViewPanel);
        this.disposeArchive();
    }

    private void disposeArchive() {
        if (this.myApkViewPanel != null) {
            this.myApkViewPanel.clearArchive();
        }
        if (this.myArchive != null) {
            try {
                this.myArchive.close();
                Files.deleteIfExists(this.myArchive.getPath());
            }
            catch (IOException e) {
                Logger.getInstance(ApkEditor.class).warn((Throwable)e);
            }
            this.myArchive = null;
        }
    }

    @NotNull
    private ApkFileEditorComponent getEditor(@Nullable ArchiveTreeNode[] nodes) {
        if (nodes == null || nodes.length == 0) {
            EmptyPanel emptyPanel = new EmptyPanel();
            if (emptyPanel == null) {
                ApkEditor.$$$reportNull$$$0(9);
            }
            return emptyPanel;
        }
        boolean allDex = true;
        for (ArchiveTreeNode path : nodes) {
            if (path.getData().getPath().getFileName().toString().endsWith("dex")) continue;
            allDex = false;
            break;
        }
        if (allDex) {
            Path[] paths = new Path[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                paths[i] = nodes[i].getData().getPath();
            }
            DexFileViewer dexFileViewer = new DexFileViewer(this.myProject, paths, this.myBaseFile.getParent());
            if (dexFileViewer == null) {
                ApkEditor.$$$reportNull$$$0(10);
            }
            return dexFileViewer;
        }
        ArchiveTreeNode n = nodes[0];
        Path p = n.getData().getPath();
        Path fileName = p.getFileName();
        if ("resources.arsc".equals(fileName.toString())) {
            byte[] arscContent;
            try {
                arscContent = Files.readAllBytes(p);
            }
            catch (IOException e) {
                EmptyPanel emptyPanel = new EmptyPanel();
                if (emptyPanel == null) {
                    ApkEditor.$$$reportNull$$$0(11);
                }
                return emptyPanel;
            }
            ArscViewer arscViewer = new ArscViewer(arscContent);
            if (arscViewer == null) {
                ApkEditor.$$$reportNull$$$0(12);
            }
            return arscViewer;
        }
        if (p.toString().endsWith("dex")) {
            DexFileViewer dexFileViewer = new DexFileViewer(this.myProject, new Path[]{p}, this.myBaseFile.getParent());
            if (dexFileViewer == null) {
                ApkEditor.$$$reportNull$$$0(13);
            }
            return dexFileViewer;
        }
        VirtualFile file = ApkEditor.createVirtualFile(n.getData().getArchive(), p);
        Optional<FileEditorProvider> providers = this.getFileEditorProviders(file);
        if (!providers.isPresent()) {
            EmptyPanel emptyPanel = new EmptyPanel();
            if (emptyPanel == null) {
                ApkEditor.$$$reportNull$$$0(14);
            }
            return emptyPanel;
        }
        if (file != null) {
            final FileEditor editor = providers.get().createEditor(this.myProject, file);
            ApkFileEditorComponent apkFileEditorComponent = new ApkFileEditorComponent(){

                @Override
                @NotNull
                public JComponent getComponent() {
                    JComponent jComponent = editor.getComponent();
                    if (jComponent == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return jComponent;
                }

                public void dispose() {
                    Disposer.dispose((Disposable)editor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkEditor$2", "getComponent"));
                }
            };
            if (apkFileEditorComponent == null) {
                ApkEditor.$$$reportNull$$$0(15);
            }
            return apkFileEditorComponent;
        }
        EmptyPanel emptyPanel = new EmptyPanel();
        if (emptyPanel == null) {
            ApkEditor.$$$reportNull$$$0(16);
        }
        return emptyPanel;
    }

    @Nullable
    private static VirtualFile createVirtualFile(@NotNull Archive archive, @NotNull Path p) {
        Path name;
        if (archive == null) {
            ApkEditor.$$$reportNull$$$0(17);
        }
        if (p == null) {
            ApkEditor.$$$reportNull$$$0(18);
        }
        if ((name = p.getFileName()) == null) {
            return null;
        }
        try {
            byte[] content = Files.readAllBytes(p);
            if (archive.isBinaryXml(p, content)) {
                content = BinaryXmlParser.decodeXml((String)name.toString(), (byte[])content);
                return ApkVirtualFile.create(p, content);
            }
            VirtualFile file = JarFileSystem.getInstance().findLocalVirtualFileByPath(archive.getPath().toString());
            if (file != null) {
                return file.findFileByRelativePath(p.toString());
            }
            return ApkVirtualFile.create(p, content);
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    private Optional<FileEditorProvider> getFileEditorProviders(@Nullable VirtualFile file) {
        if (file == null || file.isDirectory()) {
            Optional<FileEditorProvider> optional = Optional.empty();
            if (optional == null) {
                ApkEditor.$$$reportNull$$$0(19);
            }
            return optional;
        }
        FileEditorProvider[] providers = FileEditorProviderManager.getInstance().getProviders(this.myProject, file);
        Optional<FileEditorProvider> optional = Arrays.stream(providers).filter(fileEditorProvider -> !fileEditorProvider.getClass().getName().equals("com.android.tools.idea.editors.NinePatchEditorProvider")).findFirst();
        if (optional == null) {
            ApkEditor.$$$reportNull$$$0(20);
        }
        return optional;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkVirtualFile";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/viewer/ApkEditor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archive";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/viewer/ApkEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileEditorProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshApk";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createVirtualFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

