/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.apk.analyzer.AndroidApplicationInfo;
import com.android.tools.apk.analyzer.ArchiveEntry;
import com.android.tools.apk.analyzer.ArchiveNode;
import com.android.tools.apk.analyzer.ArchiveTreeStructure;
import com.android.tools.apk.analyzer.Archives;
import com.android.tools.apk.analyzer.internal.AndroidArtifact;
import com.android.tools.apk.analyzer.internal.ArchiveTreeNode;
import com.android.tools.apk.analyzer.internal.ZipArtifact;
import com.android.tools.idea.apk.viewer.ApkParser;
import com.android.tools.idea.apk.viewer.PercentRenderer;
import com.android.tools.idea.concurrent.EdtExecutor;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ApkAnalyzerStats;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.AsyncProcessIcon;
import icons.AndroidIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ApkViewPanel
implements TreeSelectionListener {
    private JPanel myContainer;
    private JComponent myColumnTreePane;
    private SimpleColoredComponent myNameComponent;
    private SimpleColoredComponent mySizeComponent;
    private AnimatedIcon myNameAsyncIcon;
    private AnimatedIcon mySizeAsyncIcon;
    private JButton myCompareWithButton;
    private Tree myTree;
    private Project myProject;
    private DefaultTreeModel myTreeModel;
    private Listener myListener;
    @NotNull
    private final ApkParser myApkParser;
    private boolean myArchiveDisposed;

    public ApkViewPanel(@NotNull Project project, @NotNull ApkParser apkParser) {
        if (project == null) {
            ApkViewPanel.$$$reportNull$$$0(0);
        }
        if (apkParser == null) {
            ApkViewPanel.$$$reportNull$$$0(1);
        }
        this.myArchiveDisposed = false;
        this.myApkParser = apkParser;
        this.myProject = project;
        this.$$$setupUI$$$();
        Futures.addCallback(apkParser.constructTreeStructure(), (FutureCallback)new FutureCallBackAdapter<ArchiveNode>(){

            @Override
            public void onSuccess(ArchiveNode result) {
                if (ApkViewPanel.this.myArchiveDisposed) {
                    return;
                }
                ApkViewPanel.this.setRootNode(result);
            }
        }, (Executor)EdtExecutor.INSTANCE);
        Futures.addCallback(apkParser.updateTreeWithDownloadSizes(), (FutureCallback)new FutureCallBackAdapter<ArchiveNode>(){

            @Override
            public void onSuccess(ArchiveNode result) {
                if (ApkViewPanel.this.myArchiveDisposed) {
                    return;
                }
                ArchiveTreeStructure.sort((ArchiveNode)result, (o1, o2) -> Longs.compare((long)o2.getData().getDownloadFileSize(), (long)o1.getData().getDownloadFileSize()));
                ApkViewPanel.this.refreshTree();
            }
        }, (Executor)EdtExecutor.INSTANCE);
        this.myContainer.setBorder(IdeBorderFactory.createBorder((int)8));
        this.myCompareWithButton.addActionListener(e -> {
            if (this.myListener != null) {
                this.myListener.selectApkAndCompare();
            }
        });
        this.myNameAsyncIcon.setVisible(true);
        this.myNameComponent.append("Parsing Manifest");
        Path pathToAapt = ProjectSystemUtil.getProjectSystem(this.myProject).getPathToAapt();
        ListenableFuture applicationInfo = Futures.transformAsync(apkParser.constructTreeStructure(), input -> {
            if (apkParser == null) {
                ApkViewPanel.$$$reportNull$$$0(6);
            }
            assert (input != null);
            return apkParser.getApplicationInfo(pathToAapt, Archives.getFirstManifestArchive((ArchiveNode)input));
        }, (Executor)PooledThreadExecutor.INSTANCE);
        Futures.addCallback((ListenableFuture)applicationInfo, (FutureCallback)new FutureCallBackAdapter<AndroidApplicationInfo>(){

            @Override
            public void onSuccess(AndroidApplicationInfo result) {
                if (ApkViewPanel.this.myArchiveDisposed) {
                    return;
                }
                ApkViewPanel.this.setAppInfo(result);
            }
        }, (Executor)EdtExecutor.INSTANCE);
        this.mySizeAsyncIcon.setVisible(true);
        this.mySizeComponent.append("Estimating download size..");
        ListenableFuture<Long> uncompressedApkSize = apkParser.getUncompressedApkSize();
        ListenableFuture<Long> compressedFullApkSize = apkParser.getCompressedFullApkSize();
        Futures.addCallback((ListenableFuture)Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{uncompressedApkSize, compressedFullApkSize}), (FutureCallback)new FutureCallBackAdapter<List<Long>>(){

            @Override
            public void onSuccess(List<Long> result) {
                if (ApkViewPanel.this.myArchiveDisposed) {
                    return;
                }
                if (result != null) {
                    long uncompressed = result.get(0);
                    Long compressed = result.get(1);
                    ApkViewPanel.this.setApkSizes(uncompressed, compressed == null ? 0L : compressed);
                }
            }
        }, (Executor)EdtExecutor.INSTANCE);
        Futures.addCallback((ListenableFuture)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{uncompressedApkSize, compressedFullApkSize, applicationInfo}), (FutureCallback)new FutureCallBackAdapter<List<Object>>(){

            @Override
            public void onSuccess(@Nullable List<Object> result) {
                if (result == null) {
                    return;
                }
                int size = result.size();
                long uncompressed = size > 0 && result.get(0) instanceof Long ? (Long)result.get(0) : -1L;
                long compressed = size > 1 && result.get(1) instanceof Long ? (Long)result.get(1) : -1L;
                String applicationId = size > 2 && result.get(2) instanceof AndroidApplicationInfo ? ((AndroidApplicationInfo)result.get((int)2)).packageId : "unknown";
                UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.APK_ANALYZER_STATS).setProjectId(AnonymizerUtil.anonymizeUtf8((String)applicationId)).setApkAnalyzerStats(ApkAnalyzerStats.newBuilder().setCompressedSize(compressed).setUncompressedSize(uncompressed).build()));
            }
        });
    }

    private void createUIComponents() {
        this.myNameAsyncIcon = new AsyncProcessIcon("aapt xmltree manifest");
        this.mySizeAsyncIcon = new AsyncProcessIcon("estimating apk size");
        this.myTreeModel = new DefaultTreeModel((TreeNode)new LoadingNode());
        this.myTree = new Tree((TreeModel)this.myTreeModel);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(true);
        this.myTree.setPaintBusy(true);
        TreeSpeedSearch treeSpeedSearch = new TreeSpeedSearch(this.myTree, path -> {
            Object lastPathComponent = path.getLastPathComponent();
            if (!(lastPathComponent instanceof ArchiveTreeNode)) {
                return null;
            }
            return ((ArchiveTreeNode)lastPathComponent).getData().getPath().toString();
        }, true);
        PercentRenderer.PercentProvider percentProvider = (jTree, value, row) -> {
            if (!(value instanceof ArchiveTreeNode)) {
                return 0.0;
            }
            ArchiveTreeNode entry = (ArchiveTreeNode)value;
            ArchiveTreeNode rootEntry = (ArchiveTreeNode)jTree.getModel().getRoot();
            if (entry.getData().getDownloadFileSize() < 0L) {
                return 0.0;
            }
            return (double)entry.getData().getDownloadFileSize() / (double)rootEntry.getData().getDownloadFileSize();
        };
        ColumnTreeBuilder builder = new ColumnTreeBuilder((JTree)this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("File").setPreferredWidth(600).setHeaderAlignment(10).setRenderer((ColoredTreeCellRenderer)new NameRenderer(treeSpeedSearch))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Raw File Size").setPreferredWidth(150).setHeaderAlignment(11).setRenderer((ColoredTreeCellRenderer)new SizeRenderer(false))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Download Size").setPreferredWidth(150).setHeaderAlignment(11).setRenderer((ColoredTreeCellRenderer)new SizeRenderer(true))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("% of Total Download size").setPreferredWidth(150).setHeaderAlignment(10).setRenderer((ColoredTreeCellRenderer)new PercentRenderer(percentProvider)));
        this.myColumnTreePane = builder.build();
        this.myTree.addTreeSelectionListener((TreeSelectionListener)this);
    }

    public void setListener(@NotNull Listener listener) {
        if (listener == null) {
            ApkViewPanel.$$$reportNull$$$0(2);
        }
        this.myListener = listener;
    }

    public void clearArchive() {
        this.myArchiveDisposed = true;
        this.myApkParser.cancelAll();
        this.setRootNode(null);
        Logger.getInstance(ApkViewPanel.class).info("Cleared Archive on ApkViewPanel: " + this);
    }

    private void setRootNode(@Nullable ArchiveNode root) {
        this.myTreeModel = new DefaultTreeModel((TreeNode)root);
        if (root != null) {
            this.myTree.setPaintBusy(root.getData().getDownloadFileSize() < 0L);
        }
        this.myTree.setRootVisible(false);
        this.myTree.setModel((TreeModel)this.myTreeModel);
    }

    private void refreshTree() {
        this.myTree.setPaintBusy(false);
        this.myTree.removeTreeSelectionListener((TreeSelectionListener)this);
        TreePath[] selected = this.myTree.getSelectionPaths();
        this.myTreeModel.reload();
        this.myTree.setSelectionPaths(selected);
        this.myTree.addTreeSelectionListener((TreeSelectionListener)this);
    }

    private void setApkSizes(long uncompressed, long compressedFullApk) {
        this.mySizeComponent.clear();
        if (this.mySizeAsyncIcon != null) {
            this.mySizeAsyncIcon.setVisible(false);
            Disposer.dispose((Disposable)this.mySizeAsyncIcon);
            this.mySizeAsyncIcon = null;
        }
        this.mySizeComponent.setIcon(AllIcons.General.BalloonInformation);
        if (this.myApkParser.getArchive() instanceof AndroidArtifact) {
            this.mySizeComponent.append("APK size: ");
            this.mySizeComponent.append(ApkViewPanel.getHumanizedSize(uncompressed), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.mySizeComponent.append(", Download Size: ");
            this.mySizeComponent.setToolTipText("1. The <b>APK size</b> reflects the actual size of the file, and is the minimum amount of space it will consume on the disk after installation.\n2. The <b>download size</b> is the estimated size of the file for new installations (Google Play serves a highly compressed version of the file).\nFor application updates, Google Play serves patches that are typically much smaller.\nThe installation size may be higher than the APK size depending on various other factors.");
        } else if (this.myApkParser.getArchive() instanceof ZipArtifact) {
            this.mySizeComponent.append("Zip file size: ");
            this.mySizeComponent.setToolTipText("The <b>zip file size</b> reflects the actual size of the zip file on disk.\n");
        } else {
            this.mySizeComponent.append("Raw File Size: ");
        }
        this.mySizeComponent.append(ApkViewPanel.getHumanizedSize(compressedFullApk), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
    }

    private void setAppInfo(@NotNull AndroidApplicationInfo appInfo) {
        if (appInfo == null) {
            ApkViewPanel.$$$reportNull$$$0(3);
        }
        this.myNameComponent.clear();
        if (this.myNameAsyncIcon != null) {
            this.myNameAsyncIcon.setVisible(false);
            Disposer.dispose((Disposable)this.myNameAsyncIcon);
            this.myNameAsyncIcon = null;
        }
        this.myNameComponent.append(appInfo.packageId, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        this.myNameComponent.append(" (version ", SimpleTextAttributes.GRAY_ATTRIBUTES);
        this.myNameComponent.append(appInfo.versionName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.myNameComponent.append(")", SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    @NotNull
    public JComponent getContainer() {
        JPanel jPanel = this.myContainer;
        if (jPanel == null) {
            ApkViewPanel.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        Tree tree = this.myTree;
        if (tree == null) {
            ApkViewPanel.$$$reportNull$$$0(5);
        }
        return tree;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.myListener != null) {
            ArchiveTreeNode[] components;
            TreePath[] paths = ((Tree)e.getSource()).getSelectionPaths();
            if (paths == null) {
                components = null;
            } else {
                components = new ArchiveTreeNode[paths.length];
                for (int i = 0; i < paths.length; ++i) {
                    if (!(paths[i].getLastPathComponent() instanceof ArchiveTreeNode)) {
                        this.myListener.selectionChanged(null);
                        return;
                    }
                    components[i] = (ArchiveTreeNode)paths[i].getLastPathComponent();
                }
            }
            this.myListener.selectionChanged(components);
        }
    }

    public static String getHumanizedSize(long sizeInBytes) {
        long kilo = 1024L;
        long mega = kilo * kilo;
        DecimalFormat formatter = new DecimalFormat("#.#");
        int sign = sizeInBytes < 0L ? -1 : 1;
        if ((sizeInBytes = Math.abs(sizeInBytes)) > mega) {
            return formatter.format((double)((long)sign * sizeInBytes) / (double)mega) + " MB";
        }
        if (sizeInBytes > kilo) {
            return formatter.format((double)((long)sign * sizeInBytes) / (double)kilo) + " KB";
        }
        return (long)sign * sizeInBytes + " B";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkParser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/viewer/ApkViewPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/viewer/ApkViewPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setAppInfo";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        SimpleColoredComponent simpleColoredComponent;
        SimpleColoredComponent simpleColoredComponent2;
        JPanel jPanel;
        this.createUIComponents();
        this.myContainer = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JComponent jComponent = this.myColumnTreePane;
        jPanel.add((Component)jComponent, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 5, 0));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        this.myNameComponent = simpleColoredComponent2 = new SimpleColoredComponent();
        Component component2 = jPanel2.add((Component)simpleColoredComponent2);
        AnimatedIcon animatedIcon = this.myNameAsyncIcon;
        Component component3 = jPanel2.add((Component)animatedIcon);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 5, 0));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        this.mySizeComponent = simpleColoredComponent = new SimpleColoredComponent();
        Component component4 = jPanel3.add((Component)simpleColoredComponent);
        AnimatedIcon animatedIcon2 = this.mySizeAsyncIcon;
        Component component5 = jPanel3.add((Component)animatedIcon2);
        this.myCompareWithButton = jButton = new JButton();
        jButton.setText("Compare with previous APK...");
        jPanel.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 4, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContainer;
    }

    private static class SizeRenderer
    extends ColoredTreeCellRenderer {
        private final boolean myUseDownloadSize;

        SizeRenderer(boolean useDownloadSize) {
            this.myUseDownloadSize = useDownloadSize;
            this.setTextAlign(4);
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            long size;
            if (tree == null) {
                SizeRenderer.$$$reportNull$$$0(0);
            }
            if (!(value instanceof ArchiveTreeNode)) {
                return;
            }
            ArchiveEntry data = ((ArchiveTreeNode)value).getData();
            long l = size = this.myUseDownloadSize ? data.getDownloadFileSize() : data.getRawFileSize();
            if (size > 0L) {
                this.append(ApkViewPanel.getHumanizedSize(size));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/apk/viewer/ApkViewPanel$SizeRenderer", "customizeCellRenderer"));
        }
    }

    public static class NameRenderer
    extends ColoredTreeCellRenderer {
        private final TreeSpeedSearch mySpeedSearch;

        public NameRenderer(@NotNull TreeSpeedSearch speedSearch) {
            if (speedSearch == null) {
                NameRenderer.$$$reportNull$$$0(0);
            }
            this.mySpeedSearch = speedSearch;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                NameRenderer.$$$reportNull$$$0(1);
            }
            if (!(value instanceof ArchiveNode)) {
                this.append(value.toString());
                return;
            }
            ArchiveEntry entry = ((ArchiveNode)value).getData();
            Path path = entry.getPath();
            this.setIcon(NameRenderer.getIconFor(path));
            Path base = path.getFileName();
            String name = base == null ? "" : base.toString();
            name = StringUtil.trimEnd((String)name, (String)"/");
            SimpleTextAttributes attr2 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            SearchUtil.appendFragments((String)this.mySpeedSearch.getEnteredPrefix(), (String)name, (int)attr2.getStyle(), (Color)attr2.getFgColor(), (Color)attr2.getBgColor(), (SimpleColoredComponent)this);
        }

        @NotNull
        private static Icon getIconFor(@NotNull Path path) {
            Path base;
            String fileName;
            if (path == null) {
                NameRenderer.$$$reportNull$$$0(2);
            }
            String string = fileName = (base = path.getFileName()) == null ? "" : base.toString();
            if (!Files.isDirectory(path, new LinkOption[0])) {
                if (fileName == "AndroidManifest.xml") {
                    Icon icon = AndroidIcons.ManifestFile;
                    if (icon == null) {
                        NameRenderer.$$$reportNull$$$0(3);
                    }
                    return icon;
                }
                if (fileName.endsWith(".dex")) {
                    Icon icon = AllIcons.FileTypes.JavaClass;
                    if (icon == null) {
                        NameRenderer.$$$reportNull$$$0(4);
                    }
                    return icon;
                }
                FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(fileName);
                Icon ftIcon = fileType.getIcon();
                Icon icon = ftIcon == null ? AllIcons.FileTypes.Any_type : ftIcon;
                if (icon == null) {
                    NameRenderer.$$$reportNull$$$0(5);
                }
                return icon;
            }
            if ((fileName = StringUtil.trimEnd((String)fileName, (String)"/")).equals("res")) {
                Icon icon = AllIcons.Modules.ResourcesRoot;
                if (icon == null) {
                    NameRenderer.$$$reportNull$$$0(6);
                }
                return icon;
            }
            Icon icon = AllIcons.Modules.SourceFolder;
            if (icon == null) {
                NameRenderer.$$$reportNull$$$0(7);
            }
            return icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "speedSearch";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/apk/viewer/ApkViewPanel$NameRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/apk/viewer/ApkViewPanel$NameRenderer";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIconFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeCellRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getIconFor";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class FutureCallBackAdapter<V>
    implements FutureCallback<V> {
        public void onSuccess(V result) {
        }

        public void onFailure(@NotNull Throwable t) {
            if (t == null) {
                FutureCallBackAdapter.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/apk/viewer/ApkViewPanel$FutureCallBackAdapter", "onFailure"));
        }
    }

    public static interface Listener {
        public void selectionChanged(@Nullable ArchiveTreeNode[] var1);

        public void selectApkAndCompare();
    }
}

