/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant.view;

import com.android.tools.idea.assistant.datamodel.FeatureData;
import com.android.tools.idea.assistant.datamodel.StepData;
import com.android.tools.idea.assistant.datamodel.TutorialData;
import com.android.tools.idea.assistant.view.CardViewPanel;
import com.android.tools.idea.assistant.view.NavigationButton;
import com.android.tools.idea.assistant.view.TutorialStep;
import com.android.tools.idea.assistant.view.UIUtils;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class TutorialCard
extends CardViewPanel {
    @NotNull
    private final TutorialData myTutorial;
    @NotNull
    private final FeatureData myFeature;
    @NotNull
    private final Project myProject;
    private final boolean myHideChooserAndNavigationBar;
    private final boolean myIsStepByStep;
    @NotNull
    private final JBScrollPane myContentsScroller;
    @NotNull
    private final String myTutorialsTitle;
    private int myStepIndex;

    TutorialCard(@NotNull ActionListener listener, @NotNull TutorialData tutorial, @NotNull FeatureData feature, @NotNull String tutorialsTitle, @NotNull Project project, boolean hideChooserAndNavigationalBar, boolean isStepByStep) {
        if (listener == null) {
            TutorialCard.$$$reportNull$$$0(0);
        }
        if (tutorial == null) {
            TutorialCard.$$$reportNull$$$0(1);
        }
        if (feature == null) {
            TutorialCard.$$$reportNull$$$0(2);
        }
        if (tutorialsTitle == null) {
            TutorialCard.$$$reportNull$$$0(3);
        }
        if (project == null) {
            TutorialCard.$$$reportNull$$$0(4);
        }
        super(listener);
        this.myContentsScroller = new JBScrollPane();
        this.myTutorialsTitle = tutorialsTitle;
        this.myTutorial = tutorial;
        this.myFeature = feature;
        this.myProject = project;
        this.myHideChooserAndNavigationBar = hideChooserAndNavigationalBar;
        this.myIsStepByStep = isStepByStep;
        this.myStepIndex = 0;
        if (!this.myHideChooserAndNavigationBar) {
            this.add((Component)new HeaderNav(this.myFeature.getName(), this.myListener), "North");
        }
        this.add((Component)this.myContentsScroller, "Center");
        if (this.myIsStepByStep) {
            this.add((Component)new StepByStepFooter(), "South");
        }
        this.redraw();
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        JScrollBar verticalScrollBar = this.myContentsScroller.getVerticalScrollBar();
        JScrollBar horizontalScrollBar = this.myContentsScroller.getHorizontalScrollBar();
        verticalScrollBar.setValue(verticalScrollBar.getMinimum());
        horizontalScrollBar.setValue(horizontalScrollBar.getMinimum());
    }

    private void redraw() {
        JPanel contents = new JPanel();
        contents.setLayout(new GridBagLayout());
        contents.setOpaque(false);
        contents.setAlignmentX(0.0f);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = JBUI.insetsBottom((int)5);
        JBLabel title = new JBLabel(this.myTutorial.getLabel());
        title.setFont(title.getFont().deriveFont(1, 16.0f));
        title.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        if (this.myTutorial.getIcon() != null) {
            title.setIcon(this.myTutorial.getIcon());
        }
        contents.add((Component)title, c);
        ++c.gridy;
        TutorialDescription description = new TutorialDescription();
        StringBuffer sb = new StringBuffer();
        sb.append("<p class=\"description\">").append(this.myTutorial.getDescription());
        if (this.myTutorial.getRemoteLink() != null && this.myTutorial.getRemoteLinkLabel() != null) {
            sb.append("<br><br><a href=\"").append(this.myTutorial.getRemoteLink()).append("\" target=\"_blank\">").append(this.myTutorial.getRemoteLinkLabel()).append("</a>");
        }
        sb.append("</p>");
        UIUtils.setHtml(description, sb.toString(), ".description { margin: 10px;}");
        contents.add((Component)description, c);
        ++c.gridy;
        c.insets = JBUI.insets((int)0, (int)5, (int)5, (int)5);
        if (this.myIsStepByStep) {
            contents.add((Component)new TutorialStep(this.myTutorial.getSteps().get(this.myStepIndex), this.myStepIndex, this.myListener, this.myProject), c);
            ++c.gridy;
        } else {
            int numericLabel = 0;
            for (StepData stepData : this.myTutorial.getSteps()) {
                TutorialStep stepDisplay = new TutorialStep(stepData, numericLabel, this.myListener, this.myProject);
                contents.add((Component)stepDisplay, c);
                ++c.gridy;
                ++numericLabel;
            }
        }
        GridBagConstraints glueConstraints = UIUtils.getVerticalGlueConstraints(c.gridy);
        contents.add(Box.createVerticalGlue(), glueConstraints);
        ++c.gridy;
        if (!this.myHideChooserAndNavigationBar) {
            c.insets = JBUI.emptyInsets();
            contents.add((Component)new FooterNav(), c);
        }
        this.myContentsScroller.getVerticalScrollBar().setUnitIncrement(16);
        this.myContentsScroller.setViewportView((Component)contents);
        this.myContentsScroller.setBorder((Border)BorderFactory.createMatteBorder(1, 0, 0, 0, UIUtils.getSeparatorColor()));
        this.myContentsScroller.setViewportBorder(BorderFactory.createEmptyBorder());
        this.myContentsScroller.setOpaque(false);
        this.myContentsScroller.getViewport().setOpaque(false);
        this.myContentsScroller.setHorizontalScrollBarPolicy(31);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "listener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "tutorial";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "feature";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "tutorialsTitle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/assistant/view/TutorialCard";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class BackButton
    extends NavigationButton {
        BackButton(String label) {
            super(label, "studio_tutorial_chooser", TutorialCard.this.myListener);
            this.setIcon(AllIcons.Actions.Back);
            this.setHorizontalTextPosition(4);
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setBorder(null);
            this.setOpaque(false);
            this.setCursor(Cursor.getPredefinedCursor(12));
            Font font = new JBLabel().getFont();
            this.setFont(new Font(font.getFontName(), 0, font.getSize()));
        }
    }

    private static class StepButton
    extends NavigationButton {
        public Direction myDirection;

        StepButton(String label, Direction direction, ActionListener listener) {
            super(label, "studio_tutorial_chooser", listener);
            this.myDirection = direction;
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setBorder(null);
            this.setOpaque(false);
            if (Direction.NEXT == direction) {
                this.setIcon(AllIcons.Actions.Forward);
                this.setHorizontalTextPosition(2);
            } else {
                this.setIcon(AllIcons.Actions.Back);
                this.setHorizontalTextPosition(4);
            }
            this.setCursor(Cursor.getPredefinedCursor(12));
            Font font = new JBLabel().getFont();
            this.setFont(font.deriveFont(0, font.getSize()));
        }

        public static enum Direction {
            NEXT,
            PREV;

        }
    }

    private class StepByStepFooter
    extends JPanel {
        @NotNull
        private final StepButton myPrevButton;
        @NotNull
        private final StepButton myNextButton;

        StepByStepFooter() {
            super(new BorderLayout());
            this.myPrevButton = new StepButton("Previous", StepButton.Direction.PREV, e -> this.handleStepButtonClick(e));
            this.add((Component)this.myPrevButton, "Before");
            this.myNextButton = new StepButton("Next", StepButton.Direction.NEXT, e -> this.handleStepButtonClick(e));
            this.add((Component)this.myNextButton, "After");
            this.updateVisibility();
            this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIUtils.getSeparatorColor()));
        }

        private void handleStepButtonClick(@NotNull ActionEvent event) {
            if (event == null) {
                StepByStepFooter.$$$reportNull$$$0(0);
            }
            Object source = event.getSource();
            StepButton stepButton = (StepButton)source;
            if (stepButton.myDirection == StepButton.Direction.NEXT) {
                if (TutorialCard.this.myStepIndex < TutorialCard.this.myTutorial.getSteps().size() - 1) {
                    TutorialCard.this.myStepIndex++;
                } else {
                    this.closeAssistant();
                }
            } else if (TutorialCard.this.myStepIndex > 0) {
                TutorialCard.this.myStepIndex--;
            }
            this.updateVisibility();
            TutorialCard.this.redraw();
            this.repaint();
        }

        private void closeAssistant() {
            ToolWindowManager.getInstance((Project)TutorialCard.this.myProject).getToolWindow("Assistant").hide(() -> {});
        }

        private void updateVisibility() {
            this.myPrevButton.setVisible(TutorialCard.this.myStepIndex > 0);
            this.myNextButton.setText(TutorialCard.this.myStepIndex < TutorialCard.this.myTutorial.getSteps().size() - 1 ? "Next" : "Finish");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/assistant/view/TutorialCard$StepByStepFooter", "handleStepButtonClick"));
        }
    }

    private class FooterNav
    extends JPanel {
        private final String BACK_LABEL;

        FooterNav() {
            super(new FlowLayout(3));
            this.BACK_LABEL = "Back to " + TutorialCard.this.myTutorialsTitle;
            this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIUtils.getSeparatorColor()));
            this.setOpaque(false);
            this.add(new BackButton(this.BACK_LABEL));
        }
    }

    private class HeaderNav
    extends JPanel {
        public final String ROOT_TITLE;

        HeaderNav(String location, ActionListener listener) {
            super((LayoutManager)new HorizontalLayout(5, 0));
            this.ROOT_TITLE = "<html><b>" + TutorialCard.this.myTutorialsTitle + "</b> &nbsp;&rsaquo;</html>";
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add(new BackButton(this.ROOT_TITLE));
            JBLabel label = new JBLabel(location);
            label.setForeground(UIUtils.getSecondaryColor());
            this.add((Component)label);
        }
    }

    private static class TutorialDescription
    extends JTextPane {
        TutorialDescription() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIUtils.getSeparatorColor()));
        }
    }
}

