/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.repository.Revision;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.google.common.base.Objects;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SystemImageDescription {
    private ISystemImage mySystemImage;
    private RemotePackage myRemotePackage;

    public SystemImageDescription(@NotNull ISystemImage systemImage) {
        if (systemImage == null) {
            SystemImageDescription.$$$reportNull$$$0(0);
        }
        this.mySystemImage = systemImage;
    }

    public SystemImageDescription(@NotNull RemotePackage remotePackage) {
        if (remotePackage == null) {
            SystemImageDescription.$$$reportNull$$$0(1);
        }
        this.myRemotePackage = remotePackage;
        assert (SystemImageDescription.hasSystemImage((RepoPackage)remotePackage));
        this.mySystemImage = new RemoteSystemImage(remotePackage);
    }

    static boolean hasSystemImage(RepoPackage p) {
        TypeDetails details = p.getTypeDetails();
        if (!(details instanceof DetailsTypes.ApiDetailsType)) {
            return false;
        }
        int apiLevel = ((DetailsTypes.ApiDetailsType)details).getApiLevel();
        if (details instanceof DetailsTypes.SysImgDetailsType) {
            return true;
        }
        if (details instanceof DetailsTypes.PlatformDetailsType && apiLevel <= 13) {
            return true;
        }
        return details instanceof DetailsTypes.AddonDetailsType && ((DetailsTypes.AddonDetailsType)details).getVendor().getId().equals("google") && AvdWizardUtils.TAGS_WITH_GOOGLE_API.contains(((DetailsTypes.AddonDetailsType)details).getTag()) && apiLevel <= 19;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mySystemImage, this.myRemotePackage});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SystemImageDescription)) {
            return false;
        }
        SystemImageDescription other = (SystemImageDescription)obj;
        return Objects.equal((Object)this.mySystemImage, (Object)other.mySystemImage) && Objects.equal((Object)this.myRemotePackage, (Object)other.myRemotePackage);
    }

    @Nullable
    public AndroidVersion getVersion() {
        return this.mySystemImage.getAndroidVersion();
    }

    @Nullable
    public RepoPackage getRemotePackage() {
        return this.myRemotePackage;
    }

    public boolean isRemote() {
        return this.myRemotePackage != null;
    }

    public boolean obsolete() {
        return this.mySystemImage.obsolete();
    }

    @NotNull
    public String getAbiType() {
        String string = this.mySystemImage.getAbiType();
        if (string == null) {
            SystemImageDescription.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public IdDisplay getTag() {
        IdDisplay idDisplay = this.mySystemImage.getTag();
        if (idDisplay == null) {
            SystemImageDescription.$$$reportNull$$$0(3);
        }
        return idDisplay;
    }

    public String getName() {
        String versionString = SdkVersionInfo.getVersionString((int)this.getVersion().getFeatureLevel());
        return String.format("Android %s", versionString == null ? "API " + this.getVersion().getApiString() : versionString);
    }

    public String getVendor() {
        if (this.mySystemImage.getAddonVendor() != null) {
            return this.mySystemImage.getAddonVendor().getDisplay();
        }
        return "Android Open Source Project";
    }

    public String getVersionName() {
        return SdkVersionInfo.getVersionString((int)this.mySystemImage.getAndroidVersion().getApiLevel());
    }

    @Nullable
    Revision getRevision() {
        return this.mySystemImage.getRevision();
    }

    public File[] getSkins() {
        return this.mySystemImage.getSkins();
    }

    public ISystemImage getSystemImage() {
        return this.mySystemImage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemImage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePackage";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/avdmanager/SystemImageDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/avdmanager/SystemImageDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbiType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoteSystemImage
    implements ISystemImage {
        private final RemotePackage myRemotePackage;
        private final IdDisplay myTag;
        private final IdDisplay myVendor;
        private final String myAbi;
        private final AndroidVersion myAndroidVersion;

        RemoteSystemImage(RemotePackage p) {
            this.myRemotePackage = p;
            TypeDetails details = this.myRemotePackage.getTypeDetails();
            assert (details instanceof DetailsTypes.ApiDetailsType);
            this.myAndroidVersion = ((DetailsTypes.ApiDetailsType)details).getAndroidVersion();
            IdDisplay tag = null;
            IdDisplay vendor = null;
            String abi = "armeabi";
            if (details instanceof DetailsTypes.AddonDetailsType) {
                tag = ((DetailsTypes.AddonDetailsType)details).getTag();
                vendor = ((DetailsTypes.AddonDetailsType)details).getVendor();
                if (SystemImage.GOOGLE_APIS_X86_TAG.equals((Object)tag)) {
                    abi = "x86";
                }
            }
            if (details instanceof DetailsTypes.SysImgDetailsType) {
                tag = ((DetailsTypes.SysImgDetailsType)details).getTag();
                vendor = ((DetailsTypes.SysImgDetailsType)details).getVendor();
                abi = ((DetailsTypes.SysImgDetailsType)details).getAbi();
            }
            this.myTag = tag != null ? tag : SystemImage.DEFAULT_TAG;
            this.myVendor = vendor;
            this.myAbi = abi;
        }

        public File getLocation() {
            assert (false) : "Can't get location for remote image";
            return new File("");
        }

        public IdDisplay getTag() {
            return this.myTag;
        }

        public IdDisplay getAddonVendor() {
            return this.myVendor;
        }

        public String getAbiType() {
            return this.myAbi;
        }

        public File[] getSkins() {
            return new File[0];
        }

        public Revision getRevision() {
            return this.myRemotePackage.getVersion();
        }

        public AndroidVersion getAndroidVersion() {
            return this.myAndroidVersion;
        }

        public boolean hasPlayStore() {
            if (SystemImage.PLAY_STORE_TAG.equals((Object)this.myTag)) {
                return true;
            }
            return SystemImage.WEAR_TAG.equals((Object)this.getTag()) && this.myAndroidVersion.getApiLevel() >= 25 && !this.myRemotePackage.getPath().contains("android-wear-cn");
        }

        public boolean obsolete() {
            return this.myRemotePackage.obsolete();
        }

        public int compareTo(ISystemImage o) {
            if (o instanceof RemoteSystemImage) {
                return this.myRemotePackage.compareTo((Object)((RemoteSystemImage)o).myRemotePackage);
            }
            return 1;
        }

        public int hashCode() {
            return this.myRemotePackage.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof RemoteSystemImage)) {
                return false;
            }
            RemoteSystemImage other = (RemoteSystemImage)o;
            return this.myRemotePackage.equals(other.myRemotePackage);
        }
    }
}

