/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.IdDisplay;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.HaxmAlert;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.npw.ChooseApiLevelDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemImagePreview {
    private JBLabel myReleaseName;
    private JBLabel myReleaseIcon;
    private JBLabel myApiLevel;
    private JBLabel myAndroidVersion;
    private JBLabel myAbi;
    private HyperlinkLabel myDocumentationLink;
    private JBLabel myVendor;
    private JPanel myRootPanel;
    private JPanel myMainPanel;
    private JSeparator mySeparator;
    private HaxmAlert myHaxmAlert;
    private JBLabel myRecommendedExplanation;
    private SystemImageDescription myImageDescription;
    private Disposable myDisposable;
    ApiLevelHyperlinkListener myApiLevelListener;
    private static final String NO_SYSTEM_IMAGE_SELECTED = "No System Image Selected";
    private static final String MAIN_CONTENT = "main";
    private static final String NO_IMAGE_CONTENT = "none";
    private static final String PS_RECOMMENDATION = "<html>We recommend these Google Play images because this device is compatible with Google Play.<br><br></html>";
    private static final String WEAR_RECOMMENDATION = "<html>We recommend these Android Wear images because they run the fastest.<br><br></html>";
    private static final String NON_PS_RECOMMENDATION = "<html>We recommend these images because they run the fastest and support Google APIs.<br><br></html>";

    public SystemImagePreview(@Nullable Disposable disposable) {
        this.$$$setupUI$$$();
        this.myApiLevelListener = new ApiLevelHyperlinkListener();
        this.myDisposable = disposable;
        this.myRootPanel.setLayout(new CardLayout());
        this.myReleaseName.setFont(AvdWizardUtils.TITLE_FONT);
        this.myApiLevel.setFont(AvdWizardUtils.TITLE_FONT);
        this.myAndroidVersion.setFont(AvdWizardUtils.TITLE_FONT);
        this.myVendor.setFont(AvdWizardUtils.TITLE_FONT);
        this.myDocumentationLink.setOpaque(false);
        this.myAbi.setFont(AvdWizardUtils.TITLE_FONT);
        this.myRootPanel.add((Component)this.myMainPanel, MAIN_CONTENT);
        JPanel nonePanel = new JPanel(new BorderLayout());
        JBLabel noneLabel = new JBLabel(NO_SYSTEM_IMAGE_SELECTED);
        noneLabel.setHorizontalAlignment(0);
        nonePanel.add((Component)noneLabel, "Center");
        nonePanel.setBackground((Color)JBColor.WHITE);
        this.myRootPanel.add((Component)nonePanel, NO_IMAGE_CONTENT);
        this.myMainPanel.setBackground((Color)JBColor.WHITE);
        this.mySeparator.setForeground((Color)JBColor.BLACK);
        this.myDocumentationLink.addHyperlinkListener((HyperlinkListener)((Object)this.myApiLevelListener));
        this.myDocumentationLink.setHtmlText("See the <a>API level distribution chart</a>");
    }

    public void setImage(@Nullable SystemImageDescription image) {
        this.myImageDescription = image;
        this.myHaxmAlert.setSystemImageDescription(image);
        ((CardLayout)this.myRootPanel.getLayout()).show(this.myRootPanel, NO_IMAGE_CONTENT);
        if (image != null) {
            ((CardLayout)this.myRootPanel.getLayout()).show(this.myRootPanel, MAIN_CONTENT);
            AndroidVersion version = image.getVersion();
            if (version == null) {
                return;
            }
            int apiLevel = version.getApiLevel();
            this.myApiLevelListener.setApiLevel(apiLevel);
            String codeName = SdkVersionInfo.getCodeName((int)this.myImageDescription.getVersion().getFeatureLevel());
            if (codeName != null) {
                this.myReleaseName.setText(codeName);
            } else {
                this.myReleaseName.setText(version.getCodename());
            }
            Icon icon = SystemImagePreview.getIcon(codeName);
            if (icon == null) {
                try {
                    icon = IconLoader.findIcon((String)"/icons/versions/Default.png", AndroidIcons.class);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            this.myReleaseIcon.setIcon(icon);
            this.myApiLevel.setText(image.getVersion().getApiString());
            this.myAndroidVersion.setVisible(!image.getVersion().isPreview());
            this.myAndroidVersion.setText(SdkVersionInfo.getVersionString((int)apiLevel));
            IdDisplay tag = this.myImageDescription.getTag();
            String vendorName = tag.getId().equals("android-wear") || tag.getId().equals("android-tv") ? "Android" : this.myImageDescription.getVendor();
            this.myVendor.setText("<html>" + vendorName + "</html>");
            this.myAbi.setText(this.myImageDescription.getAbiType());
        }
    }

    @Nullable
    JBLabel getReleaseIcon() {
        return this.myReleaseIcon;
    }

    public void showExplanationForRecommended(ImageRecommendation recommendationChoice) {
        switch (recommendationChoice) {
            case RECOMMENDATION_NONE: {
                this.myRecommendedExplanation.setVisible(false);
                break;
            }
            case RECOMMENDATION_X86: {
                this.myRecommendedExplanation.setText(NON_PS_RECOMMENDATION);
                this.myRecommendedExplanation.setVisible(true);
                break;
            }
            case RECOMMENDATION_GOOGLE_PLAY: {
                this.myRecommendedExplanation.setText(PS_RECOMMENDATION);
                this.myRecommendedExplanation.setVisible(true);
                break;
            }
            case RECOMMENDATION_WEAR: {
                this.myRecommendedExplanation.setText(WEAR_RECOMMENDATION);
                this.myRecommendedExplanation.setVisible(true);
            }
        }
    }

    @Nullable
    public static Icon getIcon(@Nullable String codename) {
        if (codename == null) {
            return null;
        }
        Icon icon = null;
        try {
            icon = IconLoader.findIcon((String)String.format("/icons/versions/%1$s.png", codename), AndroidIcons.class);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (icon != null) {
            return icon;
        }
        try {
            icon = IconLoader.findIcon((String)"/icons/versions/Default.png", AndroidIcons.class);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (icon != null) {
            return icon;
        }
        int size = JBUI.scale((int)128);
        BufferedImage image = UIUtil.createImage((int)size, (int)size, (int)2);
        Graphics g = ((Image)image).getGraphics();
        GraphicsUtil.setupAntialiasing((Graphics)g);
        GraphicsUtil.setupAAPainting((Graphics)g);
        Font f = UIUtil.getLabelFont();
        Font font = new Font(f.getName(), f.getStyle() | 1, JBUI.scale((int)100));
        g.setColor(JBColor.background());
        g.fillRect(0, 0, size, size);
        g.setColor(JBColor.foreground());
        g.setFont(font);
        int height = g.getFontMetrics().getHeight();
        int width = g.getFontMetrics().stringWidth("?");
        g.drawString("?", (size - width) / 2, height + (size - height) / 2);
        return new ImageIcon(image);
    }

    private void createUIComponents() {
        this.myHaxmAlert = new HaxmAlert();
        this.myHaxmAlert.setSystemImageDescription(this.myImageDescription);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        HyperlinkLabel hyperlinkLabel;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        JBLabel jBLabel6;
        JBLabel jBLabel7;
        JSeparator jSeparator;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(16, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(16, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 16, 3, 0, 3, 3, 3, null, null, null));
        this.mySeparator = jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.setOpaque(false);
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(15, 15, 5, 15), null, 0, 0, null, null));
        this.myReleaseName = jBLabel7 = new JBLabel();
        jPanel3.add((Component)jBLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(14, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel4).setEnabled(true);
        jPanel4.setOpaque(false);
        jPanel.add((Component)jPanel4, new GridConstraints(2, 0, 14, 1, 0, 3, 3, 7, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20), null, 0, 0, null, null));
        JBLabel jBLabel8 = new JBLabel();
        Font font = this.$$$getFont$$$(null, -1, 10, jBLabel8.getFont());
        if (font != null) {
            jBLabel8.setFont(font);
        }
        jBLabel8.setText("API Level");
        jPanel4.add((Component)jBLabel8, new GridConstraints(0, 1, 1, 1, 8, 0, 4, 0, null, null, null));
        this.myApiLevel = jBLabel6 = new JBLabel();
        jPanel4.add((Component)jBLabel6, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 0, new Dimension(-1, 15), new Dimension(-1, 15), null));
        JBLabel jBLabel9 = new JBLabel();
        Font font2 = this.$$$getFont$$$(null, -1, 10, jBLabel9.getFont());
        if (font2 != null) {
            jBLabel9.setFont(font2);
        }
        jBLabel9.setText("Android");
        jPanel4.add((Component)jBLabel9, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAndroidVersion = jBLabel5 = new JBLabel();
        jPanel4.add((Component)jBLabel5, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 0, new Dimension(-1, 15), new Dimension(-1, 15), null));
        JBLabel jBLabel10 = new JBLabel();
        Font font3 = this.$$$getFont$$$(null, -1, 10, jBLabel10.getFont());
        if (font3 != null) {
            jBLabel10.setFont(font3);
        }
        jBLabel10.setText("System Image");
        jPanel4.add((Component)jBLabel10, new GridConstraints(7, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAbi = jBLabel4 = new JBLabel();
        jPanel4.add((Component)jBLabel4, new GridConstraints(8, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(9, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myDocumentationLink = hyperlinkLabel = new HyperlinkLabel();
        jPanel4.add((Component)hyperlinkLabel, new GridConstraints(13, 0, 1, 2, 8, 0, 3, 3, null, null, null));
        this.myVendor = jBLabel3 = new JBLabel();
        jPanel4.add((Component)jBLabel3, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 2, null, new Dimension(150, -1), new Dimension(150, -1)));
        this.myReleaseIcon = jBLabel2 = new JBLabel();
        jBLabel2.setVerticalAlignment(1);
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 0, 9, 1, 9, 0, 0, 0, null, null, null));
        JBLabel jBLabel11 = new JBLabel();
        jBLabel11.setText("Questions on API level?");
        jPanel4.add((Component)jBLabel11, new GridConstraints(12, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        HaxmAlert haxmAlert = this.myHaxmAlert;
        jPanel4.add((Component)haxmAlert, new GridConstraints(10, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myRecommendedExplanation = jBLabel = new JBLabel();
        jPanel4.add((Component)jBLabel, new GridConstraints(11, 0, 1, 2, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }

    private class ApiLevelHyperlinkListener
    extends HyperlinkAdapter {
        private int myApiLevel = -1;

        private ApiLevelHyperlinkListener() {
        }

        protected void hyperlinkActivated(HyperlinkEvent e) {
            ChooseApiLevelDialog dialog = new ChooseApiLevelDialog(null, this.myApiLevel){

                @NotNull
                protected Action[] createActions() {
                    Action close = this.getCancelAction();
                    close.putValue("Name", "Close");
                    Action[] actionArray = new Action[]{close};
                    if (actionArray == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return actionArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/SystemImagePreview$ApiLevelHyperlinkListener$1", "createActions"));
                }
            };
            Disposer.register((Disposable)SystemImagePreview.this.myDisposable, (Disposable)dialog.getDisposable());
            dialog.show();
        }

        public void setApiLevel(int apiLevel) {
            this.myApiLevel = apiLevel;
        }
    }

    public static enum ImageRecommendation {
        RECOMMENDATION_NONE,
        RECOMMENDATION_X86,
        RECOMMENDATION_GOOGLE_PLAY,
        RECOMMENDATION_WEAR;

    }
}

