/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.rendering.AttributeSnapshot;
import com.android.tools.idea.rendering.TagSnapshot;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.uibuilder.handlers.relative.DependencyGraph;
import com.android.tools.idea.uibuilder.model.AttributesHelperKt;
import com.android.tools.idea.uibuilder.model.QualifiedName;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlComponent
implements NlAttributesHolder {
    @Nullable
    private XmlModelComponentMixin myMixin;
    private final List<NlComponent> children;
    private NlComponent myParent;
    @NotNull
    private final NlModel myModel;
    @NotNull
    private XmlTag myTag;
    @NotNull
    private SmartPsiElementPointer<XmlTag> myTagPointer;
    @NotNull
    private String myTagName;
    @Nullable
    private TagSnapshot mySnapshot;
    private final HashMap<Object, Object> myClientProperties;
    private final ListenerCollection<ChangeListener> myListeners;
    private final ChangeEvent myChangeEvent;
    private DependencyGraph myCachedDependencyGraph;
    @Nullable
    AttributesTransaction myCurrentTransaction;

    public NlComponent(@NotNull NlModel model, @NotNull XmlTag tag) {
        if (model == null) {
            NlComponent.$$$reportNull$$$0(0);
        }
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(1);
        }
        this.children = Lists.newArrayList();
        this.myClientProperties = new HashMap();
        this.myListeners = ListenerCollection.createWithDirectExecutor();
        this.myChangeEvent = new ChangeEvent(this);
        this.myModel = model;
        this.myTag = tag;
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed()) {
            this.myTagPointer = SmartPointerManager.getInstance((Project)this.myModel.getProject()).createSmartPsiElementPointer((PsiElement)tag);
            this.myTagName = tag.getName();
        } else {
            application.runReadAction(() -> {
                if (tag == null) {
                    NlComponent.$$$reportNull$$$0(44);
                }
                this.myTagPointer = SmartPointerManager.getInstance((Project)this.myModel.getProject()).createSmartPsiElementPointer((PsiElement)tag);
                this.myTagName = tag.getName();
            });
        }
    }

    public NlComponent(@NotNull NlModel model, @NotNull XmlTag tag, @NotNull SmartPsiElementPointer<XmlTag> tagPointer) {
        if (model == null) {
            NlComponent.$$$reportNull$$$0(2);
        }
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(3);
        }
        if (tagPointer == null) {
            NlComponent.$$$reportNull$$$0(4);
        }
        this.children = Lists.newArrayList();
        this.myClientProperties = new HashMap();
        this.myListeners = ListenerCollection.createWithDirectExecutor();
        this.myChangeEvent = new ChangeEvent(this);
        this.myModel = model;
        this.myTag = tag;
        this.myTagPointer = tagPointer;
        this.myTagName = tag.getName();
    }

    public void setMixin(@NotNull XmlModelComponentMixin mixin) {
        if (mixin == null) {
            NlComponent.$$$reportNull$$$0(5);
        }
        assert (this.myMixin == null);
        this.myMixin = mixin;
    }

    @Nullable
    public XmlModelComponentMixin getMixin() {
        return this.myMixin;
    }

    @NotNull
    public XmlTag getTag() {
        Application application = ApplicationManager.getApplication();
        XmlTag tag = application.isReadAccessAllowed() ? (XmlTag)this.myTagPointer.getElement() : (XmlTag)application.runReadAction(() -> this.myTagPointer.getElement());
        XmlTag xmlTag = tag != null ? tag : this.myTag;
        if (xmlTag == null) {
            NlComponent.$$$reportNull$$$0(6);
        }
        return xmlTag;
    }

    @NotNull
    public NlModel getModel() {
        NlModel nlModel = this.myModel;
        if (nlModel == null) {
            NlComponent.$$$reportNull$$$0(7);
        }
        return nlModel;
    }

    public void setTag(@NotNull XmlTag tag) {
        Application application;
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(8);
        }
        if ((application = ApplicationManager.getApplication()).isReadAccessAllowed()) {
            if (tag.isValid()) {
                this.myTagPointer = SmartPointerManager.getInstance((Project)this.myModel.getProject()).createSmartPsiElementPointer((PsiElement)tag);
            }
            this.myTagName = tag.getName();
        } else {
            application.runReadAction(() -> {
                if (tag == null) {
                    NlComponent.$$$reportNull$$$0(43);
                }
                if (tag.isValid()) {
                    this.myTagPointer = SmartPointerManager.getInstance((Project)this.myModel.getProject()).createSmartPsiElementPointer((PsiElement)tag);
                }
                this.myTagName = tag.getName();
            });
        }
        this.myTag = tag;
    }

    @Nullable
    public TagSnapshot getSnapshot() {
        return this.mySnapshot;
    }

    public void setSnapshot(@Nullable TagSnapshot snapshot) {
        this.mySnapshot = snapshot;
    }

    public void addChild(@NotNull NlComponent component2) {
        if (component2 == null) {
            NlComponent.$$$reportNull$$$0(9);
        }
        this.addChild(component2, null);
    }

    public void addChild(@NotNull NlComponent component2, @Nullable NlComponent before) {
        int index;
        if (component2 == null) {
            NlComponent.$$$reportNull$$$0(10);
        }
        if (component2 == this) {
            throw new IllegalArgumentException();
        }
        int n = index = before != null ? this.children.indexOf(before) : -1;
        if (index != -1) {
            this.children.add(index, component2);
        } else {
            this.children.add(component2);
        }
        component2.setParent(this);
    }

    public void removeChild(@NotNull NlComponent component2) {
        if (component2 == null) {
            NlComponent.$$$reportNull$$$0(11);
        }
        if (component2 == this) {
            throw new IllegalArgumentException();
        }
        this.children.remove(component2);
        component2.setParent(null);
    }

    public void setChildren(@Nullable List<NlComponent> components) {
        this.children.clear();
        if (components == null) {
            return;
        }
        this.children.addAll(components);
        for (NlComponent component2 : components) {
            if (component2 == this) {
                throw new IllegalArgumentException();
            }
            component2.setParent(this);
        }
    }

    @NotNull
    public List<NlComponent> getChildren() {
        ImmutableList immutableList = ImmutableList.copyOf(this.children);
        if (immutableList == null) {
            NlComponent.$$$reportNull$$$0(12);
        }
        return immutableList;
    }

    public int getChildCount() {
        return this.children.size();
    }

    @Nullable
    public NlComponent getChild(int index) {
        return index >= 0 && index < this.children.size() ? this.children.get(index) : null;
    }

    @NotNull
    public Stream<NlComponent> flatten() {
        Stream<NlComponent> stream = Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(NlComponent::flatten));
        if (stream == null) {
            NlComponent.$$$reportNull$$$0(13);
        }
        return stream;
    }

    @NotNull
    public DependencyGraph getDependencyGraph() {
        if (this.myCachedDependencyGraph == null || this.myCachedDependencyGraph.isStale(this)) {
            this.myCachedDependencyGraph = new DependencyGraph(this);
        }
        DependencyGraph dependencyGraph = this.myCachedDependencyGraph;
        if (dependencyGraph == null) {
            NlComponent.$$$reportNull$$$0(14);
        }
        return dependencyGraph;
    }

    @Nullable
    public NlComponent getNextSibling() {
        if (this.myParent == null) {
            return null;
        }
        for (int index = 0; index < this.myParent.getChildCount(); ++index) {
            if (this.myParent.getChild(index) != this) continue;
            return this.myParent.getChild(index + 1);
        }
        return null;
    }

    @Nullable
    public NlComponent findViewByTag(@NotNull XmlTag tag) {
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(15);
        }
        if (this.getTag() == tag) {
            return this;
        }
        for (NlComponent child : this.getChildren()) {
            NlComponent result = child.findViewByTag(tag);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void findViewsByTag(@NotNull XmlTag tag, @NotNull ImmutableList.Builder<NlComponent> builder) {
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(16);
        }
        if (builder == null) {
            NlComponent.$$$reportNull$$$0(17);
        }
        for (NlComponent child : this.getChildren()) {
            child.findViewsByTag(tag, builder);
        }
        if (this.getTag() == tag) {
            builder.add((Object)this);
        }
    }

    @NotNull
    public ImmutableList<NlComponent> findViewsByTag(@NotNull XmlTag tag) {
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(18);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        this.findViewsByTag(tag, (ImmutableList.Builder<NlComponent>)builder);
        ImmutableList immutableList = builder.build();
        if (immutableList == null) {
            NlComponent.$$$reportNull$$$0(19);
        }
        return immutableList;
    }

    public boolean isRoot() {
        return !(this.getTag().getParent() instanceof XmlTag);
    }

    public NlComponent getRoot() {
        NlComponent component2;
        for (component2 = this; component2 != null && !component2.isRoot(); component2 = component2.getParent()) {
        }
        return component2;
    }

    @Nullable
    public String getId() {
        String id = this.myCurrentTransaction != null ? this.myCurrentTransaction.getAndroidAttribute("id") : this.resolveAttribute("http://schemas.android.com/apk/res/android", "id");
        return NlComponent.stripId(id);
    }

    @Nullable
    public static String stripId(@Nullable String id) {
        if (id != null) {
            if (id.startsWith("@+id/")) {
                return id.substring("@+id/".length());
            }
            if (id.startsWith("@id/")) {
                return id.substring("@id/".length());
            }
        }
        return null;
    }

    @Nullable
    public NlComponent getParent() {
        return this.myParent;
    }

    private void setParent(@Nullable NlComponent parent) {
        this.myParent = parent;
    }

    @NotNull
    public String getTagName() {
        String string = this.myTagName;
        if (string == null) {
            NlComponent.$$$reportNull$$$0(20);
        }
        return string;
    }

    public String toString() {
        if (this.getMixin() != null) {
            return this.getMixin().toString();
        }
        return String.format("<%s>", this.myTagName);
    }

    @Override
    public void setAttribute(@Nullable String namespace, @NotNull String attribute, @Nullable String value) {
        String previous;
        XmlTag tag;
        if (attribute == null) {
            NlComponent.$$$reportNull$$$0(21);
        }
        if (!(tag = this.getTag()).isValid()) {
            return;
        }
        String prefix = null;
        if (namespace != null && !"http://schemas.android.com/apk/res/android".equals(namespace)) {
            prefix = AndroidResourceUtil.ensureNamespaceImported((XmlFile)tag.getContainingFile(), namespace, null);
        }
        if (Objects.equals(previous = this.getAttribute(namespace, attribute), value)) {
            return;
        }
        tag.setAttribute(attribute, namespace, value);
        if (this.mySnapshot != null) {
            this.mySnapshot.setAttribute(attribute, namespace, prefix, value);
        }
    }

    @NotNull
    public AttributesTransaction startAttributeTransaction() {
        if (this.myCurrentTransaction == null) {
            this.myCurrentTransaction = new AttributesTransaction(this);
        }
        AttributesTransaction attributesTransaction = this.myCurrentTransaction;
        if (attributesTransaction == null) {
            NlComponent.$$$reportNull$$$0(22);
        }
        return attributesTransaction;
    }

    @Nullable
    public String getLiveAttribute(@Nullable String namespace, @NotNull String attribute) {
        if (attribute == null) {
            NlComponent.$$$reportNull$$$0(23);
        }
        if (this.myCurrentTransaction != null) {
            return this.myCurrentTransaction.getAttribute(namespace, attribute);
        }
        return this.getAttribute(namespace, attribute);
    }

    @Override
    @Nullable
    public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
        if (attribute == null) {
            NlComponent.$$$reportNull$$$0(24);
        }
        if (this.mySnapshot != null) {
            return this.mySnapshot.getAttribute(attribute, namespace);
        }
        XmlTag tag = this.getTag();
        if (AndroidPsiUtils.isValid(tag)) {
            return AndroidPsiUtils.getAttributeSafely(tag, namespace, attribute);
        }
        return null;
    }

    @Nullable
    public String resolveAttribute(@Nullable String namespace, @NotNull String attribute) {
        String value;
        if (attribute == null) {
            NlComponent.$$$reportNull$$$0(25);
        }
        if ((value = this.getAttribute(namespace, attribute)) != null) {
            return value;
        }
        if (this.getMixin() != null) {
            return this.getMixin().getAttribute(namespace, attribute);
        }
        return null;
    }

    @NotNull
    public List<AttributeSnapshot> getAttributes() {
        if (this.mySnapshot != null) {
            List<AttributeSnapshot> list = this.mySnapshot.attributes;
            if (list == null) {
                NlComponent.$$$reportNull$$$0(26);
            }
            return list;
        }
        XmlTag tag = this.getTag();
        if (tag.isValid()) {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                List list = (List)application.runReadAction(() -> AttributeSnapshot.createAttributesForTag(tag));
                if (list == null) {
                    NlComponent.$$$reportNull$$$0(27);
                }
                return list;
            }
            List<AttributeSnapshot> list = AttributeSnapshot.createAttributesForTag(tag);
            if (list == null) {
                NlComponent.$$$reportNull$$$0(28);
            }
            return list;
        }
        List<AttributeSnapshot> list = Collections.emptyList();
        if (list == null) {
            NlComponent.$$$reportNull$$$0(29);
        }
        return list;
    }

    public String ensureNamespace(@NotNull String prefix, @NotNull String namespace) {
        if (prefix == null) {
            NlComponent.$$$reportNull$$$0(30);
        }
        if (namespace == null) {
            NlComponent.$$$reportNull$$$0(31);
        }
        return AndroidResourceUtil.ensureNamespaceImported((XmlFile)this.getTag().getContainingFile(), namespace, prefix);
    }

    public boolean isShowing() {
        return this.mySnapshot != null;
    }

    @Nullable
    public static String extractId(@Nullable String str) {
        if (str == null) {
            return null;
        }
        int index = str.lastIndexOf("@id/");
        if (index != -1) {
            return str.substring(index + 4);
        }
        index = str.lastIndexOf("@+id/");
        if (index != -1) {
            return str.substring(index + 5);
        }
        return null;
    }

    public void removeObsoleteAttributes() {
        Set<QualifiedName> obsoleteAttributes = AttributesHelperKt.getObsoleteAttributes(this);
        AttributesTransaction transaction = this.startAttributeTransaction();
        obsoleteAttributes.forEach(qualifiedName -> transaction.removeAttribute(qualifiedName.getNamespace(), qualifiedName.getName()));
        transaction.commit();
    }

    public final void putClientProperty(Object key, Object value) {
        this.myClientProperties.put(key, value);
    }

    public final Object getClientProperty(Object key) {
        return this.myClientProperties.get(key);
    }

    public final Object removeClientProperty(Object key) {
        return this.myClientProperties.remove(key);
    }

    public void addLiveChangeListener(ChangeListener listener) {
        this.myListeners.add(listener);
    }

    public void removeLiveChangeListener(ChangeListener listener) {
        this.myListeners.remove(listener);
    }

    public void fireLiveChangeEvent() {
        this.myListeners.forEach(listener -> listener.stateChanged(this.myChangeEvent));
    }

    @NotNull
    public String assignId() {
        String string = this.assignId(this.getTagName());
        if (string == null) {
            NlComponent.$$$reportNull$$$0(32);
        }
        return string;
    }

    public String ensureId() {
        if (this.getId() != null) {
            return this.getId();
        }
        return this.assignId();
    }

    @NotNull
    public String assignId(@NotNull String baseName) {
        if (baseName == null) {
            NlComponent.$$$reportNull$$$0(33);
        }
        String string = this.assignId(baseName, this.getModel().getIds());
        if (string == null) {
            NlComponent.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    public String assignId(@NotNull Set<String> ids) {
        if (ids == null) {
            NlComponent.$$$reportNull$$$0(35);
        }
        String string = this.assignId(this.getTagName(), ids);
        if (string == null) {
            NlComponent.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    public String assignId(@NotNull String baseName, @NotNull Set<String> ids) {
        if (baseName == null) {
            NlComponent.$$$reportNull$$$0(37);
        }
        if (ids == null) {
            NlComponent.$$$reportNull$$$0(38);
        }
        String newId = NlComponent.generateId(baseName, ids, ResourceFolderType.LAYOUT, this.getModel().getModule());
        NlAttributesHolder attributes = this.myCurrentTransaction == null ? this : this.myCurrentTransaction;
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "id", "@+id/" + newId);
        this.getModel().getPendingIds().add(newId);
        String string = newId;
        if (string == null) {
            NlComponent.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NotNull
    public static String generateId(@NotNull String baseName, @NotNull Set<String> ids, ResourceFolderType type, Module module) {
        if (baseName == null) {
            NlComponent.$$$reportNull$$$0(40);
        }
        if (ids == null) {
            NlComponent.$$$reportNull$$$0(41);
        }
        String idValue = StringUtil.decapitalize((String)baseName.substring(baseName.lastIndexOf(46) + 1));
        Project project = module.getProject();
        String nextIdValue = idValue = ResourceHelper.prependResourcePrefix(module, idValue, type);
        int index = 0;
        NamesValidator validator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)JavaLanguage.INSTANCE);
        while (ids.contains(nextIdValue) || validator != null && validator.isKeyword(nextIdValue, project)) {
            if (!(++index != 1 || validator != null && validator.isKeyword(nextIdValue, project))) {
                nextIdValue = idValue;
                continue;
            }
            nextIdValue = idValue + index;
        }
        String string = idValue + (index == 0 ? "" : Integer.valueOf(index));
        if (string == null) {
            NlComponent.$$$reportNull$$$0(42);
        }
        return string;
    }

    @Nullable
    public String getTooltipText() {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            return mixin.getTooltipText();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 39: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 39: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 15: 
            case 16: 
            case 18: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagPointer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mixin";
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/model/NlComponent";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 33: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 35: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/model/NlComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTag";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "flatten";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyGraph";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findViewsByTag";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "startAttributeTransaction";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 32: 
            case 34: 
            case 36: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "assignId";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "generateId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setMixin";
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 39: 
            case 42: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setTag";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findViewByTag";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findViewsByTag";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setAttribute";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLiveAttribute";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAttribute";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "resolveAttribute";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "ensureNamespace";
                break;
            }
            case 33: 
            case 35: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "assignId";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "generateId";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setTag$1";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 39: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class XmlModelComponentMixin {
        private final NlComponent myComponent;

        public XmlModelComponentMixin(@NotNull NlComponent component2) {
            if (component2 == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(0);
            }
            this.myComponent = component2;
        }

        @NotNull
        protected NlComponent getComponent() {
            NlComponent nlComponent = this.myComponent;
            if (nlComponent == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(1);
            }
            return nlComponent;
        }

        @Nullable
        public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
            if (attribute == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(2);
            }
            return null;
        }

        public String toString() {
            return String.format("<%s>", this.myComponent.getTagName());
        }

        @Nullable
        public String getTooltipText() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/common/model/NlComponent$XmlModelComponentMixin";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attribute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/common/model/NlComponent$XmlModelComponentMixin";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getAttribute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

