/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.resources.LayoutDirection;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneHitListener;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.ActionTarget;
import com.android.tools.idea.common.scene.target.DragBaseTarget;
import com.android.tools.idea.common.scene.target.LassoTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.naveditor.scene.targets.ActionHandleTarget;
import com.android.tools.idea.naveditor.scene.targets.ScreenHeaderTarget;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.AnchorTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.BarrierTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintDragTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.GuidelineCycleTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.GuidelineTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.MultiComponentTarget;
import com.android.tools.idea.uibuilder.handlers.coordinator.CoordinatorSnapTarget;
import com.android.tools.idea.uibuilder.model.SelectionHandle;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.SceneMode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ui.JBUI;
import java.awt.Cursor;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Scene
implements SelectionListener,
Disposable {
    private static final int DRAG_THRESHOLD = JBUI.scale((int)10);
    private final DesignSurface myDesignSurface;
    private final SceneManager mySceneManager;
    private static final boolean DEBUG = false;
    private final HashMap<NlComponent, SceneComponent> mySceneComponents;
    private SceneComponent myRoot;
    private boolean myIsAnimated;
    public static final int NO_LAYOUT = 0;
    public static final int IMMEDIATE_LAYOUT = 1;
    public static final int ANIMATED_LAYOUT = 2;
    private long myDisplayListVersion;
    private Target myOverTarget;
    private Target mySnapTarget;
    private SceneComponent myCurrentComponent;
    private int mNeedsLayout;
    protected int myPressedMouseX;
    protected int myPressedMouseY;
    private int myLastMouseX;
    private int myLastMouseY;
    @NotNull
    private final SceneHitListener myHoverListener;
    @NotNull
    private final SceneHitListener myHitListener;
    @NotNull
    private final SceneHitListener myFindListener;
    @NotNull
    private final SceneHitListener mySnapListener;
    private Target myHitTarget;
    private Cursor myMouseCursor;
    private SceneComponent myHitComponent;
    ArrayList<SceneComponent> myNewSelectedComponentsOnRelease;
    ArrayList<SceneComponent> myNewSelectedComponentsOnDown;
    private boolean myIsControlDown;
    private boolean myIsShiftDown;
    private boolean myIsAltDown;
    private boolean myShowAllConstraints;
    private FilterType myFilterTarget;

    public Scene(@NotNull SceneManager sceneManager, @NotNull DesignSurface surface) {
        if (sceneManager == null) {
            Scene.$$$reportNull$$$0(0);
        }
        if (surface == null) {
            Scene.$$$reportNull$$$0(1);
        }
        this.mySceneComponents = new HashMap();
        this.myIsAnimated = true;
        this.myDisplayListVersion = 1L;
        this.mNeedsLayout = 0;
        this.myHitTarget = null;
        this.myNewSelectedComponentsOnRelease = new ArrayList();
        this.myNewSelectedComponentsOnDown = new ArrayList();
        this.myShowAllConstraints = false;
        this.myFilterTarget = FilterType.NONE;
        this.myDesignSurface = surface;
        this.mySceneManager = sceneManager;
        SelectionModel selectionModel = this.myDesignSurface.getSelectionModel();
        this.myHoverListener = new SceneHitListener(selectionModel);
        this.myHitListener = new SceneHitListener(selectionModel);
        this.myFindListener = new SceneHitListener(selectionModel);
        this.mySnapListener = new SceneHitListener(selectionModel);
        selectionModel.addListener(this);
        Disposer.register((Disposable)sceneManager, (Disposable)this);
    }

    public void dispose() {
        this.myDesignSurface.getSelectionModel().removeListener(this);
    }

    @NotNull
    public SceneManager getSceneManager() {
        SceneManager sceneManager = this.mySceneManager;
        if (sceneManager == null) {
            Scene.$$$reportNull$$$0(2);
        }
        return sceneManager;
    }

    public boolean supportsRTL() {
        return true;
    }

    public boolean isInRTL() {
        Configuration configuration = this.myDesignSurface.getConfiguration();
        if (configuration == null) {
            return false;
        }
        LayoutDirectionQualifier qualifier = configuration.getFullConfig().getLayoutDirectionQualifier();
        if (qualifier == null) {
            return false;
        }
        return qualifier.getValue() == LayoutDirection.RTL;
    }

    public int getRenderedApiLevel() {
        IAndroidTarget target;
        Configuration configuration = this.myDesignSurface.getConfiguration();
        if (configuration != null && (target = configuration.getTarget()) != null) {
            return target.getVersion().getApiLevel();
        }
        return 1;
    }

    public boolean isAnimated() {
        return this.myIsAnimated;
    }

    public void setAnimated(boolean animated) {
        this.myIsAnimated = animated;
    }

    @Nullable
    public SceneComponent getSceneComponent(@Nullable NlComponent component2) {
        if (component2 == null) {
            return null;
        }
        return this.mySceneComponents.get(component2);
    }

    @NotNull
    public DesignSurface getDesignSurface() {
        DesignSurface designSurface = this.myDesignSurface;
        if (designSurface == null) {
            Scene.$$$reportNull$$$0(3);
        }
        return designSurface;
    }

    @Nullable
    public SceneComponent getSceneComponent(@NotNull String componentId) {
        if (componentId == null) {
            Scene.$$$reportNull$$$0(4);
        }
        if (this.myRoot == null) {
            return null;
        }
        return this.myRoot.getSceneComponent(componentId);
    }

    public List<NlComponent> getSelection() {
        return this.myDesignSurface.getSelectionModel().getSelection();
    }

    @Nullable
    public SceneComponent getRoot() {
        return this.myRoot;
    }

    public Cursor getMouseCursor() {
        return this.myMouseCursor;
    }

    public boolean isAutoconnectOn() {
        return PropertiesComponent.getInstance().getBoolean("ConstraintLayoutPreferenceAutoConnect", false);
    }

    public boolean isShowAllConstraints() {
        return this.myShowAllConstraints || PropertiesComponent.getInstance().getBoolean("ConstraintLayoutPreferenceShowAllConstraints");
    }

    public void setShowAllConstraints(boolean showAllConstraints) {
        this.myShowAllConstraints = showAllConstraints;
    }

    public void updateModifiers(int modifiers) {
        this.myIsControlDown = (modifiers & 0x80) != 0 || (modifiers & 2) != 0;
        this.myIsShiftDown = (modifiers & 0x40) != 0 || (modifiers & 1) != 0;
        this.myIsAltDown = (modifiers & 0x200) != 0 || (modifiers & 8) != 0;
    }

    public boolean isControlDown() {
        return this.myIsControlDown;
    }

    public boolean isShiftDown() {
        return this.myIsShiftDown;
    }

    public boolean isAltDown() {
        return this.myIsAltDown;
    }

    public void clearAttributes() {
        if (this.myRoot != null) {
            this.myRoot.clearAttributes();
        }
        this.select(Collections.emptyList());
    }

    public void addComponent(@NotNull SceneComponent component2) {
        if (component2 == null) {
            Scene.$$$reportNull$$$0(5);
        }
        this.mySceneComponents.put(component2.getNlComponent(), component2);
        this.needsRebuildList();
    }

    public void removeComponent(@NotNull SceneComponent component2) {
        if (component2 == null) {
            Scene.$$$reportNull$$$0(6);
        }
        component2.removeFromParent();
        this.mySceneComponents.remove(component2.getNlComponent(), component2);
        this.needsRebuildList();
    }

    void removeAllComponents() {
        Iterator<Map.Entry<NlComponent, SceneComponent>> it = this.mySceneComponents.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<NlComponent, SceneComponent> entry = it.next();
            entry.getValue().removeFromParent();
            it.remove();
        }
    }

    @Override
    public void selectionChanged(@NotNull SelectionModel model, @NotNull List<NlComponent> selection) {
        if (model == null) {
            Scene.$$$reportNull$$$0(7);
        }
        if (selection == null) {
            Scene.$$$reportNull$$$0(8);
        }
        if (this.myRoot != null) {
            Scene.markSelection(this.myRoot, model);
        }
    }

    private static void markSelection(SceneComponent component2, SelectionModel model) {
        component2.setSelected(model.isSelected(component2.getNlComponent()));
        for (SceneComponent child : component2.getChildren()) {
            Scene.markSelection(child, model);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void buildDisplayList(@NotNull DisplayList displayList, long time, SceneView sceneView) {
        void sceneView2;
        if (displayList == null) {
            Scene.$$$reportNull$$$0(9);
        }
        this.buildDisplayList(displayList, time, SceneContext.get((SceneView)sceneView2));
    }

    public void buildDisplayList(@NotNull DisplayList displayList, long time) {
        if (displayList == null) {
            Scene.$$$reportNull$$$0(10);
        }
        this.layout(time, SceneContext.get());
        this.buildDisplayList(displayList, time, SceneContext.get());
    }

    public void repaint() {
        this.myDesignSurface.repaint();
    }

    /*
     * WARNING - void declaration
     */
    public void buildDisplayList(@NotNull DisplayList displayList, long time, SceneContext sceneContext) {
        if (displayList == null) {
            Scene.$$$reportNull$$$0(11);
        }
        if (this.myRoot != null) {
            void sceneContext2;
            this.myRoot.buildDisplayList(time, displayList, (SceneContext)sceneContext2);
        }
    }

    public boolean layout(long time, SceneContext sceneContext) {
        boolean needsToRebuildDisplayList = false;
        if (this.myRoot != null && (needsToRebuildDisplayList = this.myRoot.layout(sceneContext, time))) {
            this.needsRebuildList();
        }
        return needsToRebuildDisplayList;
    }

    public void select(List<SceneComponent> components) {
        if (this.myDesignSurface != null) {
            ArrayList<NlComponent> nlComponents = new ArrayList<NlComponent>();
            if (this.myIsShiftDown) {
                ImmutableList<NlComponent> selection = this.myDesignSurface.getSelectionModel().getSelection();
                nlComponents.addAll((Collection<NlComponent>)selection);
            }
            for (SceneComponent sceneComponent : components) {
                NlComponent nlComponent = sceneComponent.getNlComponent();
                if (this.myIsShiftDown && nlComponents.contains(nlComponent)) {
                    nlComponents.remove(nlComponent);
                    continue;
                }
                nlComponents.add(nlComponent);
            }
            this.myDesignSurface.getSelectionModel().setSelection(nlComponents);
        }
    }

    public boolean allowsTarget(Target target) {
        SceneComponent component2 = target.getComponent();
        if (component2.isSelected()) {
            boolean hasBaselineConnection;
            boolean bl = hasBaselineConnection = component2.getAuthoritativeNlComponent().getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf") != null;
            if (target instanceof AnchorTarget) {
                AnchorTarget anchor = (AnchorTarget)target;
                if (anchor.getType() == AnchorTarget.Type.BASELINE) {
                    return component2.canShowBaseline() || hasBaselineConnection;
                }
                return !hasBaselineConnection && !component2.canShowBaseline() || hasBaselineConnection && anchor.isHorizontalAnchor();
            }
            if (component2.canShowBaseline()) {
                return target instanceof ActionTarget || target instanceof ConstraintDragTarget || target instanceof DragBaseTarget || target instanceof ResizeBaseTarget;
            }
            return !component2.isDragging();
        }
        if (target instanceof CoordinatorSnapTarget) {
            return true;
        }
        if (target instanceof AnchorTarget) {
            AnchorTarget anchor = (AnchorTarget)target;
            if (this.myFilterTarget == FilterType.BASELINE_ANCHOR) {
                return anchor.getType() == AnchorTarget.Type.BASELINE;
            }
            if (this.myFilterTarget == FilterType.VERTICAL_ANCHOR && anchor.isVerticalAnchor()) {
                return true;
            }
            if (this.myFilterTarget == FilterType.HORIZONTAL_ANCHOR && anchor.isHorizontalAnchor()) {
                return true;
            }
            if (this.myFilterTarget == FilterType.ANCHOR) {
                return true;
            }
        }
        if (this.myFilterTarget == FilterType.RESIZE && target instanceof ResizeBaseTarget) {
            return true;
        }
        if (target instanceof MultiComponentTarget) {
            return true;
        }
        if (target instanceof DragBaseTarget) {
            return true;
        }
        if (target instanceof LassoTarget) {
            return true;
        }
        if (target instanceof GuidelineCycleTarget) {
            return true;
        }
        if (target instanceof ActionTarget) {
            return false;
        }
        return this.myFilterTarget == FilterType.ALL;
    }

    public void mouseHover(@NotNull SceneContext transform2, int x, int y) {
        SceneComponent closestComponent;
        Target snapTarget;
        if (transform2 == null) {
            Scene.$$$reportNull$$$0(12);
        }
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        if (this.myRoot != null) {
            this.myHoverListener.find(transform2, this.myRoot, x, y);
            this.mySnapListener.find(transform2, this.myRoot, x, y);
        }
        this.repaint();
        Target closestTarget = this.myHoverListener.getClosestTarget();
        if (this.myOverTarget != closestTarget) {
            if (this.myOverTarget != null) {
                this.myOverTarget.setMouseHovered(false);
                this.myOverTarget = null;
                this.needsRebuildList();
            }
            if (closestTarget != null) {
                closestTarget.setMouseHovered(true);
                transform2.setToolTip(closestTarget.getToolTipText());
                this.myOverTarget = closestTarget;
                this.needsRebuildList();
            }
        }
        if (closestTarget != null && (snapTarget = this.myHoverListener.getFilteredTarget(closestTarget)) != this.mySnapTarget) {
            if (this.mySnapTarget != null) {
                this.mySnapTarget.setMouseHovered(false);
                this.mySnapTarget = null;
                this.needsRebuildList();
            }
            if (snapTarget != null) {
                snapTarget.setMouseHovered(true);
                transform2.setToolTip(closestTarget.getToolTipText());
                this.mySnapTarget = closestTarget;
                this.needsRebuildList();
            }
        }
        if (this.myCurrentComponent != (closestComponent = this.myHoverListener.getClosestComponent())) {
            if (this.myCurrentComponent != null) {
                this.myCurrentComponent.setDrawState(SceneComponent.DrawState.NORMAL);
                this.myCurrentComponent = null;
            }
            if (closestComponent != null) {
                closestComponent.setDrawState(SceneComponent.DrawState.HOVER);
                this.myCurrentComponent = closestComponent;
            }
            this.needsRebuildList();
        }
        this.setCursor(transform2, x, y);
    }

    private void setCursor(@NotNull SceneContext transform2, int x, int y) {
        int max;
        SelectionHandle handle;
        if (transform2 == null) {
            Scene.$$$reportNull$$$0(13);
        }
        this.myMouseCursor = Cursor.getDefaultCursor();
        if (this.myCurrentComponent != null && this.myCurrentComponent.isDragging()) {
            this.myMouseCursor = Cursor.getPredefinedCursor(13);
            return;
        }
        if (this.myOverTarget != null) {
            this.myMouseCursor = this.myOverTarget.getMouseCursor();
            return;
        }
        SelectionModel selectionModel = this.myDesignSurface.getSelectionModel();
        if (!selectionModel.isEmpty() && (handle = selectionModel.findHandle(x, y, max = Coordinates.getAndroidDimensionDip(this.myDesignSurface, 10), this.getDesignSurface())) != null) {
            this.myMouseCursor = handle.getCursor();
            return;
        }
        SceneComponent component2 = this.findComponent(transform2, x, y);
        if (component2 != null && component2.getParent() != null) {
            this.myMouseCursor = Cursor.getPredefinedCursor(12);
        }
    }

    private void delegateMouseDownToSelection(int x, int y, SceneComponent currentComponent) {
        List<NlComponent> selection = this.getSelection();
        if (selection.size() > 1) {
            for (NlComponent nlComponent : selection) {
                SceneComponent c;
                if (nlComponent == currentComponent.getNlComponent() || (c = currentComponent.getScene().getSceneComponent(nlComponent)) == null || c == currentComponent) continue;
                for (Target target : c.getTargets()) {
                    if (!(target instanceof MultiComponentTarget)) continue;
                    target.mouseDown(x, y);
                }
            }
        }
    }

    private void delegateMouseDragToSelection(int x, int y, @Nullable Target closestTarget, SceneComponent currentComponent) {
        List<NlComponent> selection = this.getSelection();
        if (selection.size() > 1) {
            for (NlComponent nlComponent : selection) {
                SceneComponent c;
                if (nlComponent == currentComponent.getNlComponent() || (c = currentComponent.getScene().getSceneComponent(nlComponent)) == null || c == currentComponent) continue;
                for (Target target : c.getTargets()) {
                    if (!(target instanceof MultiComponentTarget)) continue;
                    ArrayList<Target> list = new ArrayList<Target>();
                    list.add(closestTarget);
                    target.mouseDrag(x, y, list);
                }
            }
        }
    }

    private void delegateMouseReleaseToSelection(int x, int y, @Nullable Target closestTarget, SceneComponent currentComponent) {
        List<NlComponent> selection = this.getSelection();
        if (selection.size() > 1) {
            int count = selection.size();
            for (int i = 0; i < count; ++i) {
                SceneComponent c;
                NlComponent nlComponent = selection.get(i);
                if (nlComponent == currentComponent.getNlComponent() || (c = currentComponent.getScene().getSceneComponent(nlComponent)) == null) continue;
                for (Target target : c.getTargets()) {
                    if (!(target instanceof MultiComponentTarget)) continue;
                    target.mouseRelease(x, y, Collections.singletonList(closestTarget));
                }
            }
        }
    }

    public void mouseDown(@NotNull SceneContext transform2, int x, int y) {
        if (transform2 == null) {
            Scene.$$$reportNull$$$0(14);
        }
        this.myPressedMouseX = x;
        this.myPressedMouseY = y;
        this.mNeedsLayout = 0;
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        this.myFilterTarget = FilterType.NONE;
        if (this.myRoot == null) {
            return;
        }
        this.myNewSelectedComponentsOnDown.clear();
        this.myHitListener.find(transform2, this.myRoot, x, y);
        this.myHitTarget = this.myHitListener.getClosestTarget();
        this.myHitComponent = this.myHitListener.getClosestComponent();
        if (this.myHitTarget != null) {
            if (this.myHitTarget instanceof AnchorTarget) {
                AnchorTarget anchor = (AnchorTarget)this.myHitTarget;
                this.myFilterTarget = anchor.isHorizontalAnchor() ? FilterType.HORIZONTAL_ANCHOR : FilterType.VERTICAL_ANCHOR;
                if (anchor.getType() == AnchorTarget.Type.BASELINE) {
                    this.myFilterTarget = FilterType.BASELINE_ANCHOR;
                }
            }
            this.myHitTarget.mouseDown(x, y);
            if (this.myHitTarget instanceof MultiComponentTarget) {
                this.delegateMouseDownToSelection(x, y, this.myHitTarget.getComponent());
            }
        } else if (this.myHitComponent != null && !this.inCurrentSelection(this.myHitComponent)) {
            this.myNewSelectedComponentsOnDown.add(this.myHitComponent);
            this.select(this.myNewSelectedComponentsOnDown);
        }
    }

    public void mouseDrag(@NotNull SceneContext transform2, int x, int y) {
        if (transform2 == null) {
            Scene.$$$reportNull$$$0(15);
        }
        if (this.myLastMouseX == x && this.myLastMouseY == y) {
            return;
        }
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        if (this.myHitTarget != null) {
            if (!this.myHitTarget.getComponent().isDragging() && !this.myDesignSurface.getSelectionModel().isSelected(this.myHitTarget.getComponent().getNlComponent()) && Scene.isWithinThreshold(this.myPressedMouseX, x, transform2) && Scene.isWithinThreshold(this.myPressedMouseY, y, transform2)) {
                return;
            }
            this.myHitListener.skipTarget(this.myHitTarget);
            this.myHitListener.find(transform2, this.myRoot, x, y);
            this.myHitTarget.mouseDrag(x, y, this.myHitListener.myHitTargets);
            if (this.myHitTarget instanceof MultiComponentTarget) {
                this.delegateMouseDragToSelection(x, y, this.myHitListener.getClosestTarget(), this.myHitTarget.getComponent());
            }
            this.myHitListener.skipTarget(null);
        }
        this.mouseHover(transform2, x, y);
        this.checkRequestLayoutStatus();
    }

    private static boolean isWithinThreshold(int pos1, int pos2, SceneContext transform2) {
        int pos4;
        int pos3 = transform2.getSwingDimensionDip(pos1);
        return Math.abs(pos3 - (pos4 = transform2.getSwingDimensionDip(pos2))) < DRAG_THRESHOLD;
    }

    public void checkRequestLayoutStatus() {
        if (this.mNeedsLayout != 0) {
            SceneManager manager = this.myDesignSurface.getSceneManager();
            if (manager == null) {
                return;
            }
            boolean renderOnLayout = (Boolean)StudioFlags.NELE_LIVE_RENDER.get();
            if ((renderOnLayout &= this.myDesignSurface instanceof NlDesignSurface && ((NlDesignSurface)this.myDesignSurface).getSceneMode() != SceneMode.BLUEPRINT_ONLY) && manager instanceof LayoutlibSceneManager) {
                ((LayoutlibSceneManager)manager).requestLayoutAndRender(this.mNeedsLayout == 2);
            } else {
                manager.layout(this.mNeedsLayout == 2);
            }
        }
    }

    public void mouseRelease(@NotNull SceneContext transform2, int x, int y) {
        SceneComponent closestComponent;
        DragBaseTarget dragTarget;
        if (transform2 == null) {
            Scene.$$$reportNull$$$0(16);
        }
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        if (this.myHitTarget != null) {
            this.myHitListener.find(transform2, this.myRoot, x, y);
            Target closest = this.myHitListener.getFilteredTarget(this.myHitTarget);
            this.myHitTarget.mouseRelease(x, y, closest != null ? Collections.singletonList(closest) : Collections.emptyList());
            this.myHitTarget.getComponent().setDragging(false);
            if (this.myHitTarget instanceof MultiComponentTarget) {
                this.delegateMouseReleaseToSelection(x, y, this.myHitListener.getClosestTarget(), this.myHitTarget.getComponent());
            }
        }
        this.myFilterTarget = FilterType.NONE;
        this.myNewSelectedComponentsOnRelease.clear();
        if (this.myHitComponent != null && this.myHitListener.getClosestComponent() == this.myHitComponent && !this.myNewSelectedComponentsOnRelease.contains(this.myHitComponent)) {
            this.myNewSelectedComponentsOnRelease.add(this.myHitComponent);
        }
        if (this.myHitTarget instanceof ActionTarget || this.myHitTarget instanceof GuidelineTarget || this.myHitTarget instanceof BarrierTarget || this.myHitTarget instanceof ScreenHeaderTarget) {
            this.myNewSelectedComponentsOnRelease.clear();
            this.myNewSelectedComponentsOnRelease.add(this.myHitTarget.getComponent());
        }
        if (this.myHitTarget instanceof DragBaseTarget && (dragTarget = (DragBaseTarget)this.myHitTarget).hasChangedComponent()) {
            this.myNewSelectedComponentsOnRelease.clear();
            this.myNewSelectedComponentsOnRelease.add(dragTarget.getComponent());
        }
        if (this.myHitTarget instanceof LassoTarget) {
            LassoTarget lassoTarget = (LassoTarget)this.myHitTarget;
            lassoTarget.fillSelectedComponents(this.myNewSelectedComponentsOnRelease);
        }
        if (this.myHitTarget instanceof ActionHandleTarget && (closestComponent = this.myHitListener.getClosestComponent()) != null && closestComponent != this.myRoot) {
            ActionHandleTarget actionHandleTarget = (ActionHandleTarget)this.myHitTarget;
            actionHandleTarget.createAction(closestComponent);
        }
        boolean canChangeSelection = true;
        if (this.myHitTarget != null) {
            canChangeSelection = this.myHitTarget.canChangeSelection();
        }
        if (canChangeSelection && !this.sameSelection()) {
            this.select(this.myNewSelectedComponentsOnRelease);
        }
        this.checkRequestLayoutStatus();
    }

    private boolean inCurrentSelection(@NotNull SceneComponent component2) {
        if (component2 == null) {
            Scene.$$$reportNull$$$0(17);
        }
        ImmutableList<NlComponent> currentSelection = this.myDesignSurface.getSelectionModel().getSelection();
        return currentSelection.contains(component2.getNlComponent());
    }

    private boolean sameSelection() {
        if (!this.myNewSelectedComponentsOnRelease.isEmpty() && this.myNewSelectedComponentsOnRelease.size() == this.myNewSelectedComponentsOnDown.size() && this.myNewSelectedComponentsOnRelease.containsAll(this.myNewSelectedComponentsOnDown)) {
            return true;
        }
        ImmutableList<NlComponent> currentSelection = this.myDesignSurface.getSelectionModel().getSelection();
        if (this.myNewSelectedComponentsOnRelease.size() == currentSelection.size()) {
            int count = currentSelection.size();
            for (int i = 0; i < count; ++i) {
                NlComponent component2 = (NlComponent)currentSelection.get(i);
                SceneComponent sceneComponent = this.getSceneComponent(component2);
                if (this.myNewSelectedComponentsOnRelease.contains(sceneComponent)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void needsLayout(int type) {
        if (this.mNeedsLayout < type) {
            this.mNeedsLayout = type;
        }
    }

    public long getDisplayListVersion() {
        return this.myDisplayListVersion;
    }

    public void needsRebuildList() {
        ++this.myDisplayListVersion;
    }

    public List<SceneComponent> findWithin(int x, int y, int width, int height) {
        ArrayList within = Lists.newArrayList();
        if (this.getRoot() != null) {
            Scene.addWithin(within, this.getRoot(), x, y, width, height);
        }
        return within;
    }

    private static boolean addWithin(@NotNull List<SceneComponent> result, @NotNull SceneComponent component2, int x, int y, int width, int height) {
        if (result == null) {
            Scene.$$$reportNull$$$0(18);
        }
        if (component2 == null) {
            Scene.$$$reportNull$$$0(19);
        }
        if (component2.getDrawX() + component2.getDrawWidth() <= x || x + width <= component2.getDrawX() || component2.getDrawY() + component2.getDrawHeight() <= y || y + height <= component2.getDrawY()) {
            return false;
        }
        boolean found = false;
        for (SceneComponent child : component2.getChildren()) {
            found |= Scene.addWithin(result, child, x, y, width, height);
        }
        if (!found) {
            result.add(component2);
        }
        return true;
    }

    @Nullable
    public SceneComponent findComponent(@NotNull SceneContext transform2, int x, int y) {
        if (transform2 == null) {
            Scene.$$$reportNull$$$0(20);
        }
        if (this.myRoot == null) {
            return null;
        }
        this.myFindListener.find(transform2, this.myRoot, x, y);
        return this.myFindListener.getClosestComponent();
    }

    public Collection<SceneComponent> getSceneComponents() {
        return this.mySceneComponents.values();
    }

    public void setRoot(SceneComponent root) {
        this.myRoot = root;
    }

    @Nullable
    public Dimension measureWrapSize(@NotNull SceneComponent component2) {
        if (component2 == null) {
            Scene.$$$reportNull$$$0(21);
        }
        return this.measure(component2, (n, namespace, localName) -> {
            if ("layout_width".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                return "wrap_content";
            }
            if ("layout_height".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                return "wrap_content";
            }
            return null;
        });
    }

    @Nullable
    private Dimension measure(@NotNull SceneComponent component2, @Nullable RenderTask.AttributeFilter filter) {
        NlComponent neleComponent;
        XmlTag tag;
        if (component2 == null) {
            Scene.$$$reportNull$$$0(22);
        }
        if (!(tag = (neleComponent = component2.getNlComponent()).getTag()).isValid()) {
            return null;
        }
        NlModel model = neleComponent.getModel();
        XmlFile xmlFile = model.getFile();
        AndroidFacet facet = model.getFacet();
        RenderService renderService = RenderService.getInstance(facet);
        RenderLogger logger = renderService.createLogger();
        RenderTask task = renderService.createTask((PsiFile)xmlFile, model.getConfiguration(), logger, null);
        if (task == null) {
            return null;
        }
        ViewInfo viewInfo = task.measureChild(tag, filter);
        if (viewInfo == null) {
            return null;
        }
        viewInfo = RenderService.getSafeBounds(viewInfo);
        return new Dimension(Coordinates.pxToDp(this.getDesignSurface(), viewInfo.getRight() - viewInfo.getLeft()), Coordinates.pxToDp(this.getDesignSurface(), viewInfo.getBottom() - viewInfo.getTop()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/scene/Scene";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentId";
                break;
            }
            case 5: 
            case 6: 
            case 17: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayList";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/scene/Scene";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesignSurface";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSceneComponent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeComponent";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "selectionChanged";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildDisplayList";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "mouseHover";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setCursor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "mouseDown";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "mouseDrag";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "mouseRelease";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "inCurrentSelection";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addWithin";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findComponent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "measureWrapSize";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "measure";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum FilterType {
        ALL,
        ANCHOR,
        VERTICAL_ANCHOR,
        HORIZONTAL_ANCHOR,
        BASELINE_ANCHOR,
        NONE,
        RESIZE;

    }
}

