/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.ComponentProvider;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.TargetProvider;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecorator;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.decorator.DecoratorUtilities;
import com.android.tools.idea.uibuilder.scene.target.Notch;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SceneComponent {
    public static final int ANIMATION_DURATION = 350;
    public HashMap<String, Object> myCache;
    public SceneDecorator myDecorator;
    private boolean myAllowsAutoconnect;
    private TargetProvider myTargetProvider;
    private ComponentProvider myComponentProvider;
    private final Scene myScene;
    private final NlComponent myNlComponent;
    private CopyOnWriteArrayList<SceneComponent> myChildren;
    private SceneComponent myParent;
    private boolean myIsToolLocked;
    private boolean myIsSelected;
    protected boolean myDragging;
    private boolean myIsModelUpdateAuthorized;
    private AnimatedValue myAnimatedDrawX;
    private AnimatedValue myAnimatedDrawY;
    private AnimatedValue myAnimatedDrawWidth;
    private AnimatedValue myAnimatedDrawHeight;
    private DrawState myDrawState;
    @GuardedBy(value="myTargets")
    private final ArrayList<Target> myTargets;
    @GuardedBy(value="myTargets")
    @Nullable
    private ImmutableList<Target> myCachedTargetList;
    private int myCurrentLeft;
    private int myCurrentTop;
    private int myCurrentRight;
    private int myCurrentBottom;
    private boolean myShowBaseline;
    private Notch.Provider myNotchProvider;

    public int getCenterX() {
        return this.myCurrentLeft + (this.myCurrentRight - this.myCurrentLeft) / 2;
    }

    public int getCenterY() {
        return this.myCurrentTop + (this.myCurrentBottom - this.myCurrentTop) / 2;
    }

    public SceneComponent(@NotNull Scene scene, @NotNull NlComponent component2) {
        if (scene == null) {
            SceneComponent.$$$reportNull$$$0(0);
        }
        if (component2 == null) {
            SceneComponent.$$$reportNull$$$0(1);
        }
        this.myCache = new HashMap();
        this.myAllowsAutoconnect = true;
        this.myChildren = new CopyOnWriteArrayList();
        this.myParent = null;
        this.myIsToolLocked = false;
        this.myIsSelected = false;
        this.myDragging = false;
        this.myIsModelUpdateAuthorized = true;
        this.myAnimatedDrawX = new AnimatedValue();
        this.myAnimatedDrawY = new AnimatedValue();
        this.myAnimatedDrawWidth = new AnimatedValue();
        this.myAnimatedDrawHeight = new AnimatedValue();
        this.myDrawState = DrawState.NORMAL;
        this.myTargets = new ArrayList();
        this.myCurrentLeft = 0;
        this.myCurrentTop = 0;
        this.myCurrentRight = 0;
        this.myCurrentBottom = 0;
        this.myShowBaseline = false;
        this.myScene = scene;
        this.myNlComponent = component2;
        this.myScene.addComponent(this);
        SceneManager manager = scene.getSceneManager();
        this.myDecorator = manager.getSceneDecoratorFactory().get(component2);
        this.myAllowsAutoconnect = !this.myNlComponent.getTagName().equalsIgnoreCase("android.support.constraint.Guideline");
        this.setSelected(this.myScene.getDesignSurface().getSelectionModel().isSelected(component2));
    }

    public String toString() {
        return this.getNlComponent().toString() + " [ " + this.myCurrentLeft + ", " + this.myCurrentTop + " - " + this.myCurrentRight + ", " + this.myCurrentBottom + "]";
    }

    @Nullable
    public SceneComponent getParent() {
        return this.myParent;
    }

    private void setParent(@NotNull SceneComponent parent) {
        if (parent == null) {
            SceneComponent.$$$reportNull$$$0(2);
        }
        this.myParent = parent;
    }

    private TargetProvider getTargetProvider() {
        return this.myTargetProvider;
    }

    public boolean allowsAutoConnect() {
        return this.myScene.isAutoconnectOn() && this.myAllowsAutoconnect;
    }

    public boolean useRtlAttributes() {
        return this.myScene.supportsRTL();
    }

    public int findTarget(Class aClass) {
        ImmutableList<Target> targets = this.getTargets();
        int count = targets.size();
        for (int i = 0; i < count; ++i) {
            if (!aClass.isInstance(targets.get(i))) continue;
            return i;
        }
        return -1;
    }

    boolean hasAncestor(SceneComponent candidate) {
        for (SceneComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != candidate) continue;
            return true;
        }
        return false;
    }

    public boolean isSelected() {
        return this.myIsSelected;
    }

    public boolean canShowBaseline() {
        return this.myShowBaseline;
    }

    public void setShowBaseline(boolean value) {
        this.myShowBaseline = value;
    }

    public boolean hasNoDimension() {
        return this.myAnimatedDrawWidth.value == 0 && this.myAnimatedDrawHeight.value == 0 && this.myAnimatedDrawX.value == this.myAnimatedDrawX.target && this.myAnimatedDrawY.value == this.myAnimatedDrawY.target;
    }

    public int getDrawX() {
        return this.myAnimatedDrawX.getValue(0L);
    }

    public int getDrawY() {
        return this.myAnimatedDrawY.getValue(0L);
    }

    public int getDrawWidth() {
        return this.myAnimatedDrawWidth.getValue(0L);
    }

    public int getDrawHeight() {
        return this.myAnimatedDrawHeight.getValue(0L);
    }

    public int getDrawX(long time) {
        return this.myAnimatedDrawX.getValue(time);
    }

    public int getDrawY(long time) {
        return this.myAnimatedDrawY.getValue(time);
    }

    public int getDrawWidth(long time) {
        return this.myAnimatedDrawWidth.getValue(time);
    }

    public int getDrawHeight(long time) {
        return this.myAnimatedDrawHeight.getValue(time);
    }

    public void setPosition(int dx, int dy) {
        this.setPosition(dx, dy, false);
    }

    public void setPosition(int dx, int dy, boolean isFromModel) {
        if (!isFromModel || this.myIsModelUpdateAuthorized) {
            this.myAnimatedDrawX.setValue(dx);
            this.myAnimatedDrawY.setValue(dy);
            if (NlComponentHelperKt.getHasNlComponentInfo(this.myNlComponent)) {
                NlComponentHelperKt.setX(this.myNlComponent, Coordinates.dpToPx(this.myScene.getDesignSurface(), (float)dx));
                NlComponentHelperKt.setY(this.myNlComponent, Coordinates.dpToPx(this.myScene.getDesignSurface(), (float)dy));
            }
            this.myScene.needsRebuildList();
        }
    }

    public void setPositionTarget(int dx, int dy, long time, boolean isFromModel) {
        if (!isFromModel || this.myIsModelUpdateAuthorized) {
            this.myAnimatedDrawX.setTarget(dx, time);
            this.myAnimatedDrawY.setTarget(dy, time);
            if (NlComponentHelperKt.getHasNlComponentInfo(this.myNlComponent)) {
                NlComponentHelperKt.setX(this.myNlComponent, Coordinates.dpToPx(this.myScene.getDesignSurface(), (float)dx));
                NlComponentHelperKt.setY(this.myNlComponent, Coordinates.dpToPx(this.myScene.getDesignSurface(), (float)dy));
            } else {
                this.myScene.needsRebuildList();
            }
        }
    }

    public void setSize(int width, int height, boolean isFromModel) {
        if (!isFromModel || this.myIsModelUpdateAuthorized) {
            this.myAnimatedDrawWidth.setValue(width);
            this.myAnimatedDrawHeight.setValue(height);
            if (NlComponentHelperKt.getHasNlComponentInfo(this.myNlComponent)) {
                NlComponentHelperKt.setW(this.myNlComponent, Coordinates.dpToPx(this.myScene.getDesignSurface(), (float)width));
                NlComponentHelperKt.setH(this.myNlComponent, Coordinates.dpToPx(this.myScene.getDesignSurface(), (float)height));
            }
            this.myScene.needsRebuildList();
        }
    }

    public void setSizeTarget(int width, int height, long time, boolean isFromModel) {
        if (!isFromModel || this.myIsModelUpdateAuthorized) {
            this.myAnimatedDrawWidth.setTarget(width, time);
            this.myAnimatedDrawHeight.setTarget(height, time);
            if (NlComponentHelperKt.getHasNlComponentInfo(this.myNlComponent)) {
                NlComponentHelperKt.setW(this.myNlComponent, Coordinates.dpToPx(this.myScene.getDesignSurface(), (float)width));
                NlComponentHelperKt.setH(this.myNlComponent, Coordinates.dpToPx(this.myScene.getDesignSurface(), (float)height));
            }
        }
    }

    @NotNull
    public NlComponent getAuthoritativeNlComponent() {
        ComponentProvider provider = this.myComponentProvider;
        if (provider != null) {
            NlComponent nlComponent = provider.getComponent(this);
            if (nlComponent == null) {
                SceneComponent.$$$reportNull$$$0(3);
            }
            return nlComponent;
        }
        NlComponent nlComponent = this.myNlComponent;
        if (nlComponent == null) {
            SceneComponent.$$$reportNull$$$0(4);
        }
        return nlComponent;
    }

    @NotNull
    public NlComponent getNlComponent() {
        NlComponent nlComponent = this.myNlComponent;
        if (nlComponent == null) {
            SceneComponent.$$$reportNull$$$0(5);
        }
        return nlComponent;
    }

    @NotNull
    public Scene getScene() {
        Scene scene = this.myScene;
        if (scene == null) {
            SceneComponent.$$$reportNull$$$0(6);
        }
        return scene;
    }

    public List<SceneComponent> getChildren() {
        return this.myChildren;
    }

    public int getChildCount() {
        return this.myChildren.size();
    }

    public SceneComponent getChild(int i) {
        return this.myChildren.get(i);
    }

    public void setToolLocked(boolean locked) {
        this.myIsToolLocked = locked;
    }

    public boolean isToolLocked() {
        return this.myIsToolLocked;
    }

    @NotNull
    public Stream<SceneComponent> flatten() {
        Stream<SceneComponent> stream = Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(SceneComponent::flatten));
        if (stream == null) {
            SceneComponent.$$$reportNull$$$0(7);
        }
        return stream;
    }

    public void setDrawState(@NotNull DrawState drawState) {
        if (drawState == null) {
            SceneComponent.$$$reportNull$$$0(8);
        }
        DrawState oldState = this.myDrawState;
        this.myDrawState = drawState;
        if (this.myIsSelected) {
            this.myDrawState = DrawState.SELECTED;
        }
        if (oldState != this.myDrawState) {
            DecoratorUtilities.setTimeChange(this.myNlComponent, "view", DecoratorUtilities.mapState(drawState));
        }
    }

    public int getBaseline() {
        return Coordinates.pxToDp(this.getScene().getDesignSurface(), NlComponentHelperKt.getBaseline(this.myNlComponent));
    }

    public void setSelected(boolean selected) {
        if (!selected || !this.myIsSelected) {
            this.myShowBaseline = false;
        }
        this.myIsSelected = selected;
        if (this.myIsSelected) {
            this.setDrawState(DrawState.SELECTED);
        } else {
            this.setDrawState(DrawState.NORMAL);
        }
        for (Target target : this.getTargets()) {
            target.onComponentSelectionChanged(this.myIsSelected);
        }
    }

    public void setDragging(boolean dragging) {
        if (!this.getNlComponent().isRoot()) {
            this.myDragging = dragging;
        }
    }

    public boolean isDragging() {
        return this.myDragging;
    }

    public DrawState getDrawState() {
        return this.myDrawState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<Target> getTargets() {
        assert (ApplicationManager.getApplication().isDispatchThread());
        ArrayList<Target> arrayList = this.myTargets;
        synchronized (arrayList) {
            if (this.myCachedTargetList == null) {
                this.myCachedTargetList = ImmutableList.copyOf(this.myTargets);
            }
            return this.myCachedTargetList;
        }
    }

    public SceneDecorator getDecorator() {
        return this.myDecorator;
    }

    public Notch.Provider getNotchProvider() {
        return this.myNotchProvider;
    }

    public void setNotchProvider(Notch.Provider notchProvider) {
        this.myNotchProvider = notchProvider;
    }

    public void setExpandTargetArea(boolean expandArea) {
        for (Target target : this.getTargets()) {
            target.setExpandSize(expandArea);
        }
        this.myScene.needsRebuildList();
    }

    ResizeBaseTarget getResizeTarget(ResizeBaseTarget.Type type) {
        ImmutableList<Target> targets = this.getTargets();
        int count = targets.size();
        for (int i = 0; i < count; ++i) {
            ResizeBaseTarget target;
            if (!(targets.get(i) instanceof ResizeBaseTarget) || (target = (ResizeBaseTarget)targets.get(i)).getType() != type) continue;
            return target;
        }
        return null;
    }

    @Nullable
    public SceneComponent getSceneComponent(@NotNull String componentId) {
        if (componentId == null) {
            SceneComponent.$$$reportNull$$$0(9);
        }
        if (componentId.equalsIgnoreCase(this.myNlComponent.getId())) {
            return this;
        }
        int count = this.myChildren.size();
        for (int i = 0; i < count; ++i) {
            SceneComponent child = this.myChildren.get(i);
            SceneComponent found = child.getSceneComponent(componentId);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Nullable
    public SceneComponent getSceneComponent(@NotNull NlComponent nlComponent) {
        if (nlComponent == null) {
            SceneComponent.$$$reportNull$$$0(10);
        }
        if (nlComponent == this.myNlComponent) {
            return this;
        }
        for (SceneComponent child : this.getChildren()) {
            SceneComponent found = child.getSceneComponent(nlComponent);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public boolean intersects(Rectangle rectangle) {
        return rectangle.intersects(this.fillRect(null));
    }

    public void clearAttributes() {
        NlComponent component2 = this.getAuthoritativeNlComponent();
        ViewGroupHandler viewGroupHandler = NlComponentHelperKt.getViewGroupHandler(component2);
        viewGroupHandler.clearAttributes(component2);
        for (SceneComponent child : this.getChildren()) {
            viewGroupHandler.clearAttributes(child.getAuthoritativeNlComponent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTarget(@NotNull Target target) {
        if (target == null) {
            SceneComponent.$$$reportNull$$$0(11);
        }
        target.setComponent(this);
        ArrayList<Target> arrayList = this.myTargets;
        synchronized (arrayList) {
            this.myCachedTargetList = null;
            this.myTargets.add(target);
        }
    }

    public void addChild(@NotNull SceneComponent child) {
        if (child == null) {
            SceneComponent.$$$reportNull$$$0(12);
        }
        child.removeFromParent();
        child.setParent(this);
        this.myChildren.add(child);
    }

    public void removeFromParent() {
        SceneComponent parent = this.myParent;
        if (parent != null) {
            parent.remove(this);
        }
    }

    private void remove(@NotNull SceneComponent component2) {
        if (component2 == null) {
            SceneComponent.$$$reportNull$$$0(13);
        }
        if (this.myChildren.remove(component2)) {
            component2.myParent = null;
        }
    }

    public boolean layout(@NotNull SceneContext sceneTransform, long time) {
        if (sceneTransform == null) {
            SceneComponent.$$$reportNull$$$0(14);
        }
        boolean needsRebuildDisplayList = false;
        int left = this.myAnimatedDrawX.getValue(time);
        int top = this.myAnimatedDrawY.getValue(time);
        int right = left + this.myAnimatedDrawWidth.getValue(time);
        int bottom = top + this.myAnimatedDrawHeight.getValue(time);
        needsRebuildDisplayList |= this.myCurrentLeft != left;
        needsRebuildDisplayList |= this.myCurrentTop != top;
        needsRebuildDisplayList |= this.myCurrentRight != right;
        needsRebuildDisplayList |= this.myCurrentBottom != bottom;
        this.myCurrentLeft = left;
        this.myCurrentTop = top;
        this.myCurrentRight = right;
        this.myCurrentBottom = bottom;
        boolean animating = false;
        animating |= this.myAnimatedDrawX.isAnimating();
        animating |= this.myAnimatedDrawY.isAnimating();
        animating |= this.myAnimatedDrawWidth.isAnimating();
        needsRebuildDisplayList |= (animating |= this.myAnimatedDrawHeight.isAnimating());
        ImmutableList<Target> targets = this.getTargets();
        int num = targets.size();
        for (int i = 0; i < num; ++i) {
            Target target = (Target)targets.get(i);
            needsRebuildDisplayList |= target.layout(sceneTransform, this.myCurrentLeft, this.myCurrentTop, this.myCurrentRight, this.myCurrentBottom);
        }
        int childCount = this.myChildren.size();
        for (int i = 0; i < childCount; ++i) {
            SceneComponent child = this.myChildren.get(i);
            needsRebuildDisplayList |= child.layout(sceneTransform, time);
        }
        return needsRebuildDisplayList;
    }

    public Rectangle fillRect(@Nullable Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        rectangle.x = this.myCurrentLeft;
        rectangle.y = this.myCurrentTop;
        rectangle.width = this.myCurrentRight - this.myCurrentLeft;
        rectangle.height = this.myCurrentBottom - this.myCurrentTop;
        return rectangle;
    }

    public void addHit(@NotNull SceneContext sceneTransform, @NotNull ScenePicker picker) {
        if (sceneTransform == null) {
            SceneComponent.$$$reportNull$$$0(15);
        }
        if (picker == null) {
            SceneComponent.$$$reportNull$$$0(16);
        }
        if (this.myIsToolLocked) {
            return;
        }
        picker.addRect(this, 0, sceneTransform.getSwingXDip(this.myCurrentLeft), sceneTransform.getSwingYDip(this.myCurrentTop), sceneTransform.getSwingXDip(this.myCurrentRight), sceneTransform.getSwingYDip(this.myCurrentBottom));
        ImmutableList<Target> targets = this.getTargets();
        int num = targets.size();
        for (int i = 0; i < num; ++i) {
            Target target = (Target)targets.get(i);
            target.addHit(sceneTransform, picker);
        }
        int childCount = this.myChildren.size();
        for (int i = 0; i < childCount; ++i) {
            SceneComponent child = this.myChildren.get(i);
            if (child instanceof TemporarySceneComponent) continue;
            child.addHit(sceneTransform, picker);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void buildDisplayList(long time, @NotNull DisplayList list, SceneContext sceneContext) {
        void sceneContext2;
        if (list == null) {
            SceneComponent.$$$reportNull$$$0(17);
        }
        this.myDecorator.buildList(list, time, (SceneContext)sceneContext2, this);
    }

    @NotNull
    public Rectangle fillDrawRect(long time, @Nullable Rectangle rec) {
        if (rec == null) {
            rec = new Rectangle();
        }
        rec.x = this.getDrawX(time);
        rec.y = this.getDrawY(time);
        rec.width = this.getDrawWidth(time);
        rec.height = this.getDrawHeight(time);
        Rectangle rectangle = rec;
        if (rectangle == null) {
            SceneComponent.$$$reportNull$$$0(18);
        }
        return rectangle;
    }

    public String getId() {
        return this.myNlComponent.getId();
    }

    public boolean containsX(int xDp) {
        return this.getDrawX() <= xDp && xDp <= this.getDrawX() + this.getDrawWidth();
    }

    public boolean containsY(int yDp) {
        return this.getDrawY() <= yDp && yDp <= this.getDrawY() + this.getDrawHeight();
    }

    public void setTargetProvider(@Nullable TargetProvider targetProvider) {
        if (this.myTargetProvider == targetProvider) {
            return;
        }
        this.myTargetProvider = targetProvider;
        this.updateTargets();
        for (SceneComponent child : this.getChildren()) {
            child.updateTargets();
        }
    }

    public void setComponentProvider(@NotNull ComponentProvider provider) {
        if (provider == null) {
            SceneComponent.$$$reportNull$$$0(19);
        }
        this.myComponentProvider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTargets() {
        TargetProvider provider;
        ArrayList<Target> arrayList = this.myTargets;
        synchronized (arrayList) {
            this.myCachedTargetList = null;
            this.myTargets.clear();
        }
        SceneComponent parent = this.myParent;
        if (parent != null && (provider = parent.getTargetProvider()) != null) {
            provider.createChildTargets(parent, this).forEach(this::addTarget);
        }
        if ((provider = this.myTargetProvider) != null) {
            provider.createTargets(this).forEach(this::addTarget);
        }
        for (SceneComponent child : this.getChildren()) {
            child.updateTargets();
        }
    }

    public void setModelUpdateAuthorized(boolean modelUpdateAuthorized) {
        this.myIsModelUpdateAuthorized = modelUpdateAuthorized;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scene";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/scene/SceneComponent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawState";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nlComponent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneTransform";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "picker";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/scene/SceneComponent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthoritativeNlComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNlComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getScene";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "flatten";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "fillDrawRect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setParent";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 18: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setDrawState";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSceneComponent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addTarget";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "layout";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addHit";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildDisplayList";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setComponentProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class AnimatedValue {
        int value;
        int target;
        long startTime;
        int duration = 350;

        AnimatedValue() {
        }

        public void setValue(int v) {
            this.value = v;
            this.target = v;
            this.startTime = 0L;
        }

        public void setTarget(int v, long time) {
            if (this.target == v) {
                return;
            }
            this.startTime = time;
            this.target = v;
        }

        public int getValue(long time) {
            if (this.startTime == 0L) {
                this.target = this.value;
                return this.value;
            }
            float progress = (float)(time - this.startTime) / (float)this.duration;
            if (progress >= 1.0f) {
                this.value = this.target;
                return this.value;
            }
            if (progress <= 0.0f) {
                return this.value;
            }
            return (int)(0.5 + this.EaseInOutInterpolator(progress, this.value, this.target));
        }

        public boolean isAnimating() {
            return this.value != this.target;
        }

        double EaseInOutInterpolator(double progress, double begin, double end) {
            double change = (end - begin) / 2.0;
            if ((progress *= 2.0) < 1.0) {
                return change * progress * progress + begin;
            }
            return -change * ((progress -= 1.0) * (progress - 2.0) - 1.0) + begin;
        }
    }

    public static enum DrawState {
        SUBDUED,
        NORMAL,
        HOVER,
        SELECTED,
        DRAG;

    }
}

