/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DrawCommand;
import com.android.tools.idea.common.scene.draw.DrawComponentBackground;
import com.android.tools.idea.common.scene.draw.DrawNlComponentFrame;
import com.android.tools.idea.common.scene.draw.DrawTextRegion;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawAnchor;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnection;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnectionUtils;
import com.android.tools.idea.uibuilder.scene.decorator.ButtonDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.CheckBoxDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.ImageViewDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.LinearLayoutDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.ProgressBarDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.RadioButtonDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.SeekBarDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.SwitchDecorator;
import com.android.tools.idea.uibuilder.scene.draw.DrawResize;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class DisplayList {
    private static final boolean DEBUG = false;
    private ArrayList<DrawCommand> myCommands = new ArrayList();
    static HashMap<String, Function<String, ? extends DrawCommand>> ourBuildMap = new HashMap();

    public void clear() {
        this.myCommands.clear();
    }

    public ArrayList<DrawCommand> getCommands() {
        return this.myCommands;
    }

    public void add(DrawCommand cmd) {
        this.myCommands.add(cmd);
    }

    public UNClip addClip(SceneContext context, Rectangle r) {
        int l = context.getSwingXDip(r.x);
        int t = context.getSwingYDip(r.y);
        int w = context.getSwingDimensionDip(r.width);
        int h = context.getSwingDimensionDip(r.height);
        Clip c = new Clip(l, t, w, h);
        this.myCommands.add(c);
        return new UNClip(c);
    }

    public void addRect(SceneContext context, Rectangle r, Color color) {
        int l = context.getSwingXDip(r.x);
        int t = context.getSwingYDip(r.y);
        int w = context.getSwingDimensionDip(r.width);
        int h = context.getSwingDimensionDip(r.height);
        this.myCommands.add(new Rect(l, t, w, h, color));
    }

    public void addRect(SceneContext context, float left, float top, float right, float bottom, Color color) {
        int l = context.getSwingXDip(left);
        int t = context.getSwingYDip(top);
        int w = context.getSwingDimensionDip(right - left);
        int h = context.getSwingDimensionDip(bottom - top);
        this.add(new Rect(l, t, w, h, color));
    }

    public void addConnection(SceneContext context, float x1, float y1, float x2, float y2, int direction) {
        int sx1 = context.getSwingXDip(x1);
        int sy1 = context.getSwingYDip(y1);
        int sx2 = context.getSwingXDip(x2);
        int sy2 = context.getSwingYDip(y2);
        this.add(new Connection(sx1, sy1, sx2, sy2, direction));
    }

    public void addLine(SceneContext context, float x1, float y1, float x2, float y2, Color color) {
        this.add(new Line(context, x1, y1, x2, y2, color));
    }

    public void paint(Graphics2D g2, SceneContext sceneContext) {
        int count = this.myCommands.size();
        if (count == 0) {
            return;
        }
        Graphics2D g = (Graphics2D)g2.create();
        DrawCommand[] array = this.myCommands.toArray(new DrawCommand[this.myCommands.size()]);
        CommandSet set = new CommandSet(array, 0, array.length - 1);
        set.sort();
        set.paint(g, sceneContext);
        g.dispose();
    }

    public String generateSortedDisplayList(SceneContext sceneContext) {
        DrawCommand[] array = this.myCommands.toArray(new DrawCommand[this.myCommands.size()]);
        CommandSet set = new CommandSet(array, 0, array.length - 1);
        set.sort();
        return set.serialize();
    }

    public String serialize() {
        String str = "";
        int count = this.myCommands.size();
        for (int i = 0; i < count; ++i) {
            DrawCommand command = this.myCommands.get(i);
            str = str + command.serialize() + "\n";
        }
        return str;
    }

    public DrawCommand getCommand(int level) {
        DrawCommand[] array = this.myCommands.toArray(new DrawCommand[this.myCommands.size()]);
        return new CommandSet(array, 0, array.length - 1, level);
    }

    public static void addListElementConstructor(Class<? extends DrawCommand> c) {
        ourBuildMap.put(c.getSimpleName(), s -> {
            try {
                return (DrawCommand)c.getConstructor(String.class).newInstance(s);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                Logger.getInstance(DisplayList.class).error((Throwable)e);
                return null;
            }
        });
    }

    public static void addListElementProvider(Class<? extends DrawCommand> c, Function<String, ? extends DrawCommand> provider) {
        ourBuildMap.put(c.getSimpleName(), provider);
    }

    @Nullable
    private static DrawCommand get(String cmd, String args) {
        return ourBuildMap.get(cmd).apply(args);
    }

    public static DisplayList getDisplayList(String str) {
        DisplayList list = new DisplayList();
        String[] sp = str.split("\n");
        Clip lastClip = null;
        for (int i = 0; i < sp.length; ++i) {
            String args;
            String cmd;
            String s = sp[i];
            if (s.indexOf(44) > 0) {
                cmd = s.substring(0, s.indexOf(44));
                args = s.substring(s.indexOf(44) + 1);
            } else {
                cmd = s;
                args = "";
            }
            DrawCommand drawCommand = DisplayList.get(cmd, args);
            list.add(drawCommand);
            if (drawCommand instanceof Clip) {
                lastClip = (Clip)drawCommand;
            }
            if (!(drawCommand instanceof UNClip)) continue;
            UNClip unclip = (UNClip)drawCommand;
            unclip.setClip(lastClip);
        }
        return list;
    }

    static {
        DisplayList.addListElementConstructor(Connection.class);
        DisplayList.addListElementConstructor(Rect.class);
        DisplayList.addListElementConstructor(Clip.class);
        DisplayList.addListElementConstructor(UNClip.class);
        DisplayList.addListElementConstructor(Line.class);
        DisplayList.addListElementConstructor(DrawConnection.class);
        DisplayList.addListElementConstructor(DrawResize.class);
        DisplayList.addListElementConstructor(DrawAnchor.class);
        DisplayList.addListElementConstructor(DrawComponentBackground.class);
        DisplayList.addListElementConstructor(DrawNlComponentFrame.class);
        DisplayList.addListElementConstructor(ProgressBarDecorator.DrawProgressBar.class);
        DisplayList.addListElementConstructor(LinearLayoutDecorator.DrawLinearLayout.class);
        DisplayList.addListElementConstructor(ImageViewDecorator.DrawImageView.class);
        DisplayList.addListElementConstructor(SeekBarDecorator.DrawSeekBar.class);
        DisplayList.addListElementProvider(DrawTextRegion.class, DrawTextRegion::createFromString);
        DisplayList.addListElementProvider(ButtonDecorator.DrawButton.class, ButtonDecorator.DrawButton::createFromString);
        DisplayList.addListElementProvider(SwitchDecorator.DrawSwitch.class, SwitchDecorator.DrawSwitch::createFromString);
        DisplayList.addListElementProvider(RadioButtonDecorator.DrawRadioButton.class, RadioButtonDecorator.DrawRadioButton::createFromString);
        DisplayList.addListElementProvider(CheckBoxDecorator.DrawCheckbox.class, CheckBoxDecorator.DrawCheckbox::createFromString);
    }

    static class CommandSet
    implements DrawCommand {
        private ArrayList<DrawCommand> myCommands = new ArrayList();
        private int myLevel;

        CommandSet(DrawCommand[] commands, int start, int end) {
            this(commands, start, end, 20);
        }

        CommandSet(DrawCommand[] commands, int start, int end, int level) {
            this.myLevel = level;
            if (commands.length == 0) {
                return;
            }
            int first = CommandSet.findFirstClip(commands, start, end);
            int last = CommandSet.findLastUnClip(commands, start, end);
            if (first == start && last == end) {
                this.myCommands.add(commands[start]);
                for (int i = start + 1; i < end; ++i) {
                    DrawCommand cmd = commands[i];
                    if (cmd instanceof Clip) {
                        int n = CommandSet.findNextUnClip(commands, i + 1, end - 1);
                        cmd = new CommandSet(commands, i, n);
                        i = Math.max(n, i);
                    }
                    this.myCommands.add(cmd);
                }
                this.myCommands.add(commands[end]);
            } else if (first != -1 && last != -1) {
                int i;
                for (i = start; i < first; ++i) {
                    this.myCommands.add(commands[i]);
                }
                this.myCommands.add(new CommandSet(commands, first, last));
                for (i = last + 1; i <= end; ++i) {
                    this.myCommands.add(commands[i]);
                }
            } else {
                for (int i = start; i <= end; ++i) {
                    this.myCommands.add(commands[i]);
                }
            }
        }

        private static int findFirstClip(DrawCommand[] commands, int start, int end) {
            for (int i = start; i < end; ++i) {
                if (!(commands[i] instanceof Clip)) continue;
                return i;
            }
            return -1;
        }

        private static int findLastUnClip(DrawCommand[] commands, int start, int end) {
            for (int i = end; i > start; --i) {
                if (!(commands[i] instanceof UNClip)) continue;
                return i;
            }
            return -1;
        }

        private static int findNextUnClip(DrawCommand[] commands, int start, int end) {
            int count = 0;
            for (int i = start; i <= end; ++i) {
                if (commands[i] instanceof Clip) {
                    ++count;
                }
                if (!(commands[i] instanceof UNClip)) continue;
                if (count == 0) {
                    return i;
                }
                --count;
            }
            return -1;
        }

        public void sort() {
            this.myCommands.sort(Comparator.comparingInt(DrawCommand::getLevel));
            this.myCommands.forEach(command -> {
                if (command instanceof CommandSet) {
                    ((CommandSet)command).sort();
                }
            });
        }

        @Override
        public int getLevel() {
            return this.myLevel;
        }

        @Override
        public void paint(Graphics2D g2, SceneContext sceneContext) {
            for (int i = 0; i < this.myCommands.size(); ++i) {
                this.myCommands.get(i).paint(g2, sceneContext);
            }
        }

        public void print(String s) {
            this.myCommands.forEach(command -> {
                if (command instanceof CommandSet) {
                    ((CommandSet)command).print(s + ">");
                } else {
                    System.out.println(s + command.serialize());
                }
            });
        }

        @Override
        public String serialize() {
            String str = "";
            for (DrawCommand command : this.myCommands) {
                str = str + command.serialize() + "\n";
            }
            return str;
        }
    }

    static class Line
    implements DrawCommand {
        Color color;
        int x1;
        int y1;
        int x2;
        int y2;

        @Override
        public String serialize() {
            return "Line," + this.x1 + "," + this.y1 + "," + this.x2 + "," + this.y2 + "," + Integer.toHexString(this.color.getRGB());
        }

        @Override
        public int getLevel() {
            return 50;
        }

        Line(String s) {
            String[] sp = s.split(",");
            int c = 0;
            this.x1 = Integer.parseInt(sp[c++]);
            this.y1 = Integer.parseInt(sp[c++]);
            this.x2 = Integer.parseInt(sp[c++]);
            this.y2 = Integer.parseInt(sp[c++]);
            this.color = new Color((int)Long.parseLong(sp[c], 16));
        }

        Line(SceneContext transform2, float x1, float y1, float x2, float y2, Color c) {
            this.x1 = transform2.getSwingXDip(x1);
            this.y1 = transform2.getSwingYDip(y1);
            this.x2 = transform2.getSwingXDip(x2);
            this.y2 = transform2.getSwingYDip(y2);
            this.color = c;
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            g.setColor(this.color);
            g.drawLine(this.x1, this.y1, this.x2, this.y2);
        }
    }

    public static class UNClip
    implements DrawCommand {
        Clip lastClip;

        @Override
        public String serialize() {
            return "UNClip";
        }

        @Override
        public int getLevel() {
            return 1000;
        }

        public UNClip(String s) {
        }

        public UNClip(Clip s) {
            this.lastClip = s;
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            g.setClip(this.lastClip.getOriginalShape());
        }

        public void setClip(Clip clip) {
            this.lastClip = clip;
        }
    }

    static class Clip
    extends Rectangle
    implements DrawCommand {
        Shape myOriginal;

        @Override
        public String serialize() {
            return "Clip," + this.x + "," + this.y + "," + this.width + "," + this.height;
        }

        @Override
        public int getLevel() {
            return 0;
        }

        Clip(String s) {
            String[] sp = s.split(",");
            int c = 0;
            this.x = Integer.parseInt(sp[c++]);
            this.y = Integer.parseInt(sp[c++]);
            this.width = Integer.parseInt(sp[c++]);
            this.height = Integer.parseInt(sp[c]);
        }

        Clip(int x, int y, int width, int height) {
            super(x, y, width, height);
        }

        public Shape getOriginalShape() {
            return this.myOriginal;
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            this.myOriginal = g.getClip();
            g.clipRect(this.x, this.y, this.width, this.height);
        }
    }

    static class Rect
    extends Rectangle
    implements DrawCommand {
        Color color;

        @Override
        public String serialize() {
            return "Rect," + this.x + "," + this.y + "," + this.width + "," + this.height + "," + Integer.toHexString(this.color.getRGB());
        }

        Rect(String s) {
            String[] sp = s.split(",");
            int c = 0;
            this.x = Integer.parseInt(sp[c++]);
            this.y = Integer.parseInt(sp[c++]);
            this.width = Integer.parseInt(sp[c++]);
            this.height = Integer.parseInt(sp[c++]);
            this.color = new Color((int)Long.parseLong(sp[c], 16));
        }

        Rect(int x, int y, int width, int height, Color c) {
            super(x, y, width, height);
            this.color = c;
        }

        @Override
        public int getLevel() {
            return 20;
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            g.setColor(this.color);
            g.drawRect(this.x, this.y, this.width, this.height);
        }
    }

    static class Connection
    implements DrawCommand {
        int x1;
        int y1;
        int x2;
        int y2;
        int myDirection;
        private static final int DIR_LEFT = 0;
        private static final int DIR_TOP = 1;
        private static final int DIR_RIGHT = 2;
        private static final int DIR_BOTTOM = 3;
        private static final int DIR_BASELINE = 4;

        @Override
        public int getLevel() {
            return 100;
        }

        @Override
        public String serialize() {
            return "Connection," + this.x1 + "," + this.y1 + "," + this.x2 + "," + this.y2 + this.myDirection;
        }

        Connection(String s) {
            String[] sp = s.split(",");
            int c = 0;
            this.x1 = Integer.parseInt(sp[c++]);
            this.y1 = Integer.parseInt(sp[c++]);
            this.x2 = Integer.parseInt(sp[c++]);
            this.y2 = Integer.parseInt(sp[c++]);
            this.myDirection = Integer.parseInt(sp[c]);
        }

        Connection(int x1, int y1, int x2, int y2, int direction) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.myDirection = direction;
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            g.setColor(sceneContext.getColorSet().getAnchorConnectionCircle());
            int start_dx = 0;
            int start_dy = 0;
            int end_dx = 0;
            int end_dy = 0;
            int scale = 20;
            int arrowDirection = 0;
            int arrowX = this.x2;
            int arrowY = this.y2;
            int arrowGap = 5;
            switch (this.myDirection) {
                case 0: {
                    start_dx = -scale;
                    end_dx = this.x2 > this.x1 ? -scale : scale;
                    arrowDirection = this.x2 > this.x1 ? 0 : 1;
                    arrowX += this.x2 > this.x1 ? -arrowGap : arrowGap;
                    break;
                }
                case 1: {
                    start_dy = -10;
                    end_dy = this.y2 > this.y1 ? -scale : scale;
                    arrowDirection = this.y2 > this.y1 ? 2 : 3;
                    arrowY += this.y2 > this.y1 ? -arrowGap : arrowGap;
                    break;
                }
                case 2: {
                    end_dx = this.x2 > this.x1 ? -scale : scale;
                    start_dx = scale;
                    arrowDirection = this.x2 > this.x1 ? 0 : 1;
                    arrowX += this.x2 > this.x1 ? -arrowGap : arrowGap;
                    break;
                }
                case 3: {
                    start_dy = scale;
                    end_dy = this.y2 > this.y1 ? -scale : scale;
                    arrowDirection = this.y2 > this.y1 ? 2 : 3;
                    arrowY += this.y2 > this.y1 ? -arrowGap : arrowGap;
                    break;
                }
                case 4: {
                    start_dy = -scale;
                    end_dy = this.y2 > this.y1 ? -scale : scale;
                    arrowDirection = this.y2 > this.y1 ? 2 : 3;
                    arrowY += this.y2 > this.y1 ? -arrowGap : arrowGap;
                }
            }
            GeneralPath path = new GeneralPath();
            path.moveTo(this.x1, this.y1);
            path.curveTo(this.x1 + start_dx, this.y1 + start_dy, this.x2 + end_dx, this.y2 + end_dy, arrowX, arrowY);
            g.draw(path);
            int[] xPoints = new int[3];
            int[] yPoints = new int[3];
            DrawConnectionUtils.getArrow(arrowDirection, this.x2, this.y2, xPoints, yPoints);
            g.fillPolygon(xPoints, yPoints, 3);
        }
    }
}

