/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;

public class DrawComponentFrame
extends DrawRegion {
    public static final int SUBDUED = 0;
    public static final int NORMAL = 1;
    public static final int OVER = 2;
    public static final int SELECTED = 3;
    private static final Stroke myNormalStroke = new BasicStroke(1.0f);
    private static final Stroke myDragReceiverStroke = new BasicStroke(3.0f);
    private final int myMode;

    public DrawComponentFrame(String s) {
        String[] sp = s.split(",");
        int c = 0;
        c = super.parse(sp, c);
        this.myMode = Integer.parseInt(sp[c]);
    }

    @Override
    public int getLevel() {
        return 20;
    }

    public DrawComponentFrame(int x, int y, int width, int height, int mode) {
        super(x, y, width, height);
        this.myMode = mode;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet colorSet = sceneContext.getColorSet();
        Color[] colorFrame = new Color[]{colorSet.getSubduedFrames(), colorSet.getFrames(), colorSet.getHighlightedFrames(), colorSet.getSelectedFrames(), colorSet.getDragReceiverFrames()};
        Stroke previousStroke = g.getStroke();
        Color previousColor = g.getColor();
        g.setStroke(myNormalStroke);
        g.setColor(colorFrame[this.myMode]);
        g.drawRect(this.x, this.y, this.width, this.height);
        g.setStroke(previousStroke);
        g.setColor(previousColor);
    }

    @Override
    public String serialize() {
        return super.serialize() + "," + this.myMode;
    }

    public static void add(DisplayList list, SceneContext sceneContext, Rectangle rect, int mode) {
        int l = sceneContext.getSwingXDip(rect.x);
        int t = sceneContext.getSwingYDip(rect.y);
        int w = sceneContext.getSwingDimensionDip(rect.width);
        int h = sceneContext.getSwingDimensionDip(rect.height);
        list.add(new DrawComponentFrame(l, t, w, h, mode));
    }
}

