/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.LerpValue;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DrawCommand;
import com.android.tools.idea.common.scene.draw.DrawCommandSerializationHelperKt;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007B%\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\tH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/common/scene/draw/DrawFilledCircle;", "Lcom/android/tools/idea/common/scene/draw/DrawCommand;", "sp", "", "", "([Ljava/lang/String;)V", "s", "(Ljava/lang/String;)V", "myLevel", "", "myCenter", "Ljava/awt/Point;", "myColor", "Ljava/awt/Color;", "myRadius", "Lcom/android/tools/idea/common/scene/LerpValue;", "(ILjava/awt/Point;Ljava/awt/Color;Lcom/android/tools/idea/common/scene/LerpValue;)V", "getLevel", "paint", "", "g", "Ljava/awt/Graphics2D;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "serialize", "intellij.android.designer"})
public final class DrawFilledCircle
implements DrawCommand {
    private final int myLevel;
    private final Point myCenter;
    private final Color myColor;
    private final LerpValue myRadius;

    @Override
    public int getLevel() {
        return this.myLevel;
    }

    @Override
    @NotNull
    public String serialize() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        return DrawCommandSerializationHelperKt.buildString(string, this.myLevel, DrawCommandSerializationHelperKt.pointToString(this.myCenter), DrawCommandSerializationHelperKt.colorToString(this.myColor), DrawCommandSerializationHelperKt.lerpToString(this.myRadius));
    }

    @Override
    public void paint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        Graphics g2;
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        int r = this.myRadius.getValue(sceneContext.getTime());
        Graphics graphics = g2 = g.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)graphics, (String)"g2");
        graphics.setColor(this.myColor);
        g2.fillOval(this.myCenter.x - r, this.myCenter.y - r, 2 * r, 2 * r);
        g2.dispose();
        if (r != this.myRadius.getEnd()) {
            sceneContext.repaint();
        }
    }

    public DrawFilledCircle(int myLevel, @NotNull Point myCenter, @NotNull Color myColor, @NotNull LerpValue myRadius) {
        Intrinsics.checkParameterIsNotNull((Object)myCenter, (String)"myCenter");
        Intrinsics.checkParameterIsNotNull((Object)myColor, (String)"myColor");
        Intrinsics.checkParameterIsNotNull((Object)myRadius, (String)"myRadius");
        this.myLevel = myLevel;
        this.myCenter = myCenter;
        this.myColor = myColor;
        this.myRadius = myRadius;
    }

    private DrawFilledCircle(String[] sp) {
        String string = sp[0];
        DrawFilledCircle drawFilledCircle = this;
        int n = Integer.parseInt(string);
        drawFilledCircle(n, DrawCommandSerializationHelperKt.stringToPoint(sp[1]), DrawCommandSerializationHelperKt.stringToColor(sp[2]), DrawCommandSerializationHelperKt.stringToLerp(sp[3]));
    }

    public DrawFilledCircle(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this(DrawCommandSerializationHelperKt.parse(s, 4));
    }
}

