/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DrawCommand;
import com.android.tools.idea.common.scene.draw.DrawCommandSerializationHelperKt;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007B-\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/common/scene/draw/DrawLine;", "Lcom/android/tools/idea/common/scene/draw/DrawCommand;", "sp", "", "", "([Ljava/lang/String;)V", "s", "(Ljava/lang/String;)V", "myLevel", "", "myFrom", "Ljava/awt/Point;", "myTo", "myColor", "Ljava/awt/Color;", "myStroke", "Ljava/awt/BasicStroke;", "(ILjava/awt/Point;Ljava/awt/Point;Ljava/awt/Color;Ljava/awt/BasicStroke;)V", "getLevel", "paint", "", "g", "Ljava/awt/Graphics2D;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "serialize", "intellij.android.designer"})
public final class DrawLine
implements DrawCommand {
    private final int myLevel;
    private final Point myFrom;
    private final Point myTo;
    private final Color myColor;
    private final BasicStroke myStroke;

    @Override
    public int getLevel() {
        return this.myLevel;
    }

    @Override
    @NotNull
    public String serialize() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        return DrawCommandSerializationHelperKt.buildString(string, this.myLevel, DrawCommandSerializationHelperKt.pointToString(this.myFrom), DrawCommandSerializationHelperKt.pointToString(this.myTo), DrawCommandSerializationHelperKt.colorToString(this.myColor), DrawCommandSerializationHelperKt.strokeToString(this.myStroke));
    }

    @Override
    public void paint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        Graphics graphics = g.create();
        if (graphics == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setColor(this.myColor);
        g2.setStroke(this.myStroke);
        g2.drawLine(this.myFrom.x, this.myFrom.y, this.myTo.x, this.myTo.y);
        g2.dispose();
    }

    public DrawLine(int myLevel, @NotNull Point myFrom, @NotNull Point myTo, @NotNull Color myColor, @NotNull BasicStroke myStroke) {
        Intrinsics.checkParameterIsNotNull((Object)myFrom, (String)"myFrom");
        Intrinsics.checkParameterIsNotNull((Object)myTo, (String)"myTo");
        Intrinsics.checkParameterIsNotNull((Object)myColor, (String)"myColor");
        Intrinsics.checkParameterIsNotNull((Object)myStroke, (String)"myStroke");
        this.myLevel = myLevel;
        this.myFrom = myFrom;
        this.myTo = myTo;
        this.myColor = myColor;
        this.myStroke = myStroke;
    }

    private DrawLine(String[] sp) {
        String string = sp[0];
        DrawLine drawLine = this;
        int n = Integer.parseInt(string);
        drawLine(n, DrawCommandSerializationHelperKt.stringToPoint(sp[1]), DrawCommandSerializationHelperKt.stringToPoint(sp[2]), DrawCommandSerializationHelperKt.stringToColor(sp[3]), DrawCommandSerializationHelperKt.stringToStroke(sp[4]));
    }

    public DrawLine(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this(DrawCommandSerializationHelperKt.parse(s, 5));
    }
}

