/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DrawCommand;
import com.android.tools.idea.common.scene.draw.DrawCommandSerializationHelperKt;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0012\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007B5\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0017\u001a\u00020\tH\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0003H\u0016J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/common/scene/draw/DrawTruncatedText;", "Lcom/android/tools/idea/common/scene/draw/DrawCommand;", "s", "", "(Ljava/lang/String;)V", "sp", "", "([Ljava/lang/String;)V", "myLevel", "", "myText", "myRectangle", "Ljava/awt/Rectangle;", "myColor", "Ljava/awt/Color;", "myFont", "Ljava/awt/Font;", "myIsCentered", "", "(ILjava/lang/String;Ljava/awt/Rectangle;Ljava/awt/Color;Ljava/awt/Font;Z)V", "myTruncatedText", "myX", "myY", "getLevel", "paint", "", "g", "Ljava/awt/Graphics2D;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "serialize", "truncateText", "metrics", "Ljava/awt/FontMetrics;", "intellij.android.designer"})
public final class DrawTruncatedText
implements DrawCommand {
    private String myTruncatedText;
    private int myX;
    private int myY;
    private int myLevel;
    private String myText;
    private final Rectangle myRectangle;
    private final Color myColor;
    private final Font myFont;
    private final boolean myIsCentered;

    @Override
    public int getLevel() {
        return this.myLevel;
    }

    @Override
    @NotNull
    public String serialize() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        return DrawCommandSerializationHelperKt.buildString(string, this.myLevel, this.myText, DrawCommandSerializationHelperKt.rectToString(this.myRectangle), DrawCommandSerializationHelperKt.colorToString(this.myColor), DrawCommandSerializationHelperKt.fontToString(this.myFont), this.myIsCentered);
    }

    @Override
    public void paint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        Graphics g2;
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        FontMetrics fontMetrics = g.getFontMetrics(this.myFont);
        CharSequence charSequence = this.myTruncatedText;
        if (charSequence.length() == 0) {
            FontMetrics fontMetrics2 = fontMetrics;
            Intrinsics.checkExpressionValueIsNotNull((Object)fontMetrics2, (String)"fontMetrics");
            this.myTruncatedText = this.truncateText(fontMetrics2);
            this.myX = this.myRectangle.x;
            this.myY = this.myRectangle.y + this.myRectangle.height;
            if (this.myIsCentered) {
                this.myX += (this.myRectangle.width - fontMetrics.stringWidth(this.myTruncatedText)) / 2;
                this.myY -= (this.myRectangle.height - fontMetrics.getAscent()) / 2;
            }
        }
        Graphics graphics = g2 = g.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)graphics, (String)"g2");
        graphics.setColor(this.myColor);
        g2.setFont(this.myFont);
        g2.drawString(this.myTruncatedText, this.myX, this.myY);
        g2.dispose();
    }

    /*
     * WARNING - void declaration
     */
    private final String truncateText(FontMetrics metrics) {
        String string;
        if (metrics.stringWidth(this.myText) <= this.myRectangle.width) {
            return this.myText;
        }
        int ellipsisWidth = metrics.stringWidth("...");
        String string2 = string = this.myText;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string2.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] array = cArray;
        int n = array.length;
        boolean bl = false;
        while (n >= 0) {
            void i;
            if (metrics.charsWidth(array, 0, (int)i) + ellipsisWidth < this.myRectangle.width) {
                int n2 = 0;
                StringBuilder stringBuilder = new StringBuilder();
                String string3 = new String(array, n2, (int)i);
                return stringBuilder.append(string3).append("...").toString();
            }
            --i;
        }
        return "...";
    }

    public DrawTruncatedText(int myLevel, @NotNull String myText, @NotNull Rectangle myRectangle, @NotNull Color myColor, @NotNull Font myFont, boolean myIsCentered) {
        Intrinsics.checkParameterIsNotNull((Object)myText, (String)"myText");
        Intrinsics.checkParameterIsNotNull((Object)myRectangle, (String)"myRectangle");
        Intrinsics.checkParameterIsNotNull((Object)myColor, (String)"myColor");
        Intrinsics.checkParameterIsNotNull((Object)myFont, (String)"myFont");
        this.myLevel = myLevel;
        this.myText = myText;
        this.myRectangle = myRectangle;
        this.myColor = myColor;
        this.myFont = myFont;
        this.myIsCentered = myIsCentered;
        this.myTruncatedText = "";
    }

    public DrawTruncatedText(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this(DrawCommandSerializationHelperKt.parse(s, 6));
    }

    private DrawTruncatedText(String[] sp) {
        String string = sp[0];
        DrawTruncatedText drawTruncatedText = this;
        int n = Integer.parseInt(string);
        string = sp[5];
        Font font = DrawCommandSerializationHelperKt.stringToFont(sp[4]);
        Color color = DrawCommandSerializationHelperKt.stringToColor(sp[3]);
        Rectangle rectangle = DrawCommandSerializationHelperKt.stringToRect(sp[2]);
        String string2 = sp[1];
        boolean bl = Boolean.parseBoolean(string);
        drawTruncatedText(n, string2, rectangle, color, font, bl);
    }
}

