/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.idea.common.editor.ActionManager;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlLayoutType;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurfaceActionHandler;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionManager;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.PanZoomListener;
import com.android.tools.idea.common.surface.SceneLayer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.ZoomType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.idea.uibuilder.error.IssueModel;
import com.android.tools.idea.uibuilder.error.IssuePanel;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.android.tools.idea.uibuilder.surface.ConstraintsLayer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.Magnificator;
import com.intellij.util.Alarm;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.plaf.ScrollBarUI;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DesignSurface
extends EditorDesignSurface
implements Disposable,
DataProvider {
    private static final Integer LAYER_PROGRESS = JLayeredPane.POPUP_LAYER + 100;
    private final Project myProject;
    protected double myScale;
    @NotNull
    protected final JScrollPane myScrollPane;
    private final MyLayeredPane myLayeredPane;
    @NotNull
    public ImmutableList<Layer> myLayers;
    private final InteractionManager myInteractionManager;
    private final GlassPane myGlassPane;
    protected final List<DesignSurfaceListener> myListeners;
    private List<PanZoomListener> myZoomListeners;
    private final ActionManager myActionManager;
    @NotNull
    private WeakReference<FileEditor> myFileEditorDelegate;
    @Nullable
    protected NlModel myModel;
    private SceneManager mySceneManager;
    private final SelectionModel mySelectionModel;
    private final RenderListener myRenderListener;
    private final ModelListener myModelListener;
    private final IssueModel myIssueModel;
    private final IssuePanel myIssuePanel;
    private final Object myErrorQueueLock;
    private MergingUpdateQueue myErrorQueue;
    private boolean myIsActive;
    private String myDescriptionString;
    private boolean mySkipResizeContent;
    private boolean mySkipResizeContentOnce;
    private final ConfigurationListener myConfigurationListener;
    private ZoomType myCurrentZoomType;
    private Timer myRepaintTimer;
    private final SelectionListener mySelectionListener;
    private final List<ProgressIndicator> myProgressIndicators;
    private final MyProgressPanel myProgressPanel;

    public DesignSurface(@NotNull Project project, @NotNull Disposable parentDisposable) {
        if (project == null) {
            DesignSurface.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            DesignSurface.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myScale = 1.0;
        this.myLayers = ImmutableList.of();
        this.myListeners = new ArrayList<DesignSurfaceListener>();
        this.myFileEditorDelegate = new WeakReference<Object>(null);
        this.myRenderListener = this::modelRendered;
        this.myModelListener = (model, animate) -> this.repaint();
        this.myIssueModel = new IssueModel();
        this.myErrorQueueLock = new Object();
        this.myIsActive = false;
        this.myConfigurationListener = flags -> {
            if ((flags & 6) != 0 && !this.isLayoutDisabled()) {
                this.zoom(ZoomType.FIT_INTO);
            }
            return true;
        };
        this.myRepaintTimer = new Timer(15, actionEvent -> this.repaint());
        this.mySelectionListener = (model, selection) -> {
            if (this.getCurrentSceneView() != null) {
                this.notifySelectionListeners(selection);
            } else {
                this.notifySelectionListeners(Collections.emptyList());
            }
        };
        this.myProgressIndicators = new ArrayList<ProgressIndicator>();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myProject = project;
        this.setOpaque(true);
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.mySelectionModel = new SelectionModel();
        this.mySelectionModel.addListener(this.mySelectionListener);
        this.myInteractionManager = new InteractionManager(this);
        this.myLayeredPane = new MyLayeredPane();
        this.myLayeredPane.setBounds(0, 0, 100, 100);
        this.myGlassPane = new GlassPane();
        this.myLayeredPane.add((Component)this.myGlassPane, JLayeredPane.DRAG_LAYER);
        this.myProgressPanel = new MyProgressPanel();
        this.myProgressPanel.setName("Layout Editor Progress Panel");
        this.myLayeredPane.add((Component)this.myProgressPanel, LAYER_PROGRESS);
        this.myScrollPane = new MyScrollPane();
        this.myScrollPane.setViewportView(this.myLayeredPane);
        this.myScrollPane.setBorder(null);
        this.myScrollPane.setVerticalScrollBarPolicy(22);
        this.myScrollPane.setHorizontalScrollBarPolicy(32);
        this.myScrollPane.getHorizontalScrollBar().addAdjustmentListener(this::notifyPanningChanged);
        this.myScrollPane.getVerticalScrollBar().addAdjustmentListener(this::notifyPanningChanged);
        this.myScrollPane.getViewport().setBackground(this.getBackground());
        this.myIssuePanel = new IssuePanel(this, this.myIssueModel);
        Disposer.register((Disposable)this, (Disposable)this.myIssuePanel);
        this.add(this.myScrollPane);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (DesignSurface.this.isShowing() && DesignSurface.this.getWidth() > 0 && DesignSurface.this.getHeight() > 0 && (!DesignSurface.this.contentResizeSkipped() || DesignSurface.this.getFitScale(false) > DesignSurface.this.myScale)) {
                    DesignSurface.this.zoomToFit();
                } else {
                    DesignSurface.this.layoutContent();
                    DesignSurface.this.updateScrolledAreaSize();
                }
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
        this.myInteractionManager.startListening();
        this.myActionManager = this.createActionManager();
        this.myActionManager.registerActionsShortcuts(this.myLayeredPane);
    }

    public abstract float getSceneScalingFactor();

    public float getScreenScalingFactor() {
        return 1.0f;
    }

    @NotNull
    protected abstract ActionManager<? extends DesignSurface> createActionManager();

    @NotNull
    protected abstract SceneManager createSceneManager(@NotNull NlModel var1);

    protected abstract void layoutContent();

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DesignSurface.$$$reportNull$$$0(2);
        }
        return project;
    }

    @NotNull
    public NlLayoutType getLayoutType() {
        if (this.myModel == null) {
            NlLayoutType nlLayoutType = NlLayoutType.UNKNOWN;
            if (nlLayoutType == null) {
                DesignSurface.$$$reportNull$$$0(3);
            }
            return nlLayoutType;
        }
        NlLayoutType nlLayoutType = this.myModel.getType();
        if (nlLayoutType == null) {
            DesignSurface.$$$reportNull$$$0(4);
        }
        return nlLayoutType;
    }

    @NotNull
    public ActionManager getActionManager() {
        ActionManager actionManager = this.myActionManager;
        if (actionManager == null) {
            DesignSurface.$$$reportNull$$$0(5);
        }
        return actionManager;
    }

    public SelectionModel getSelectionModel() {
        return this.mySelectionModel;
    }

    @NotNull
    public ItemTransferable getSelectionAsTransferable() {
        ItemTransferable itemTransferable = this.getSelectionModel().getTransferable(this.myModel != null ? this.myModel.getId() : 0L);
        if (itemTransferable == null) {
            DesignSurface.$$$reportNull$$$0(6);
        }
        return itemTransferable;
    }

    @Nullable
    public NlModel getModel() {
        return this.myModel;
    }

    public void setModel(@Nullable NlModel model) {
        if (model == this.myModel) {
            return;
        }
        if (this.myModel != null) {
            this.myModel.getConfiguration().removeListener(this.myConfigurationListener);
            this.myModel.removeListener(this.myModelListener);
            this.mySceneManager.removeRenderListener(this.myRenderListener);
            this.removeLayers(this.mySceneManager.getLayers());
            Disposer.dispose((Disposable)this.mySceneManager);
        }
        this.myModel = model;
        if (model == null) {
            this.mySceneManager = null;
            return;
        }
        model.addListener(this.myModelListener);
        model.getConfiguration().addListener(this.myConfigurationListener);
        this.mySceneManager = this.createSceneManager(model);
        this.mySceneManager.addRenderListener(this.myRenderListener);
        if (this.getLayoutType().isSupportedByDesigner()) {
            this.myInteractionManager.startListening();
        } else {
            this.myInteractionManager.stopListening();
        }
        this.layoutContent();
        this.repaint();
        for (DesignSurfaceListener listener : ImmutableList.copyOf(this.myListeners)) {
            listener.modelChanged(this, model);
        }
        this.zoomToFit();
    }

    public void dispose() {
        this.myInteractionManager.stopListening();
        if (this.myModel != null) {
            this.myModel.getConfiguration().removeListener(this.myConfigurationListener);
            this.myModel.removeListener(this.myModelListener);
            this.mySceneManager.removeRenderListener(this.myRenderListener);
        }
    }

    @Nullable
    public abstract Dimension getScrolledAreaSize();

    @Nullable
    public Dimension updateScrolledAreaSize() {
        Dimension dimension = this.getScrolledAreaSize();
        if (dimension == null) {
            return null;
        }
        this.myLayeredPane.setSize(dimension.width, dimension.height);
        this.myLayeredPane.setPreferredSize(dimension);
        this.myScrollPane.revalidate();
        SceneView view = this.getCurrentSceneView();
        if (view != null) {
            this.myProgressPanel.setBounds(this.getContentOriginX(), this.getContentOriginY(), view.getSize().width, view.getSize().height);
        }
        return dimension;
    }

    public abstract int getContentOriginX();

    public abstract int getContentOriginY();

    public JComponent getPreferredFocusedComponent() {
        return this.myGlassPane;
    }

    public void needsRepaint() {
        if (!this.myRepaintTimer.isRunning()) {
            this.myRepaintTimer.setRepeats(false);
            this.myRepaintTimer.start();
        }
    }

    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        if (this.isFocusOwner()) {
            graphics.setColor(UIUtil.getFocusedBoundsColor());
            graphics.drawRect(this.getX(), this.getY(), this.getWidth() - 1, this.getHeight() - 1);
        }
    }

    @Nullable
    public SceneView getCurrentSceneView() {
        SceneManager sceneManager = this.getSceneManager();
        return sceneManager != null ? sceneManager.getSceneView() : null;
    }

    public void startDragDropInteraction() {
        for (Layer layer : this.myLayers) {
            SceneLayer sceneLayer;
            ConstraintsLayer constraintsLayer;
            if (layer instanceof ConstraintsLayer && !(constraintsLayer = (ConstraintsLayer)layer).isShowOnHover()) {
                constraintsLayer.setShowOnHover(true);
                this.repaint();
            }
            if (!(layer instanceof SceneLayer) || (sceneLayer = (SceneLayer)layer).isShowOnHover()) continue;
            sceneLayer.setShowOnHover(true);
            this.repaint();
        }
    }

    public void stopDragDropInteraction() {
        for (Layer layer : this.myLayers) {
            SceneLayer sceneLayer;
            ConstraintsLayer constraintsLayer;
            if (layer instanceof ConstraintsLayer && (constraintsLayer = (ConstraintsLayer)layer).isShowOnHover()) {
                constraintsLayer.setShowOnHover(false);
                this.repaint();
            }
            if (!(layer instanceof SceneLayer) || !(sceneLayer = (SceneLayer)layer).isShowOnHover()) continue;
            sceneLayer.setShowOnHover(false);
            this.repaint();
        }
    }

    @NotNull
    public abstract Dimension getContentSize(@Nullable Dimension var1);

    public void hover(int x, int y) {
        for (Layer layer : this.myLayers) {
            layer.hover(x, y);
        }
    }

    public void zoom(@NotNull ZoomType type) {
        if (type == null) {
            DesignSurface.$$$reportNull$$$0(7);
        }
        this.zoom(type, -1, -1);
    }

    public void zoom(@NotNull ZoomType type, int x, int y) {
        SceneComponent component2;
        Scene scene;
        if (type == null) {
            DesignSurface.$$$reportNull$$$0(8);
        }
        SceneView view = this.getCurrentSceneView();
        if (!(type != ZoomType.IN || x >= 0 && y >= 0 || view == null || this.getSelectionModel().isEmpty() || (scene = this.getScene()) == null || (component2 = scene.getSceneComponent(this.getSelectionModel().getPrimary())) == null)) {
            x = Coordinates.getSwingXDip(view, component2.getCenterX());
            y = Coordinates.getSwingYDip(view, component2.getCenterY());
        }
        this.myCurrentZoomType = type;
        switch (type) {
            case IN: {
                double currentScale = this.myScale * (double)this.getScreenScalingFactor();
                int current = (int)(currentScale * 100.0);
                double scale = (double)ZoomType.zoomIn(current) / 100.0 / (double)this.getScreenScalingFactor();
                this.setScale(scale, x, y);
                this.repaint();
                break;
            }
            case OUT: {
                double currentScale = this.myScale * (double)this.getScreenScalingFactor();
                int current = (int)(currentScale * 100.0);
                double scale = (double)ZoomType.zoomOut(current) / 100.0 / (double)this.getScreenScalingFactor();
                this.setScale(scale, x, y);
                this.repaint();
                break;
            }
            case ACTUAL: {
                this.setScale(1.0 / (double)this.getScreenScalingFactor());
                this.repaint();
                break;
            }
            case FIT: 
            case FIT_INTO: {
                if (this.getCurrentSceneView() == null) {
                    return;
                }
                this.setScale(this.getFitScale(type == ZoomType.FIT_INTO));
                this.repaint();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not yet implemented: " + (Object)((Object)type));
            }
        }
    }

    protected double getFitScale(boolean fitInto) {
        int availableWidth = this.myScrollPane.getWidth() - this.myScrollPane.getVerticalScrollBar().getWidth();
        int availableHeight = this.myScrollPane.getHeight() - this.myScrollPane.getHorizontalScrollBar().getHeight();
        return this.getFitScale(this.getPreferredContentSize(availableWidth, availableHeight), fitInto);
    }

    protected double getFitScale(Dimension size, boolean fitInto) {
        int availableWidth = this.myScrollPane.getWidth() - this.myScrollPane.getVerticalScrollBar().getWidth();
        int availableHeight = this.myScrollPane.getHeight() - this.myScrollPane.getHorizontalScrollBar().getHeight();
        Dimension padding = this.getDefaultOffset();
        double scaleX = size.width == 0 ? 1.0 : (double)(availableWidth -= padding.width) / (double)size.width;
        double scaleY = size.height == 0 ? 1.0 : (double)(availableHeight -= padding.height) / (double)size.height;
        double scale = Math.min(scaleX, scaleY);
        if (fitInto) {
            double min = 1.0 / (double)this.getScreenScalingFactor();
            scale = Math.min(min, scale);
        }
        return scale;
    }

    protected abstract Dimension getDefaultOffset();

    @NotNull
    protected abstract Dimension getPreferredContentSize(int var1, int var2);

    public void zoomActual() {
        this.zoom(ZoomType.ACTUAL);
    }

    public void zoomIn() {
        this.zoom(ZoomType.IN);
    }

    public void zoomOut() {
        this.zoom(ZoomType.OUT);
    }

    public void zoomToFit() {
        this.zoom(ZoomType.FIT);
    }

    public double getScale() {
        return this.myScale;
    }

    public void setScrollPosition(int x, int y) {
        this.setScrollPosition(new Point(x, y));
    }

    public void setScrollPosition(Point p) {
        JScrollBar horizontalScrollBar = this.myScrollPane.getHorizontalScrollBar();
        JScrollBar verticalScrollBar = this.myScrollPane.getVerticalScrollBar();
        p.setLocation(Math.max(horizontalScrollBar.getMinimum(), p.x), Math.max(verticalScrollBar.getMinimum(), p.y));
        p.setLocation(Math.min(horizontalScrollBar.getMaximum() - horizontalScrollBar.getVisibleAmount(), p.x), Math.min(verticalScrollBar.getMaximum() - verticalScrollBar.getVisibleAmount(), p.y));
        this.myScrollPane.getViewport().setViewPosition(p);
    }

    public Point getScrollPosition() {
        return this.myScrollPane.getViewport().getViewPosition();
    }

    private void setScale(double scale) {
        this.setScale(scale, -1, -1);
    }

    public void setScale(double scale, int x, int y) {
        if (scale < 0.0) {
            scale = -1.0;
        } else if (Math.abs(scale - 1.0) < 1.0E-4) {
            scale = 1.0;
        }
        Point oldViewPosition = this.getScrollPosition();
        if (x < 0 || y < 0) {
            x = oldViewPosition.x + this.myScrollPane.getWidth() / 2;
            y = oldViewPosition.y + this.myScrollPane.getHeight() / 2;
        }
        SceneView view = this.getCurrentSceneView();
        int androidX = 0;
        int androidY = 0;
        if (view != null) {
            androidX = Coordinates.getAndroidXDip(view, x);
            androidY = Coordinates.getAndroidYDip(view, y);
        }
        this.myScale = Math.min(Math.max(scale, this.getMinScale()), this.getMaxScale());
        this.layoutContent();
        this.updateScrolledAreaSize();
        if (view != null) {
            int shiftedX = Coordinates.getSwingXDip(view, androidX);
            int shiftedY = Coordinates.getSwingYDip(view, androidY);
            this.myScrollPane.getViewport().setViewPosition(new Point(oldViewPosition.x + shiftedX - x, oldViewPosition.y + shiftedY - y));
        }
        this.notifyScaleChanged();
    }

    protected double getMinScale() {
        return 0.0;
    }

    protected double getMaxScale() {
        return 1.0;
    }

    private void notifyScaleChanged() {
        if (this.myZoomListeners != null) {
            for (PanZoomListener myZoomListener : this.myZoomListeners) {
                myZoomListener.zoomChanged(this);
            }
        }
    }

    private void notifyPanningChanged(AdjustmentEvent adjustmentEvent) {
        if (this.myZoomListeners != null) {
            for (PanZoomListener myZoomListener : this.myZoomListeners) {
                myZoomListener.panningChanged(adjustmentEvent);
            }
        }
    }

    @NotNull
    public JComponent getLayeredPane() {
        MyLayeredPane myLayeredPane = this.myLayeredPane;
        if (myLayeredPane == null) {
            DesignSurface.$$$reportNull$$$0(9);
        }
        return myLayeredPane;
    }

    private void notifySelectionListeners(@NotNull List<NlComponent> newSelection) {
        if (newSelection == null) {
            DesignSurface.$$$reportNull$$$0(10);
        }
        ArrayList listeners = Lists.newArrayList(this.myListeners);
        for (DesignSurfaceListener listener : listeners) {
            listener.componentSelectionChanged(this, newSelection);
        }
    }

    public void notifyComponentActivate(@NotNull NlComponent component2, int x, int y) {
        if (component2 == null) {
            DesignSurface.$$$reportNull$$$0(11);
        }
        this.notifyComponentActivate(component2);
    }

    public void notifyComponentActivate(@NotNull NlComponent component2) {
        if (component2 == null) {
            DesignSurface.$$$reportNull$$$0(12);
        }
        this.activatePreferredEditor(component2);
    }

    protected void activatePreferredEditor(@NotNull NlComponent component2) {
        if (component2 == null) {
            DesignSurface.$$$reportNull$$$0(13);
        }
        for (DesignSurfaceListener listener : new ArrayList<DesignSurfaceListener>(this.myListeners)) {
            if (listener.activatePreferredEditor(this, component2)) break;
        }
    }

    public void addListener(@NotNull DesignSurfaceListener listener) {
        if (listener == null) {
            DesignSurface.$$$reportNull$$$0(14);
        }
        this.myListeners.remove(listener);
        this.myListeners.add(listener);
    }

    public void removeListener(@NotNull DesignSurfaceListener listener) {
        if (listener == null) {
            DesignSurface.$$$reportNull$$$0(15);
        }
        this.myListeners.remove(listener);
    }

    protected void modelRendered() {
        if (this.getCurrentSceneView() != null) {
            this.repaint();
            this.layoutContent();
        }
    }

    public void addPanZoomListener(PanZoomListener listener) {
        if (this.myZoomListeners == null) {
            this.myZoomListeners = Lists.newArrayList();
        } else {
            this.myZoomListeners.remove(listener);
        }
        this.myZoomListeners.add(listener);
    }

    public void removePanZoomListener(PanZoomListener listener) {
        if (this.myZoomListeners != null) {
            this.myZoomListeners.remove(listener);
        }
    }

    public void activate() {
        if (!this.myIsActive && this.myModel != null) {
            this.myModel.activate((Object)this);
        }
        this.myIsActive = true;
    }

    public void deactivate() {
        if (this.myIsActive && this.myModel != null) {
            this.myModel.deactivate((Object)this);
        }
        this.myIsActive = false;
        this.myInteractionManager.cancelInteraction();
    }

    public void setFileEditorDelegate(@Nullable FileEditor fileEditor) {
        this.myFileEditorDelegate = new WeakReference<FileEditor>(fileEditor);
    }

    @Nullable
    public SceneView getSceneView(int x, int y) {
        return this.getCurrentSceneView();
    }

    @Nullable
    public SceneView getHoverSceneView(int x, int y) {
        return this.getCurrentSceneView();
    }

    @Nullable
    public Scene getScene() {
        return this.getSceneManager() != null ? this.mySceneManager.getScene() : null;
    }

    @Nullable
    public SceneManager getSceneManager() {
        return this.mySceneManager;
    }

    public void setSkipResizeContent(boolean skipLayout) {
        this.mySkipResizeContent = skipLayout;
    }

    public void skipContentResizeOnce() {
        this.mySkipResizeContentOnce = true;
    }

    public boolean isSkipContentResize() {
        return this.mySkipResizeContent || this.mySkipResizeContentOnce || this.myCurrentZoomType != ZoomType.FIT;
    }

    protected boolean contentResizeSkipped() {
        boolean skip = this.isSkipContentResize();
        this.mySkipResizeContentOnce = false;
        return skip;
    }

    public CompletableFuture<?> goingToSetModel(NlModel model) {
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIndicator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            DesignSurface.$$$reportNull$$$0(16);
        }
        if (this.myProject.isDisposed() || Disposer.isDisposed((Disposable)this)) {
            return;
        }
        List<ProgressIndicator> list = this.myProgressIndicators;
        synchronized (list) {
            this.myProgressIndicators.add(indicator);
            this.myProgressPanel.showProgressIcon();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterIndicator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            DesignSurface.$$$reportNull$$$0(17);
        }
        List<ProgressIndicator> list = this.myProgressIndicators;
        synchronized (list) {
            this.myProgressIndicators.remove(indicator);
            if (this.myProgressIndicators.isEmpty()) {
                this.myProgressPanel.hideProgressIcon();
            }
        }
    }

    protected boolean useSmallProgressIcon() {
        return true;
    }

    public void requestRender() {
        SceneManager sceneManager = this.getSceneManager();
        if (sceneManager != null) {
            sceneManager.requestRender();
        }
    }

    @NotNull
    public JScrollPane getScrollPane() {
        JScrollPane jScrollPane = this.myScrollPane;
        if (jScrollPane == null) {
            DesignSurface.$$$reportNull$$$0(18);
        }
        return jScrollPane;
    }

    public void setDesignToolTip(@Nullable String text) {
        this.myDescriptionString = text;
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            DesignSurface.$$$reportNull$$$0(19);
        }
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            return this.myFileEditorDelegate.get();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) || PlatformDataKeys.CUT_PROVIDER.is(dataId) || PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return new DesignSurfaceActionHandler(this);
        }
        return this.myLayeredPane.getData(dataId);
    }

    public abstract boolean isLayoutDisabled();

    @Override
    @Nullable
    public Configuration getConfiguration() {
        return this.getModel() != null ? this.getModel().getConfiguration() : null;
    }

    @NotNull
    public IssueModel getIssueModel() {
        IssueModel issueModel = this.myIssueModel;
        if (issueModel == null) {
            DesignSurface.$$$reportNull$$$0(20);
        }
        return issueModel;
    }

    @NotNull
    public IssuePanel getIssuePanel() {
        IssuePanel issuePanel = this.myIssuePanel;
        if (issuePanel == null) {
            DesignSurface.$$$reportNull$$$0(21);
        }
        return issuePanel;
    }

    public void setShowIssuePanel(boolean show) {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myIssuePanel.setMinimized(!show);
            this.revalidate();
            this.repaint();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected MergingUpdateQueue getErrorQueue() {
        Object object = this.myErrorQueueLock;
        // MONITORENTER : object
        if (this.myErrorQueue == null) {
            this.myErrorQueue = new MergingUpdateQueue("android.error.computation", 200, true, null, (Disposable)this.myProject, null, Alarm.ThreadToUse.POOLED_THREAD);
        }
        MergingUpdateQueue mergingUpdateQueue = this.myErrorQueue;
        // MONITOREXIT : object
        if (mergingUpdateQueue != null) return mergingUpdateQueue;
        DesignSurface.$$$reportNull$$$0(22);
        return mergingUpdateQueue;
    }

    public void addLayers(@NotNull ImmutableList<Layer> layers) {
        if (layers == null) {
            DesignSurface.$$$reportNull$$$0(23);
        }
        this.myLayers = ImmutableList.copyOf((Iterable)Iterables.concat(this.myLayers, layers));
    }

    public void removeLayers(@NotNull ImmutableList<Layer> layers) {
        if (layers == null) {
            DesignSurface.$$$reportNull$$$0(24);
        }
        this.myLayers = ImmutableList.copyOf((Iterable)Iterables.filter(this.myLayers, l -> {
            if (layers == null) {
                DesignSurface.$$$reportNull$$$0(26);
            }
            return !layers.contains(l);
        }));
    }

    @NotNull
    protected List<Layer> getLayers() {
        ImmutableList<Layer> immutableList = this.myLayers;
        if (immutableList == null) {
            DesignSurface.$$$reportNull$$$0(25);
        }
        return immutableList;
    }

    @Nullable
    public final Interaction createInteractionOnClick(int mouseX, int mouseY) {
        SceneView sceneView = this.getSceneView(mouseX, mouseY);
        if (sceneView == null) {
            return null;
        }
        return this.doCreateInteractionOnClick(mouseX, mouseY, sceneView);
    }

    @Nullable
    public abstract Interaction doCreateInteractionOnClick(int var1, int var2, @NotNull SceneView var3);

    @Nullable
    public abstract Interaction createInteractionOnDrag(@NotNull SceneComponent var1, @Nullable SceneComponent var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/surface/DesignSurface";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSelection";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/surface/DesignSurface";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionAsTransferable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayeredPane";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getScrollPane";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssueModel";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssuePanel";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorQueue";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "zoom";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "notifySelectionListeners";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "notifyComponentActivate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "activatePreferredEditor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "registerIndicator";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "unregisterIndicator";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addLayers";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "removeLayers";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeLayers$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyProgressPanel
    extends JPanel {
        private AsyncProcessIcon mySmallProgressIcon;
        private AsyncProcessIcon myLargeProgressIcon;
        private boolean mySmall;
        private boolean myProgressVisible;

        private MyProgressPanel() {
            super(new BorderLayout());
            this.setOpaque(false);
            this.setVisible(false);
        }

        private void setSmallIcon(boolean small) {
            if (small != this.mySmall) {
                if (this.myProgressVisible && this.getComponentCount() != 0) {
                    AsyncProcessIcon oldIcon = this.getProgressIcon();
                    oldIcon.suspend();
                }
                this.mySmall = true;
                this.removeAll();
                AsyncProcessIcon icon = this.getProgressIcon();
                this.add((Component)icon, "Center");
                if (this.myProgressVisible) {
                    icon.setVisible(true);
                    icon.resume();
                }
            }
        }

        public void showProgressIcon() {
            if (!this.myProgressVisible) {
                this.setSmallIcon(DesignSurface.this.useSmallProgressIcon());
                this.myProgressVisible = true;
                this.setVisible(true);
                AsyncProcessIcon icon = this.getProgressIcon();
                if (this.getComponentCount() == 0) {
                    this.add((Component)this.getProgressIcon(), "Center");
                } else {
                    icon.setVisible(true);
                }
                icon.resume();
            }
        }

        public void hideProgressIcon() {
            if (this.myProgressVisible) {
                this.myProgressVisible = false;
                this.setVisible(false);
                AsyncProcessIcon icon = this.getProgressIcon();
                icon.setVisible(false);
                icon.suspend();
            }
        }

        @Override
        public void doLayout() {
            super.doLayout();
            this.setBackground((Color)JBColor.RED);
            if (!this.myProgressVisible) {
                return;
            }
            AsyncProcessIcon icon = this.getProgressIcon();
            Dimension size = icon.getPreferredSize();
            if (this.mySmall) {
                icon.setBounds(this.getWidth() - size.width - 1, 1, size.width, size.height);
            } else {
                icon.setBounds(this.getWidth() / 2 - size.width / 2, this.getHeight() / 2 - size.height / 2, size.width, size.height);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getProgressIcon().getPreferredSize();
        }

        @NotNull
        private AsyncProcessIcon getProgressIcon() {
            AsyncProcessIcon asyncProcessIcon = this.getProgressIcon(this.mySmall);
            if (asyncProcessIcon == null) {
                MyProgressPanel.$$$reportNull$$$0(0);
            }
            return asyncProcessIcon;
        }

        @NotNull
        private AsyncProcessIcon getProgressIcon(boolean small) {
            if (small) {
                if (this.mySmallProgressIcon == null) {
                    this.mySmallProgressIcon = new AsyncProcessIcon("Android layout rendering");
                    Disposer.register((Disposable)DesignSurface.this, (Disposable)this.mySmallProgressIcon);
                }
                AsyncProcessIcon asyncProcessIcon = this.mySmallProgressIcon;
                if (asyncProcessIcon == null) {
                    MyProgressPanel.$$$reportNull$$$0(1);
                }
                return asyncProcessIcon;
            }
            if (this.myLargeProgressIcon == null) {
                this.myLargeProgressIcon = new AsyncProcessIcon.Big("Android layout rendering");
                Disposer.register((Disposable)DesignSurface.this, (Disposable)this.myLargeProgressIcon);
            }
            AsyncProcessIcon asyncProcessIcon = this.myLargeProgressIcon;
            if (asyncProcessIcon == null) {
                MyProgressPanel.$$$reportNull$$$0(2);
            }
            return asyncProcessIcon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/common/surface/DesignSurface$MyProgressPanel", "getProgressIcon"));
        }
    }

    private static class GlassPane
    extends JComponent {
        private static final long EVENT_FLAGS = 56L;

        GlassPane() {
            this.enableEvents(56L);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (enabled) {
                this.enableEvents(56L);
            } else {
                this.disableEvents(56L);
            }
        }

        @Override
        protected void processKeyEvent(KeyEvent event) {
            if (!event.isConsumed()) {
                super.processKeyEvent(event);
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent event) {
            if (event.getID() == 501) {
                this.requestFocusInWindow();
            }
            super.processMouseEvent(event);
        }
    }

    private class MyLayeredPane
    extends JLayeredPane
    implements Magnificator,
    DataProvider {
        MyLayeredPane() {
            this.putClientProperty(Magnificator.CLIENT_PROPERTY_KEY, this);
        }

        public Point magnify(double scale, Point at) {
            DesignSurface.this.setScale(scale * DesignSurface.this.myScale);
            DesignSurface.this.repaint();
            return new Point((int)((double)at.x * scale), (int)((double)at.y * scale));
        }

        @Override
        protected void paintComponent(@NotNull Graphics graphics) {
            if (graphics == null) {
                MyLayeredPane.$$$reportNull$$$0(0);
            }
            super.paintComponent(graphics);
            Graphics2D g2d = (Graphics2D)graphics;
            int tlx = DesignSurface.this.myScrollPane.getHorizontalScrollBar().getValue();
            int tly = DesignSurface.this.myScrollPane.getVerticalScrollBar().getValue();
            this.paintBackground(g2d, tlx, tly);
            if (DesignSurface.this.getCurrentSceneView() == null) {
                return;
            }
            for (Layer layer : DesignSurface.this.myLayers) {
                if (layer.isHidden()) continue;
                layer.paint(g2d);
            }
            if (!DesignSurface.this.getLayoutType().isSupportedByDesigner()) {
                return;
            }
            List<Layer> layers = DesignSurface.this.myInteractionManager.getLayers();
            if (layers != null) {
                for (Layer layer : layers) {
                    if (layer.isHidden()) continue;
                    layer.paint(g2d);
                }
            }
        }

        private void paintBackground(@NotNull Graphics2D graphics, int lx, int ly) {
            if (graphics == null) {
                MyLayeredPane.$$$reportNull$$$0(1);
            }
            int width = DesignSurface.this.myScrollPane.getWidth();
            int height = DesignSurface.this.myScrollPane.getHeight();
            graphics.setColor(this.getBackground());
            graphics.fillRect(lx, ly, width, height);
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            SelectionModel selectionModel;
            NlComponent primary;
            if (dataId == null) {
                MyLayeredPane.$$$reportNull$$$0(2);
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId) && DesignSurface.this.getCurrentSceneView() != null && (primary = (selectionModel = DesignSurface.this.getCurrentSceneView().getSelectionModel()).getPrimary()) != null) {
                return primary.getTag();
            }
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId) && DesignSurface.this.getCurrentSceneView() != null) {
                selectionModel = DesignSurface.this.getCurrentSceneView().getSelectionModel();
                ImmutableList<NlComponent> selection = selectionModel.getSelection();
                ArrayList list = Lists.newArrayListWithCapacity((int)selection.size());
                for (NlComponent component2 : selection) {
                    list.add(component2.getTag());
                }
                return list.toArray(XmlTag.EMPTY);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graphics";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/common/surface/DesignSurface$MyLayeredPane";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintBackground";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyScrollBar
    extends JBScrollBar
    implements IdeGlassPane.TopComponent {
        private ScrollBarUI myPersistentUI;

        private MyScrollBar(@JdkConstants.AdjustableOrientation int orientation) {
            super(orientation);
            this.setOpaque(false);
        }

        public boolean canBePreprocessed(MouseEvent e) {
            return JBScrollPane.canBePreprocessed((MouseEvent)e, (JScrollBar)((Object)this));
        }

        public void setUI(ScrollBarUI ui) {
            if (this.myPersistentUI == null) {
                this.myPersistentUI = ui;
            }
            super.setUI(this.myPersistentUI);
            this.setOpaque(false);
        }

        public int getUnitIncrement(int direction) {
            return 5;
        }

        public int getBlockIncrement(int direction) {
            return 1;
        }
    }

    private static class MyScrollPane
    extends JBScrollPane {
        private MyScrollPane() {
            super(0);
            this.setupCorners();
        }

        @NotNull
        public JScrollBar createVerticalScrollBar() {
            MyScrollBar myScrollBar = new MyScrollBar(1);
            if (myScrollBar == null) {
                MyScrollPane.$$$reportNull$$$0(0);
            }
            return myScrollBar;
        }

        @NotNull
        public JScrollBar createHorizontalScrollBar() {
            MyScrollBar myScrollBar = new MyScrollBar(0);
            if (myScrollBar == null) {
                MyScrollPane.$$$reportNull$$$0(1);
            }
            return myScrollBar;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/idea/common/surface/DesignSurface$MyScrollPane";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createVerticalScrollBar";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createHorizontalScrollBar";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

