/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DesignSurfaceActionHandler
implements DeleteProvider,
CutProvider,
CopyProvider,
PasteProvider {
    private final DesignSurface mySurface;
    private CopyPasteManager myCopyPasteManager;

    public DesignSurfaceActionHandler(@NotNull DesignSurface surface) {
        if (surface == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(0);
        }
        this(surface, CopyPasteManager.getInstance());
    }

    DesignSurfaceActionHandler(@NotNull DesignSurface surface, @NotNull CopyPasteManager copyPasteManager) {
        if (surface == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(1);
        }
        if (copyPasteManager == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(2);
        }
        this.mySurface = surface;
        this.myCopyPasteManager = copyPasteManager;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(3);
        }
        if (!this.mySurface.getSelectionModel().isEmpty()) {
            this.myCopyPasteManager.setContents((Transferable)this.mySurface.getSelectionAsTransferable());
        }
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(4);
        }
        return this.hasNonEmptySelection();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(5);
        }
        return true;
    }

    public void performCut(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(6);
        }
        if (!this.mySurface.getSelectionModel().isEmpty()) {
            ItemTransferable transferable = this.mySurface.getSelectionAsTransferable();
            try {
                DnDTransferItem transferItem = (DnDTransferItem)transferable.getTransferData(ItemTransferable.DESIGNER_FLAVOR);
                transferItem.setIsCut();
                this.myCopyPasteManager.setContents((Transferable)transferable);
            }
            catch (UnsupportedFlavorException e) {
                this.performCopy(dataContext);
            }
            this.deleteElement(dataContext);
        }
    }

    public boolean isCutEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(7);
        }
        return this.hasNonEmptySelection();
    }

    public boolean isCutVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(8);
        }
        return true;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        NlModel model;
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(9);
        }
        if ((model = this.mySurface.getModel()) == null) {
            return;
        }
        SelectionModel selectionModel = this.mySurface.getSelectionModel();
        model.delete((Collection<NlComponent>)selectionModel.getSelection());
        selectionModel.clear();
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(10);
        }
        return this.hasNonEmptySelection();
    }

    public void performPaste(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(11);
        }
        this.pasteOperation(false);
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(12);
        }
        return this.mySurface.getSelectionModel().getSelection().size() <= 1;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(13);
        }
        return this.pasteOperation(true);
    }

    private boolean hasNonEmptySelection() {
        return !this.mySurface.getSelectionModel().isEmpty();
    }

    private boolean pasteOperation(boolean checkOnly) {
        NlComponent before;
        ImmutableList<NlComponent> components;
        NlComponent receiver;
        SceneView sceneView = this.mySurface.getCurrentSceneView();
        if (sceneView == null) {
            return false;
        }
        ImmutableList<NlComponent> selection = this.mySurface.getSelectionModel().getSelection();
        if (selection.size() > 1) {
            return false;
        }
        NlComponent nlComponent = receiver = !selection.isEmpty() ? (NlComponent)selection.get(0) : null;
        if (receiver == null && (components = sceneView.getModel().getComponents()).size() == 1) {
            receiver = (NlComponent)components.get(0);
        }
        if (receiver == null) {
            return false;
        }
        NlModel model = sceneView.getModel();
        ViewHandlerManager handlerManager = ViewHandlerManager.get(model.getProject());
        ViewHandler handler = handlerManager.getHandler(receiver);
        if (handler instanceof ViewGroupHandler) {
            before = receiver.getChild(0);
        } else {
            before = receiver.getNextSibling();
            if ((receiver = receiver.getParent()) == null) {
                return false;
            }
        }
        DnDTransferItem transferItem = DesignSurfaceActionHandler.getClipboardData();
        if (transferItem == null) {
            return false;
        }
        DragType dragType = transferItem.isCut() ? DragType.MOVE : DragType.PASTE;
        InsertType insertType = model.determineInsertType(dragType, transferItem, checkOnly);
        List<NlComponent> pasted = NlModelHelperKt.createComponents(model, sceneView, transferItem, insertType);
        if (!model.canAddComponents(pasted, receiver, before, checkOnly)) {
            return false;
        }
        if (checkOnly) {
            return true;
        }
        transferItem.consumeCut();
        model.addComponents(pasted, receiver, before, insertType, ViewEditorImpl.getOrCreate(sceneView));
        return true;
    }

    @Nullable
    private static DnDTransferItem getClipboardData() {
        CopyPasteManager instance = CopyPasteManager.getInstance();
        Transferable contents = instance.getContents();
        if (contents == null) {
            return null;
        }
        try {
            return (DnDTransferItem)contents.getTransferData(ItemTransferable.DESIGNER_FLAVOR);
        }
        catch (UnsupportedFlavorException | IOException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyPasteManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/common/surface/DesignSurfaceActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "performCopy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyVisible";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "performCut";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isCutEnabled";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isCutVisible";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "canDeleteElement";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "performPaste";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isPastePossible";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isPasteEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

