/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.MaterialDesignIcons;
import com.android.tools.idea.res.ModuleResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.uibuilder.editor.LayoutNavigationManager;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.google.common.io.CharStreams;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\u0007\u001a\u001e\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007\u001a0\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\"\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0007H\u0002\u001a\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007\u001a(\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u0011\u00a8\u0006\u001d"}, d2={"copyLayoutToMainModuleSourceSet", "", "project", "Lcom/intellij/openapi/project/Project;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "layout", "", "xml", "copyVectorAssetToMainModuleSourceSet", "asset", "createResourceFile", "resourceDirectory", "resourceFileName", "resourceFileContent", "", "getResourceDirectoryChild", "Lcom/intellij/openapi/vfs/VirtualFile;", "child", "moduleContainsResource", "", "type", "Lcom/android/resources/ResourceType;", "name", "openResource", "configuration", "Lcom/android/tools/idea/configurations/Configuration;", "reference", "currentFile", "intellij.android.designer"})
@JvmName(name="DesignSurfaceHelper")
public final class DesignSurfaceHelper {
    public static final boolean openResource(@NotNull Project project, @NotNull Configuration configuration, @NotNull String reference, @Nullable VirtualFile currentFile) {
        VirtualFile file;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
        ResourceResolver resourceResolver = configuration.getResourceResolver();
        if (resourceResolver == null) {
            return false;
        }
        ResourceResolver resourceResolver2 = resourceResolver;
        ResourceValue resValue = resourceResolver2.findResValue(reference, false);
        File path = ResourceHelper.resolveLayout((RenderResources)resourceResolver2, resValue);
        if (path != null && (file = LocalFileSystem.getInstance().findFileByIoFile(path)) != null) {
            FileEditor[] fileEditorArray;
            if (currentFile != null) {
                return LayoutNavigationManager.getInstance(project).pushFile(currentFile, file);
            }
            FileEditor[] editors = FileEditorManager.getInstance((Project)project).openFile(file, true, true);
            Intrinsics.checkExpressionValueIsNotNull((Object)editors, (String)"editors");
            FileEditor[] fileEditorArray2 = fileEditorArray = editors;
            if (!(fileEditorArray2.length == 0)) {
                return true;
            }
        }
        return false;
    }

    public static final boolean moduleContainsResource(@NotNull AndroidFacet facet, @NotNull ResourceType type, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)facet), (String)"facet");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return ModuleResourceRepository.getOrCreateInstance(facet).hasResourceItem(type, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyVectorAssetToMainModuleSourceSet(@NotNull Project project, @NotNull AndroidFacet facet, @NotNull String asset) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)facet), (String)"facet");
        Intrinsics.checkParameterIsNotNull((Object)asset, (String)"asset");
        String path = MaterialDesignIcons.getPathForBasename(asset);
        try {
            Closeable closeable = new InputStreamReader(IconGenerator.class.getClassLoader().getResourceAsStream(path), StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                InputStreamReader reader = (InputStreamReader)closeable;
                String string = asset + ".xml";
                String string2 = CharStreams.toString((Readable)reader);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"CharStreams.toString(reader)");
                DesignSurfaceHelper.createResourceFile(project, facet, "drawable", string, string2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException exception) {
            Logger.getInstance(ViewEditorImpl.class).warn((Throwable)exception);
        }
    }

    public static final void copyLayoutToMainModuleSourceSet(@NotNull Project project, @NotNull AndroidFacet facet, @NotNull String layout, @Language(value="XML") @NotNull String xml) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)facet), (String)"facet");
        Intrinsics.checkParameterIsNotNull((Object)layout, (String)"layout");
        Intrinsics.checkParameterIsNotNull((Object)xml, (String)"xml");
        String message = "Do you want to copy layout " + layout + " to your main module source set?";
        if (Messages.showYesNoDialog((Project)project, (String)message, (String)"Copy Layout", (Icon)Messages.getQuestionIcon()) == 1) {
            return;
        }
        DesignSurfaceHelper.createResourceFile(project, facet, "layout", layout + ".xml", xml);
    }

    private static final void createResourceFile(Project project, AndroidFacet facet, String resourceDirectory, String resourceFileName, CharSequence resourceFileContent) {
        WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(project, facet, resourceDirectory, resourceFileName, resourceFileContent){
            final /* synthetic */ Project $project;
            final /* synthetic */ AndroidFacet $facet;
            final /* synthetic */ String $resourceDirectory;
            final /* synthetic */ String $resourceFileName;
            final /* synthetic */ CharSequence $resourceFileContent;

            public final void run() {
                try {
                    VirtualFile directory = DesignSurfaceHelper.access$getResourceDirectoryChild(this.$project, this.$facet, this.$resourceDirectory);
                    if (directory == null) {
                        return;
                    }
                    Document document = FileDocumentManager.getInstance().getDocument(directory.createChildData((Object)this.$project, this.$resourceFileName));
                    if (document == null) {
                        Intrinsics.throwNpe();
                    }
                    Document document2 = document;
                    document2.setText(this.$resourceFileContent);
                }
                catch (IOException exception) {
                    Logger.getInstance(ViewEditorImpl.class).warn((Throwable)exception);
                }
            }
            {
                this.$project = project;
                this.$facet = androidFacet;
                this.$resourceDirectory = string;
                this.$resourceFileName = string2;
                this.$resourceFileContent = charSequence;
            }
        });
    }

    private static final VirtualFile getResourceDirectoryChild(Project project, AndroidFacet facet, String child) throws IOException {
        VirtualFile resourceDirectory = facet.getPrimaryResourceDir();
        if (resourceDirectory == null) {
            Logger.getInstance((String)"DesignSurfaceHelper").warn("resourceDirectory is null");
            return null;
        }
        VirtualFile virtualFile = resourceDirectory.findChild(child);
        if (virtualFile == null) {
            return resourceDirectory.createChildDirectory((Object)project, child);
        }
        return virtualFile;
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getResourceDirectoryChild(@NotNull Project project, @NotNull AndroidFacet facet, @NotNull String child) {
        return DesignSurfaceHelper.getResourceDirectoryChild(project, facet, child);
    }
}

