/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.connection.assistant.actions;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.assistant.AssistActionState;
import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.DefaultActionState;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.android.tools.idea.connection.assistant.actions.ListUsbDevicesAction;
import com.android.tools.usb.Platform;
import com.android.tools.usb.UsbDevice;
import com.android.tools.usb.UsbDeviceCollector;
import com.android.tools.usb.UsbDeviceCollectorImpl;
import com.android.utils.HtmlBuilder;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ConnectionAssistantEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J$\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0014H\u0016J\u0018\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010\u001f\u001a\u00020\u0012R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\f\u0010\u0003\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/connection/assistant/actions/ListUsbDevicesActionStateManager;", "Lcom/android/tools/idea/assistant/AssistActionStateManager;", "Lcom/intellij/openapi/Disposable;", "()V", "myDevicesFuture", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/android/tools/usb/UsbDevice;", "myProject", "Lcom/intellij/openapi/project/Project;", "usbDeviceCollector", "Lcom/android/tools/usb/UsbDeviceCollector;", "usbDeviceCollector$annotations", "getUsbDeviceCollector", "()Lcom/android/tools/usb/UsbDeviceCollector;", "setUsbDeviceCollector", "(Lcom/android/tools/usb/UsbDeviceCollector;)V", "dispose", "", "generateMessage", "", "getId", "getState", "Lcom/android/tools/idea/assistant/AssistActionState;", "project", "actionData", "Lcom/android/tools/idea/assistant/datamodel/ActionData;", "getStateDisplay", "Lcom/android/tools/idea/assistant/view/StatefulButtonMessage;", "message", "init", "refresh", "Companion", "intellij.android"})
public final class ListUsbDevicesActionStateManager
extends AssistActionStateManager
implements Disposable {
    @NotNull
    public UsbDeviceCollector usbDeviceCollector;
    private Project myProject;
    private CompletableFuture<List<UsbDevice>> myDevicesFuture;
    private static ListUsbDevicesActionStateManager myInstance;
    public static final Companion Companion;

    public static /* synthetic */ void usbDeviceCollector$annotations() {
    }

    @NotNull
    public final UsbDeviceCollector getUsbDeviceCollector() {
        UsbDeviceCollector usbDeviceCollector = this.usbDeviceCollector;
        if (usbDeviceCollector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"usbDeviceCollector");
        }
        return usbDeviceCollector;
    }

    public final void setUsbDeviceCollector(@NotNull UsbDeviceCollector usbDeviceCollector) {
        Intrinsics.checkParameterIsNotNull((Object)usbDeviceCollector, (String)"<set-?>");
        this.usbDeviceCollector = usbDeviceCollector;
    }

    @Override
    public void init(@NotNull Project project, @NotNull ActionData actionData) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)actionData, (String)"actionData");
        this.myProject = project;
        this.usbDeviceCollector = (UsbDeviceCollector)new UsbDeviceCollectorImpl();
        myInstance = this;
        this.refresh();
        Disposer.register((Disposable)((Disposable)project), (Disposable)this);
    }

    public final void refresh() {
        UsbDeviceCollector usbDeviceCollector = this.usbDeviceCollector;
        if (usbDeviceCollector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"usbDeviceCollector");
        }
        this.myDevicesFuture = usbDeviceCollector.listUsbDevices();
        CompletableFuture<List<UsbDevice>> completableFuture = this.myDevicesFuture;
        if (completableFuture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDevicesFuture");
        }
        completableFuture.thenAccept(new Consumer<List<? extends UsbDevice>>(this){
            final /* synthetic */ ListUsbDevicesActionStateManager this$0;

            public final void accept(List<UsbDevice> it) {
                UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.CONNECTION_ASSISTANT_EVENT).setConnectionAssistantEvent(ConnectionAssistantEvent.newBuilder().setType(ConnectionAssistantEvent.ConnectionAssistantEventType.USB_DEVICES_DETECTED).setUsbDevicesDetected(((List)ListUsbDevicesActionStateManager.access$getMyDevicesFuture$p(this.this$0).get()).size())));
                this.this$0.refreshDependencyState(ListUsbDevicesActionStateManager.access$getMyProject$p(this.this$0));
            }
            {
                this.this$0 = listUsbDevicesActionStateManager;
            }
        });
        Project project = this.myProject;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myProject");
        }
        this.refreshDependencyState(project);
    }

    public void dispose() {
        CompletableFuture<List<UsbDevice>> completableFuture = this.myDevicesFuture;
        if (completableFuture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDevicesFuture");
        }
        completableFuture.cancel(true);
    }

    @Override
    @NotNull
    public AssistActionState getState(@NotNull Project project, @NotNull ActionData actionData) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)actionData, (String)"actionData");
        UsbDeviceCollector usbDeviceCollector = this.usbDeviceCollector;
        if (usbDeviceCollector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"usbDeviceCollector");
        }
        if (usbDeviceCollector.getPlatform() == Platform.Windows) {
            return DefaultActionState.COMPLETE;
        }
        CompletableFuture<List<UsbDevice>> completableFuture = this.myDevicesFuture;
        if (completableFuture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDevicesFuture");
        }
        if (!completableFuture.isDone()) {
            return DefaultActionState.IN_PROGRESS;
        }
        CompletableFuture<List<UsbDevice>> completableFuture2 = this.myDevicesFuture;
        if (completableFuture2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDevicesFuture");
        }
        return completableFuture2.get().isEmpty() ? (AssistActionState)DefaultActionState.INCOMPLETE : (AssistActionState)DefaultActionState.PARTIALLY_COMPLETE;
    }

    @Override
    @Nullable
    public StatefulButtonMessage getStateDisplay(@NotNull Project project, @NotNull ActionData actionData, @Nullable String message) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)actionData, (String)"actionData");
        AssistActionState state = this.getState(project, actionData);
        return new StatefulButtonMessage(this.generateMessage(), state);
    }

    @Override
    @NotNull
    public String getId() {
        return ListUsbDevicesAction.Companion.getACTION_ID();
    }

    private final String generateMessage() {
        Iterable $receiver$iv;
        CompletableFuture<List<UsbDevice>> completableFuture = this.myDevicesFuture;
        if (completableFuture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDevicesFuture");
        }
        if (!completableFuture.isDone()) {
            return "Loading...";
        }
        CompletableFuture<List<UsbDevice>> completableFuture2 = this.myDevicesFuture;
        if (completableFuture2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDevicesFuture");
        }
        if (completableFuture2.get().isEmpty()) {
            return "No USB device detected.";
        }
        CompletableFuture<List<UsbDevice>> completableFuture3 = this.myDevicesFuture;
        if (completableFuture3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDevicesFuture");
        }
        List<UsbDevice> list = completableFuture3.get();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"myDevicesFuture.get()");
        Iterable iterable = $receiver$iv = (Iterable)list;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                UsbDevice it = (UsbDevice)a;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (UsbDevice)b;
                Comparable comparable2 = comparable;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        List devices = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        int count = devices.size();
        HtmlBuilder htmlBuilder = new HtmlBuilder().openHtmlBody().add("Android Studio detected the following " + count + " USB device(s):").newline();
        UsbDeviceCollector usbDeviceCollector = this.usbDeviceCollector;
        if (usbDeviceCollector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"usbDeviceCollector");
        }
        if (usbDeviceCollector.getPlatform() == Platform.Windows) {
            htmlBuilder.add("<b>Install device drivers.</b> If you want to connect a device for testing, then you need to install the appropriate USB drivers. For more information, read the <a href=\"https://developer.android.com/studio/run/oem-usb.html\">online documentation</a>.").newline();
        }
        Iterable $receiver$iv2 = devices;
        for (Object element$iv : $receiver$iv2) {
            UsbDevice $name_vendorId_productId = (UsbDevice)element$iv;
            String name = $name_vendorId_productId.component1();
            String vendorId = $name_vendorId_productId.component2();
            String productId = $name_vendorId_productId.component3();
            htmlBuilder.addHtml("<p>").addHtml("<b>" + name + "</b>").newline().add("Product ID: " + productId + ", Vendor ID: " + vendorId).newlineIfNecessary().addHtml("</p>");
        }
        HtmlBuilder htmlBuilder2 = htmlBuilder.closeHtmlBody();
        Intrinsics.checkExpressionValueIsNotNull((Object)htmlBuilder2, (String)"htmlBuilder.closeHtmlBody()");
        String string = htmlBuilder2.getHtml();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"htmlBuilder.closeHtmlBody().html");
        return string;
    }

    static {
        Companion = new Companion(null);
    }

    @NotNull
    public static final /* synthetic */ CompletableFuture access$getMyDevicesFuture$p(ListUsbDevicesActionStateManager $this) {
        CompletableFuture<List<UsbDevice>> completableFuture = $this.myDevicesFuture;
        if (completableFuture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDevicesFuture");
        }
        return completableFuture;
    }

    public static final /* synthetic */ void access$setMyDevicesFuture$p(ListUsbDevicesActionStateManager $this, @NotNull CompletableFuture completableFuture) {
        $this.myDevicesFuture = completableFuture;
    }

    @NotNull
    public static final /* synthetic */ Project access$getMyProject$p(ListUsbDevicesActionStateManager $this) {
        Project project = $this.myProject;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myProject");
        }
        return project;
    }

    public static final /* synthetic */ void access$setMyProject$p(ListUsbDevicesActionStateManager $this, @NotNull Project project) {
        $this.myProject = project;
    }

    @NotNull
    public static final /* synthetic */ ListUsbDevicesActionStateManager access$getMyInstance$cp() {
        ListUsbDevicesActionStateManager listUsbDevicesActionStateManager = myInstance;
        if (listUsbDevicesActionStateManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myInstance");
        }
        return listUsbDevicesActionStateManager;
    }

    public static final /* synthetic */ void access$setMyInstance$cp(@NotNull ListUsbDevicesActionStateManager listUsbDevicesActionStateManager) {
        myInstance = listUsbDevicesActionStateManager;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/connection/assistant/actions/ListUsbDevicesActionStateManager$Companion;", "", "()V", "myInstance", "Lcom/android/tools/idea/connection/assistant/actions/ListUsbDevicesActionStateManager;", "getInstance", "intellij.android"})
    public static final class Companion {
        @NotNull
        public final ListUsbDevicesActionStateManager getInstance() {
            return ListUsbDevicesActionStateManager.access$getMyInstance$cp();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

