/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.ide.common.res2.DataBindingResourceType;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.databinding.ResourceCacheValueProvider;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.PsiDataBindingResourceItem;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.light.LightField;
import com.intellij.psi.impl.light.LightIdentifier;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.augment.AndroidLightClassBase;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightBindingClass
extends AndroidLightClassBase {
    private static final int STATIC_METHOD_COUNT = 6;
    private DataBindingInfo myInfo;
    private CachedValue<PsiMethod[]> myPsiMethodsCache;
    private CachedValue<PsiField[]> myPsiFieldsCache;
    private CachedValue<Map<String, String>> myAliasCache;
    private PsiReferenceList myExtendsList;
    private PsiClassType[] myExtendsListTypes;
    private final AndroidFacet myFacet;
    private static Lexer ourJavaLexer;
    private PsiFile myVirtualPsiFile;
    private final Object myLock;

    protected LightBindingClass(AndroidFacet facet, @NotNull PsiManager psiManager, DataBindingInfo info) {
        if (psiManager == null) {
            LightBindingClass.$$$reportNull$$$0(0);
        }
        super(psiManager);
        this.myLock = new Object();
        this.myInfo = info;
        this.myFacet = facet;
        this.myVirtualPsiFile = info.getPsiFile();
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)info.getProject());
        this.myAliasCache = cachedValuesManager.createCachedValue((CachedValueProvider)new ResourceCacheValueProvider<Map<String, String>>(facet, this.myLock, new ModificationTracker[0]){

            @Override
            Map<String, String> doCompute() {
                HashMap<String, String> result = new HashMap<String, String>();
                for (PsiDataBindingResourceItem imp : LightBindingClass.this.myInfo.getItems(DataBindingResourceType.IMPORT)) {
                    String alias = imp.getExtra("alias");
                    if (alias == null) continue;
                    result.put(alias, imp.getExtra("type"));
                }
                return result;
            }

            @Override
            Map<String, String> defaultValue() {
                return new HashMap<String, String>();
            }
        }, false);
        this.myPsiMethodsCache = cachedValuesManager.createCachedValue((CachedValueProvider)new ResourceCacheValueProvider<PsiMethod[]>(facet, this.myLock, new ModificationTracker[0]){

            @Override
            PsiMethod[] doCompute() {
                List<PsiDataBindingResourceItem> variables = LightBindingClass.this.myInfo.getItems(DataBindingResourceType.VARIABLE);
                PsiElementFactory factory = PsiElementFactory.SERVICE.getInstance((Project)LightBindingClass.this.myInfo.getProject());
                ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>(variables.size() * 2 + 6);
                DataBindingInfo mergedInfo = LightBindingClass.this.myInfo.getMergedInfo();
                if (mergedInfo == null) {
                    for (PsiDataBindingResourceItem variable : variables) {
                        LightBindingClass.this.createVariableMethods(factory, variable, methods, true);
                    }
                    LightBindingClass.this.createStaticMethods(factory, methods);
                } else {
                    for (PsiDataBindingResourceItem variable : mergedInfo.getItems(DataBindingResourceType.VARIABLE)) {
                        LightBindingClass.this.createVariableMethods(factory, variable, methods, false);
                    }
                }
                PsiMethod constructor = LightBindingClass.createConstructor(factory);
                methods.add(constructor);
                return methods.toArray(new PsiMethod[methods.size()]);
            }

            @Override
            PsiMethod[] defaultValue() {
                return PsiMethod.EMPTY_ARRAY;
            }
        }, false);
        this.myPsiFieldsCache = cachedValuesManager.createCachedValue((CachedValueProvider)new ResourceCacheValueProvider<PsiField[]>(facet, this.myLock, new ModificationTracker[0]){

            @Override
            PsiField[] doCompute() {
                if (LightBindingClass.this.myInfo.getMergedInfo() != null) {
                    return PsiField.EMPTY_ARRAY;
                }
                List<DataBindingInfo.ViewWithId> viewsWithIds = LightBindingClass.this.myInfo.getViewsWithIds();
                PsiElementFactory factory = PsiElementFactory.SERVICE.getInstance((Project)LightBindingClass.this.myInfo.getProject());
                PsiField[] result = new PsiField[viewsWithIds.size()];
                int i = 0;
                int unresolved = 0;
                for (DataBindingInfo.ViewWithId viewWithId : viewsWithIds) {
                    PsiField psiField = LightBindingClass.this.createPsiField(factory, viewWithId);
                    if (psiField == null) {
                        ++unresolved;
                        continue;
                    }
                    result[i++] = psiField;
                }
                if (unresolved > 0) {
                    PsiField[] validResult = new PsiField[i];
                    System.arraycopy(result, 0, validResult, 0, i);
                    return validResult;
                }
                return result;
            }

            @Override
            PsiField[] defaultValue() {
                return PsiField.EMPTY_ARRAY;
            }
        }, false);
    }

    @NotNull
    private static PsiMethod createConstructor(PsiElementFactory factory) {
        PsiMethod constructor = factory.createConstructor();
        PsiUtil.setModifierProperty((PsiModifierListOwner)constructor, (String)"private", (boolean)true);
        PsiMethod psiMethod = constructor;
        if (psiMethod == null) {
            LightBindingClass.$$$reportNull$$$0(1);
        }
        return psiMethod;
    }

    public String toString() {
        return this.myInfo.getClassName();
    }

    @Nullable
    public String getQualifiedName() {
        return this.myInfo.getQualifiedName();
    }

    @Nullable
    public PsiClass getContainingClass() {
        return null;
    }

    @Override
    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = (PsiField[])this.myPsiFieldsCache.getValue();
        if (psiFieldArray == null) {
            LightBindingClass.$$$reportNull$$$0(2);
        }
        return psiFieldArray;
    }

    @Override
    @NotNull
    public PsiField[] getAllFields() {
        PsiField[] psiFieldArray = this.getFields();
        if (psiFieldArray == null) {
            LightBindingClass.$$$reportNull$$$0(3);
        }
        return psiFieldArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = (PsiMethod[])this.myPsiMethodsCache.getValue();
        if (psiMethodArray == null) {
            LightBindingClass.$$$reportNull$$$0(4);
        }
        return psiMethodArray;
    }

    @Override
    public PsiClass getSuperClass() {
        DataBindingInfo mergedInfo = this.myInfo.getMergedInfo();
        String superClassName = mergedInfo == null ? "android.databinding.ViewDataBinding" : mergedInfo.getQualifiedName();
        return JavaPsiFacade.getInstance((Project)this.myInfo.getProject()).findClass(superClassName, this.myFacet.getModule().getModuleWithDependenciesAndLibrariesScope(false));
    }

    @Override
    public PsiReferenceList getExtendsList() {
        if (this.myExtendsList == null) {
            PsiElementFactory factory = PsiElementFactory.SERVICE.getInstance((Project)this.myInfo.getProject());
            PsiJavaCodeReferenceElement referenceElementByType = factory.createReferenceElementByType(this.getExtendsListTypes()[0]);
            this.myExtendsList = factory.createReferenceList(new PsiJavaCodeReferenceElement[]{referenceElementByType});
        }
        return this.myExtendsList;
    }

    @Override
    @NotNull
    public PsiClassType[] getSuperTypes() {
        PsiClassType[] psiClassTypeArray = this.getExtendsListTypes();
        if (psiClassTypeArray == null) {
            LightBindingClass.$$$reportNull$$$0(5);
        }
        return psiClassTypeArray;
    }

    @Override
    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        if (this.myExtendsListTypes == null) {
            DataBindingInfo mergedInfo = this.myInfo.getMergedInfo();
            String superClassName = mergedInfo == null ? "android.databinding.ViewDataBinding" : mergedInfo.getQualifiedName();
            this.myExtendsListTypes = new PsiClassType[]{PsiType.getTypeByName((String)superClassName, (Project)this.myInfo.getProject(), (GlobalSearchScope)this.myFacet.getModule().getModuleWithDependenciesAndLibrariesScope(false))};
        }
        if (this.myExtendsListTypes == null) {
            LightBindingClass.$$$reportNull$$$0(6);
        }
        return this.myExtendsListTypes;
    }

    @Override
    @NotNull
    public PsiMethod[] getAllMethods() {
        PsiMethod[] psiMethodArray = this.getMethods();
        if (psiMethodArray == null) {
            LightBindingClass.$$$reportNull$$$0(7);
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] findMethodsByName(@NonNls String name, boolean checkBases) {
        ArrayList<PsiMethod> matched = null;
        for (PsiMethod method : this.getMethods()) {
            if (!name.equals(method.getName())) continue;
            if (matched == null) {
                matched = new ArrayList<PsiMethod>();
            }
            matched.add(method);
        }
        PsiMethod[] psiMethodArray = matched == null ? PsiMethod.EMPTY_ARRAY : matched.toArray(new PsiMethod[matched.size()]);
        if (psiMethodArray == null) {
            LightBindingClass.$$$reportNull$$$0(8);
        }
        return psiMethodArray;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        boolean continueProcessing;
        if (processor == null) {
            LightBindingClass.$$$reportNull$$$0(9);
        }
        if (state == null) {
            LightBindingClass.$$$reportNull$$$0(10);
        }
        if (place == null) {
            LightBindingClass.$$$reportNull$$$0(11);
        }
        if (!(continueProcessing = super.processDeclarations(processor, state, lastParent, place))) {
            return false;
        }
        List<PsiDataBindingResourceItem> imports = this.myInfo.getItems(DataBindingResourceType.IMPORT);
        if (imports.isEmpty()) {
            return true;
        }
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if (classHint != null && classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
            String name = nameHint != null ? nameHint.getName(state) : null;
            for (PsiDataBindingResourceItem imp : imports) {
                String qName;
                String alias = imp.getExtra("alias");
                if (alias != null || (qName = imp.getExtra("type")) == null || name != null && !qName.endsWith("." + name)) continue;
                Module module = this.myInfo.getModule();
                if (module == null) {
                    return true;
                }
                PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findClass(qName, module.getModuleWithDependenciesAndLibrariesScope(true));
                if (aClass == null || processor.execute((PsiElement)aClass, state)) continue;
                return false;
            }
        }
        return true;
    }

    private static Lexer getJavaLexer() {
        if (ourJavaLexer == null) {
            ourJavaLexer = JavaParserDefinition.createLexer((LanguageLevel)LanguageLevel.JDK_1_6);
        }
        return ourJavaLexer;
    }

    private String replaceImportAliases(String type) {
        Map lookup = (Map)this.myAliasCache.getValue();
        if (lookup == null || lookup.isEmpty()) {
            return type;
        }
        Lexer lexer = LightBindingClass.getJavaLexer();
        lexer.start((CharSequence)type);
        boolean checkNext = true;
        StringBuilder out = new StringBuilder();
        IElementType tokenType = lexer.getTokenType();
        while (tokenType != null) {
            if (checkNext && tokenType == JavaTokenType.IDENTIFIER) {
                String tokenText = lexer.getTokenText();
                String replacement = (String)lookup.get(tokenText);
                if (replacement != null) {
                    out.append(replacement);
                } else {
                    out.append(tokenText);
                }
            } else {
                out.append(lexer.getTokenText());
            }
            if (tokenType != TokenType.WHITE_SPACE) {
                checkNext = tokenType == JavaTokenType.LT || tokenType == JavaTokenType.COMMA;
            }
            lexer.advance();
            tokenType = lexer.getTokenType();
        }
        return out.toString();
    }

    private void createVariableMethods(PsiElementFactory factory, PsiDataBindingResourceItem item, List<PsiMethod> outPsiMethods, boolean addGetter) {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myInfo.getProject());
        PsiMethod setter = factory.createMethod("set" + StringUtil.capitalize((String)item.getName()), (PsiType)PsiType.VOID);
        String variableType = this.replaceImportAliases(item.getExtra("type"));
        PsiType type = DataBindingUtil.parsePsiType(variableType, this.myFacet, (PsiElement)this);
        if (type == null) {
            return;
        }
        PsiParameter param = factory.createParameter(item.getName(), type);
        setter.getParameterList().add((PsiElement)param);
        PsiUtil.setModifierProperty((PsiModifierListOwner)setter, (String)"public", (boolean)true);
        if (this.myInfo.isMerged()) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)setter, (String)"abstract", (boolean)true);
        }
        outPsiMethods.add((PsiMethod)new LightDataBindingMethod((PsiElement)item.getXmlTag(), psiManager, setter, this, (Language)JavaLanguage.INSTANCE));
        if (addGetter) {
            PsiMethod getter = factory.createMethod("get" + StringUtil.capitalize((String)item.getName()), type);
            PsiUtil.setModifierProperty((PsiModifierListOwner)getter, (String)"public", (boolean)true);
            outPsiMethods.add((PsiMethod)new LightDataBindingMethod((PsiElement)item.getXmlTag(), psiManager, getter, this, (Language)JavaLanguage.INSTANCE));
        }
    }

    private void createStaticMethods(PsiElementFactory factory, List<PsiMethod> outPsiMethods) {
        PsiClassType myType = factory.createType((PsiClass)this);
        PsiClassType viewGroupType = PsiType.getTypeByName((String)"android.view.ViewGroup", (Project)this.myInfo.getProject(), (GlobalSearchScope)this.myFacet.getModule().getModuleWithDependenciesAndLibrariesScope(true));
        PsiClassType layoutInflaterType = PsiType.getTypeByName((String)"android.view.LayoutInflater", (Project)this.myInfo.getProject(), (GlobalSearchScope)this.myFacet.getModule().getModuleWithDependenciesAndLibrariesScope(true));
        PsiClassType dataBindingComponent = PsiType.getTypeByName((String)"android.databinding.DataBindingComponent", (Project)this.myInfo.getProject(), (GlobalSearchScope)this.myFacet.getModule().getModuleWithDependenciesAndLibrariesScope(true));
        PsiClassType viewType = PsiType.getTypeByName((String)"android.view.View", (Project)this.myInfo.getProject(), (GlobalSearchScope)this.myFacet.getModule().getModuleWithDependenciesAndLibrariesScope(true));
        PsiParameter layoutInflaterParam = factory.createParameter("inflater", (PsiType)layoutInflaterType);
        PsiParameter rootParam = factory.createParameter("root", (PsiType)viewGroupType);
        PsiParameter attachToRootParam = factory.createParameter("attachToRoot", (PsiType)PsiType.BOOLEAN);
        PsiParameter viewParam = factory.createParameter("view", (PsiType)viewType);
        PsiParameter componentParam = factory.createParameter("bindingComponent", (PsiType)dataBindingComponent);
        PsiMethod inflate4Arg = factory.createMethod("inflate", (PsiType)myType);
        inflate4Arg.getParameterList().add((PsiElement)layoutInflaterParam);
        inflate4Arg.getParameterList().add((PsiElement)rootParam);
        inflate4Arg.getParameterList().add((PsiElement)attachToRootParam);
        inflate4Arg.getParameterList().add((PsiElement)componentParam);
        PsiMethod inflate3Arg = factory.createMethod("inflate", (PsiType)myType);
        inflate3Arg.getParameterList().add((PsiElement)layoutInflaterParam);
        inflate3Arg.getParameterList().add((PsiElement)rootParam);
        inflate3Arg.getParameterList().add((PsiElement)attachToRootParam);
        PsiMethod inflate2Arg = factory.createMethod("inflate", (PsiType)myType);
        inflate2Arg.getParameterList().add((PsiElement)layoutInflaterParam);
        inflate2Arg.getParameterList().add((PsiElement)componentParam);
        PsiMethod inflate1Arg = factory.createMethod("inflate", (PsiType)myType);
        inflate1Arg.getParameterList().add((PsiElement)layoutInflaterParam);
        PsiMethod bind = factory.createMethod("bind", (PsiType)myType);
        bind.getParameterList().add((PsiElement)viewParam);
        PsiMethod bindWithComponent = factory.createMethod("bind", (PsiType)myType);
        bindWithComponent.getParameterList().add((PsiElement)viewParam);
        bindWithComponent.getParameterList().add((PsiElement)componentParam);
        PsiMethod[] methods = new PsiMethod[]{inflate1Arg, inflate2Arg, inflate3Arg, inflate4Arg, bind, bindWithComponent};
        PsiManager psiManager = PsiManager.getInstance((Project)this.myInfo.getProject());
        for (PsiMethod method : methods) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"public", (boolean)true);
            PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"static", (boolean)true);
            outPsiMethods.add((PsiMethod)new LightDataBindingMethod((PsiElement)this.myInfo.getPsiFile(), psiManager, method, this, (Language)JavaLanguage.INSTANCE));
        }
    }

    @Nullable
    private PsiField createPsiField(PsiElementFactory factory, DataBindingInfo.ViewWithId viewWithId) {
        PsiType type = DataBindingUtil.resolveViewPsiType(viewWithId, this.myFacet);
        if (type == null) {
            return null;
        }
        PsiField field = factory.createField(viewWithId.name, type);
        PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"public", (boolean)true);
        PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"final", (boolean)true);
        return new LightDataBindingField(viewWithId, PsiManager.getInstance((Project)this.myInfo.getProject()), field, this);
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.myInfo.getNavigationElement();
        if (psiElement == null) {
            LightBindingClass.$$$reportNull$$$0(12);
        }
        return psiElement;
    }

    public String getName() {
        return this.myInfo.getClassName();
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        return this.myVirtualPsiFile;
    }

    public boolean isValid() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/databinding/LightBindingClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/databinding/LightBindingClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsListTypes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethods";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsByName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LightDataBindingField
    extends LightField {
        private final DataBindingInfo.ViewWithId myViewWithId;

        LightDataBindingField(DataBindingInfo.ViewWithId viewWithId, @NotNull PsiManager manager, @NotNull PsiField field, @NotNull PsiClass containingClass) {
            if (manager == null) {
                LightDataBindingField.$$$reportNull$$$0(0);
            }
            if (field == null) {
                LightDataBindingField.$$$reportNull$$$0(1);
            }
            if (containingClass == null) {
                LightDataBindingField.$$$reportNull$$$0(2);
            }
            super(manager, field, containingClass);
            this.myViewWithId = viewWithId;
        }

        @Nullable
        public PsiFile getContainingFile() {
            PsiClass containingClass = super.getContainingClass();
            return containingClass == null ? null : containingClass.getContainingFile();
        }

        @NotNull
        public PsiElement getNavigationElement() {
            XmlTag xmlTag = this.myViewWithId.tag;
            if (xmlTag == null) {
                LightDataBindingField.$$$reportNull$$$0(3);
            }
            return xmlTag;
        }

        @NotNull
        public PsiElement setName(@NotNull String name) {
            if (name == null) {
                LightDataBindingField.$$$reportNull$$$0(4);
            }
            LightDataBindingField lightDataBindingField = this;
            if (lightDataBindingField == null) {
                LightDataBindingField.$$$reportNull$$$0(5);
            }
            return lightDataBindingField;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingClass";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/databinding/LightBindingClass$LightDataBindingField";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/databinding/LightBindingClass$LightDataBindingField";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class LightDataBindingMethod
    extends LightMethod {
        private PsiElement myNavigationElement;

        LightDataBindingMethod(@NotNull PsiElement navigationElement, @NotNull PsiManager manager, @NotNull PsiMethod method, @NotNull PsiClass containingClass, @NotNull Language language) {
            if (navigationElement == null) {
                LightDataBindingMethod.$$$reportNull$$$0(0);
            }
            if (manager == null) {
                LightDataBindingMethod.$$$reportNull$$$0(1);
            }
            if (method == null) {
                LightDataBindingMethod.$$$reportNull$$$0(2);
            }
            if (containingClass == null) {
                LightDataBindingMethod.$$$reportNull$$$0(3);
            }
            if (language == null) {
                LightDataBindingMethod.$$$reportNull$$$0(4);
            }
            super(manager, method, containingClass, language);
            this.myNavigationElement = navigationElement;
        }

        @Nullable
        public PsiFile getContainingFile() {
            PsiClass containingClass = super.getContainingClass();
            return containingClass.getContainingFile();
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.myNavigationElement;
            if (psiElement == null) {
                LightDataBindingMethod.$$$reportNull$$$0(5);
            }
            return psiElement;
        }

        public PsiIdentifier getNameIdentifier() {
            return new LightIdentifier(this.getManager(), this.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "navigationElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingClass";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/databinding/LightBindingClass$LightDataBindingMethod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/databinding/LightBindingClass$LightDataBindingMethod";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

