/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.allocations;

import com.android.ddmlib.AllocationInfo;
import com.android.tools.adtui.Choreographer;
import com.android.tools.adtui.LegacyAnimatedComponent;
import com.android.tools.adtui.ValuedTreeNode;
import com.android.tools.adtui.chart.SunburstChart;
import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.idea.actions.BrowserHelpAction;
import com.android.tools.idea.actions.EditMultipleSourcesAction;
import com.android.tools.idea.actions.PsiClassNavigation;
import com.android.tools.idea.editors.allocations.nodes.AbstractTreeNode;
import com.android.tools.idea.editors.allocations.nodes.AllocNode;
import com.android.tools.idea.editors.allocations.nodes.ClassNode;
import com.android.tools.idea.editors.allocations.nodes.MainTreeNode;
import com.android.tools.idea.editors.allocations.nodes.PackageNode;
import com.android.tools.idea.editors.allocations.nodes.PackageRootNode;
import com.android.tools.idea.editors.allocations.nodes.StackNode;
import com.android.tools.idea.editors.allocations.nodes.StackTraceRootNode;
import com.android.tools.idea.editors.allocations.nodes.ThreadNode;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.ImmutableMap;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SearchTextFieldWithStoredHistory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AllocationsView
implements SunburstChart.SliceSelectionListener {
    @NotNull
    private static final String ALLOCATION_VIEW_ID = "AllocationView";
    @NotNull
    private static final String GROUP_BY_NAME = ".GroupBy";
    @NotNull
    private static final String SHOW_CHART_STATE = ".ShowChart";
    private static final int MAX_AUTO_EXPANSION_DEPTH = 5;
    @NotNull
    private final Project myProject;
    @NotNull
    private final AllocationInfo[] myAllocations;
    private final DefaultTableModel myInfoTableModel;
    private final SearchTextFieldWithStoredHistory myPackageFilter;
    @NotNull
    private MainTreeNode myTreeNode;
    @NotNull
    private final JTree myTree;
    @NotNull
    private final DefaultTreeModel myTreeModel;
    @NotNull
    private JBSplitter mySplitter;
    @NotNull
    private JComponent myChartPane;
    @NotNull
    private final Component myComponent;
    private final Map<String, GroupBy> myGroupBy;
    private String myGroupByName;
    private final SunburstChart myLayout;
    private String myChartOrientation;
    private String myChartUnit;
    private final JLabel myInfoLabel;
    private Alarm myAlarm;
    private final JBTable myInfoTable;

    public AllocationsView(@NotNull Project project, @NotNull AllocationInfo[] allocations) {
        if (project == null) {
            AllocationsView.$$$reportNull$$$0(0);
        }
        if (allocations == null) {
            AllocationsView.$$$reportNull$$$0(1);
        }
        this.myGroupBy = new ImmutableMap.Builder().put((Object)"Group by Method", (Object)new GroupByMethod()).put((Object)"Group by Allocator", (Object)new GroupByAllocator()).build();
        this.myProject = project;
        this.myAllocations = allocations;
        this.myGroupByName = PropertiesComponent.getInstance((Project)project).getValue("AllocationView.GroupBy", "Group by Method");
        this.myPackageFilter = new SearchTextFieldWithStoredHistory("alloc.package.filter");
        this.myPackageFilter.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                AllocationsView.this.myAlarm.cancelAllRequests();
                AllocationsView.this.myAlarm.addRequest(() -> AllocationsView.this.setGroupByName("Group by Allocator"), 1000);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/editors/allocations/AllocationsView$1", "textChanged"));
            }
        });
        this.myTreeNode = this.generateTree();
        this.myTreeModel = new DefaultTreeModel((TreeNode)((Object)this.myTreeNode));
        this.myAlarm = new Alarm((Disposable)project);
        this.myTree = new Tree((TreeModel)this.myTreeModel);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.putClientProperty("DataProvider", new TreeDataProvider());
        final DefaultActionGroup popupGroup = new DefaultActionGroup();
        popupGroup.add((AnAction)new EditMultipleSourcesAction());
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)popupGroup).getComponent().show(comp, x, y);
            }
        });
        this.myTree.addTreeExpansionListener(new TreeExpansionListener(){
            private boolean myIsCurrentlyExpanding = false;

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                AbstractTreeNode childNode;
                AbstractTreeNode node;
                if (this.myIsCurrentlyExpanding) {
                    return;
                }
                this.myIsCurrentlyExpanding = true;
                AbstractTreeNode currentNode = node = (AbstractTreeNode)event.getPath().getLastPathComponent();
                ArrayList<Object> expandedPath = new ArrayList<Object>(Arrays.asList(event.getPath().getPath()));
                for (int recursiveDepth = 0; currentNode.getChildCount() == 1 && recursiveDepth < 5 && !(childNode = (AbstractTreeNode)((Object)currentNode.getChildAt(0))).isLeaf(); ++recursiveDepth) {
                    expandedPath.add(childNode);
                    currentNode = childNode;
                }
                if (node != currentNode) {
                    AllocationsView.this.myTree.expandPath(new TreePath(expandedPath.toArray()));
                }
                this.myIsCurrentlyExpanding = false;
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        ColumnTreeBuilder builder = new ColumnTreeBuilder(this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Method").setPreferredWidth(600).setHeaderAlignment(2).setComparator((a, b) -> {
            if (a instanceof ThreadNode && b instanceof ThreadNode) {
                return ((ThreadNode)a).getThreadId() - ((ThreadNode)b).getThreadId();
            }
            if (a instanceof StackNode && b instanceof StackNode) {
                StackTraceElement ea = ((StackNode)a).getStackTraceElement();
                StackTraceElement eb = ((StackNode)b).getStackTraceElement();
                int value = ea.getMethodName().compareTo(eb.getMethodName());
                if (value == 0) {
                    value = ea.getLineNumber() - eb.getLineNumber();
                }
                return value;
            }
            return a.getClass().toString().compareTo(b.getClass().toString());
        }).setRenderer((ColoredTreeCellRenderer)new NodeTreeCellRenderer())).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Count").setPreferredWidth(150).setHeaderAlignment(4).setComparator((a, b) -> a.getCount() - b.getCount()).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (value instanceof ValuedTreeNode) {
                    int v = ((ValuedTreeNode)value).getCount();
                    int total = AllocationsView.this.myTreeNode.getCount();
                    this.setTextAlign(4);
                    this.append(String.valueOf(v));
                    this.append(String.format(" (%.2f%%)", Float.valueOf(100.0f * (float)v / (float)total)), new SimpleTextAttributes(0, (Color)JBColor.GRAY));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/allocations/AllocationsView$5", "customizeCellRenderer"));
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Total Size").setPreferredWidth(150).setHeaderAlignment(4).setInitialOrder(SortOrder.DESCENDING).setComparator((a, b) -> a.getValue() - b.getValue()).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (value instanceof ValuedTreeNode) {
                    int v = ((ValuedTreeNode)value).getValue();
                    int total = AllocationsView.this.myTreeNode.getValue();
                    this.setTextAlign(4);
                    this.append(String.valueOf(v));
                    this.append(String.format(" (%.2f%%)", Float.valueOf(100.0f * (float)v / (float)total)), new SimpleTextAttributes(0, (Color)JBColor.GRAY));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/allocations/AllocationsView$4", "customizeCellRenderer"));
            }
        }));
        builder.setTreeSorter((comparator, sortOrder) -> {
            this.myTreeNode.sort(comparator);
            this.myTreeModel.nodeStructureChanged((TreeNode)((Object)this.myTreeNode));
        });
        JComponent columnTree = builder.build();
        this.mySplitter = new JBSplitter(true);
        new TreeSpeedSearch(this.myTree, e -> {
            Object o = e.getLastPathComponent();
            if (o instanceof StackNode) {
                StackTraceElement ee = ((StackNode)o).getStackTraceElement();
                return ee.toString();
            }
            return o.toString();
        }, true);
        JPanel panel = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("AndroidAllocationsView", this.getMainActions(), true);
        topPanel.add((Component)toolbar.getComponent(), "Center");
        this.myPackageFilter.setVisible(false);
        topPanel.add((Component)this.myPackageFilter, "East");
        panel.add((Component)topPanel, "North");
        panel.add((Component)columnTree, "Center");
        this.mySplitter.setFirstComponent((JComponent)panel);
        this.myChartPane = new JPanel(new BorderLayout());
        this.myLayout = new SunburstChart((ValuedTreeNode)this.myTreeNode);
        this.myLayout.setAngle(360.0f);
        this.myLayout.setAutoSize(true);
        this.myLayout.setSeparator(1.0f);
        this.myLayout.setGap(20.0f);
        this.myLayout.addSelectionListener((SunburstChart.SliceSelectionListener)this);
        this.myLayout.setBorder(IdeBorderFactory.createBorder());
        this.myLayout.setBackground(UIUtil.getTreeBackground());
        Choreographer.animate((LegacyAnimatedComponent)this.myLayout);
        toolbar = ActionManager.getInstance().createActionToolbar("AndroidAllocationsViewSunburst", this.getChartActions(), true);
        this.myChartOrientation = "Sunburst";
        this.myChartUnit = "Size";
        this.myChartPane = new JPanel(new BorderLayout());
        this.myChartPane.add((Component)toolbar.getComponent(), "North");
        JBSplitter chartSplitter = new JBSplitter();
        this.myChartPane.add((Component)chartSplitter, "Center");
        chartSplitter.setFirstComponent((JComponent)this.myLayout);
        if (PropertiesComponent.getInstance().getBoolean("AllocationView.ShowChart", false)) {
            this.mySplitter.setSecondComponent(this.myChartPane);
        }
        JPanel infoPanel = new JPanel(new BorderLayout());
        infoPanel.setBorder(IdeBorderFactory.createBorder());
        this.myInfoLabel = new JLabel();
        this.myInfoLabel.setBackground(UIUtil.getTreeBackground());
        this.myInfoLabel.setOpaque(true);
        this.myInfoLabel.setVerticalAlignment(1);
        infoPanel.add((Component)this.myInfoLabel, "North");
        this.myInfoTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int i, int i1) {
                return false;
            }
        };
        this.myInfoTableModel.addColumn("Data");
        this.myInfoTable = new JBTable((TableModel)this.myInfoTableModel);
        this.myInfoTable.putClientProperty((Object)"DataProvider", (Object)new TableDataProvider());
        this.myInfoTable.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)popupGroup).getComponent().show(comp, x, y);
            }

            public void mousePressed(MouseEvent e) {
                Object value;
                super.mousePressed(e);
                if (e.getClickCount() == 2 && (value = AllocationsView.this.myInfoTable.getValueAt(AllocationsView.this.myInfoTable.getSelectedRow(), 0)) instanceof TreeNode) {
                    Object[] nodes = AllocationsView.this.myTreeModel.getPathToRoot((TreeNode)value);
                    TreePath path = new TreePath(nodes);
                    AllocationsView.this.myTree.setSelectionPath(path);
                    AllocationsView.this.myTree.scrollPathToVisible(path);
                }
            }
        });
        this.myInfoTable.setTableHeader(null);
        this.myInfoTable.setShowGrid(false);
        this.myInfoTable.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new NodeTableCellRenderer()));
        JBScrollPane scroll = new JBScrollPane((Component)this.myInfoTable);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        infoPanel.add((Component)scroll, "Center");
        chartSplitter.setSecondComponent((JComponent)infoPanel);
        chartSplitter.setProportion(0.7f);
        this.myComponent = this.mySplitter;
        this.setGroupByName(this.myGroupByName);
    }

    @NotNull
    public Component getComponent() {
        Component component2 = this.myComponent;
        if (component2 == null) {
            AllocationsView.$$$reportNull$$$0(2);
        }
        return component2;
    }

    private void setGroupByName(@NotNull String groupByName) {
        if (groupByName == null) {
            AllocationsView.$$$reportNull$$$0(3);
        }
        if (this.myGroupBy.containsKey(groupByName)) {
            this.myGroupByName = groupByName;
            this.myTreeNode = this.generateTree();
            this.myTreeModel.setRoot((TreeNode)((Object)this.myTreeNode));
            this.myLayout.setData((ValuedTreeNode)this.myTreeNode);
            this.myLayout.resetZoom();
            this.myTreeModel.nodeStructureChanged((TreeNode)((Object)this.myTreeNode));
            this.myPackageFilter.setVisible(this.myGroupBy.get(this.myGroupByName) instanceof GroupByAllocator);
            PropertiesComponent.getInstance((Project)this.myProject).setValue("AllocationView.GroupBy", this.myGroupByName);
        }
    }

    private ActionGroup getMainActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ComboBoxAction(){

            @NotNull
            protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                DefaultActionGroup group = new DefaultActionGroup();
                group.add((AnAction)new ChangeGroupAction("Group by Method"));
                group.add((AnAction)new ChangeGroupAction("Group by Allocator"));
                DefaultActionGroup defaultActionGroup = group;
                if (defaultActionGroup == null) {
                    8.$$$reportNull$$$0(0);
                }
                return defaultActionGroup;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(1);
                }
                super.update(e);
                this.getTemplatePresentation().setText(((GroupBy)AllocationsView.this.myGroupBy.get(AllocationsView.this.myGroupByName)).getName());
                e.getPresentation().setText(((GroupBy)AllocationsView.this.myGroupBy.get(AllocationsView.this.myGroupByName)).getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/idea/editors/allocations/AllocationsView$8";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPopupActionGroup";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/idea/editors/allocations/AllocationsView$8";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        group.add((AnAction)new EditMultipleSourcesAction());
        group.add((AnAction)new ShowChartAction());
        group.add((AnAction)new Separator());
        group.add((AnAction)new BrowserHelpAction("Hprof Viewer", "http://developer.android.com/r/studio-ui/am-allocation.html"));
        return group;
    }

    @Nullable
    public Object getData(@NonNls String dataId, Object selectionData) {
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.getTargetFiles(selectionData);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        return null;
    }

    private ActionGroup getChartActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ComboBoxAction(){

            @NotNull
            protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                DefaultActionGroup group = new DefaultActionGroup();
                group.add(new AnAction("Sunburst"){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        AllocationsView.this.myChartOrientation = "Sunburst";
                        AllocationsView.this.myLayout.setAngle(360.0f);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/editors/allocations/AllocationsView$9$1", "actionPerformed"));
                    }
                });
                group.add(new AnAction("Layout"){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        AllocationsView.this.myChartOrientation = "Layout";
                        AllocationsView.this.myLayout.setAngle(0.0f);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/editors/allocations/AllocationsView$9$2", "actionPerformed"));
                    }
                });
                DefaultActionGroup defaultActionGroup = group;
                if (defaultActionGroup == null) {
                    9.$$$reportNull$$$0(0);
                }
                return defaultActionGroup;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(1);
                }
                super.update(e);
                this.getTemplatePresentation().setText(AllocationsView.this.myChartOrientation);
                e.getPresentation().setText(AllocationsView.this.myChartOrientation);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/idea/editors/allocations/AllocationsView$9";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPopupActionGroup";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/idea/editors/allocations/AllocationsView$9";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        group.add((AnAction)new ComboBoxAction(){

            @NotNull
            protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                DefaultActionGroup group = new DefaultActionGroup();
                group.add(new AnAction("Size"){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        AllocationsView.this.myChartUnit = "Size";
                        AllocationsView.this.myLayout.setUseCount(false);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/editors/allocations/AllocationsView$10$1", "actionPerformed"));
                    }
                });
                group.add(new AnAction("Count"){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        AllocationsView.this.myChartUnit = "Count";
                        AllocationsView.this.myLayout.setUseCount(true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/editors/allocations/AllocationsView$10$2", "actionPerformed"));
                    }
                });
                DefaultActionGroup defaultActionGroup = group;
                if (defaultActionGroup == null) {
                    10.$$$reportNull$$$0(0);
                }
                return defaultActionGroup;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    10.$$$reportNull$$$0(1);
                }
                super.update(e);
                this.getTemplatePresentation().setText(AllocationsView.this.myChartUnit);
                e.getPresentation().setText(AllocationsView.this.myChartUnit);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/idea/editors/allocations/AllocationsView$10";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPopupActionGroup";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/idea/editors/allocations/AllocationsView$10";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return group;
    }

    @NotNull
    private MainTreeNode generateTree() {
        MainTreeNode tree = this.myGroupBy.get(this.myGroupByName).create();
        for (AllocationInfo alloc : this.myAllocations) {
            tree.insert(alloc);
        }
        MainTreeNode mainTreeNode = tree;
        if (mainTreeNode == null) {
            AllocationsView.$$$reportNull$$$0(4);
        }
        return mainTreeNode;
    }

    public void valueChanged(SunburstChart.SliceSelectionEvent e) {
        ValuedTreeNode node = e == null ? null : e.getNode();
        HtmlBuilder builder = new HtmlBuilder();
        builder.openHtmlBody();
        if (node == null) {
            node = this.myTreeNode;
        }
        builder.add("Total allocations:").addNbsp().addBold(Integer.toString(node.getCount())).newline().add("Total size:").addNbsp().addBold(StringUtil.formatFileSize((long)node.getValue())).newline().newline();
        if (node instanceof AbstractTreeNode) {
            TreeNode[] path = this.myTreeModel.getPathToRoot((TreeNode)node);
            this.myInfoTableModel.setRowCount(path.length);
            for (int i = 1; i < path.length; ++i) {
                this.myInfoTableModel.setValueAt(path[i], i - 1, 0);
            }
            this.myInfoTableModel.fireTableDataChanged();
        }
        builder.closeHtmlBody();
        this.myInfoLabel.setText(builder.getHtml());
    }

    private static void customizeColoredRenderer(SimpleColoredComponent renderer, Object value) {
        renderer.setTransparentIconBackground(true);
        if (value instanceof ThreadNode) {
            renderer.setIcon(AllIcons.Debugger.ThreadSuspended);
            renderer.append("< Thread " + ((ThreadNode)value).getThreadId() + " >");
        } else if (value instanceof StackNode) {
            StackTraceElement element = ((StackNode)value).getStackTraceElement();
            String name = element.getClassName();
            String pkg = null;
            int ix = name.lastIndexOf(46);
            if (ix != -1) {
                pkg = name.substring(0, ix);
                name = name.substring(ix + 1);
            }
            renderer.setIcon(PlatformIcons.METHOD_ICON);
            renderer.append(element.getMethodName() + "()");
            renderer.append(":" + element.getLineNumber() + ", ");
            renderer.append(name);
            if (pkg != null) {
                renderer.append(" (" + pkg + ")", new SimpleTextAttributes(0, (Color)JBColor.GRAY));
            }
        } else if (value instanceof AllocNode) {
            AllocationInfo allocation = ((AllocNode)value).getAllocation();
            renderer.setIcon(AllIcons.FileTypes.JavaClass);
            renderer.append(allocation.getAllocatedClass());
        } else if (value instanceof ClassNode) {
            renderer.setIcon(PlatformIcons.CLASS_ICON);
            renderer.append(((PackageNode)value).getName());
        } else if (value instanceof PackageNode) {
            String name = ((PackageNode)value).getName();
            if (!name.isEmpty()) {
                renderer.setIcon(AllIcons.Modules.SourceFolder);
                renderer.append(name);
            }
        } else if (!(value instanceof StackTraceRootNode) && value != null) {
            renderer.append(value.toString());
        }
    }

    @Nullable
    private PsiClassNavigation[] getTargetFiles(Object node) {
        if (node == null) {
            return null;
        }
        String className = null;
        int lineNumber = 0;
        if (node instanceof ClassNode) {
            className = ((ClassNode)node).getQualifiedName();
        } else {
            StackTraceElement[] stack;
            StackTraceElement element = null;
            if (node instanceof StackNode) {
                element = ((StackNode)node).getStackTraceElement();
            } else if (node instanceof AllocNode && (stack = ((AllocNode)node).getAllocation().getStackTrace()).length > 0) {
                element = stack[0];
            }
            if (element != null) {
                lineNumber = element.getLineNumber() - 1;
                className = element.getClassName();
                int ix = className.indexOf(36);
                if (ix >= 0) {
                    className = className.substring(0, ix);
                }
            }
        }
        return PsiClassNavigation.getNavigationForClass(this.myProject, className, lineNumber);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allocations";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/allocations/AllocationsView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/allocations/AllocationsView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setGroupByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TableDataProvider
    implements DataProvider {
        private TableDataProvider() {
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            int selectedRow;
            if (dataId == null) {
                TableDataProvider.$$$reportNull$$$0(0);
            }
            if ((selectedRow = AllocationsView.this.myInfoTable.getSelectedRow()) < 0) {
                return null;
            }
            return AllocationsView.this.getData(dataId, AllocationsView.this.myInfoTable.getValueAt(selectedRow, 0));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/android/tools/idea/editors/allocations/AllocationsView$TableDataProvider", "getData"));
        }
    }

    private class TreeDataProvider
    implements DataProvider {
        private TreeDataProvider() {
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                TreeDataProvider.$$$reportNull$$$0(0);
            }
            return AllocationsView.this.getData(dataId, AllocationsView.this.myTree.getLastSelectedPathComponent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/android/tools/idea/editors/allocations/AllocationsView$TreeDataProvider", "getData"));
        }
    }

    class ShowChartAction
    extends ToggleAction {
        ShowChartAction() {
            super("Show/Hide Chart", "Shows/hides the allocation chart and stack trace", AndroidIcons.Sunburst);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowChartAction.$$$reportNull$$$0(0);
            }
            return AllocationsView.this.mySplitter.getSecondComponent() != null;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowChartAction.$$$reportNull$$$0(1);
            }
            PropertiesComponent.getInstance().setValue("AllocationView.ShowChart", state);
            if (state) {
                AllocationsView.this.mySplitter.setSecondComponent(AllocationsView.this.myChartPane);
            } else {
                AllocationsView.this.mySplitter.setSecondComponent(null);
            }
            AllocationsView.this.valueChanged(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/android/tools/idea/editors/allocations/AllocationsView$ShowChartAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    class ChangeGroupAction
    extends AnAction {
        @NotNull
        private String myGroupByName;

        ChangeGroupAction(String groupByName) {
            if (groupByName == null) {
                ChangeGroupAction.$$$reportNull$$$0(0);
            }
            super(groupByName);
            this.myGroupByName = groupByName;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangeGroupAction.$$$reportNull$$$0(1);
            }
            AllocationsView.this.setGroupByName(this.myGroupByName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupByName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/editors/allocations/AllocationsView$ChangeGroupAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    class GroupByAllocator
    implements GroupBy {
        public static final String NAME = "Group by Allocator";

        GroupByAllocator() {
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public MainTreeNode create() {
            return new PackageRootNode("", AllocationsView.this.myPackageFilter.getText());
        }
    }

    static class GroupByMethod
    implements GroupBy {
        public static final String NAME = "Group by Method";

        GroupByMethod() {
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public MainTreeNode create() {
            return new StackTraceRootNode();
        }
    }

    static interface GroupBy {
        public String getName();

        public MainTreeNode create();
    }

    private static class NodeTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private NodeTreeCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                NodeTreeCellRenderer.$$$reportNull$$$0(0);
            }
            AllocationsView.customizeColoredRenderer((SimpleColoredComponent)this, value);
        }

        protected boolean shouldDrawBackground() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/allocations/AllocationsView$NodeTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    public static class NodeTableCellRenderer
    extends ColoredTableCellRenderer {
        protected void customizeCellRenderer(JTable table2, Object value, boolean selected, boolean hasFocus, int row, int column) {
            AllocationsView.customizeColoredRenderer((SimpleColoredComponent)this, value);
        }
    }
}

