/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.views;

import com.android.ddmlib.BitmapDecoder;
import com.android.tools.idea.editors.hprof.views.InstancesTreeView;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.memoryanalyzer.HprofBitmapProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import icons.ImagesIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.intellij.images.editor.impl.ImageEditorManagerImpl;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public final class ViewBitmapAction
extends AnAction {
    public ViewBitmapAction() {
        super(AndroidBundle.message("android.profiler.hprof.actions.view.bitmap.title", new Object[0]), AndroidBundle.message("android.profiler.hprof.actions.view.bitmap.description", new Object[0]), ImagesIcons.ImagesFileType);
    }

    public void update(@NotNull AnActionEvent e) {
        boolean isBitmap;
        if (e == null) {
            ViewBitmapAction.$$$reportNull$$$0(0);
        }
        ClassInstance selectedClassInstance = (ClassInstance)e.getData(InstancesTreeView.SELECTED_CLASS_INSTANCE);
        Presentation presentation = e.getPresentation();
        if (selectedClassInstance != null && (isBitmap = HprofBitmapProvider.canGetBitmapFromInstance((Instance)selectedClassInstance))) {
            presentation.setEnabled(true);
            return;
        }
        presentation.setEnabled(false);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ClassInstance selectedClassInstance;
        if (e == null) {
            ViewBitmapAction.$$$reportNull$$$0(1);
        }
        if ((selectedClassInstance = (ClassInstance)e.getData(InstancesTreeView.SELECTED_CLASS_INSTANCE)) == null) {
            return;
        }
        try {
            Object comp;
            BufferedImage img = BitmapDecoder.getBitmap((BitmapDecoder.BitmapDataProvider)new HprofBitmapProvider((Instance)selectedClassInstance));
            if (img != null) {
                comp = ImageEditorManagerImpl.createImageEditorUI((BufferedImage)img);
            } else {
                String errorMessage = AndroidBundle.message("android.profiler.hprof.actions.view.bitmap.fail", new Object[0]);
                comp = new JLabel(errorMessage, Messages.getErrorIcon(), 0);
            }
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            JBPopup popup2 = DebuggerUIUtil.createValuePopup((Project)project, (JComponent)comp, null);
            JFrame frame = WindowManager.getInstance().getFrame(project);
            Dimension frameSize = frame.getSize();
            Dimension size = new Dimension(frameSize.width / 2, frameSize.height / 2);
            popup2.setSize(size);
            popup2.show(new RelativePoint((Component)frame, new Point(size.width / 2, size.height / 2)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/android/tools/idea/editors/hprof/views/ViewBitmapAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

