/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector.actions;

import com.android.tools.idea.editors.layoutInspector.ui.ViewNodeActiveDisplay;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileTypeDescriptor;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/editors/layoutInspector/actions/LoadOverlayAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "myPreview", "Lcom/android/tools/idea/editors/layoutInspector/ui/ViewNodeActiveDisplay;", "(Lcom/android/tools/idea/editors/layoutInspector/ui/ViewNodeActiveDisplay;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "loadImageFile", "Ljava/awt/Image;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "loadOverlay", "update", "Companion", "intellij.android"})
public final class LoadOverlayAction
extends AnAction
implements CustomComponentAction {
    private final ViewNodeActiveDisplay myPreview;
    @JvmField
    @NotNull
    public static final String ACTION_ID = "Load Overlay";
    @JvmField
    @NotNull
    public static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        return (JComponent)new ActionButtonWithText((AnAction)this, presentation, "Toolbar", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (this.myPreview.hasOverlay()) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setIcon(StudioIcons.LayoutInspector.CLEAR_OVERLAY);
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
            presentation2.setText("Clear Overlay");
        } else {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setIcon(StudioIcons.LayoutInspector.LOAD_OVERLAY);
            Presentation presentation3 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation3, (String)"e.presentation");
            presentation3.setText(ACTION_ID);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (this.myPreview.hasOverlay()) {
            this.myPreview.setOverLay(null, null);
        } else {
            this.loadOverlay(e);
        }
    }

    private final void loadOverlay(AnActionEvent e) {
        boolean bl;
        FileTypeDescriptor descriptor = new FileTypeDescriptor("Choose Overlay", new String[]{"svg", "png", "jpg"});
        FileChooserDialog fileChooserDialog = FileChooserFactory.getInstance().createFileChooser((FileChooserDescriptor)descriptor, null, null);
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Object object = e.getProject();
        if (object == null || (object = object.getBasePath()) == null) {
            object = "/";
        }
        VirtualFile toSelect = localFileSystem.refreshAndFindFileByPath((String)object);
        VirtualFile[] virtualFileArray = new VirtualFile[1];
        VirtualFile virtualFile = toSelect;
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        virtualFileArray[0] = virtualFile;
        VirtualFile[] files = fileChooserDialog.choose(null, virtualFileArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)files, (String)"files");
        VirtualFile[] virtualFileArray2 = files;
        if (virtualFileArray2.length == 0) {
            return;
        }
        boolean bl2 = bl = files.length == 1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        VirtualFile virtualFile2 = files[0];
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"files[0]");
        Image image = this.loadImageFile(virtualFile2);
        VirtualFile virtualFile3 = files[0];
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"files[0]");
        this.myPreview.setOverLay(image, virtualFile3.getName());
    }

    private final Image loadImageFile(VirtualFile file) {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(file.getInputStream());
        }
        catch (IOException e) {
            Messages.showErrorDialog((String)("Failed to read image from \"" + file.getName() + "\" Error: " + e.getMessage()), (String)"Error");
            LOG.warn((Throwable)e);
            return null;
        }
        return bufferedImage;
    }

    public LoadOverlayAction(@NotNull ViewNodeActiveDisplay myPreview) {
        Intrinsics.checkParameterIsNotNull((Object)myPreview, (String)"myPreview");
        super(ACTION_ID, "Overlay Image", StudioIcons.LayoutInspector.LOAD_OVERLAY);
        this.myPreview = myPreview;
    }

    static {
        Companion = new Companion(null);
        ACTION_ID = ACTION_ID;
        LOG = Logger.getInstance(Companion.getClass());
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/editors/layoutInspector/actions/LoadOverlayAction$Companion;", "", "()V", "ACTION_ID", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.android"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

