/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.manifest;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.Actions;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlNode;
import com.android.tools.idea.editors.manifest.AnnotationColors;
import com.android.tools.idea.editors.manifest.ManifestUtils;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.utils.FileUtils;
import com.android.utils.HtmlBuilder;
import com.android.utils.PositionXmlParser;
import com.google.common.collect.Sets;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManifestPanel
extends JPanel
implements TreeSelectionListener {
    private static final String SUGGESTION_MARKER = "Suggestion: ";
    private static final Pattern ADD_SUGGESTION_FORMAT = Pattern.compile(".*? 'tools:([\\w:]+)=\"([\\w:]+)\"' to \\<(\\w+)\\> element at [^:]+:(\\d+):(\\d+)-[\\d:]+ to override\\.", 32);
    private static final Pattern NAV_FILE_PATTERN = Pattern.compile(".*/navigation(-[^/]*)?/[^/]*$");
    private static final File GRADLE_MODEL_MARKER_FILE = new File("build.gradle");
    private final AndroidFacet myFacet;
    private final Font myDefaultFont;
    private final Tree myTree;
    private final JEditorPane myDetails;
    private JPopupMenu myPopup;
    private JMenuItem myRemoveItem;
    private MergedManifest myManifest;
    private final List<File> myFiles;
    private final List<File> myOtherFiles;
    private final HtmlLinkManager myHtmlLinkManager;
    private VirtualFile myFile;
    private final Color myBackgroundColor;
    private static final Comparator<File> MANIFEST_SORTER = (o1, o2) -> {
        boolean lib2;
        String p1 = o1.getPath();
        String p2 = o2.getPath();
        boolean lib1 = p1.contains("exploded-aar");
        if (lib1 != (lib2 = p2.contains("exploded-aar"))) {
            return lib1 ? 1 : -1;
        }
        return p1.compareTo(p2);
    };

    public ManifestPanel(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ManifestPanel.$$$reportNull$$$0(0);
        }
        this.myFiles = new ArrayList<File>();
        this.myOtherFiles = new ArrayList<File>();
        this.myHtmlLinkManager = new HtmlLinkManager();
        this.myFacet = facet;
        this.setLayout(new BorderLayout());
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme scheme = colorsManager.getGlobalScheme();
        this.myBackgroundColor = scheme.getDefaultBackground();
        this.myDefaultFont = scheme.getFont(EditorFontType.PLAIN);
        this.myTree = new FileColorTree();
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new SyntaxHighlightingCellRenderer()));
        TreeSelectionModel selectionModel = this.myTree.getSelectionModel();
        selectionModel.setSelectionMode(1);
        selectionModel.addTreeSelectionListener(this);
        this.myDetails = this.createDetailsPane(facet);
        this.addSpeedSearch();
        this.createPopupMenu();
        this.registerGotoAction();
        JBSplitter splitter = new JBSplitter(0.5f);
        splitter.setFirstComponent((JComponent)new JBScrollPane((Component)this.myTree));
        splitter.setSecondComponent((JComponent)new JBScrollPane((Component)this.myDetails));
        this.add((Component)splitter);
    }

    private JEditorPane createDetailsPane(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ManifestPanel.$$$reportNull$$$0(1);
        }
        JEditorPane details = new JEditorPane();
        details.setMargin((Insets)JBUI.insets((int)5));
        details.setContentType("text/html");
        details.setEditable(false);
        details.setFont(this.myDefaultFont);
        details.setBackground(this.myBackgroundColor);
        HyperlinkListener hyperLinkListener = e -> {
            if (facet == null) {
                ManifestPanel.$$$reportNull$$$0(48);
            }
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String url = e.getDescription();
                this.myHtmlLinkManager.handleUrl(url, facet.getModule(), null, null, null);
            }
        };
        details.addHyperlinkListener(hyperLinkListener);
        return details;
    }

    private void createPopupMenu() {
        this.myPopup = new JBPopupMenu();
        JBMenuItem gotoItem = new JBMenuItem("Go to Declaration");
        gotoItem.addActionListener(e -> {
            TreePath treePath = this.myTree.getSelectionPath();
            ManifestTreeNode node = (ManifestTreeNode)treePath.getLastPathComponent();
            if (node != null) {
                this.goToDeclaration(node.getUserObject());
            }
        });
        this.myPopup.add((JMenuItem)gotoItem);
        this.myRemoveItem = new JBMenuItem("Remove");
        this.myRemoveItem.addActionListener(e -> {
            TreePath treePath = this.myTree.getSelectionPath();
            final ManifestTreeNode node = (ManifestTreeNode)treePath.getLastPathComponent();
            new WriteCommandAction.Simple(this.myFacet.getModule().getProject(), "Removing manifest tag", new PsiFile[]{ManifestUtils.getMainManifest(this.myFacet)}){

                protected void run() throws Throwable {
                    ManifestUtils.toolsRemove(ManifestUtils.getMainManifest(ManifestPanel.this.myFacet), node.getUserObject());
                }
            }.execute();
        });
        this.myPopup.add(this.myRemoveItem);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (e.isPopupTrigger()) {
                    this.handlePopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.handlePopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ManifestTreeNode node;
                Node attribute;
                TreePath treePath;
                if (e.getClickCount() == 2 && e.getButton() == 1 && (treePath = ManifestPanel.this.myTree.getPathForLocation(e.getX(), e.getY())) != null && (attribute = (node = (ManifestTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof Attr) {
                    ManifestPanel.this.goToDeclaration(attribute);
                }
            }

            private void handlePopup(@NotNull MouseEvent e) {
                TreePath treePath;
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((treePath = ManifestPanel.this.myTree.getPathForLocation(e.getX(), e.getY())) == null || e.getSource() == ManifestPanel.this.myDetails) {
                    treePath = ManifestPanel.this.myTree.getSelectionPath();
                }
                if (treePath != null) {
                    ManifestTreeNode node = (ManifestTreeNode)treePath.getLastPathComponent();
                    ManifestPanel.this.myRemoveItem.setEnabled(ManifestPanel.this.canRemove(node.getUserObject()));
                    ManifestPanel.this.myPopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/android/tools/idea/editors/manifest/ManifestPanel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mousePressed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handlePopup";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myTree.addMouseListener((MouseListener)ml);
        this.myDetails.addMouseListener(ml);
    }

    private void registerGotoAction() {
        AnAction goToDeclarationAction = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ManifestTreeNode node;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((node = (ManifestTreeNode)ManifestPanel.this.myTree.getLastSelectedPathComponent()) != null) {
                    ManifestPanel.this.goToDeclaration(node.getUserObject());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/editors/manifest/ManifestPanel$3", "actionPerformed"));
            }
        };
        goToDeclarationAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("GotoDeclaration").getShortcutSet(), (JComponent)this.myTree);
    }

    @NotNull
    private TreeSpeedSearch addSpeedSearch() {
        TreeSpeedSearch treeSpeedSearch = new TreeSpeedSearch((JTree)this.myTree);
        if (treeSpeedSearch == null) {
            ManifestPanel.$$$reportNull$$$0(2);
        }
        return treeSpeedSearch;
    }

    public void setManifest(@NotNull MergedManifest manifest, @NotNull VirtualFile selectedManifest) {
        if (manifest == null) {
            ManifestPanel.$$$reportNull$$$0(3);
        }
        if (selectedManifest == null) {
            ManifestPanel.$$$reportNull$$$0(4);
        }
        this.myFile = selectedManifest;
        this.myManifest = manifest;
        Document document = this.myManifest.getDocument();
        Element root = document != null ? document.getDocumentElement() : null;
        this.myTree.setModel((TreeModel)(root == null ? null : new DefaultTreeModel(new ManifestTreeNode(root))));
        this.myFiles.clear();
        this.myOtherFiles.clear();
        List<VirtualFile> manifestFiles = this.myManifest.getManifestFiles();
        this.myFiles.add(VfsUtilCore.virtualToIoFile((VirtualFile)selectedManifest));
        HashSet referenced = Sets.newHashSet();
        if (root != null) {
            this.recordLocationReferences(root, referenced);
        }
        if (manifestFiles != null) {
            for (VirtualFile f : manifestFiles) {
                if (f.equals(selectedManifest)) continue;
                File file = VfsUtilCore.virtualToIoFile((VirtualFile)f);
                if (referenced.contains(file)) {
                    this.myFiles.add(file);
                    continue;
                }
                this.myOtherFiles.add(file);
            }
            Collections.sort(this.myFiles, MANIFEST_SORTER);
            Collections.sort(this.myOtherFiles, MANIFEST_SORTER);
            if (referenced.contains(GRADLE_MODEL_MARKER_FILE)) {
                this.myFiles.add(GRADLE_MODEL_MARKER_FILE);
            }
        }
        if (root != null) {
            TreeUtil.expandAll((JTree)this.myTree);
        }
        this.updateDetails(null);
    }

    private void recordLocationReferences(@NotNull Node node, @NotNull Set<File> files) {
        block6: {
            short type;
            block5: {
                Actions.Record record;
                block7: {
                    XmlNode.NodeKey targetId;
                    if (node == null) {
                        ManifestPanel.$$$reportNull$$$0(5);
                    }
                    if (files == null) {
                        ManifestPanel.$$$reportNull$$$0(6);
                    }
                    if ((type = node.getNodeType()) != 2) break block5;
                    List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, node);
                    if (records.isEmpty() || !(targetId = (record = records.get(0)).getTargetId()).toString().contains("@")) break block6;
                    if (record.getActionType() != Actions.ActionType.INJECTED) break block7;
                    files.add(GRADLE_MODEL_MARKER_FILE);
                    break block6;
                }
                File location = record.getActionLocation().getFile().getSourceFile();
                if (location == null || files.contains(location)) break block6;
                files.add(location);
                break block6;
            }
            if (type == 1) {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child.getNodeType() != 1) continue;
                    this.recordLocationReferences(child, files);
                }
                NamedNodeMap attributes = node.getAttributes();
                int n = attributes.getLength();
                for (int i = 0; i < n; ++i) {
                    this.recordLocationReferences(attributes.item(i), files);
                }
            }
        }
    }

    @Override
    public void valueChanged(@Nullable TreeSelectionEvent e) {
        if (e != null && e.isAddedPath()) {
            TreePath treePath = e.getPath();
            ManifestTreeNode node = (ManifestTreeNode)treePath.getLastPathComponent();
            this.updateDetails(node);
        } else {
            this.updateDetails(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateDetails(@Nullable ManifestTreeNode node) {
        HtmlBuilder sb = new HtmlBuilder();
        Font font = UIUtil.getLabelFont();
        sb.addHtml("<html><body style=\"font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt;\">");
        sb.beginUnderline().beginBold();
        sb.add("Manifest Sources");
        sb.endBold().endUnderline().newline();
        sb.addHtml("<table border=\"0\">");
        String borderColor = ColorUtil.toHex((Color)JBColor.GRAY);
        for (File file : this.myFiles) {
            Color color = this.getFileColor(file);
            sb.addHtml("<tr><td width=\"24\" height=\"24\" style=\"background-color:#");
            sb.addHtml(ColorUtil.toHex((Color)color));
            sb.addHtml("; border: 1px solid #");
            sb.addHtml(borderColor);
            sb.addHtml(";\">");
            sb.addHtml("</td><td>");
            this.describePosition(sb, this.myFacet, new SourceFilePosition(file, SourcePosition.UNKNOWN));
            sb.addHtml("</td></tr>");
        }
        sb.addHtml("</table>");
        sb.newline();
        if (!this.myOtherFiles.isEmpty()) {
            sb.beginUnderline().beginBold();
            sb.add("Other Manifest Files");
            sb.endBold().endUnderline().newline();
            sb.add("(Included in merge, but did not contribute any elements)").newline();
            boolean first = true;
            for (File file : this.myOtherFiles) {
                if (first) {
                    first = false;
                } else {
                    sb.add(", ");
                }
                this.describePosition(sb, this.myFacet, new SourceFilePosition(file, SourcePosition.UNKNOWN));
            }
            sb.newline().newline();
        }
        if (!this.myManifest.getLoggingRecords().isEmpty()) {
            for (MergingReport.Record record : this.myManifest.getLoggingRecords()) {
                if (record.getSeverity() != MergingReport.Record.Severity.ERROR) continue;
                node = null;
                break;
            }
        }
        if (node != null) {
            List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, node.getUserObject());
            sb.beginUnderline().beginBold();
            sb.add("Merging Log");
            sb.endBold().endUnderline().newline();
            if (records.isEmpty()) {
                sb.add("No records found. (This is a bug in the manifest merger.)");
            }
            Object var6_12 = null;
            boolean prevInjected = false;
            for (Actions.Record record : records) {
                boolean injected;
                void var6_13;
                SourceFilePosition location = ManifestUtils.getActionLocation(this.myFacet.getModule(), record);
                if (location.equals((Object)var6_13)) continue;
                SourceFilePosition sourceFilePosition = location;
                Actions.ActionType actionType = record.getActionType();
                boolean bl = injected = actionType == Actions.ActionType.INJECTED;
                if (injected && prevInjected) continue;
                prevInjected = injected;
                if (injected) {
                    sb.add("Value provided by Gradle");
                    sb.newline();
                    continue;
                }
                sb.add(StringUtil.capitalize((String)String.valueOf(actionType).toLowerCase(Locale.US)));
                sb.add(" from the ");
                sb.addHtml(this.getHtml(this.myFacet, location));
                String reason = record.getReason();
                if (reason != null) {
                    sb.add("; reason: ");
                    sb.add(reason);
                }
                sb.newline();
            }
        } else if (!this.myManifest.getLoggingRecords().isEmpty()) {
            sb.add("Merging Errors:").newline();
            for (MergingReport.Record record : this.myManifest.getLoggingRecords()) {
                sb.addHtml(ManifestPanel.getHtml(record.getSeverity()));
                sb.add(" ");
                try {
                    sb.addHtml(ManifestPanel.getErrorHtml(this.myFacet, record.getMessage(), record.getSourceLocation(), this.myHtmlLinkManager, LocalFileSystem.getInstance().findFileByIoFile(this.myFiles.get(0))));
                }
                catch (Exception ex) {
                    Logger.getInstance(ManifestPanel.class).error("error getting error html", (Throwable)ex);
                    sb.add(record.getMessage());
                }
                sb.add(" ");
                sb.addHtml(this.getHtml(this.myFacet, record.getSourceLocation()));
                sb.newline();
            }
        }
        sb.closeHtmlBody();
        this.myDetails.setText(sb.getHtml());
        this.myDetails.setCaretPosition(0);
    }

    @NotNull
    private Color getNodeColor(@NotNull Node node) {
        Actions.Record record;
        File file;
        List<? extends Actions.Record> records;
        if (node == null) {
            ManifestPanel.$$$reportNull$$$0(7);
        }
        if (!(records = ManifestUtils.getRecords(this.myManifest, node)).isEmpty() && (file = (record = records.get(0)).getActionType() == Actions.ActionType.INJECTED ? GRADLE_MODEL_MARKER_FILE : ManifestUtils.getActionLocation(this.myFacet.getModule(), record).getFile().getSourceFile()) != null) {
            Color color = this.getFileColor(file);
            if (color == null) {
                ManifestPanel.$$$reportNull$$$0(8);
            }
            return color;
        }
        Color color = this.myBackgroundColor;
        if (color == null) {
            ManifestPanel.$$$reportNull$$$0(9);
        }
        return color;
    }

    @NotNull
    private Color getFileColor(@NotNull File file) {
        int index;
        if (file == null) {
            ManifestPanel.$$$reportNull$$$0(10);
        }
        if (!this.myFiles.contains(file)) {
            this.myFiles.add(file);
        }
        if ((index = this.myFiles.indexOf(file)) == 0) {
            Color color = this.myBackgroundColor;
            if (color == null) {
                ManifestPanel.$$$reportNull$$$0(11);
            }
            return color;
        }
        Color color = AnnotationColors.BG_COLORS[(index - 1) * 3 % AnnotationColors.BG_COLORS.length];
        if (color == null) {
            ManifestPanel.$$$reportNull$$$0(12);
        }
        return color;
    }

    private boolean canRemove(@NotNull Node node) {
        List<? extends Actions.Record> records;
        if (node == null) {
            ManifestPanel.$$$reportNull$$$0(13);
        }
        if ((records = ManifestUtils.getRecords(this.myManifest, node)).isEmpty()) {
            return false;
        }
        File mainManifest = VfsUtilCore.virtualToIoFile((VirtualFile)ManifestUtils.getMainManifest(this.myFacet).getVirtualFile());
        for (Actions.Record record : records) {
            if (!FileUtil.filesEqual((File)ManifestUtils.getActionLocation(this.myFacet.getModule(), record).getFile().getSourceFile(), (File)mainManifest)) continue;
            return false;
        }
        return true;
    }

    private void goToDeclaration(Node element) {
        List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, element);
        for (Actions.Record record : records) {
            File ioFile;
            SourceFilePosition sourceFilePosition = ManifestUtils.getActionLocation(this.myFacet.getModule(), record);
            SourceFile sourceFile = sourceFilePosition.getFile();
            if (SourceFile.UNKNOWN.equals((Object)sourceFile) || (ioFile = sourceFile.getSourceFile()) == null) continue;
            VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(ioFile);
            assert (file != null);
            int line = -1;
            int column = 0;
            SourcePosition sourcePosition = sourceFilePosition.getPosition();
            if (!SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
                line = sourcePosition.getStartLine();
                column = sourcePosition.getStartColumn();
            }
            Project project = this.myFacet.getModule().getProject();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file, line, column);
            FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
            break;
        }
    }

    @NotNull
    static String getErrorHtml(@NotNull AndroidFacet facet, @NotNull String message, @NotNull SourceFilePosition position, @NotNull HtmlLinkManager htmlLinkManager, @Nullable VirtualFile currentlyOpenFile) {
        if (facet == null) {
            ManifestPanel.$$$reportNull$$$0(14);
        }
        if (message == null) {
            ManifestPanel.$$$reportNull$$$0(15);
        }
        if (position == null) {
            ManifestPanel.$$$reportNull$$$0(16);
        }
        if (htmlLinkManager == null) {
            ManifestPanel.$$$reportNull$$$0(17);
        }
        HtmlBuilder sb = new HtmlBuilder();
        int index = message.indexOf(SUGGESTION_MARKER);
        if (index >= 0) {
            String action = message.substring(index += SUGGESTION_MARKER.length(), message.indexOf(32, index));
            sb.add(message.substring(0, index));
            message = message.substring(index);
            if ("add".equals(action)) {
                sb.addHtml(ManifestPanel.getErrorAddHtml(facet, message, position, htmlLinkManager, currentlyOpenFile));
            } else if ("use".equals(action)) {
                sb.addHtml(ManifestPanel.getErrorUseHtml(facet, message, position, htmlLinkManager, currentlyOpenFile));
            }
        } else {
            sb.add(message);
        }
        String string = sb.getHtml();
        if (string == null) {
            ManifestPanel.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static String getErrorAddHtml(@NotNull AndroidFacet facet, @NotNull String message, @NotNull SourceFilePosition position, @NotNull HtmlLinkManager htmlLinkManager, @Nullable VirtualFile currentlyOpenFile) {
        if (facet == null) {
            ManifestPanel.$$$reportNull$$$0(19);
        }
        if (message == null) {
            ManifestPanel.$$$reportNull$$$0(20);
        }
        if (position == null) {
            ManifestPanel.$$$reportNull$$$0(21);
        }
        if (htmlLinkManager == null) {
            ManifestPanel.$$$reportNull$$$0(22);
        }
        HtmlBuilder sb = new HtmlBuilder();
        Matcher matcher = ADD_SUGGESTION_FORMAT.matcher(message);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("unexpected add suggestion format " + message);
        }
        String attributeName = matcher.group(1);
        String attributeValue = matcher.group(2);
        String tagName = matcher.group(3);
        int line = Integer.parseInt(matcher.group(4));
        int col = Integer.parseInt(matcher.group(5));
        XmlFile mainManifest = ManifestUtils.getMainManifest(facet);
        Element element = ManifestPanel.getElementAt(mainManifest, line, col);
        if (element != null && tagName.equals(element.getTagName())) {
            Element xmlTag = element;
            sb.addLink(message, htmlLinkManager.createRunnableLink(() -> ManifestPanel.addToolsAttribute(mainManifest, xmlTag, attributeName, attributeValue)));
        } else {
            Logger.getInstance(ManifestPanel.class).warn("can not find " + tagName + " tag " + element);
            sb.add(message);
        }
        String string = sb.getHtml();
        if (string == null) {
            ManifestPanel.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Nullable
    private static Element getElementAt(XmlFile mainManifest, int line, int col) {
        Element element = null;
        try {
            Document document = PositionXmlParser.parse((String)mainManifest.getText());
            for (Node node = PositionXmlParser.findNodeAtLineAndCol((Document)document, (int)line, (int)col); node != null; node = node.getParentNode()) {
                if (!(node instanceof Element)) continue;
                element = (Element)node;
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return element;
    }

    @NotNull
    private static String getErrorUseHtml(@NotNull AndroidFacet facet, @NotNull String message, @NotNull SourceFilePosition position, @NotNull HtmlLinkManager htmlLinkManager, @Nullable VirtualFile currentlyOpenFile) {
        if (facet == null) {
            ManifestPanel.$$$reportNull$$$0(24);
        }
        if (message == null) {
            ManifestPanel.$$$reportNull$$$0(25);
        }
        if (position == null) {
            ManifestPanel.$$$reportNull$$$0(26);
        }
        if (htmlLinkManager == null) {
            ManifestPanel.$$$reportNull$$$0(27);
        }
        HtmlBuilder sb = new HtmlBuilder();
        int eq = message.indexOf(61);
        if (eq < 0) {
            throw new IllegalArgumentException("unexpected use suggestion format " + message);
        }
        int end = message.indexOf(34, eq + 2);
        if (end < 0 || message.charAt(eq + 1) != '\"') {
            throw new IllegalArgumentException("unexpected use suggestion format " + message);
        }
        String suggestion = message.substring(message.indexOf(32) + 1, end + 1);
        if (!SourcePosition.UNKNOWN.equals((Object)position.getPosition())) {
            XmlFile mainManifest = ManifestUtils.getMainManifest(facet);
            Element element = ManifestPanel.getElementAt(mainManifest, position.getPosition().getStartLine(), position.getPosition().getStartColumn());
            if (element != null && "uses-sdk".equals(element.getTagName())) {
                sb.addLink(message.substring(0, end + 1), htmlLinkManager.createRunnableLink(() -> {
                    int eq1 = suggestion.indexOf(61);
                    String attributeName = suggestion.substring(suggestion.indexOf(58) + 1, eq1);
                    String attributeValue = suggestion.substring(eq1 + 2, suggestion.length() - 1);
                    ManifestPanel.addToolsAttribute(mainManifest, element, attributeName, attributeValue);
                }));
                sb.add(message.substring(end + 1));
            } else {
                Logger.getInstance(ManifestPanel.class).warn("Can not find uses-sdk tag " + element);
                sb.add(message);
            }
        } else {
            sb.add(message);
        }
        sb.newlineIfNecessary().newline();
        String string = sb.getHtml();
        if (string == null) {
            ManifestPanel.$$$reportNull$$$0(28);
        }
        return string;
    }

    private static void requestSync(Project project) {
        assert (ApplicationManager.getApplication().isDispatchThread());
        ProjectSystemUtil.getProjectSystem(project).getSyncManager().syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED, true);
    }

    private static void removePackageAttribute(XmlFile manifestFile) {
        XmlTag tag = manifestFile.getRootTag();
        assert (tag != null);
        tag.setAttribute("package", null);
    }

    static void addToolsAttribute(final @NotNull XmlFile file, final @NotNull Element element, final @NotNull String attributeName, final @NotNull String attributeValue) {
        if (file == null) {
            ManifestPanel.$$$reportNull$$$0(29);
        }
        if (element == null) {
            ManifestPanel.$$$reportNull$$$0(30);
        }
        if (attributeName == null) {
            ManifestPanel.$$$reportNull$$$0(31);
        }
        if (attributeValue == null) {
            ManifestPanel.$$$reportNull$$$0(32);
        }
        Project project = file.getProject();
        new WriteCommandAction.Simple(project, "Apply manifest suggestion", new PsiFile[]{file}){

            protected void run() throws Throwable {
                ManifestUtils.addToolsAttribute(file, element, attributeName, attributeValue);
            }
        }.execute();
    }

    @NotNull
    static String getHtml(@NotNull MergingReport.Record.Severity severity) {
        if (severity == null) {
            ManifestPanel.$$$reportNull$$$0(33);
        }
        String severityString = StringUtil.capitalize((String)severity.toString().toLowerCase(Locale.US));
        if (severity == MergingReport.Record.Severity.ERROR) {
            String string = new HtmlBuilder().addHtml("<font color=\"#" + ColorUtil.toHex((Color)JBColor.RED) + "\">").addBold(severityString).addHtml("</font>:").getHtml();
            if (string == null) {
                ManifestPanel.$$$reportNull$$$0(34);
            }
            return string;
        }
        String string = severityString;
        if (string == null) {
            ManifestPanel.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    String getHtml(@NotNull AndroidFacet facet, @NotNull SourceFilePosition sourceFilePosition) {
        if (facet == null) {
            ManifestPanel.$$$reportNull$$$0(36);
        }
        if (sourceFilePosition == null) {
            ManifestPanel.$$$reportNull$$$0(37);
        }
        HtmlBuilder sb = new HtmlBuilder();
        this.describePosition(sb, facet, sourceFilePosition);
        String string = sb.getHtml();
        if (string == null) {
            ManifestPanel.$$$reportNull$$$0(38);
        }
        return string;
    }

    private void describePosition(@NotNull HtmlBuilder sb, @NotNull AndroidFacet facet, @NotNull SourceFilePosition sourceFilePosition) {
        if (sb == null) {
            ManifestPanel.$$$reportNull$$$0(39);
        }
        if (facet == null) {
            ManifestPanel.$$$reportNull$$$0(40);
        }
        if (sourceFilePosition == null) {
            ManifestPanel.$$$reportNull$$$0(41);
        }
        SourceFile sourceFile = sourceFilePosition.getFile();
        SourcePosition sourcePosition = sourceFilePosition.getPosition();
        File file = sourceFile.getSourceFile();
        if (file != null && NAV_FILE_PATTERN.matcher(FileUtils.toSystemIndependentPath((String)file.toString())).matches()) {
            VirtualFile vResDir;
            String source = "";
            File resDir = file.getParentFile() == null ? null : file.getParentFile().getParentFile();
            VirtualFile virtualFile = vResDir = resDir == null ? null : LocalFileSystem.getInstance().findFileByIoFile(resDir);
            if (vResDir != null) {
                for (IdeaSourceProvider provider : IdeaSourceProvider.getCurrentSourceProviders(facet)) {
                    if (!provider.getResDirectories().contains(vResDir)) continue;
                    source = source + provider.getName() + " ";
                    break;
                }
            }
            source = source + file.getName();
            sb.addHtml("<a href=\"");
            sb.add(file.toURI().toString());
            if (!SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
                sb.add(":");
                sb.add(String.valueOf(sourcePosition.getStartLine()));
                sb.add(":");
                sb.add(String.valueOf(sourcePosition.getStartColumn()));
            }
            sb.addHtml("\">");
            sb.add(source);
            sb.addHtml("</a>");
            sb.add(" navigation file");
            if (!SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
                sb.add(", line ");
                sb.add(Integer.toString(sourcePosition.getStartLine()));
            }
            return;
        }
        if (file != null) {
            File manifestFile;
            AndroidFacet libraryFacet;
            String source = null;
            Module libraryModule = null;
            Module[] modules = ModuleManager.getInstance((Project)facet.getModule().getProject()).getModules();
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (vFile != null) {
                IdeaSourceProvider provider;
                int n;
                Module[] moduleArray;
                String path = file.getPath();
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)facet.getModule().getProject());
                if (module != null) {
                    if (modules.length >= 2) {
                        source = module.getName();
                    }
                    if (path.contains("exploded-aar")) {
                        source = ManifestPanel.findSourceForFileInExplodedAar(file, facet, module);
                    }
                } else if (path.contains("output") && path.matches(".*\\w{40}[\\\\/]output.*")) {
                    Module singleModule;
                    moduleArray = modules;
                    n = moduleArray.length;
                    for (int i = 0; i < n && (source = ManifestPanel.findSourceForFileInExplodedAar(file, facet, singleModule = moduleArray[i])) == null; ++i) {
                    }
                } else if (path.contains("caches")) {
                    Module singleModule;
                    moduleArray = modules;
                    n = moduleArray.length;
                    for (int i = 0; i < n && (source = ManifestPanel.findSourceForFileInExplodedAar(file, facet, singleModule = moduleArray[i])) == null; ++i) {
                    }
                }
                if ((provider = ManifestUtils.findManifestSourceProvider(facet, vFile)) != null) {
                    String providerName = provider.getName();
                    source = source == null ? providerName : source + " " + providerName;
                }
            }
            if (source == null) {
                source = file.getName();
                if (!SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
                    source = source + ":" + String.valueOf(sourcePosition);
                }
            }
            sb.addHtml("<a href=\"");
            boolean redirected = false;
            if (libraryModule != null && (libraryFacet = AndroidFacet.getInstance(libraryModule)) != null && (manifestFile = libraryFacet.getMainSourceProvider().getManifestFile()).exists()) {
                sb.add(manifestFile.toURI().toString());
                redirected = true;
                sourcePosition = SourcePosition.UNKNOWN;
            }
            if (!redirected) {
                sb.add(file.toURI().toString());
                if (!SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
                    sb.add(":");
                    sb.add(String.valueOf(sourcePosition.getStartLine()));
                    sb.add(":");
                    sb.add(String.valueOf(sourcePosition.getStartColumn()));
                }
            }
            sb.addHtml("\">");
            sb.add(source);
            sb.addHtml("</a>");
            sb.add(" manifest");
            if (FileUtil.filesEqual((File)file, (File)VfsUtilCore.virtualToIoFile((VirtualFile)this.myFile))) {
                sb.add(" (this file)");
            }
            if (!SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
                sb.add(", line ");
                sb.add(Integer.toString(sourcePosition.getStartLine()));
            }
        }
    }

    @Nullable
    private static String findSourceForFileInExplodedAar(@NotNull File file, @NotNull AndroidFacet facet, @NotNull Module module) {
        if (file == null) {
            ManifestPanel.$$$reportNull$$$0(42);
        }
        if (facet == null) {
            ManifestPanel.$$$reportNull$$$0(43);
        }
        if (module == null) {
            ManifestPanel.$$$reportNull$$$0(44);
        }
        return null;
    }

    @NotNull
    public static Color harder(@NotNull Color color) {
        if (color == null) {
            ManifestPanel.$$$reportNull$$$0(45);
        }
        if (color.getBlue() == color.getRed() && color.getRed() == color.getGreen()) {
            Color color2 = color;
            if (color2 == null) {
                ManifestPanel.$$$reportNull$$$0(46);
            }
            return color2;
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        Color color3 = Color.getHSBColor(hsb[0], 1.0f, hsb[2]);
        if (color3 == null) {
            ManifestPanel.$$$reportNull$$$0(47);
        }
        return color3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 18: 
            case 23: 
            case 28: 
            case 34: 
            case 35: 
            case 38: 
            case 46: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 18: 
            case 23: 
            case 28: 
            case 34: 
            case 35: 
            case 38: 
            case 46: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 18: 
            case 23: 
            case 28: 
            case 34: 
            case 35: 
            case 38: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/manifest/ManifestPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifest";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedManifest";
                break;
            }
            case 5: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 10: 
            case 29: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 16: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 17: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlLinkManager";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeValue";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFilePosition";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/manifest/ManifestPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addSpeedSearch";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeColor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileColor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorHtml";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorAddHtml";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorUseHtml";
                break;
            }
            case 34: 
            case 35: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtml";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "harder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createDetailsPane";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 18: 
            case 23: 
            case 28: 
            case 34: 
            case 35: 
            case 38: 
            case 46: 
            case 47: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setManifest";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "recordLocationReferences";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNodeColor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFileColor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canRemove";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getErrorHtml";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getErrorAddHtml";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getErrorUseHtml";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addToolsAttribute";
                break;
            }
            case 33: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getHtml";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "describePosition";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findSourceForFileInExplodedAar";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "harder";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createDetailsPane$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 18: 
            case 23: 
            case 28: 
            case 34: 
            case 35: 
            case 38: 
            case 46: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class FileColorTree
    extends Tree {
        FileColorTree() {
            this.setFont(ManifestPanel.this.myDefaultFont);
            this.setBackground(ManifestPanel.this.myBackgroundColor);
        }

        public boolean isFileColorsEnabled() {
            if (this.isOpaque()) {
                this.setOpaque(false);
            }
            return true;
        }

        @Nullable
        public Color getFileColorFor(Object object) {
            return ManifestPanel.this.getNodeColor((Node)object);
        }
    }

    private class SyntaxHighlightingCellRenderer
    extends ColoredTreeCellRenderer {
        private final SimpleTextAttributes myTagNameAttributes;
        private final SimpleTextAttributes myNameAttributes;
        private final SimpleTextAttributes myValueAttributes;
        private final SimpleTextAttributes myPrefixAttributes;

        SyntaxHighlightingCellRenderer() {
            EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
            Color tagNameColor = globalScheme.getAttributes(XmlHighlighterColors.XML_TAG_NAME).getForegroundColor();
            Color nameColor = globalScheme.getAttributes(XmlHighlighterColors.XML_ATTRIBUTE_NAME).getForegroundColor();
            Color valueColor = globalScheme.getAttributes(XmlHighlighterColors.XML_ATTRIBUTE_VALUE).getForegroundColor();
            Color prefixColor = globalScheme.getAttributes(XmlHighlighterColors.XML_NS_PREFIX).getForegroundColor();
            this.myTagNameAttributes = new SimpleTextAttributes(1, tagNameColor);
            this.myNameAttributes = new SimpleTextAttributes(0, nameColor);
            this.myValueAttributes = new SimpleTextAttributes(0, valueColor);
            this.myPrefixAttributes = new SimpleTextAttributes(0, prefixColor);
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                SyntaxHighlightingCellRenderer.$$$reportNull$$$0(0);
            }
            if (value instanceof ManifestTreeNode) {
                ManifestTreeNode node = (ManifestTreeNode)value;
                this.setIcon(null);
                if (node.getUserObject() instanceof Element) {
                    Element element = (Element)node.getUserObject();
                    this.append("<");
                    this.append(element.getTagName(), this.myTagNameAttributes);
                    if (!expanded) {
                        this.append(" ... " + this.getCloseTag(node));
                    }
                }
                if (node.getUserObject() instanceof Attr) {
                    Attr attr = (Attr)node.getUserObject();
                    ManifestTreeNode parent = node.getParent();
                    assert (parent != null);
                    if (attr.getPrefix() != null) {
                        this.append(attr.getPrefix(), this.myPrefixAttributes);
                        this.append(":");
                        this.append(attr.getLocalName(), this.myNameAttributes);
                    } else {
                        this.append(attr.getName(), this.myNameAttributes);
                    }
                    this.append("=\"");
                    this.append(attr.getValue(), this.myValueAttributes);
                    this.append("\"");
                    if (parent.lastAttribute() == node) {
                        this.append(" " + this.getCloseTag(node));
                    }
                }
            }
        }

        private String getCloseTag(ManifestTreeNode node) {
            return node.hasElementChildren() ? ">" : "/>";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/manifest/ManifestPanel$SyntaxHighlightingCellRenderer", "customizeCellRenderer"));
        }
    }

    static class ManifestTreeNode
    extends DefaultMutableTreeNode {
        ManifestTreeNode(@NotNull Node obj) {
            if (obj == null) {
                ManifestTreeNode.$$$reportNull$$$0(0);
            }
            super(obj);
        }

        @Override
        @NotNull
        public Node getUserObject() {
            Node node = (Node)super.getUserObject();
            if (node == null) {
                ManifestTreeNode.$$$reportNull$$$0(1);
            }
            return node;
        }

        @Override
        public int getChildCount() {
            Node obj = this.getUserObject();
            if (obj instanceof Element) {
                Element element = (Element)obj;
                NamedNodeMap attributes = element.getAttributes();
                int count = attributes.getLength();
                NodeList childNodes = element.getChildNodes();
                int n = childNodes.getLength();
                for (int i = 0; i < n; ++i) {
                    Node child = childNodes.item(i);
                    if (child.getNodeType() != 1) continue;
                    ++count;
                }
                return count;
            }
            return 0;
        }

        @Override
        @NotNull
        public ManifestTreeNode getChildAt(int index) {
            Node obj = this.getUserObject();
            if (this.children == null && obj instanceof Element) {
                Element element = (Element)obj;
                NamedNodeMap attributes = element.getAttributes();
                int n = attributes.getLength();
                for (int i = 0; i < n; ++i) {
                    this.add(new ManifestTreeNode(attributes.item(i)));
                }
                NodeList childNodes = element.getChildNodes();
                int n2 = childNodes.getLength();
                for (int i = 0; i < n2; ++i) {
                    Node child = childNodes.item(i);
                    if (child.getNodeType() != 1) continue;
                    this.add(new ManifestTreeNode(child));
                }
            }
            ManifestTreeNode manifestTreeNode = (ManifestTreeNode)super.getChildAt(index);
            if (manifestTreeNode == null) {
                ManifestTreeNode.$$$reportNull$$$0(2);
            }
            return manifestTreeNode;
        }

        @Override
        public void add(@NotNull MutableTreeNode newChild) {
            if (newChild == null) {
                ManifestTreeNode.$$$reportNull$$$0(3);
            }
            this.insert(newChild, this.children == null ? 0 : this.children.size());
        }

        @Override
        @NotNull
        public String toString() {
            Node obj = this.getUserObject();
            if (obj instanceof Attr) {
                Attr xmlAttribute = (Attr)obj;
                String string = xmlAttribute.getName() + " = " + xmlAttribute.getValue();
                if (string == null) {
                    ManifestTreeNode.$$$reportNull$$$0(4);
                }
                return string;
            }
            if (obj instanceof Element) {
                Element xmlTag = (Element)obj;
                String string = xmlTag.getTagName();
                if (string == null) {
                    ManifestTreeNode.$$$reportNull$$$0(5);
                }
                return string;
            }
            String string = obj.toString();
            if (string == null) {
                ManifestTreeNode.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        @Nullable
        public ManifestTreeNode getParent() {
            return (ManifestTreeNode)super.getParent();
        }

        @NotNull
        public ManifestTreeNode lastAttribute() {
            Node xmlTag = this.getUserObject();
            ManifestTreeNode manifestTreeNode = this.getChildAt(xmlTag.getAttributes().getLength() - 1);
            if (manifestTreeNode == null) {
                ManifestTreeNode.$$$reportNull$$$0(7);
            }
            return manifestTreeNode;
        }

        public boolean hasElementChildren() {
            Node node = this.getUserObject();
            if (node instanceof Attr) {
                ManifestTreeNode parent = this.getParent();
                assert (parent != null);
                return parent.hasElementChildren();
            }
            return node.getChildNodes().getLength() > 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/editors/manifest/ManifestPanel$ManifestTreeNode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newChild";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/editors/manifest/ManifestPanel$ManifestTreeNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUserObject";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildAt";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "lastAttribute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

