/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.adtui.font.FontUtil;
import com.android.tools.idea.actions.BrowserHelpAction;
import com.android.tools.idea.editors.strings.AddKeyAction;
import com.android.tools.idea.editors.strings.AddLocaleAction;
import com.android.tools.idea.editors.strings.DeleteStringAction;
import com.android.tools.idea.editors.strings.FilterKeysAction;
import com.android.tools.idea.editors.strings.FilterLocalesAction;
import com.android.tools.idea.editors.strings.GoToDeclarationAction;
import com.android.tools.idea.editors.strings.MultilineStringEditorDialog;
import com.android.tools.idea.editors.strings.RemoveKeysAction;
import com.android.tools.idea.editors.strings.RemoveLocaleMouseListener;
import com.android.tools.idea.editors.strings.ResourceLoadingTask;
import com.android.tools.idea.editors.strings.TranslationsEditorPasteAction;
import com.android.tools.idea.editors.strings.TranslationsEditorTextField;
import com.android.tools.idea.editors.strings.table.StringResourceTable;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.editors.strings.table.StringTableCellEditor;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.rendering.Locale;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

final class StringResourceViewPanel
implements Disposable,
HyperlinkListener {
    private static final boolean HIDE_TRANSLATION_ORDER_LINK = Boolean.getBoolean("hide.order.translations");
    private final JBLoadingPanel myLoadingPanel;
    private JPanel myContainer;
    private StringResourceTable myTable;
    private JTextComponent myKeyTextField;
    @VisibleForTesting
    TextFieldWithBrowseButton myDefaultValueTextField;
    private TextFieldWithBrowseButton myTranslationTextField;
    private JPanel myToolbarPanel;
    private final AndroidFacet myFacet;
    private GoToDeclarationAction myGoToAction;
    private DeleteStringAction myDeleteAction;
    private RemoveKeysAction myRemoveKeysAction;

    StringResourceViewPanel(AndroidFacet facet, Disposable parentDisposable) {
        this.myFacet = facet;
        this.$$$setupUI$$$();
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 200);
        this.myLoadingPanel.add((Component)this.myContainer);
        ActionToolbar toolbar = this.createToolbar();
        this.myToolbarPanel.add((Component)toolbar.getComponent(), "Center");
        if (!HIDE_TRANSLATION_ORDER_LINK) {
            HyperlinkLabel hyperlinkLabel = new HyperlinkLabel("Order a translation...");
            this.myToolbarPanel.add((Component)hyperlinkLabel, "East");
            hyperlinkLabel.addHyperlinkListener((HyperlinkListener)this);
            this.myToolbarPanel.setBorder(IdeBorderFactory.createBorder((int)8));
        }
        this.initTable();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myLoadingPanel.setLoadingText("Loading string resource data");
        this.myLoadingPanel.startLoading();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            new ResourceLoadingTask(this).queue();
        }
    }

    public void dispose() {
    }

    public void removeSelectedKeys() {
        this.myRemoveKeysAction.perform();
    }

    void addDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            StringResourceViewPanel.$$$reportNull$$$0(0);
        }
        ((StringTableCellEditor)this.myTable.getDefaultEditor(String.class)).getComponent().getDocument().addDocumentListener(listener);
        this.myDefaultValueTextField.getTextField().getDocument().addDocumentListener(listener);
        this.myTranslationTextField.getTextField().getDocument().addDocumentListener(listener);
    }

    void addFocusListener(@NotNull FocusListener listener) {
        if (listener == null) {
            StringResourceViewPanel.$$$reportNull$$$0(1);
        }
        ((StringTableCellEditor)this.myTable.getDefaultEditor(String.class)).getComponent().addFocusListener(listener);
        this.myDefaultValueTextField.getTextField().addFocusListener(listener);
        this.myTranslationTextField.getTextField().addFocusListener(listener);
    }

    private void createUIComponents() {
        this.createTable();
        this.createTablePopupMenu();
        this.myKeyTextField = new TranslationsEditorTextField(this.myTable, 0);
        this.createDefaultValueTextField();
        this.createTranslationTextField();
    }

    private void createTable() {
        this.myTable = new StringResourceTable();
        this.myRemoveKeysAction = new RemoveKeysAction(this);
        this.myDeleteAction = new DeleteStringAction(this);
        this.myGoToAction = new GoToDeclarationAction(this);
        ActionMap actionMap = this.myTable.getActionMap();
        actionMap.put("delete", this.myDeleteAction);
    }

    private void createTablePopupMenu() {
        final JPopupMenu menu = new JPopupMenu();
        final JMenuItem goTo = menu.add(this.myGoToAction);
        final JMenuItem delete = menu.add(this.myDeleteAction);
        this.myTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.openPopup(e);
            }

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.openPopup(e);
            }

            private void openPopup(@NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!e.isPopupTrigger()) {
                    return;
                }
                StringResourceViewPanel.this.myGoToAction.update(goTo, e);
                StringResourceViewPanel.this.myDeleteAction.update(delete, e);
                if (goTo.isVisible() || delete.isVisible()) {
                    menu.show((Component)((Object)StringResourceViewPanel.this.myTable), e.getX(), e.getY());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/android/tools/idea/editors/strings/StringResourceViewPanel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mousePressed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseReleased";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "openPopup";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void createDefaultValueTextField() {
        TranslationsEditorTextField textField2 = new TranslationsEditorTextField(this.myTable, 3);
        new TranslationsEditorPasteAction().registerCustomShortcutSet((JComponent)((Object)textField2), this);
        this.myDefaultValueTextField = new TextFieldWithBrowseButton((JTextField)((Object)textField2), (ActionListener)new ShowMultilineActionListener(), (Disposable)this);
        this.myDefaultValueTextField.setButtonIcon(AllIcons.Actions.ShowViewer);
    }

    private void createTranslationTextField() {
        TranslationsEditorTextField textField2 = new TranslationsEditorTextField(this.myTable, this.myTable::getSelectedColumnModelIndex);
        new TranslationsEditorPasteAction().registerCustomShortcutSet((JComponent)((Object)textField2), this);
        this.myTranslationTextField = new TextFieldWithBrowseButton((JTextField)((Object)textField2), (ActionListener)new ShowMultilineActionListener(), (Disposable)this);
        this.myTranslationTextField.setButtonIcon(AllIcons.Actions.ShowViewer);
    }

    @NotNull
    public AndroidFacet getFacet() {
        AndroidFacet androidFacet = this.myFacet;
        if (androidFacet == null) {
            StringResourceViewPanel.$$$reportNull$$$0(2);
        }
        return androidFacet;
    }

    void reloadData() {
        this.myLoadingPanel.setLoadingText("Updating string resource data");
        this.myLoadingPanel.startLoading();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            new ResourceLoadingTask(this).queue();
        }
    }

    private ActionToolbar createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("TranslationsEditorToolbar", (ActionGroup)group, true);
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarComponent.setName("toolbar");
        group.add((AnAction)new AddKeyAction(this));
        group.add((AnAction)this.myRemoveKeysAction);
        group.add((AnAction)new AddLocaleAction(this));
        group.add((AnAction)new FilterKeysAction(this.myTable));
        group.add((AnAction)new FilterLocalesAction(this.myTable));
        group.add((AnAction)new BrowserHelpAction("Translations editor", "https://developer.android.com/r/studio-ui/translations-editor.html"));
        return toolbar;
    }

    private void initTable() {
        CellSelectionListener listener = new CellSelectionListener();
        this.myTable.getColumnModel().getSelectionModel().addListSelectionListener(listener);
        this.myTable.getSelectionModel().addListSelectionListener(listener);
        this.myTable.getTableHeader().addMouseListener(new RemoveLocaleMouseListener(this));
    }

    @NotNull
    JBLoadingPanel getLoadingPanel() {
        JBLoadingPanel jBLoadingPanel = this.myLoadingPanel;
        if (jBLoadingPanel == null) {
            StringResourceViewPanel.$$$reportNull$$$0(3);
        }
        return jBLoadingPanel;
    }

    @NotNull
    public JBTable getPreferredFocusedComponent() {
        StringResourceTable stringResourceTable = this.myTable;
        if (stringResourceTable == null) {
            StringResourceViewPanel.$$$reportNull$$$0(4);
        }
        return stringResourceTable;
    }

    StringResourceTable getTable() {
        return this.myTable;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        Integer versionCode;
        AndroidModuleInfo moduleInfo;
        String appId;
        StringBuilder sb = new StringBuilder("https://translate.google.com/manager/android_studio/");
        sb.append("?asVer=");
        ApplicationInfo ideInfo = ApplicationInfo.getInstance();
        sb.append(ideInfo.getMajorVersion()).append('.').append(ideInfo.getMinorVersion()).append('.').append(ideInfo.getMicroVersion()).append('.').append(ideInfo.getPatchVersion());
        MergedManifest manifest = MergedManifest.get(this.myFacet);
        String pkg = manifest.getPackage();
        if (pkg != null) {
            sb.append("&pkgName=");
            sb.append(pkg.replace('.', '_'));
        }
        if ((appId = (moduleInfo = AndroidModuleInfo.getInstance(this.myFacet)).getPackage()) != null) {
            sb.append("&appId=");
            sb.append(appId.replace('.', '_'));
        }
        if ((versionCode = manifest.getVersionCode()) != null) {
            sb.append("&apkVer=");
            sb.append(versionCode.toString());
        }
        BrowserUtil.browse((String)sb.toString());
    }

    private static boolean isValueEditableInline(@NotNull String value) {
        if (value == null) {
            StringResourceViewPanel.$$$reportNull$$$0(5);
        }
        return !StringUtil.containsChar((String)value, (char)'\n');
    }

    private static void setTextAndEditable(@NotNull JTextComponent component2, @NotNull String text, boolean editable) {
        if (component2 == null) {
            StringResourceViewPanel.$$$reportNull$$$0(6);
        }
        if (text == null) {
            StringResourceViewPanel.$$$reportNull$$$0(7);
        }
        component2.setText(text);
        component2.setCaretPosition(0);
        component2.setEditable(editable);
        component2.getCaret().setVisible(editable && component2.hasFocus());
        component2.setFont(FontUtil.getFontAbleToDisplay((String)text, (Font)component2.getFont()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/StringResourceViewPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/StringResourceViewPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addDocumentListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addFocusListener";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValueEditableInline";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setTextAndEditable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myContainer = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setName("translationsEditor");
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        StringResourceTable stringResourceTable = this.myTable;
        ((Component)((Object)stringResourceTable)).setName("table");
        jBScrollPane.setViewportView((Component)((Object)stringResourceTable));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 2, 1, 3, 1, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Key:");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JTextComponent jTextComponent = this.myKeyTextField;
        ((Component)jTextComponent).setEnabled(false);
        jTextComponent.setName("keyTextField");
        jPanel3.add((Component)jTextComponent, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Default Value:");
        jPanel3.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Translation:");
        jPanel3.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myDefaultValueTextField;
        textFieldWithBrowseButton.setName("defaultValueTextField");
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.myTranslationTextField;
        textFieldWithBrowseButton2.setEnabled(false);
        textFieldWithBrowseButton2.setName("translationTextField");
        jPanel3.add((Component)textFieldWithBrowseButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myToolbarPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 1, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContainer;
    }

    private class ShowMultilineActionListener
    implements ActionListener {
        private ShowMultilineActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StringResourceViewPanel.this.myTable.getSelectedRowCount() != 1 || StringResourceViewPanel.this.myTable.getSelectedColumnCount() != 1) {
                return;
            }
            int row = StringResourceViewPanel.this.myTable.getSelectedRowModelIndex();
            int column = StringResourceViewPanel.this.myTable.getSelectedColumnModelIndex();
            StringResourceTableModel model = StringResourceViewPanel.this.myTable.getModel();
            String value = (String)model.getValueAt(row, 3);
            Locale locale = model.getLocale(column);
            String translation = locale == null ? null : (String)model.getValueAt(row, column);
            MultilineStringEditorDialog d = new MultilineStringEditorDialog(StringResourceViewPanel.this.myFacet, model.getKey(row).getName(), value, locale, translation);
            if (d.showAndGet()) {
                if (!StringUtil.equals((CharSequence)value, (CharSequence)d.getDefaultValue())) {
                    model.setValueAt(d.getDefaultValue(), row, 3);
                    StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myDefaultValueTextField.getTextField(), d.getDefaultValue(), StringResourceViewPanel.isValueEditableInline(d.getDefaultValue()));
                }
                if (locale != null && !StringUtil.equals((CharSequence)translation, (CharSequence)d.getTranslation())) {
                    model.setValueAt(d.getTranslation(), row, column);
                    StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myTranslationTextField.getTextField(), d.getTranslation(), StringResourceViewPanel.isValueEditableInline(d.getTranslation()));
                }
            }
        }
    }

    private class CellSelectionListener
    implements ListSelectionListener {
        private CellSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (StringResourceViewPanel.this.myTable.getSelectedColumnCount() != 1 || StringResourceViewPanel.this.myTable.getSelectedRowCount() != 1) {
                StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myKeyTextField, "", false);
                StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myDefaultValueTextField.getTextField(), "", false);
                StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myTranslationTextField.getTextField(), "", false);
                StringResourceViewPanel.this.myDefaultValueTextField.getButton().setEnabled(false);
                StringResourceViewPanel.this.myTranslationTextField.getButton().setEnabled(false);
                return;
            }
            StringResourceViewPanel.this.myKeyTextField.setEnabled(true);
            StringResourceViewPanel.this.myDefaultValueTextField.setEnabled(true);
            StringResourceViewPanel.this.myTranslationTextField.setEnabled(true);
            StringResourceTableModel model = StringResourceViewPanel.this.myTable.getModel();
            int row = StringResourceViewPanel.this.myTable.getSelectedRowModelIndex();
            int column = StringResourceViewPanel.this.myTable.getSelectedColumnModelIndex();
            Locale locale = model.getLocale(column);
            StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myKeyTextField, model.getKey(row).getName(), false);
            String defaultValue = (String)model.getValueAt(row, 3);
            boolean defaultValueEditable = StringResourceViewPanel.isValueEditableInline(defaultValue);
            StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myDefaultValueTextField.getTextField(), defaultValue, defaultValueEditable);
            StringResourceViewPanel.this.myDefaultValueTextField.getButton().setEnabled(true);
            boolean translationEditable = false;
            String translation = "";
            if (locale != null) {
                translation = (String)model.getValueAt(row, column);
                translationEditable = StringResourceViewPanel.isValueEditableInline(translation);
            }
            StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myTranslationTextField.getTextField(), translation, translationEditable);
            StringResourceViewPanel.this.myTranslationTextField.getButton().setEnabled(locale != null);
        }
    }
}

