/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.adtui.TableUtils;
import com.android.tools.adtui.ui.FixedColumnTable;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.table.LocaleRenderer;
import com.android.tools.idea.editors.strings.table.StringResourceTableColumnFilter;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.editors.strings.table.StringResourceTableRowFilter;
import com.android.tools.idea.editors.strings.table.StringTableCellEditor;
import com.android.tools.idea.editors.strings.table.StringsCellRenderer;
import com.android.tools.idea.rendering.Locale;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.table.JBTable;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import javax.swing.DefaultRowSorter;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringResourceTable
extends FixedColumnTable
implements DataProvider,
PasteProvider {
    @Nullable
    private StringResourceTableColumnFilter myColumnFilter;
    private boolean myColumnPreferredWidthsSet;

    public StringResourceTable() {
        super((TableModel)new StringResourceTableModel());
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "delete");
        inputMap.put(KeyStroke.getKeyStroke(8, 0), "delete");
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(true);
        this.setDefaultEditor(String.class, new StringTableCellEditor());
        this.setDefaultRenderer(String.class, (TableCellRenderer)((Object)new StringsCellRenderer()));
        this.setFixedColumnCount(2);
        this.setRowSorter(new ThreeStateTableRowSorter<StringResourceTableModel>(this.getModel()));
        new TableSpeedSearch((JTable)((Object)this));
    }

    @NotNull
    protected JTableHeader createDefaultTableHeader() {
        JBTable.JBTableHeader header = new JBTable.JBTableHeader((JBTable)this);
        header.setName("tableHeader");
        header.setReorderingAllowed(false);
        JBTable.JBTableHeader jBTableHeader = header;
        if (jBTableHeader == null) {
            StringResourceTable.$$$reportNull$$$0(0);
        }
        return jBTableHeader;
    }

    @Nullable
    public StringResourceData getData() {
        return this.getModel().getData();
    }

    @Nullable
    public StringResourceTableRowFilter getRowFilter() {
        return (StringResourceTableRowFilter)((DefaultRowSorter)this.getRowSorter()).getRowFilter();
    }

    public void setRowFilter(@Nullable StringResourceTableRowFilter filter) {
        ((DefaultRowSorter)this.getRowSorter()).setRowFilter(filter);
    }

    @Nullable
    public StringResourceTableColumnFilter getColumnFilter() {
        return this.myColumnFilter;
    }

    public void setColumnFilter(@Nullable StringResourceTableColumnFilter filter) {
        this.myColumnFilter = filter;
        this.createDefaultColumnsFromModel();
    }

    public void createDefaultColumnsFromModel() {
        this.addColumns(this.removeAllColumns());
    }

    @NotNull
    private Map<String, TableColumn> removeAllColumns() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)this.getTotalColumnCount());
        while (this.getTotalColumnCount() != 0) {
            TableColumn column = this.getColumn(0);
            this.removeColumn(column);
            map.put((String)column.getHeaderValue(), column);
        }
        HashMap hashMap = map;
        if (hashMap == null) {
            StringResourceTable.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    private void addColumns(@NotNull Map<String, TableColumn> map) {
        if (map == null) {
            StringResourceTable.$$$reportNull$$$0(2);
        }
        StringResourceTableModel model = this.getModel();
        LocaleRenderer renderer = this.tableHeader == null ? null : new LocaleRenderer(this.tableHeader.getDefaultRenderer());
        IntStream.range(0, model.getColumnCount()).filter(this::includeColumn).mapToObj(column -> {
            if (map == null) {
                StringResourceTable.$$$reportNull$$$0(16);
            }
            return this.getColumn(map, column, renderer);
        }).forEach(arg_0 -> ((StringResourceTable)this).addColumn(arg_0));
    }

    private boolean includeColumn(int column) {
        if (column < 4) {
            return true;
        }
        if (this.myColumnFilter == null) {
            return true;
        }
        Locale locale = this.getModel().getLocale(column);
        assert (locale != null);
        return this.myColumnFilter.include(locale);
    }

    @NotNull
    private TableColumn getColumn(@NotNull Map<String, TableColumn> map, int column, @Nullable TableCellRenderer renderer) {
        TableColumn tableColumn;
        if (map == null) {
            StringResourceTable.$$$reportNull$$$0(3);
        }
        if ((tableColumn = map.get(this.dataModel.getColumnName(column))) == null) {
            tableColumn = new TableColumn(column);
            if (column >= 4 && renderer != null) {
                tableColumn.setHeaderRenderer(renderer);
            }
        } else {
            tableColumn.setModelIndex(column);
        }
        TableColumn tableColumn2 = tableColumn;
        if (tableColumn2 == null) {
            StringResourceTable.$$$reportNull$$$0(4);
        }
        return tableColumn2;
    }

    public int getSelectedRowModelIndex() {
        return this.convertRowIndexToModel(this.getSelectedRow());
    }

    @NotNull
    public int[] getSelectedRowModelIndices() {
        int[] nArray = Arrays.stream(this.getSelectedRows()).map(arg_0 -> this.convertRowIndexToModel(arg_0)).toArray();
        if (nArray == null) {
            StringResourceTable.$$$reportNull$$$0(5);
        }
        return nArray;
    }

    public int getSelectedColumnModelIndex() {
        return this.convertColumnIndexToModel(this.getSelectedColumn());
    }

    public TableRowSorter<StringResourceTableModel> getRowSorter() {
        return (TableRowSorter)super.getRowSorter();
    }

    public StringResourceTableModel getModel() {
        return (StringResourceTableModel)super.getModel();
    }

    public void setModel(@NotNull TableModel model) {
        if (model == null) {
            StringResourceTable.$$$reportNull$$$0(6);
        }
        super.setModel(model);
        RowSorter sorter = this.getRowSorter();
        if (sorter != null) {
            ((TableRowSorter)sorter).setModel(this.getModel());
        }
        if (this.tableHeader == null) {
            return;
        }
        if (this.myColumnPreferredWidthsSet) {
            return;
        }
        OptionalInt optionalWidth = this.getKeyColumnPreferredWidth();
        if (optionalWidth.isPresent()) {
            this.getColumn(0).setPreferredWidth(optionalWidth.getAsInt());
        }
        if ((optionalWidth = this.getDefaultValueAndLocaleColumnPreferredWidths()).isPresent()) {
            int width = optionalWidth.getAsInt();
            IntStream.range(this.convertColumnIndexToView(3), this.getColumnCount()).mapToObj(this.columnModel::getColumn).forEach(column -> column.setPreferredWidth(width));
        }
        this.myColumnPreferredWidthsSet = true;
    }

    @NotNull
    @VisibleForTesting
    public OptionalInt getKeyColumnPreferredWidth() {
        OptionalInt optionalInt = IntStream.range(0, this.getModel().getRowCount()).map(row -> this.getPreferredWidth(this.getCellRendererAtModel(row, 0), this.getModel().getValueAt(row, 0), row, 0)).max();
        if (optionalInt == null) {
            StringResourceTable.$$$reportNull$$$0(7);
        }
        return optionalInt;
    }

    @NotNull
    @VisibleForTesting
    public OptionalInt getDefaultValueAndLocaleColumnPreferredWidths() {
        OptionalInt optionalInt = IntStream.range(this.convertColumnIndexToView(3), this.getColumnCount()).map(column -> this.getPreferredWidth(this.getHeaderRenderer(column), this.getColumnName(column), -1, column)).max();
        if (optionalInt == null) {
            StringResourceTable.$$$reportNull$$$0(8);
        }
        return optionalInt;
    }

    @NotNull
    private TableCellRenderer getHeaderRenderer(int column) {
        TableCellRenderer renderer = this.columnModel.getColumn(column).getHeaderRenderer();
        TableCellRenderer tableCellRenderer = renderer == null ? this.tableHeader.getDefaultRenderer() : renderer;
        if (tableCellRenderer == null) {
            StringResourceTable.$$$reportNull$$$0(9);
        }
        return tableCellRenderer;
    }

    private int getPreferredWidth(@NotNull TableCellRenderer renderer, @NotNull Object value, int row, int column) {
        if (renderer == null) {
            StringResourceTable.$$$reportNull$$$0(10);
        }
        if (value == null) {
            StringResourceTable.$$$reportNull$$$0(11);
        }
        return renderer.getTableCellRendererComponent((JTable)((Object)this), (Object)value, (boolean)false, (boolean)false, (int)row, (int)column).getPreferredSize().width + 2;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            StringResourceTable.$$$reportNull$$$0(12);
        }
        return dataId.equals(PlatformDataKeys.PASTE_PROVIDER.getName()) ? this : null;
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            StringResourceTable.$$$reportNull$$$0(13);
        }
        if (this.getSelectedRowCount() != 1 || this.getSelectedColumnCount() != 1) {
            return false;
        }
        int column = this.getSelectedColumn();
        return column != 0 && column != 2;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            StringResourceTable.$$$reportNull$$$0(14);
        }
        return this.isPastePossible(dataContext);
    }

    public void performPaste(@NotNull DataContext dataContext) {
        Transferable transferable;
        if (dataContext == null) {
            StringResourceTable.$$$reportNull$$$0(15);
        }
        if ((transferable = CopyPasteManager.getInstance().getContents()) != null) {
            TableUtils.paste((JTable)((Object)this), (Transferable)transferable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/table/StringResourceTable";
                break;
            }
            case 2: 
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultTableHeader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "removeAllColumns";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/table/StringResourceTable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumn";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRowModelIndices";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyColumnPreferredWidth";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValueAndLocaleColumnPreferredWidths";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addColumns";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getColumn";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredWidth";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isPastePossible";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isPasteEnabled";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "performPaste";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addColumns$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ThreeStateTableRowSorter<M extends TableModel>
    extends TableRowSorter<M> {
        ThreeStateTableRowSorter(M model) {
            super(model);
        }

        @Override
        public void toggleSortOrder(int column) {
            List<RowSorter.SortKey> sortKeys = this.getSortKeys();
            if (!sortKeys.isEmpty() && sortKeys.get(0).getSortOrder() == SortOrder.DESCENDING) {
                this.setSortKeys(null);
                return;
            }
            super.toggleSortOrder(column);
        }

        @Override
        public void modelStructureChanged() {
            List<RowSorter.SortKey> sortKeys = this.getSortKeys();
            super.modelStructureChanged();
            this.setSortKeys(sortKeys);
        }
    }
}

