/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.editors.strings.StringResourceRepository;
import com.android.tools.idea.rendering.Locale;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceTableModel
extends AbstractTableModel {
    public static final int KEY_COLUMN = 0;
    public static final int RESOURCE_FOLDER_COLUMN = 1;
    public static final int UNTRANSLATABLE_COLUMN = 2;
    public static final int DEFAULT_VALUE_COLUMN = 3;
    public static final int FIXED_COLUMN_COUNT = 4;
    private final StringResourceRepository myRepository;
    private final StringResourceData myData;
    private final List<StringResourceKey> myKeys;
    private final List<Locale> myLocales;

    StringResourceTableModel() {
        this.myRepository = StringResourceRepository.create();
        this.myData = null;
        this.myKeys = Collections.emptyList();
        this.myLocales = Collections.emptyList();
    }

    public StringResourceTableModel(@NotNull StringResourceRepository repository, @NotNull AndroidFacet facet) {
        StringResourceData data;
        if (repository == null) {
            StringResourceTableModel.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            StringResourceTableModel.$$$reportNull$$$0(1);
        }
        this.myRepository = repository;
        this.myData = data = repository.getData(facet);
        this.myKeys = data.getKeys();
        this.myLocales = data.getLocaleList();
    }

    @NotNull
    public StringResourceRepository getRepository() {
        StringResourceRepository stringResourceRepository = this.myRepository;
        if (stringResourceRepository == null) {
            StringResourceTableModel.$$$reportNull$$$0(2);
        }
        return stringResourceRepository;
    }

    @Nullable
    public StringResourceData getData() {
        return this.myData;
    }

    @NotNull
    public StringResource getStringResourceAt(int row) {
        StringResource stringResource = this.myData.getStringResource(this.getKey(row));
        if (stringResource == null) {
            StringResourceTableModel.$$$reportNull$$$0(3);
        }
        return stringResource;
    }

    @NotNull
    public List<StringResourceKey> getKeys() {
        List<StringResourceKey> list = this.myKeys;
        if (list == null) {
            StringResourceTableModel.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public StringResourceKey getKey(int row) {
        StringResourceKey stringResourceKey = this.myKeys.get(row);
        if (stringResourceKey == null) {
            StringResourceTableModel.$$$reportNull$$$0(5);
        }
        return stringResourceKey;
    }

    @Nullable
    public Locale getLocale(int column) {
        assert (0 <= column && column < this.getColumnCount()) : column;
        return column < 4 ? null : this.myLocales.get(column - 4);
    }

    @Override
    public int getRowCount() {
        return this.myKeys.size();
    }

    @Override
    public int getColumnCount() {
        return 4 + this.myLocales.size();
    }

    @Override
    public void setValueAt(@NotNull Object value, int row, int column) {
        if (value == null) {
            StringResourceTableModel.$$$reportNull$$$0(6);
        }
        assert (this.myData != null && this.myKeys != null);
        switch (column) {
            case 0: {
                String oldName = this.getKey(row).getName();
                String newName = (String)value;
                if (StringUtil.equals((CharSequence)oldName, (CharSequence)newName)) break;
                this.myData.changeKeyName(this.getKey(row), newName);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                Boolean doNotTranslate = (Boolean)value;
                if (!this.myData.setTranslatable(this.getKey(row), doNotTranslate == false)) break;
                this.fireTableCellUpdated(row, column);
                break;
            }
            case 3: {
                if (!this.getStringResourceAt(row).setDefaultValue((String)value)) break;
                this.fireTableCellUpdated(row, column);
                break;
            }
            default: {
                Locale locale = this.getLocale(column);
                assert (locale != null);
                if (!this.getStringResourceAt(row).putTranslation(locale, (String)value)) break;
                this.fireTableCellUpdated(row, column);
            }
        }
    }

    @Override
    @NotNull
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                String string = this.getKey(row).getName();
                if (string == null) {
                    StringResourceTableModel.$$$reportNull$$$0(7);
                }
                return string;
            }
            case 1: {
                String string = this.getStringResourceAt(row).getResourceFolder();
                if (string == null) {
                    StringResourceTableModel.$$$reportNull$$$0(8);
                }
                return string;
            }
            case 2: {
                Boolean bl = !this.getStringResourceAt(row).isTranslatable();
                if (bl == null) {
                    StringResourceTableModel.$$$reportNull$$$0(9);
                }
                return bl;
            }
            case 3: {
                String string = this.getStringResourceAt(row).getDefaultValueAsString();
                if (string == null) {
                    StringResourceTableModel.$$$reportNull$$$0(10);
                }
                return string;
            }
        }
        Locale locale = this.getLocale(column);
        assert (locale != null);
        String string = this.getStringResourceAt(row).getTranslationAsString(locale);
        if (string == null) {
            StringResourceTableModel.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                if ("Key" == null) {
                    StringResourceTableModel.$$$reportNull$$$0(12);
                }
                return "Key";
            }
            case 1: {
                if ("Resource Folder" == null) {
                    StringResourceTableModel.$$$reportNull$$$0(13);
                }
                return "Resource Folder";
            }
            case 2: {
                if ("Untranslatable" == null) {
                    StringResourceTableModel.$$$reportNull$$$0(14);
                }
                return "Untranslatable";
            }
            case 3: {
                if ("Default Value" == null) {
                    StringResourceTableModel.$$$reportNull$$$0(15);
                }
                return "Default Value";
            }
        }
        String string = LocaleMenuAction.getLocaleLabel(this.getLocale(column), false);
        if (string == null) {
            StringResourceTableModel.$$$reportNull$$$0(16);
        }
        return string;
    }

    public Class getColumnClass(int column) {
        return column == 2 ? Boolean.class : String.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        switch (column) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
            case 3: {
                return !this.getStringResourceAt(row).getDefaultValueAsString().contains("\n");
            }
        }
        Locale locale = this.getLocale(column);
        assert (locale != null);
        return !this.getStringResourceAt(row).getTranslationAsString(locale).contains("\n");
    }

    @Nullable
    public String getCellProblem(int row, int column) {
        switch (column) {
            case 0: {
                return this.myData.validateKey(this.getKey(row));
            }
            case 1: 
            case 2: {
                return null;
            }
            case 3: {
                return this.getStringResourceAt(row).validateDefaultValue();
            }
        }
        Locale locale = this.getLocale(column);
        assert (locale != null);
        return this.getStringResourceAt(row).validateTranslation(locale);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/table/StringResourceTableModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/table/StringResourceTableModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepository";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringResourceAt";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAt";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setValueAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

