/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.builder.model.SourceProvider;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.AndroidTextUtils;
import com.android.tools.idea.actions.OverrideResourceAction;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ResourceResolverCache;
import com.android.tools.idea.configurations.ThemeSelectionPanel;
import com.android.tools.idea.editors.manifest.ManifestUtils;
import com.android.tools.idea.editors.theme.ActivityChooser;
import com.android.tools.idea.editors.theme.MaterialColorUtils;
import com.android.tools.idea.editors.theme.NewStyleDialog;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditor;
import com.android.tools.idea.editors.theme.ThemeEditorComponent;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorVirtualFile;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.javadoc.AndroidJavaDocRenderer;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.ui.resourcechooser.ChooseResourceDialog;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.JBColor;
import com.intellij.util.Processor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorUtils {
    private static final Logger LOG = Logger.getInstance(ThemeEditorUtils.class);
    private static final Cache<String, String> ourTooltipCache = CacheBuilder.newBuilder().weakValues().maximumSize(30L).build();
    private static final Set<String> DEFAULT_THEMES = ImmutableSet.of((Object)"Theme.AppCompat.NoActionBar", (Object)"Theme.AppCompat.Light.NoActionBar");
    private static final Set<String> DEFAULT_THEMES_FALLBACK = ImmutableSet.of((Object)"Theme.Material.NoActionBar", (Object)"Theme.Material.Light.NoActionBar");
    private static final String[] CUSTOM_WIDGETS_JAR_PATHS = new String[]{"/plugins/android/lib/androidWidgets/theme-editor-widgets.jar", "/../adt/idea/android/lib/androidWidgets/theme-editor-widgets.jar", "/community/android/android/lib/androidWidgets/theme-editor-widgets.jar", "/android/android/lib/androidWidgets/theme-editor-widgets.jar", "/ultimate/community/android/android/lib/androidWidgets/theme-editor-widgets.jar"};

    private ThemeEditorUtils() {
    }

    @NotNull
    public static String generateToolTipText(@NotNull ItemResourceValue resValue, @NotNull Module module, @NotNull Configuration configuration) {
        AppResourceRepository repository;
        if (resValue == null) {
            ThemeEditorUtils.$$$reportNull$$$0(0);
        }
        if (module == null) {
            ThemeEditorUtils.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            ThemeEditorUtils.$$$reportNull$$$0(2);
        }
        if ((repository = AppResourceRepository.getOrCreateInstance(module)) == null) {
            if ("" == null) {
                ThemeEditorUtils.$$$reportNull$$$0(3);
            }
            return "";
        }
        String tooltipKey = resValue.toString() + module.toString() + configuration.toString() + ((LocalResourceRepository)repository).getModificationCount();
        String cachedTooltip = (String)ourTooltipCache.getIfPresent((Object)tooltipKey);
        if (cachedTooltip != null) {
            String string = cachedTooltip;
            if (string == null) {
                ThemeEditorUtils.$$$reportNull$$$0(4);
            }
            return string;
        }
        ResourceUrl url = ResourceUrl.parse((String)ResolutionUtils.getResourceUrlFromQualifiedName(ResolutionUtils.getQualifiedItemName(resValue), "attr"));
        assert (url != null);
        String tooltipContents = AndroidJavaDocRenderer.render(module, configuration, url);
        assert (tooltipContents != null);
        ourTooltipCache.put((Object)tooltipKey, (Object)tooltipContents);
        String string = tooltipContents;
        if (string == null) {
            ThemeEditorUtils.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String getDisplayHtml(EditedStyleItem item) {
        String string = item.isDeprecated() ? "<html><body><strike>" + item.getQualifiedName() + "</strike></body></html>" : item.getQualifiedName();
        if (string == null) {
            ThemeEditorUtils.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static boolean isThemeEditorSelected(@NotNull Project project) {
        if (project == null) {
            ThemeEditorUtils.$$$reportNull$$$0(7);
        }
        for (FileEditor editor : FileEditorManager.getInstance((Project)project).getSelectedEditors()) {
            if (!(editor instanceof ThemeEditor)) continue;
            return true;
        }
        return false;
    }

    public static void openThemeEditor(@NotNull Project project) {
        if (project == null) {
            ThemeEditorUtils.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project == null) {
                ThemeEditorUtils.$$$reportNull$$$0(66);
            }
            ThemeEditorVirtualFile file = ThemeEditorVirtualFile.getThemeEditorFile(project);
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, (VirtualFile)file);
            FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
        });
    }

    @Nullable
    public static ItemResourceValue resolveItemFromParents(@NotNull ConfiguredThemeEditorStyle theme, @NotNull String name, boolean isFrameworkAttr) {
        if (theme == null) {
            ThemeEditorUtils.$$$reportNull$$$0(9);
        }
        if (name == null) {
            ThemeEditorUtils.$$$reportNull$$$0(10);
        }
        ConfiguredThemeEditorStyle currentTheme = theme;
        for (int i = 0; i < 50 && currentTheme != null; currentTheme = currentTheme.getParent(), ++i) {
            ItemResourceValue item = currentTheme.getItem(name, isFrameworkAttr);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    @Nullable
    public static Object extractRealValue(@NotNull EditedStyleItem item, @NotNull Class<?> desiredClass) {
        if (item == null) {
            ThemeEditorUtils.$$$reportNull$$$0(11);
        }
        if (desiredClass == null) {
            ThemeEditorUtils.$$$reportNull$$$0(12);
        }
        String value = item.getValue();
        if (desiredClass == Boolean.class && ("true".equals(value) || "false".equals(value))) {
            return Boolean.valueOf(value);
        }
        if (desiredClass == Integer.class) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return value;
            }
        }
        return value;
    }

    public static boolean acceptsFormat(@Nullable AttributeDefinition attrDefByName, @NotNull AttributeFormat want) {
        if (want == null) {
            ThemeEditorUtils.$$$reportNull$$$0(13);
        }
        if (attrDefByName == null) {
            return false;
        }
        return attrDefByName.getFormats().contains((Object)want);
    }

    @NotNull
    private static ImmutableCollection<ConfiguredThemeEditorStyle> findThemes(@NotNull Collection<ConfiguredThemeEditorStyle> themes, @NotNull Set<String> names) {
        if (themes == null) {
            ThemeEditorUtils.$$$reportNull$$$0(14);
        }
        if (names == null) {
            ThemeEditorUtils.$$$reportNull$$$0(15);
        }
        ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)themes.stream().filter(theme -> {
            if (names == null) {
                ThemeEditorUtils.$$$reportNull$$$0(65);
            }
            return theme != null && names.contains(theme.getName());
        }).collect(Collectors.toList()));
        if (immutableSet == null) {
            ThemeEditorUtils.$$$reportNull$$$0(16);
        }
        return immutableSet;
    }

    @NotNull
    public static ImmutableList<Module> findAndroidModules(@NotNull Project project) {
        if (project == null) {
            ThemeEditorUtils.$$$reportNull$$$0(17);
        }
        ModuleManager manager = ModuleManager.getInstance((Project)project);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Module module : manager.getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) continue;
            builder.add((Object)module);
        }
        ImmutableList immutableList = builder.build();
        if (immutableList == null) {
            ThemeEditorUtils.$$$reportNull$$$0(18);
        }
        return immutableList;
    }

    @NotNull
    public static ImmutableList<String> getDefaultThemeNames(@NotNull ThemeResolver themeResolver) {
        if (themeResolver == null) {
            ThemeEditorUtils.$$$reportNull$$$0(19);
        }
        ImmutableList<ConfiguredThemeEditorStyle> readOnlyLibThemes = themeResolver.getExternalLibraryThemes();
        HashSet<ConfiguredThemeEditorStyle> foundThemes = new HashSet<ConfiguredThemeEditorStyle>();
        foundThemes.addAll((Collection<ConfiguredThemeEditorStyle>)ThemeEditorUtils.findThemes(readOnlyLibThemes, DEFAULT_THEMES));
        if (foundThemes.isEmpty()) {
            ImmutableList<ConfiguredThemeEditorStyle> readOnlyFrameworkThemes = themeResolver.getFrameworkThemes();
            foundThemes = new HashSet();
            foundThemes.addAll((Collection<ConfiguredThemeEditorStyle>)ThemeEditorUtils.findThemes(readOnlyFrameworkThemes, DEFAULT_THEMES_FALLBACK));
            if (foundThemes.isEmpty()) {
                foundThemes.addAll((Collection<ConfiguredThemeEditorStyle>)readOnlyLibThemes);
                foundThemes.addAll((Collection<ConfiguredThemeEditorStyle>)readOnlyFrameworkThemes);
            }
        }
        TreeSet temporarySet = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (ConfiguredThemeEditorStyle theme : foundThemes) {
            temporarySet.add(theme.getQualifiedName());
        }
        ImmutableList immutableList = ImmutableList.copyOf((Collection)temporarySet);
        if (immutableList == null) {
            ThemeEditorUtils.$$$reportNull$$$0(20);
        }
        return immutableList;
    }

    public static int getMinApiLevel(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            ThemeEditorUtils.$$$reportNull$$$0(21);
        }
        if ((facet = AndroidFacet.getInstance(module)) == null) {
            return 1;
        }
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(facet);
        return moduleInfo.getMinSdkVersion().getApiLevel();
    }

    @Nullable
    public static URL getCustomWidgetsJarUrl() {
        String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
        StringBuilder notFoundPaths = new StringBuilder();
        for (String path : CUSTOM_WIDGETS_JAR_PATHS) {
            String jarPath = homePath + path;
            VirtualFile root = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)jarPath));
            if (root != null) {
                File rootFile = VfsUtilCore.virtualToIoFile((VirtualFile)root);
                if (!rootFile.exists()) continue;
                try {
                    LOG.debug("Theme editor custom widgets found at " + jarPath);
                    return rootFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    LOG.error((Throwable)e);
                    continue;
                }
            }
            notFoundPaths.append(jarPath).append('\n');
        }
        LOG.error("Unable to find theme-editor-widgets.jar in paths:\n" + notFoundPaths.toString());
        return null;
    }

    public static boolean createNewStyle(final @NotNull Project project, final @NotNull VirtualFile resourceDir, final @NotNull String newStyleName, final @Nullable String parentStyleName, final @NotNull String fileName, final @NotNull List<String> folderNames) {
        if (project == null) {
            ThemeEditorUtils.$$$reportNull$$$0(22);
        }
        if (resourceDir == null) {
            ThemeEditorUtils.$$$reportNull$$$0(23);
        }
        if (newStyleName == null) {
            ThemeEditorUtils.$$$reportNull$$$0(24);
        }
        if (fileName == null) {
            ThemeEditorUtils.$$$reportNull$$$0(25);
        }
        if (folderNames == null) {
            ThemeEditorUtils.$$$reportNull$$$0(26);
        }
        return (Boolean)new WriteCommandAction<Boolean>(project, "Create new style " + newStyleName, new PsiFile[0]){

            protected void run(@NotNull Result<Boolean> result) {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                CommandProcessor.getInstance().addAffectedFiles(project, new VirtualFile[]{ThemeEditorVirtualFile.getThemeEditorFile(project)});
                result.setResult((Object)AndroidResourceUtil.createValueResource(project, resourceDir, newStyleName, null, ResourceType.STYLE, fileName, folderNames, (Processor<ResourceElement>)((Processor)element -> {
                    assert (element instanceof Style);
                    Style style = (Style)element;
                    if (parentStyleName != null) {
                        style.getParentStyle().setStringValue(parentStyleName);
                    }
                    return true;
                })));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/editors/theme/ThemeEditorUtils$1", "run"));
            }
        }.execute().getResultObject();
    }

    @Nullable
    public static String showCreateNewStyleDialog(@Nullable ConfiguredThemeEditorStyle defaultParentStyle, @NotNull ThemeEditorContext themeEditorContext, boolean isTheme, boolean enableParentChoice, @Nullable String message, @Nullable ThemeSelectionPanel.ThemeChangedListener themeChangedListener) {
        boolean createStyle;
        if (themeEditorContext == null) {
            ThemeEditorUtils.$$$reportNull$$$0(27);
        }
        String defaultParentStyleName = null;
        if (isTheme && defaultParentStyle == null) {
            ImmutableList<String> defaultThemes = ThemeEditorUtils.getDefaultThemeNames(themeEditorContext.getThemeResolver());
            defaultParentStyleName = !defaultThemes.isEmpty() ? (String)defaultThemes.get(0) : null;
        } else if (defaultParentStyle != null) {
            defaultParentStyleName = defaultParentStyle.getQualifiedName();
        }
        NewStyleDialog dialog = new NewStyleDialog(isTheme, themeEditorContext, defaultParentStyleName, defaultParentStyle == null ? null : defaultParentStyle.getName(), message);
        dialog.enableParentChoice(enableParentChoice);
        if (themeChangedListener != null) {
            dialog.setThemeChangedListener(themeChangedListener);
        }
        if (!(createStyle = dialog.showAndGet())) {
            return null;
        }
        int minModuleApi = ThemeEditorUtils.getMinApiLevel(themeEditorContext.getCurrentContextModule());
        int minAcceptableApi = ResolutionUtils.getOriginalApiLevel(ResolutionUtils.getStyleResourceUrl(dialog.getStyleParentName()), themeEditorContext.getProject());
        String fileName = AndroidResourceUtil.getDefaultResourceFileName(ResourceType.STYLE);
        FolderConfiguration config = new FolderConfiguration();
        if (minModuleApi < minAcceptableApi) {
            VersionQualifier qualifier = new VersionQualifier(minAcceptableApi);
            config.setVersionQualifier(qualifier);
        }
        if (fileName == null) {
            LOG.error("Couldn't find a default filename for ResourceType.STYLE");
            return null;
        }
        List<String> dirNames = Collections.singletonList(config.getFolderName(ResourceFolderType.VALUES));
        String parentStyleName = dialog.getStyleParentName();
        Module module = themeEditorContext.getCurrentContextModule();
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            LOG.error("Create new style for non-Android module " + module.getName());
            return null;
        }
        Project project = module.getProject();
        VirtualFile resourceDir = facet.getPrimaryResourceDir();
        if (resourceDir == null) {
            AndroidUtils.reportError(project, AndroidBundle.message("check.resource.dir.error", module.getName()));
            return null;
        }
        boolean isCreated = ThemeEditorUtils.createNewStyle(project, resourceDir, dialog.getStyleName(), parentStyleName, fileName, dirNames);
        return isCreated ? dialog.getStyleName() : null;
    }

    public static boolean isSelectedAppCompatTheme(@NotNull ThemeEditorContext context) {
        ConfiguredThemeEditorStyle currentTheme;
        if (context == null) {
            ThemeEditorUtils.$$$reportNull$$$0(28);
        }
        return (currentTheme = context.getCurrentTheme()) != null && ThemeEditorUtils.isAppCompatTheme(currentTheme);
    }

    public static boolean isAppCompatTheme(@NotNull ConfiguredThemeEditorStyle configuredThemeEditorStyle) {
        if (configuredThemeEditorStyle == null) {
            ThemeEditorUtils.$$$reportNull$$$0(29);
        }
        ConfiguredThemeEditorStyle currentTheme = configuredThemeEditorStyle;
        for (int i = 0; i < 50 && currentTheme != null; currentTheme = currentTheme.getParent(), ++i) {
            if (!currentTheme.getName().startsWith("Theme.AppCompat") || currentTheme.getSourceModule() != null) continue;
            return true;
        }
        return false;
    }

    public static void copyTheme(int apiLevel, @NotNull XmlTag toBeCopied) {
        if (toBeCopied == null) {
            ThemeEditorUtils.$$$reportNull$$$0(30);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        PsiFile file = toBeCopied.getContainingFile();
        assert (file instanceof XmlFile) : file;
        ResourceFolderType folderType = ResourceHelper.getFolderType(file);
        assert (folderType != null) : file;
        FolderConfiguration config = ResourceHelper.getFolderConfiguration(file);
        assert (config != null) : file;
        VersionQualifier qualifier = new VersionQualifier(apiLevel);
        config.setVersionQualifier(qualifier);
        String folder = config.getFolderName(folderType);
        if (folderType != ResourceFolderType.VALUES) {
            OverrideResourceAction.forkResourceFile((XmlFile)file, folder, false);
        } else {
            XmlTag tag = OverrideResourceAction.getValueTag((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)toBeCopied, XmlTag.class, (boolean)false));
            if (tag != null) {
                PsiDirectory dir = null;
                PsiDirectory resFolder = file.getParent();
                if (resFolder != null) {
                    resFolder = resFolder.getParent();
                }
                if (resFolder != null && (dir = resFolder.findSubdirectory(folder)) == null) {
                    dir = resFolder.createSubdirectory(folder);
                }
                OverrideResourceAction.forkResourceValue(toBeCopied.getProject(), tag, file, dir, false);
            }
        }
    }

    public static int getVersionFromConfiguration(@NotNull FolderConfiguration configuration) {
        VersionQualifier qualifier;
        if (configuration == null) {
            ThemeEditorUtils.$$$reportNull$$$0(31);
        }
        return (qualifier = configuration.getVersionQualifier()) != null ? qualifier.getVersion() : -1;
    }

    public static int getMinFolderApi(@NotNull List<String> folderNames, @NotNull Module module) {
        if (folderNames == null) {
            ThemeEditorUtils.$$$reportNull$$$0(32);
        }
        if (module == null) {
            ThemeEditorUtils.$$$reportNull$$$0(33);
        }
        int minFolderApi = Integer.MAX_VALUE;
        int minModuleApi = ThemeEditorUtils.getMinApiLevel(module);
        for (String folderName : folderNames) {
            FolderConfiguration folderConfig = FolderConfiguration.getConfigForFolder((String)folderName);
            if (folderConfig == null) continue;
            VersionQualifier version = folderConfig.getVersionQualifier();
            int folderApi = version != null ? version.getVersion() : minModuleApi;
            minFolderApi = Math.min(minFolderApi, folderApi);
        }
        return minFolderApi;
    }

    @NotNull
    public static Configuration getConfigurationForModule(@NotNull Module module) {
        if (module == null) {
            ThemeEditorUtils.$$$reportNull$$$0(34);
        }
        Project project = module.getProject();
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null) : "moduleComboModel must contain only Android modules";
        ConfigurationManager configurationManager = ConfigurationManager.getOrCreateInstance(module);
        VirtualFile projectFile = project.getProjectFile();
        assert (projectFile != null);
        Configuration configuration = configurationManager.getConfiguration(projectFile);
        if (configuration == null) {
            ThemeEditorUtils.$$$reportNull$$$0(35);
        }
        return configuration;
    }

    @NotNull
    public static List<ResourceFolderRepository> getResourceFolderRepositoriesFromSourceSet(@NotNull AndroidFacet facet, @Nullable SourceProvider provider) {
        if (facet == null) {
            ThemeEditorUtils.$$$reportNull$$$0(36);
        }
        if (provider == null) {
            List<ResourceFolderRepository> list = Collections.emptyList();
            if (list == null) {
                ThemeEditorUtils.$$$reportNull$$$0(37);
            }
            return list;
        }
        Collection resDirectories = provider.getResDirectories();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        ArrayList folders = Lists.newArrayListWithExpectedSize((int)resDirectories.size());
        for (File dir : resDirectories) {
            VirtualFile virtualFile = fileSystem.findFileByIoFile(dir);
            if (virtualFile == null) continue;
            folders.add(ResourceFolderRegistry.get(facet, virtualFile));
        }
        ArrayList arrayList = folders;
        if (arrayList == null) {
            ThemeEditorUtils.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    public static JBColor getGoodContrastPreviewBackground(@NotNull ConfiguredThemeEditorStyle theme, @NotNull ResourceResolver resourceResolver) {
        float backgroundDistance;
        String colorBackgroundValue;
        Color colorBackground;
        ItemResourceValue themeColorBackgroundItem;
        ResourceValue backgroundResourceValue;
        if (theme == null) {
            ThemeEditorUtils.$$$reportNull$$$0(39);
        }
        if (resourceResolver == null) {
            ThemeEditorUtils.$$$reportNull$$$0(40);
        }
        if ((backgroundResourceValue = resourceResolver.resolveResValue((ResourceValue)(themeColorBackgroundItem = ThemeEditorUtils.resolveItemFromParents(theme, "colorBackground", true)))) != null && (colorBackground = ResourceHelper.parseColor(colorBackgroundValue = backgroundResourceValue.getValue())) != null && (backgroundDistance = MaterialColorUtils.colorDistance(colorBackground, (Color)ThemeEditorComponent.PREVIEW_BACKGROUND)) < 8.5f && backgroundDistance < MaterialColorUtils.colorDistance(colorBackground, (Color)ThemeEditorComponent.ALT_PREVIEW_BACKGROUND)) {
            return ThemeEditorComponent.ALT_PREVIEW_BACKGROUND;
        }
        return ThemeEditorComponent.PREVIEW_BACKGROUND;
    }

    public static void acceptResourceResolverVisitor(@NotNull AndroidFacet mainFacet, @NotNull ResourceFolderVisitor visitor) {
        if (mainFacet == null) {
            ThemeEditorUtils.$$$reportNull$$$0(41);
        }
        if (visitor == null) {
            ThemeEditorUtils.$$$reportNull$$$0(42);
        }
        List dependencies = Lists.reverse(AndroidUtils.getAllAndroidDependencies(mainFacet.getModule(), true));
        for (AndroidFacet dependency : Iterables.concat((Iterable)dependencies, (Iterable)ImmutableList.of((Object)((Object)mainFacet)))) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(dependency);
            if (androidModel == null) {
                SourceProvider provider = dependency.getMainSourceProvider();
                for (LocalResourceRepository localResourceRepository : ThemeEditorUtils.getResourceFolderRepositoriesFromSourceSet(dependency, provider)) {
                    visitor.visitResourceFolder(localResourceRepository, dependency.getName(), provider.getName(), true);
                }
                continue;
            }
            List<SourceProvider> activeProviders = androidModel.getActiveSourceProviders();
            for (SourceProvider sourceProvider : activeProviders) {
                for (LocalResourceRepository localResourceRepository : ThemeEditorUtils.getResourceFolderRepositoriesFromSourceSet(dependency, sourceProvider)) {
                    visitor.visitResourceFolder(localResourceRepository, dependency.getName(), sourceProvider.getName(), true);
                }
            }
            ImmutableSet selectedProviders = ImmutableSet.copyOf(activeProviders);
            for (SourceProvider provider : androidModel.getAllSourceProviders()) {
                if (selectedProviders.contains((Object)provider)) continue;
                for (LocalResourceRepository localResourceRepository : ThemeEditorUtils.getResourceFolderRepositoriesFromSourceSet(dependency, provider)) {
                    visitor.visitResourceFolder(localResourceRepository, dependency.getName(), provider.getName(), false);
                }
            }
        }
    }

    @NotNull
    public static ImmutableList<String> getModuleThemeQualifiedNamesList(@NotNull Module module) {
        if (module == null) {
            ThemeEditorUtils.$$$reportNull$$$0(43);
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        ConfigurationManager manager = ConfigurationManager.getOrCreateInstance(module);
        ResourceResolverCache resolverCache = new ResourceResolverCache(manager);
        IAndroidTarget target = manager.getTarget();
        HashMap cache = new HashMap();
        TreeSet themeNamesSet = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        ResourceFolderVisitor visitor = (resources, moduleName, variantName, isSelected) -> {
            if (!isSelected) {
                return;
            }
            block0: for (String simpleThemeName : resources.getItemsOfType(ResourceType.STYLE)) {
                String themeStyleResourceUrl = "@style/" + simpleThemeName;
                List themeItems = resources.getResourceItem(ResourceType.STYLE, simpleThemeName);
                assert (themeItems != null);
                for (ResourceItem themeItem : themeItems) {
                    ResourceResolver resolver = resolverCache.getResourceResolver(target, themeStyleResourceUrl, themeItem.getConfiguration());
                    ResourceValue themeItemResourceValue = themeItem.getResourceValue(false);
                    assert (themeItemResourceValue != null);
                    if (!resolver.isTheme(themeItemResourceValue, cache)) continue;
                    themeNamesSet.add(simpleThemeName);
                    continue block0;
                }
            }
        };
        ThemeEditorUtils.acceptResourceResolverVisitor(facet, visitor);
        ImmutableList immutableList = ImmutableList.copyOf((Collection)themeNamesSet);
        if (immutableList == null) {
            ThemeEditorUtils.$$$reportNull$$$0(44);
        }
        return immutableList;
    }

    @NotNull
    public static ChooseResourceDialog getResourceDialog(@NotNull EditedStyleItem item, @NotNull ThemeEditorContext context, EnumSet<ResourceType> allowedTypes) {
        ResourceUrl url;
        if (item == null) {
            ThemeEditorUtils.$$$reportNull$$$0(45);
        }
        if (context == null) {
            ThemeEditorUtils.$$$reportNull$$$0(46);
        }
        Module module = context.getModuleForResources();
        ItemResourceValue itemSelectedValue = item.getSelectedValue();
        String value = itemSelectedValue.getValue();
        boolean isFrameworkValue = itemSelectedValue.isFramework();
        String nameSuggestion = value;
        ResourceUrl resourceUrl = url = value != null ? ResourceUrl.parse((String)value, (boolean)isFrameworkValue) : null;
        if (url != null) {
            nameSuggestion = url.name;
        }
        nameSuggestion = nameSuggestion != null ? ThemeEditorUtils.getDefaultResourceName(context, nameSuggestion) : null;
        ChooseResourceDialog.ResourceNameVisibility resourceNameVisibility = ChooseResourceDialog.ResourceNameVisibility.FORCE;
        if (StringUtil.startsWithChar((CharSequence)nameSuggestion, (char)'#')) {
            nameSuggestion = null;
            resourceNameVisibility = ChooseResourceDialog.ResourceNameVisibility.SHOW;
        }
        ChooseResourceDialog dialog = ChooseResourceDialog.builder().setModule(module).setTypes(allowedTypes).setCurrentValue(value).setIsFrameworkValue(isFrameworkValue).setResourceNameVisibility(resourceNameVisibility).setResourceNameSuggestion(nameSuggestion).build();
        dialog.setUseGlobalUndo();
        dialog.setTitle("Select Resource for " + item.getQualifiedName());
        ChooseResourceDialog chooseResourceDialog = dialog;
        if (chooseResourceDialog == null) {
            ThemeEditorUtils.$$$reportNull$$$0(47);
        }
        return chooseResourceDialog;
    }

    @NotNull
    private static String getDefaultResourceName(@NotNull ThemeEditorContext context, @NotNull String initialName) {
        if (context == null) {
            ThemeEditorUtils.$$$reportNull$$$0(48);
        }
        if (initialName == null) {
            ThemeEditorUtils.$$$reportNull$$$0(49);
        }
        if (context.getCurrentTheme() == null || !context.getCurrentTheme().isReadOnly()) {
            String string = initialName;
            if (string == null) {
                ThemeEditorUtils.$$$reportNull$$$0(50);
            }
            return string;
        }
        ResourceResolver resolver = context.getResourceResolver();
        assert (resolver != null);
        ResourceValue value = resolver.findResValue("@color/" + initialName, false);
        if (value == null) {
            String string = initialName;
            if (string == null) {
                ThemeEditorUtils.$$$reportNull$$$0(51);
            }
            return string;
        }
        for (int i = 1; i <= 50; ++i) {
            String name = initialName + "_" + i;
            if (resolver.findResValue("@color/" + name, false) != null) continue;
            String string = name;
            if (string == null) {
                ThemeEditorUtils.$$$reportNull$$$0(52);
            }
            return string;
        }
        if ("" == null) {
            ThemeEditorUtils.$$$reportNull$$$0(53);
        }
        return "";
    }

    @NotNull
    public static String simplifyThemeName(@NotNull ConfiguredThemeEditorStyle theme) {
        String name;
        String[] pieces;
        if (theme == null) {
            ThemeEditorUtils.$$$reportNull$$$0(54);
        }
        String result = (pieces = (name = theme.getQualifiedName()).split("\\.")).length > 1 && !"Light".equals(pieces[1]) ? pieces[1] : "Theme";
        for (ConfiguredThemeEditorStyle parent = theme; parent != null; parent = parent.getParent()) {
            if (!"Theme.Light".equals(parent.getName())) continue;
            String string = result + " Light";
            if (string == null) {
                ThemeEditorUtils.$$$reportNull$$$0(55);
            }
            return string;
        }
        String string = result + " Dark";
        if (string == null) {
            ThemeEditorUtils.$$$reportNull$$$0(56);
        }
        return string;
    }

    @NotNull
    public static String generateWordEnumeration(@NotNull Collection<String> words) {
        if (words == null) {
            ThemeEditorUtils.$$$reportNull$$$0(57);
        }
        String string = AndroidTextUtils.generateCommaSeparatedList(words, (String)"and");
        if (string == null) {
            ThemeEditorUtils.$$$reportNull$$$0(58);
        }
        return string;
    }

    @NotNull
    public static Font scaleFontForAttribute(@NotNull Font font) {
        if (font == null) {
            ThemeEditorUtils.$$$reportNull$$$0(59);
        }
        Font font2 = font.deriveFont((float)Math.ceil((float)font.getSize() * 0.9f));
        if (font2 == null) {
            ThemeEditorUtils.$$$reportNull$$$0(60);
        }
        return font2;
    }

    public static void setInheritsPopupMenuRecursive(JComponent comp) {
        comp.setInheritsPopupMenu(true);
        for (Component child : comp.getComponents()) {
            if (!(child instanceof JComponent)) continue;
            ThemeEditorUtils.setInheritsPopupMenuRecursive((JComponent)child);
        }
    }

    public static void quickfixThemeToActivity(@NotNull Module module, final @NotNull String themeUrl) {
        ActivityChooser chooser;
        if (module == null) {
            ThemeEditorUtils.$$$reportNull$$$0(61);
        }
        if (themeUrl == null) {
            ThemeEditorUtils.$$$reportNull$$$0(62);
        }
        if ((chooser = new ActivityChooser(module)).showAndGet()) {
            String activity = chooser.getActivity();
            final SourceFilePosition sourceFilePosition = ManifestUtils.getSourceFilePosition(module, activity);
            if (sourceFilePosition == null) {
                Messages.showErrorDialog((Project)module.getProject(), (String)"Not a Project Activity", (String)"Set Theme Error");
                return;
            }
            File ioFile = sourceFilePosition.getFile().getSourceFile();
            assert (ioFile != null);
            VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(ioFile);
            assert (file != null);
            final XmlFile psiFile = (XmlFile)PsiManager.getInstance((Project)module.getProject()).findFile(file);
            assert (psiFile != null);
            new WriteCommandAction.Simple(module.getProject(), "Set Theme for Activity", new PsiFile[]{psiFile}){

                protected void run() throws Throwable {
                    SourcePosition sourcePosition = sourceFilePosition.getPosition();
                    XmlTag activityTag = ThemeEditorUtils.getXmlTag(psiFile, sourcePosition.getStartLine(), sourcePosition.getStartColumn());
                    assert (activityTag != null);
                    activityTag.setAttribute("theme", "http://schemas.android.com/apk/res/android", themeUrl);
                }
            }.execute();
        }
    }

    @Nullable
    public static XmlTag getXmlTag(@NotNull XmlFile file, int line, int col) {
        XmlElement element;
        if (file == null) {
            ThemeEditorUtils.$$$reportNull$$$0(63);
        }
        return (element = ThemeEditorUtils.getXmlElement(file, line, col)) instanceof XmlTag ? (XmlTag)element : null;
    }

    @Nullable
    public static XmlElement getXmlElement(@NotNull XmlFile file, int line, int col) {
        if (file == null) {
            ThemeEditorUtils.$$$reportNull$$$0(64);
        }
        if (line < 0 || col < 0) {
            throw new IllegalArgumentException();
        }
        Document doc = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument((PsiFile)file);
        assert (doc != null);
        int offset = doc.getLineStartOffset(line) + col;
        PsiElement psiElement = file.findElementAt(offset);
        PsiElement parent = psiElement == null ? null : psiElement.getParent();
        return parent instanceof XmlElement ? (XmlElement)parent : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 18: 
            case 20: 
            case 35: 
            case 37: 
            case 38: 
            case 44: 
            case 47: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 60: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 18: 
            case 20: 
            case 35: 
            case 37: 
            case 38: 
            case 44: 
            case 47: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 60: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resValue";
                break;
            }
            case 1: 
            case 21: 
            case 33: 
            case 34: 
            case 43: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 18: 
            case 20: 
            case 35: 
            case 37: 
            case 38: 
            case 44: 
            case 47: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/ThemeEditorUtils";
                break;
            }
            case 7: 
            case 8: 
            case 17: 
            case 22: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 39: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "theme";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desiredClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "want";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "themes";
                break;
            }
            case 15: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "themeResolver";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDir";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStyleName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderNames";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "themeEditorContext";
                break;
            }
            case 28: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuredThemeEditorStyle";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toBeCopied";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceResolver";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainFacet";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialName";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "themeUrl";
                break;
            }
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/ThemeEditorUtils";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generateToolTipText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayHtml";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findThemes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findAndroidModules";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultThemeNames";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationForModule";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceFolderRepositoriesFromSourceSet";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleThemeQualifiedNamesList";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceDialog";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultResourceName";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "simplifyThemeName";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "generateWordEnumeration";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "scaleFontForAttribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateToolTipText";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 18: 
            case 20: 
            case 35: 
            case 37: 
            case 38: 
            case 44: 
            case 47: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 60: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isThemeEditorSelected";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "openThemeEditor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveItemFromParents";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extractRealValue";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFormat";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findThemes";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findAndroidModules";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultThemeNames";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getMinApiLevel";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createNewStyle";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "showCreateNewStyleDialog";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedAppCompatTheme";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isAppCompatTheme";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "copyTheme";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getVersionFromConfiguration";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getMinFolderApi";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationForModule";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getResourceFolderRepositoriesFromSourceSet";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getGoodContrastPreviewBackground";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "acceptResourceResolverVisitor";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getModuleThemeQualifiedNamesList";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getResourceDialog";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultResourceName";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "simplifyThemeName";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "generateWordEnumeration";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "scaleFontForAttribute";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "quickfixThemeToActivity";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getXmlTag";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getXmlElement";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findThemes$1";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openThemeEditor$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 18: 
            case 20: 
            case 35: 
            case 37: 
            case 38: 
            case 44: 
            case 47: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 60: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ResourceFolderVisitor {
        public void visitResourceFolder(@NotNull LocalResourceRepository var1, String var2, @NotNull String var3, boolean var4);
    }
}

